/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings.refactoring;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.refactoring.Bundle;
import org.netbeans.modules.lsp.client.bindings.refactoring.ModificationResult;
import org.netbeans.modules.lsp.client.bindings.refactoring.tree.DiffElement;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class Refactoring {
    private static String uri2SimpleName(String uri) {
        int dot = uri.lastIndexOf(47);
        return uri.substring(dot + 1);
    }

    public static class FactoryImpl
    implements RefactoringPluginFactory {
        public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
            if (refactoring instanceof WhereUsedQuery) {
                WhereUsedQuery q = (WhereUsedQuery)refactoring;
                LSPBindings bindings = (LSPBindings)q.getRefactoringSource().lookup(LSPBindings.class);
                ReferenceParams params = (ReferenceParams)q.getRefactoringSource().lookup(ReferenceParams.class);
                if (bindings != null && params != null) {
                    return new WhereUsedRefactoringPlugin(q, bindings, params);
                }
            } else if (refactoring instanceof RenameRefactoring) {
                RenameRefactoring r = (RenameRefactoring)refactoring;
                LSPBindings bindings = (LSPBindings)r.getRefactoringSource().lookup(LSPBindings.class);
                RenameParams params = (RenameParams)r.getRefactoringSource().lookup(RenameParams.class);
                if (bindings != null && params != null) {
                    return new RenameRefactoringPlugin(r, bindings, params);
                }
            }
            return null;
        }
    }

    public static class LSPCreateFile
    extends SimpleRefactoringElementImplementation {
        private final String uri;
        private final String content;
        private FileObject target;

        public LSPCreateFile(String uri, String content) {
            this.uri = uri;
            this.content = content;
        }

        public String getText() {
            return Bundle.TXT_CreateFile(Refactoring.uri2SimpleName(this.uri));
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                Pair<FileObject, String> p = LSPCreateFile.fileAndRemainingPath(this.uri);
                this.target = FileUtil.createData((FileObject)((FileObject)p.first()), (String)((String)p.second()));
                try (OutputStreamWriter w = new OutputStreamWriter(this.target.getOutputStream(), FileEncodingQuery.getEncoding((FileObject)this.target));){
                    w.write(this.content);
                }
            }
            catch (IOException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void undoChange() {
            try {
                this.target.delete();
                this.target = null;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            try {
                return (FileObject)LSPCreateFile.fileAndRemainingPath(this.uri).first();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        private static Pair<FileObject, String> fileAndRemainingPath(String uri) throws URISyntaxException, MalformedURLException {
            FileObject existing;
            StringBuilder path = new StringBuilder();
            while ((existing = URLMapper.findFileObject((URL)new URI(uri).toURL())) == null) {
                int slash = uri.lastIndexOf(47);
                if (path.length() > 0) {
                    path.insert(0, '/');
                }
                path.insert(0, uri.substring(slash + 1));
                uri = uri.substring(0, slash);
            }
            return Pair.of((Object)existing, (Object)path.toString());
        }

        public PositionBounds getPosition() {
            return null;
        }

        public String toString() {
            return "=>" + Refactoring.uri2SimpleName(this.uri) + "(" + this.content + ")";
        }
    }

    public static class LSPDeleteFile
    extends SimpleRefactoringElementImplementation {
        private final URL res;
        private final String filename;
        private BackupFacility.Handle id;

        public LSPDeleteFile(FileObject fo) {
            this.res = fo.toURL();
            this.filename = fo.getNameExt();
        }

        public String getText() {
            return Bundle.TXT_DeleteFile(this.filename);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                FileObject fo = URLMapper.findFileObject((URL)this.res);
                if (fo == null) {
                    throw new IOException(this.res.toString());
                }
                this.id = BackupFacility.getDefault().backup(new FileObject[]{fo});
                DataObject.find((FileObject)fo).delete();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void undoChange() {
            try {
                FileObject f = URLMapper.findFileObject((URL)this.res);
                if (f != null) {
                    // empty if block
                }
                this.id.restore();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.res);
        }

        public PositionBounds getPosition() {
            return null;
        }

        public String toString() {
            return Refactoring.uri2SimpleName(this.res.toString()) + "=>";
        }
    }

    public static class LSPRenameFile
    extends SimpleRefactoringElementImplementation {
        private final FileObject fo;
        private final String newUri;
        private String oldUri;

        public LSPRenameFile(FileObject fo, String newUri) {
            this.fo = fo;
            this.oldUri = fo.toURI().toString();
            this.newUri = newUri;
        }

        public String getText() {
            return this.fo.isFolder() ? Bundle.TXT_RenameFolder(this.fo.getNameExt()) : Bundle.TXT_RenameFile(this.fo.getNameExt());
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            this.oldUri = this.fo.getName();
            this.doRename(this.newUri);
        }

        public void undoChange() {
            this.doRename(this.oldUri);
        }

        private void doRename(String uri) {
            try {
                String newName = uri.substring(uri.lastIndexOf(47) + 1);
                DataObject.find((FileObject)this.fo).rename(newName);
            }
            catch (DataObjectNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }

        public String toString() {
            return Refactoring.uri2SimpleName(this.fo.toURI().toString()) + "=>" + Refactoring.uri2SimpleName(this.newUri);
        }
    }

    public static class LSPRefactoringElementImpl
    extends SimpleRefactoringElementImplementation {
        private final String annotatedLine;
        private final FileObject file;
        private final PositionBounds bounds;

        public LSPRefactoringElementImpl(String annotatedLine, FileObject file, PositionBounds bounds) {
            this.annotatedLine = annotatedLine;
            this.file = file;
            this.bounds = bounds;
        }

        public String getText() {
            return "TODO: getText";
        }

        public String getDisplayText() {
            return this.annotatedLine;
        }

        public void performChange() {
            throw new UnsupportedOperationException();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return this.bounds;
        }
    }

    private static final class RenameRefactoringPlugin
    implements RefactoringPlugin {
        private final RenameRefactoring refactoring;
        private final LSPBindings bindings;
        private final RenameParams params;
        private final AtomicBoolean cancel = new AtomicBoolean();
        private volatile CompletableFuture<WorkspaceEdit> runningRequest;

        public RenameRefactoringPlugin(RenameRefactoring refactoring, LSPBindings bindings, RenameParams params) {
            this.refactoring = refactoring;
            this.bindings = bindings;
            this.params = params;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
            this.cancel.set(true);
            CompletableFuture<WorkspaceEdit> localRunningRequest = this.runningRequest;
            if (localRunningRequest != null) {
                localRunningRequest.cancel(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Problem prepare(RefactoringElementsBag refactoringElements) {
            if (this.cancel.get()) {
                return new Problem(false, Bundle.TXT_Canceled());
            }
            Problem p = null;
            try {
                this.runningRequest = this.bindings.getTextDocumentService().rename(this.params);
                WorkspaceEdit edit = this.runningRequest.get();
                List documentChanges = edit.getDocumentChanges();
                ModificationResult result = new ModificationResult();
                HashMap<FileObject, List> file2Diffs = new HashMap<FileObject, List>();
                HashMap<String, String> newURI2Old = new HashMap<String, String>();
                HashMap<String, String> newFileURI2Content = new HashMap<String, String>();
                if (documentChanges != null) {
                    block26: for (Either either : documentChanges) {
                        if (this.cancel.get()) break;
                        if (either.isLeft()) {
                            Iterator diff;
                            String uri = ((TextDocumentEdit)either.getLeft()).getTextDocument().getUri();
                            FileObject file = Utils.fromURI(uri = newURI2Old.getOrDefault(uri, uri));
                            if (file != null) {
                                for (TextEdit te : ((TextDocumentEdit)either.getLeft()).getEdits()) {
                                    diff = this.textEdit2Difference(file, te);
                                    file2Diffs.computeIfAbsent(file, f -> new ArrayList()).add(diff);
                                }
                                continue;
                            }
                            if (!newFileURI2Content.containsKey(uri)) continue;
                            FileObject temp = FileUtil.createMemoryFileSystem().getRoot().createData("temp.txt");
                            OutputStream out = temp.getOutputStream();
                            diff = null;
                            try {
                                out.write(((String)newFileURI2Content.get(uri)).getBytes());
                            }
                            catch (Throwable throwable) {
                                diff = throwable;
                                throw throwable;
                            }
                            finally {
                                if (out != null) {
                                    if (diff != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)((Object)diff)).addSuppressed(throwable);
                                        }
                                    } else {
                                        out.close();
                                    }
                                }
                            }
                            ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                            for (TextEdit te : ((TextDocumentEdit)either.getLeft()).getEdits()) {
                                diffs.add(this.textEdit2Difference(temp, te));
                            }
                            ModificationResult tempResult = new ModificationResult();
                            tempResult.addDifferences(temp, diffs);
                            newFileURI2Content.put(uri, tempResult.getResultingSource(temp));
                            continue;
                        }
                        switch (((ResourceOperation)either.getRight()).getKind()) {
                            case "rename": {
                                RenameFile rename = (RenameFile)either.getRight();
                                FileObject file = Utils.fromURI(rename.getOldUri());
                                refactoringElements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new LSPRenameFile(file, rename.getNewUri()));
                                newURI2Old.put(rename.getNewUri(), rename.getOldUri());
                                continue block26;
                            }
                            case "delete": {
                                DeleteFile delete = (DeleteFile)either.getRight();
                                FileObject file = Utils.fromURI(delete.getUri());
                                refactoringElements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new LSPDeleteFile(file));
                                continue block26;
                            }
                            case "create": {
                                CreateFile create = (CreateFile)either.getRight();
                                String uri = create.getUri();
                                newFileURI2Content.put(uri, "");
                                continue block26;
                            }
                        }
                        p = this.chain(new Problem(true, "Unknown file operation: " + ((ResourceOperation)either.getRight()).getKind()), p);
                    }
                } else {
                    for (Map.Entry entry : edit.getChanges().entrySet()) {
                        if (!this.cancel.get()) {
                            FileObject file = Utils.fromURI((String)entry.getKey());
                            for (TextEdit te : (List)entry.getValue()) {
                                ModificationResult.Difference diff = this.textEdit2Difference(file, te);
                                file2Diffs.computeIfAbsent(file, f -> new ArrayList()).add(diff);
                            }
                            continue;
                        }
                        break;
                    }
                }
                if (this.cancel.get()) {
                    p = this.chain(new Problem(false, Bundle.TXT_Canceled()), p);
                } else {
                    file2Diffs.entrySet().forEach(e -> {
                        ((List)e.getValue()).forEach(diff -> refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, (FileObject)e.getKey(), result)));
                        result.addDifferences((FileObject)e.getKey(), (List)e.getValue());
                    });
                    newFileURI2Content.entrySet().forEach(e -> refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new LSPCreateFile((String)e.getKey(), (String)e.getValue())));
                    refactoringElements.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(result)));
                    if (this.cancel.get()) {
                        p = this.chain(new Problem(false, Bundle.TXT_Canceled()), p);
                    }
                }
                Iterator<Object> iterator = p;
                return iterator;
            }
            catch (CancellationException ex) {
                Problem problem = this.chain(new Problem(false, Bundle.TXT_Canceled()), p);
                return problem;
            }
            catch (IOException | InterruptedException | ExecutionException ex) {
                Problem problem = this.chain(new Problem(true, ex.getLocalizedMessage()), p);
                return problem;
            }
            finally {
                this.runningRequest = null;
            }
        }

        private Problem chain(Problem current, Problem existing) {
            if (existing != null) {
                current.setNext(existing);
            }
            return current;
        }

        private ModificationResult.Difference textEdit2Difference(FileObject file, TextEdit edit) {
            if (file != null) {
                try {
                    EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                    StyledDocument doc = ec.openDocument();
                    CloneableEditorSupport es = (CloneableEditorSupport)file.getLookup().lookup(CloneableEditorSupport.class);
                    PositionRef start = es.createPositionRef(Utils.getOffset(doc, edit.getRange().getStart()), Position.Bias.Forward);
                    PositionRef end = es.createPositionRef(Utils.getOffset(doc, edit.getRange().getEnd()), Position.Bias.Forward);
                    PositionBounds bounds = new PositionBounds(start, end);
                    return new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, start, end, bounds.getText(), edit.getNewText());
                }
                catch (IOException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }

    private static final class WhereUsedRefactoringPlugin
    implements RefactoringPlugin {
        private final WhereUsedQuery query;
        private final LSPBindings bindings;
        private final ReferenceParams params;
        private final AtomicBoolean cancel = new AtomicBoolean();
        private volatile CompletableFuture<List<? extends Location>> runningRequest;

        public WhereUsedRefactoringPlugin(WhereUsedQuery query, LSPBindings bindings, ReferenceParams params) {
            this.query = query;
            this.bindings = bindings;
            this.params = params;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
            this.cancel.set(true);
            CompletableFuture<List<? extends Location>> localRunningRequest = this.runningRequest;
            if (localRunningRequest != null) {
                localRunningRequest.cancel(true);
            }
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            try {
                this.runningRequest = this.bindings.getTextDocumentService().references(this.params);
                for (Location location : this.runningRequest.get()) {
                    PositionBounds bounds;
                    if (this.cancel.get()) break;
                    FileObject file = Utils.fromURI(location.getUri());
                    if (file == null) continue;
                    try {
                        CloneableEditorSupport es = (CloneableEditorSupport)file.getLookup().lookup(CloneableEditorSupport.class);
                        EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                        StyledDocument doc = ec.openDocument();
                        bounds = new PositionBounds(es.createPositionRef(Utils.getOffset(doc, location.getRange().getStart()), Position.Bias.Forward), es.createPositionRef(Utils.getOffset(doc, location.getRange().getEnd()), Position.Bias.Forward));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        bounds = null;
                    }
                    LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
                    Line startLine = lc.getLineSet().getCurrent(location.getRange().getStart().getLine());
                    String lineText = startLine.getText();
                    int highlightEnd = Math.min(lineText.length(), location.getRange().getEnd().getCharacter());
                    String annotatedLine = lineText.substring(0, location.getRange().getStart().getCharacter()) + "<strong>" + lineText.substring(location.getRange().getStart().getCharacter(), highlightEnd) + "</strong>" + lineText.substring(highlightEnd);
                    refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)new LSPRefactoringElementImpl(annotatedLine, file, bounds));
                }
                this.runningRequest = null;
                return null;
            }
            catch (CancellationException ex) {
                return new Problem(false, Bundle.TXT_Canceled());
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new Problem(true, ex.getLocalizedMessage());
            }
        }
    }
}

