/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class Utils {
    public static String toURI(FileObject file) {
        return file.toURI().toString().replace("file:/", "file:///");
    }

    public static Position createPosition(Document doc, int offset) throws BadLocationException {
        return new Position(LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)offset), offset - LineDocumentUtils.getLineStart((LineDocument)((LineDocument)doc), (int)offset));
    }

    public static int getOffset(Document doc, Position pos) {
        return LineDocumentUtils.getLineStartFromIndex((LineDocument)((LineDocument)doc), (int)pos.getLine()) + pos.getCharacter();
    }

    public static void applyWorkspaceEditor(WorkspaceEdit edit) {
        for (Map.Entry e : edit.getChanges().entrySet()) {
            try {
                StyledDocument doc;
                FileObject file = URLMapper.findFileObject((URL)new URI((String)e.getKey()).toURL());
                EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                StyledDocument styledDocument = doc = ec != null ? ec.openDocument() : null;
                if (doc == null) continue;
                NbDocument.runAtomic((StyledDocument)doc, () -> ((List)e.getValue()).stream().sorted((te1, te2) -> te1.getRange().getEnd().getLine() == te2.getRange().getEnd().getLine() ? te1.getRange().getEnd().getCharacter() - te2.getRange().getEnd().getCharacter() : te1.getRange().getEnd().getLine() - te2.getRange().getEnd().getLine()).forEach(te -> {
                    try {
                        int start = Utils.getOffset(doc, te.getRange().getStart());
                        int end = Utils.getOffset(doc, te.getRange().getEnd());
                        doc.remove(start, end - start);
                        doc.insertString(start, te.getNewText(), null);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }));
            }
            catch (IOException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void applyCodeAction(LSPBindings server, Either<Command, CodeAction> cmd) {
        try {
            Command command;
            if (cmd.isLeft()) {
                command = (Command)cmd.getLeft();
            } else {
                Utils.applyWorkspaceEditor(((CodeAction)cmd.getRight()).getEdit());
                command = ((CodeAction)cmd.getRight()).getCommand();
            }
            if (command != null) {
                server.getWorkspaceService().executeCommand(new ExecuteCommandParams(command.getCommand(), command.getArguments())).get();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

