/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class TextDocumentSyncServerCapabilityHandler {
    private final RequestProcessor WORKER = new RequestProcessor(TextDocumentSyncServerCapabilityHandler.class.getName(), 1, false, false);
    private final Set<JTextComponent> lastOpened = Collections.newSetFromMap(new IdentityHashMap());

    private void handleChange() {
        assert (SwingUtilities.isEventDispatchThread());
        Set currentOpened = Collections.newSetFromMap(new IdentityHashMap());
        currentOpened.addAll(EditorRegistry.componentList());
        Set<JTextComponent> newOpened = Collections.newSetFromMap(new IdentityHashMap());
        newOpened.addAll(currentOpened);
        newOpened.removeAll(this.lastOpened);
        Set newClosed = Collections.newSetFromMap(new IdentityHashMap());
        newClosed.addAll(this.lastOpened);
        newClosed.removeAll(newOpened);
        this.lastOpened.removeAll(newClosed);
        this.lastOpened.addAll(newOpened);
        for (JTextComponent opened : newOpened) {
            final FileObject file = NbEditorUtilities.getFileObject((Document)opened.getDocument());
            if (file == null) continue;
            final Document doc = opened.getDocument();
            this.WORKER.post(() -> {
                LSPBindings server = LSPBindings.getBindings(file);
                if (server == null) {
                    return;
                }
                String uri = Utils.toURI(file);
                String[] text = new String[1];
                doc.render(() -> {
                    try {
                        text[0] = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        text[0] = "";
                    }
                });
                TextDocumentItem textDocumentItem = new TextDocumentItem(uri, FileUtil.getMIMEType((FileObject)file), 0, text[0]);
                server.getTextDocumentService().didOpen(new DidOpenTextDocumentParams(textDocumentItem));
                server.scheduleBackgroundTasks(file);
            });
            doc.addDocumentListener(new DocumentListener(){
                int version;

                @Override
                public void insertUpdate(DocumentEvent e) {
                    try {
                        this.fireEvent(e.getOffset(), e.getDocument().getText(e.getOffset(), e.getLength()), "");
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.fireEvent(e.getOffset(), "", ((BaseDocumentEvent)e).getText());
                }

                private void fireEvent(int start, String newText, String oldText) {
                    try {
                        Position startPos = Utils.createPosition(doc, start);
                        int additionalLines = 0;
                        int additionalChars = 0;
                        for (char c : oldText.toCharArray()) {
                            if (c == '\n') {
                                ++additionalLines;
                                additionalChars = 0;
                                continue;
                            }
                            ++additionalChars;
                        }
                        Position endPos = new Position(startPos.getLine() + additionalLines, startPos.getCharacter() + additionalChars);
                        TextDocumentContentChangeEvent[] event = new TextDocumentContentChangeEvent[]{new TextDocumentContentChangeEvent(new Range(startPos, endPos), Integer.valueOf(oldText.length()), newText)};
                        TextDocumentSyncServerCapabilityHandler.this.WORKER.post(() -> {
                            LSPBindings server = LSPBindings.getBindings(file);
                            if (server == null) {
                                return;
                            }
                            TextDocumentSyncKind syncKind = TextDocumentSyncKind.None;
                            Either sync = server.getInitResult().getCapabilities().getTextDocumentSync();
                            if (sync != null) {
                                if (sync.isLeft()) {
                                    syncKind = (TextDocumentSyncKind)sync.getLeft();
                                } else {
                                    TextDocumentSyncKind change = ((TextDocumentSyncOptions)sync.getRight()).getChange();
                                    if (change != null) {
                                        syncKind = change;
                                    }
                                }
                            }
                            switch (syncKind) {
                                case None: {
                                    return;
                                }
                                case Full: {
                                    doc.render(() -> {
                                        try {
                                            event[0] = new TextDocumentContentChangeEvent(doc.getText(0, doc.getLength()));
                                        }
                                        catch (BadLocationException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                            event[0] = new TextDocumentContentChangeEvent("");
                                        }
                                    });
                                    break;
                                }
                            }
                            VersionedTextDocumentIdentifier di = new VersionedTextDocumentIdentifier(Integer.valueOf(++this.version));
                            di.setUri(Utils.toURI(file));
                            DidChangeTextDocumentParams params = new DidChangeTextDocumentParams(di, Arrays.asList(event));
                            server.getTextDocumentService().didChange(params);
                            server.scheduleBackgroundTasks(file);
                        });
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
    }

    public static class Init
    implements Runnable {
        @Override
        public void run() {
            TextDocumentSyncServerCapabilityHandler h = new TextDocumentSyncServerCapabilityHandler();
            EditorRegistry.addPropertyChangeListener(evt -> h.handleChange());
            SwingUtilities.invokeLater(() -> h.handleChange());
        }
    }
}

