/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.services.LanguageClient;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class LanguageClientImpl
implements LanguageClient {
    private static final Logger LOG = Logger.getLogger(LanguageClientImpl.class.getName());
    private static final RequestProcessor WORKER = new RequestProcessor(LanguageClientImpl.class.getName(), 1, false, false);
    private LSPBindings bindings;
    private boolean allowCodeActions;
    private static final Map<DiagnosticSeverity, Severity> severityMap = new EnumMap<DiagnosticSeverity, Severity>(DiagnosticSeverity.class);

    public void setBindings(LSPBindings bindings) {
        this.bindings = bindings;
        ServerCapabilities serverCapabilities = bindings.getInitResult().getCapabilities();
        Boolean codeActions = serverCapabilities.getCodeActionProvider();
        this.allowCodeActions = codeActions != null && codeActions != false;
    }

    public void telemetryEvent(Object arg0) {
        System.err.println("telemetry: " + arg0);
    }

    public void publishDiagnostics(PublishDiagnosticsParams pdp) {
        try {
            StyledDocument doc;
            FileObject file = URLMapper.findFileObject((URL)new URI(pdp.getUri()).toURL());
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument styledDocument = doc = ec != null ? ec.getDocument() : null;
            if (doc == null) {
                return;
            }
            List diags = pdp.getDiagnostics().stream().map(d -> {
                DiagnosticFixList fixList = this.allowCodeActions ? new DiagnosticFixList(pdp.getUri(), (Diagnostic)d) : ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
                return ErrorDescriptionFactory.createErrorDescription((Severity)severityMap.get(d.getSeverity()), (String)d.getMessage(), (LazyFixList)fixList, (FileObject)file, (int)Utils.getOffset(doc, d.getRange().getStart()), (int)Utils.getOffset(doc, d.getRange().getEnd()));
            }).collect(Collectors.toList());
            HintsController.setErrors((Document)doc, (String)LanguageClientImpl.class.getName(), diags);
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOG.log(Level.FINE, null, ex);
        }
    }

    public CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(ApplyWorkspaceEditParams params) {
        WorkspaceEdit edit = params.getEdit();
        for (Map.Entry e : edit.getChanges().entrySet()) {
            try {
                StyledDocument doc;
                FileObject file = URLMapper.findFileObject((URL)new URI((String)e.getKey()).toURL());
                EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                StyledDocument styledDocument = doc = ec != null ? ec.openDocument() : null;
                if (doc == null) continue;
                NbDocument.runAtomic((StyledDocument)doc, () -> ((List)e.getValue()).stream().sorted((te1, te2) -> te1.getRange().getEnd().getLine() == te2.getRange().getEnd().getLine() ? te1.getRange().getEnd().getCharacter() - te2.getRange().getEnd().getCharacter() : te1.getRange().getEnd().getLine() - te2.getRange().getEnd().getLine()).forEach(te -> {
                    try {
                        int start = Utils.getOffset(doc, te.getRange().getStart());
                        int end = Utils.getOffset(doc, te.getRange().getEnd());
                        doc.remove(start, end - start);
                        doc.insertString(start, te.getNewText(), null);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }));
            }
            catch (IOException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return CompletableFuture.completedFuture(new ApplyWorkspaceEditResponse(true));
    }

    public void showMessage(MessageParams arg0) {
        System.err.println("showMessage: " + arg0);
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams arg0) {
        System.err.println("showMessageRequest");
        return null;
    }

    public void logMessage(MessageParams arg0) {
        System.err.println("logMessage: " + arg0);
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams configurationParams) {
        CompletableFuture<List<Object>> result = new CompletableFuture<List<Object>>();
        WORKER.post(() -> {
            ArrayList<Object> outcome = new ArrayList<Object>();
            for (ConfigurationItem ci : configurationParams.getItems()) {
                outcome.add(null);
            }
            result.complete(outcome);
        });
        return result;
    }

    static {
        severityMap.put(DiagnosticSeverity.Error, Severity.ERROR);
        severityMap.put(DiagnosticSeverity.Hint, Severity.HINT);
        severityMap.put(DiagnosticSeverity.Information, Severity.HINT);
        severityMap.put(DiagnosticSeverity.Warning, Severity.HINT);
    }

    private final class DiagnosticFixList
    implements LazyFixList {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final String fileUri;
        private final Diagnostic diagnostic;
        private List<Fix> fixes;
        private boolean computing;
        private boolean computed;

        public DiagnosticFixList(String fileUri, Diagnostic diagnostic) {
            this.fileUri = fileUri;
            this.diagnostic = diagnostic;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public synchronized List<Fix> getFixes() {
            if (!this.computing && !this.computed) {
                this.computing = true;
                LanguageClientImpl.this.bindings.runOnBackground(() -> {
                    try {
                        List commands = (List)LanguageClientImpl.this.bindings.getTextDocumentService().codeAction(new CodeActionParams(new TextDocumentIdentifier(this.fileUri), this.diagnostic.getRange(), new CodeActionContext(Collections.singletonList(this.diagnostic)))).get();
                        List fixes = commands.stream().map(cmd -> new CommandBasedFix((Command)cmd)).collect(Collectors.toList());
                        DiagnosticFixList diagnosticFixList = this;
                        synchronized (diagnosticFixList) {
                            this.fixes = Collections.unmodifiableList(fixes);
                            this.computed = true;
                            this.computing = false;
                        }
                        this.pcs.firePropertyChange("computed", null, null);
                        this.pcs.firePropertyChange("fixes", null, null);
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
            }
            return this.fixes;
        }

        public synchronized boolean isComputed() {
            return this.computed;
        }

        private class CommandBasedFix
        implements Fix {
            private final Command cmd;

            public CommandBasedFix(Command cmd) {
                this.cmd = cmd;
            }

            public String getText() {
                return this.cmd.getTitle();
            }

            public ChangeInfo implement() throws Exception {
                try {
                    LanguageClientImpl.this.bindings.getWorkspaceService().executeCommand(new ExecuteCommandParams(this.cmd.getCommand(), this.cmd.getArguments())).get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return null;
            }
        }
    }
}

