/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.netbeans.modules.lsp.client.bindings.Utils;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class CompletionProviderImpl
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                try {
                    boolean incomplete;
                    List items;
                    FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                    if (file == null) {
                        return;
                    }
                    LSPBindings server = LSPBindings.getBindings(file);
                    if (server == null) {
                        return;
                    }
                    URI uri = file.toURI();
                    CompletionParams params = new CompletionParams(new TextDocumentIdentifier(uri.toString()), Utils.createPosition(doc, caretOffset));
                    CountDownLatch l = new CountDownLatch(1);
                    Either completionResult = (Either)server.getTextDocumentService().completion(params).get();
                    if (completionResult.isLeft()) {
                        items = (List)completionResult.getLeft();
                        incomplete = true;
                    } else {
                        items = ((CompletionList)completionResult.getRight()).getItems();
                        incomplete = ((CompletionList)completionResult.getRight()).isIncomplete();
                    }
                    for (final CompletionItem i : items) {
                        final String insert = i.getInsertText() != null ? i.getInsertText() : i.getLabel();
                        CompletionItemKind kind = i.getKind();
                        Icon ic = Icons.getCompletionIcon(kind);
                        final ImageIcon icon = new ImageIcon(ImageUtilities.icon2Image((Icon)ic));
                        resultSet.addItem(new org.netbeans.spi.editor.completion.CompletionItem(){

                            public void defaultAction(JTextComponent jtc) {
                                Document doc = jtc.getDocument();
                                TextEdit te = i.getTextEdit();
                                if (te != null) {
                                    int start = Utils.getOffset(doc, te.getRange().getStart());
                                    int end = Utils.getOffset(doc, te.getRange().getEnd());
                                    NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
                                        try {
                                            doc.remove(start, end - start);
                                            doc.insertString(start, te.getNewText(), null);
                                        }
                                        catch (BadLocationException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                        }
                                    });
                                } else {
                                    String toAdd = i.getInsertText();
                                    if (toAdd == null) {
                                        toAdd = i.getLabel();
                                    }
                                    try {
                                        int offset = jtc.getCaretPosition();
                                        String ident = Utilities.getIdentifier((BaseDocument)((BaseDocument)doc), (int)offset);
                                        doc.insertString(offset, toAdd.substring(ident != null ? ident.length() : 0), null);
                                    }
                                    catch (BadLocationException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            }

                            public void processKeyEvent(KeyEvent ke) {
                            }

                            public int getPreferredWidth(Graphics grphcs, Font font) {
                                return CompletionUtilities.getPreferredWidth((String)insert, null, (Graphics)grphcs, (Font)font);
                            }

                            public void render(Graphics grphcs, Font font, Color color, Color color1, int i2, int i1, boolean bln) {
                                CompletionUtilities.renderHtml((ImageIcon)icon, (String)insert, null, (Graphics)grphcs, (Font)font, (Color)color, (int)i2, (int)i1, (boolean)bln);
                            }

                            public CompletionTask createDocumentationTask() {
                                return null;
                            }

                            public CompletionTask createToolTipTask() {
                                return null;
                            }

                            public boolean instantSubstitution(JTextComponent jtc) {
                                return false;
                            }

                            public int getSortPriority() {
                                return 100;
                            }

                            public CharSequence getSortText() {
                                return i.getSortText();
                            }

                            public CharSequence getInsertPrefix() {
                                return insert;
                            }
                        });
                    }
                }
                catch (InterruptedException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    resultSet.finish();
                }
            }
        }, component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }
}

