/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.bindings.Utils;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CodeActions
implements CodeGenerator.Factory {
    public List<? extends CodeGenerator> create(Lookup context) {
        JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
        if (component == null) {
            return Collections.emptyList();
        }
        FileObject file = NbEditorUtilities.getFileObject((Document)component.getDocument());
        if (file == null) {
            return Collections.emptyList();
        }
        LSPBindings server = LSPBindings.getBindings(file);
        if (server == null) {
            return Collections.emptyList();
        }
        URI uri = file.toURI();
        try {
            List commands = (List)server.getTextDocumentService().codeAction(new CodeActionParams(new TextDocumentIdentifier(uri.toString()), new Range(Utils.createPosition(component.getDocument(), component.getSelectionStart()), Utils.createPosition(component.getDocument(), component.getSelectionEnd())), new CodeActionContext(Collections.emptyList()))).get();
            return commands.stream().map(cmd -> new CodeGenerator((Command)cmd, server){
                final /* synthetic */ Command val$cmd;
                final /* synthetic */ LSPBindings val$server;
                {
                    this.val$cmd = command;
                    this.val$server = lSPBindings;
                }

                public String getDisplayName() {
                    return this.val$cmd.getTitle();
                }

                public void invoke() {
                    try {
                        this.val$server.getWorkspaceService().executeCommand(new ExecuteCommandParams(this.val$cmd.getCommand(), this.val$cmd.getArguments())).get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException | BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }
}

