/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.parser.ASTFeatures;
import org.netbeans.modules.languages.parser.AnalyserAnalyser;
import org.netbeans.modules.languages.parser.First;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.util.NbBundle;

public class LLSyntaxAnalyser {
    public static final String GAP_TOKEN_TYPE_NAME = "GAP";
    private Language language;
    private List<Rule> grammarRules;
    private First first;
    private Set<Integer> skipTokenTypes;
    private int traceSteps = -1;
    private boolean printFirst = false;

    private LLSyntaxAnalyser(Language language, List<Rule> grammarRules, Set<Integer> skipTokenTypes) {
        this.language = language;
        this.grammarRules = grammarRules;
        this.skipTokenTypes = skipTokenTypes;
    }

    public List<Rule> getRules() {
        return this.grammarRules;
    }

    public Set<Integer> getSkipTokenTypes() {
        return this.skipTokenTypes;
    }

    First getFirst() {
        return this.first;
    }

    public static LLSyntaxAnalyser create(Language language, List<Rule> grammarRules, Set<Integer> skipTokenTypes) throws ParseException {
        LLSyntaxAnalyser a = new LLSyntaxAnalyser(language, grammarRules, skipTokenTypes);
        a.initTracing();
        a.first = First.create(a.grammarRules, language);
        return a;
    }

    public static LLSyntaxAnalyser createEmpty(Language language) {
        LLSyntaxAnalyser a = new LLSyntaxAnalyser(language, Collections.<Rule>emptyList(), Collections.<Integer>emptySet());
        try {
            a.first = First.create(Collections.<Rule>emptyList(), language);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return a;
    }

    public ASTNode read(TokenInput input, boolean skipErrors, List<SyntaxError> syntaxErrors, boolean[] cancel) throws ParseException {
        ASTNode root;
        HashMap<String, List<ASTItem>> embeddings = new HashMap<String, List<ASTItem>>();
        try {
            root = this.grammarRules.isEmpty() || input.eof() ? this.readNoGrammar(input, skipErrors, embeddings, syntaxErrors, cancel) : this.read2(input, skipErrors, embeddings, syntaxErrors, cancel);
        }
        catch (CancelledException ex) {
            return null;
        }
        if (embeddings.isEmpty()) {
            this.inspect(root);
            return root;
        }
        ArrayList<ASTItem> roots = new ArrayList<ASTItem>();
        for (String mimeType : embeddings.keySet()) {
            ASTNode newRoot;
            String process_embedded;
            List tokens = (List)embeddings.get(mimeType);
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            TokenInput in = TokenInputUtils.create(tokens);
            ASTNode r = language.getAnalyser().read(in, skipErrors, syntaxErrors, cancel);
            if (r == null) continue;
            Feature astProperties = language.getFeatureList().getFeature("AST");
            if (astProperties != null && ((process_embedded = (String)astProperties.getValue("process_embedded")) == null || Boolean.valueOf(process_embedded).booleanValue()) && (newRoot = (ASTNode)astProperties.getValue("process", SyntaxContext.create(null, ASTPath.create(r)))) != null) {
                r = newRoot;
            }
            roots.add(r);
        }
        roots.add(root);
        ASTNode result = ASTNode.createCompoundASTNode(this.language, "Root", roots, 0);
        this.inspect(result);
        return result;
    }

    private void inspect(ASTItem item) {
        Iterator<ASTItem> it = new ArrayList<ASTItem>(item.getChildren()).iterator();
        int i = 0;
        while (it.hasNext()) {
            ASTItem child = it.next();
            if (child instanceof ASTNode && item instanceof ASTNode) {
                ASTNode n = (ASTNode)child;
                if (this.removeNode(n)) {
                    ((ASTNode)item).removeChildren(n);
                    continue;
                }
                ASTItem r = this.replaceNode(n);
                if (r != null) {
                    ((ASTNode)item).setChildren(i, r);
                    child = r;
                }
            }
            ++i;
            this.inspect(child);
        }
    }

    private ASTNode read(TokenInput input, boolean skipErrors, Map<String, List<ASTItem>> embeddings, List<SyntaxError> syntaxErrors, boolean[] cancel) throws ParseException, CancelledException {
        if (this.grammarRules.isEmpty() || input.eof()) {
            return this.readNoGrammar(input, skipErrors, embeddings, syntaxErrors, cancel);
        }
        return this.read2(input, skipErrors, embeddings, syntaxErrors, cancel);
    }

    private ASTNode read2(TokenInput input, boolean skipErrors, Map<String, List<ASTItem>> embeddings, List<SyntaxError> syntaxErrors, boolean[] cancel) throws ParseException, CancelledException {
        List<ASTItem> whitespaces;
        Stack<Object> stack = new Stack<Object>();
        ASTNode root = null;
        ASTNode node = null;
        ListIterator it = Collections.singletonList("S").listIterator();
        boolean firstLine = true;
        while (true) {
            if (cancel[0]) {
                throw new CancelledException();
            }
            int offset = input.getOffset();
            whitespaces = this.readWhitespaces(node, input, skipErrors, embeddings, syntaxErrors, cancel);
            if (firstLine && input.eof() && whitespaces != null) {
                return this.readNoGrammar(whitespaces, offset, skipErrors, embeddings, syntaxErrors, cancel);
            }
            if (node != null) {
                offset = input.getOffset();
            }
            while (!it.hasNext() && !stack.empty()) {
                node = (ASTNode)stack.pop();
                it = (ListIterator)stack.pop();
            }
            if (!it.hasNext()) break;
            String current = it.next();
            if (current instanceof String) {
                String nt = current;
                int newRule = this.first.getRule(this.language.getNTID(nt), input, this.skipTokenTypes);
                if (newRule < 0) {
                    if (!skipErrors) {
                        if (node == null) {
                            root = node = ASTNode.create(this.language, "Root", whitespaces, offset);
                        }
                        throw new ParseException("Syntax error (nt: " + nt + ", tokens: " + input.next(1) + " " + input.next(2) + ".", root);
                    }
                    if (input.eof()) {
                        if (node == null) {
                            root = node = ASTNode.create(this.language, "Root", whitespaces, offset);
                        }
                        it.previous();
                        it = this.readError(node, root, input, null, it, stack, embeddings, syntaxErrors, whitespaces, cancel);
                        return root;
                    }
                    it.previous();
                    it = this.readError(node, root, input, null, it, stack, embeddings, syntaxErrors, whitespaces, cancel);
                    continue;
                }
                Rule rule = this.grammarRules.get(newRule);
                Feature parse = this.language.getFeatureList().getFeature("PARSE", rule.getNT());
                if (parse != null) {
                    stack.push(it);
                    stack.push(node);
                    it = Collections.EMPTY_LIST.listIterator();
                    ASTNode nast = (ASTNode)parse.getValue(new Object[]{input, stack});
                    if (nast == null) continue;
                    node.addChildren(nast);
                    continue;
                }
                if (node == null || it.hasNext() || !nt.equals(node.getNT())) {
                    if (nt.indexOf(36) > 0 || nt.indexOf(35) > 0) {
                        stack.push(it);
                        stack.push(node);
                    } else {
                        if (rule.getRight().isEmpty() && this.removeEmpty(this.language, rule.getNT())) continue;
                        ASTNode nnode = ASTNode.create(this.language, rule.getNT(), whitespaces, offset);
                        if (node != null) {
                            node.addChildren(nnode);
                            stack.push(it);
                            stack.push(node);
                        } else {
                            root = nnode;
                        }
                        node = nnode;
                    }
                }
                it = rule.getRight().listIterator();
                continue;
            }
            ASTToken token = (ASTToken)((Object)current);
            if (input.eof()) {
                if (!skipErrors) {
                    throw new ParseException("Unexpected end of file.", root);
                }
                it.previous();
                it = this.readError(node, root, input, token, it, stack, embeddings, syntaxErrors, whitespaces, cancel);
                return root;
            }
            if (!LLSyntaxAnalyser.isCompatible(token, input.next(1))) {
                if (input.next(1).getTypeName().equals(GAP_TOKEN_TYPE_NAME)) {
                    input.read();
                    continue;
                }
                if (!skipErrors) {
                    throw new ParseException("Unexpected token " + input.next(1) + ". Expecting " + token, root);
                }
                it.previous();
                it = this.readError(node, root, input, token, it, stack, embeddings, syntaxErrors, whitespaces, cancel);
                continue;
            }
            node.addChildren(this.readEmbeddings(input.read(), skipErrors, embeddings, syntaxErrors, cancel));
        }
        if (!skipErrors && !input.eof()) {
            throw new ParseException("Unexpected token " + input.next(1) + ".", root);
        }
        while (!input.eof()) {
            it = this.readError(node, root, input, null, it, stack, embeddings, syntaxErrors, whitespaces, cancel);
        }
        if (root == null) {
            root = ASTNode.create(this.language, "Root", whitespaces, input.getOffset());
        }
        return root;
    }

    private static boolean isCompatible(ASTToken t1, ASTToken t2) {
        if (t1.getTypeID() == -1) {
            return t1.getIdentifier().equals(t2.getIdentifier());
        }
        if (t1.getIdentifier() == null) {
            return t1.getTypeID() == t2.getTypeID();
        }
        return t1.getTypeID() == t2.getTypeID() && t1.getIdentifier().equals(t2.getIdentifier());
    }

    private List<ASTItem> readWhitespaces(ASTNode node, TokenInput input, boolean skipErrors, Map<String, List<ASTItem>> embeddings, List<SyntaxError> syntaxErrors, boolean[] cancel) throws ParseException, CancelledException {
        ArrayList<ASTItem> result = null;
        while (!input.eof() && this.skipTokenTypes.contains(input.next(1).getTypeID())) {
            if (cancel[0]) {
                throw new CancelledException();
            }
            ASTToken token = input.read();
            if (node != null) {
                node.addChildren(this.readEmbeddings(token, skipErrors, embeddings, syntaxErrors, cancel));
                continue;
            }
            if (result == null) {
                result = new ArrayList<ASTItem>();
            }
            result.add(this.readEmbeddings(token, skipErrors, embeddings, syntaxErrors, cancel));
        }
        return result;
    }

    private ASTItem readEmbeddings(ASTToken token, boolean skipErrors, Map<String, List<ASTItem>> embeddings, List<SyntaxError> syntaxErrors, boolean[] cancel) throws ParseException, CancelledException {
        ASTNode newRoot;
        String process_embedded;
        String skip_embedded;
        List<ASTItem> children = token.getChildren();
        if (children.isEmpty()) {
            return token;
        }
        TokenInput in = TokenInputUtils.create(children);
        String mimeType = children.get(0).getMimeType();
        Language language = (Language)children.get(0).getLanguage();
        if (language == null) {
            return this.readNoGrammar(in, skipErrors, embeddings, syntaxErrors, cancel);
        }
        Feature astp = language.getFeatureList().getFeature("AST");
        if (astp != null && (skip_embedded = (String)astp.getValue("skip_embedded")) != null && Boolean.valueOf(skip_embedded).booleanValue()) {
            return this.skipEmbedding(token, embeddings, children, mimeType);
        }
        Language outerLanguage = (Language)token.getLanguage();
        if (outerLanguage != null) {
            Feature f = outerLanguage.getPreprocessorImport();
            if (f != null && f.getValue("mimeType").equals(mimeType) && f.getBoolean("continual", false)) {
                return this.skipEmbedding(token, embeddings, children, mimeType);
            }
            f = outerLanguage.getTokenImports().get(token.getTypeName());
            if (f != null && f.getValue("mimeType").equals(mimeType) && f.getBoolean("continual", false)) {
                return this.skipEmbedding(token, embeddings, children, mimeType);
            }
        }
        Feature astProperties = language.getFeatureList().getFeature("AST");
        ASTNode root = language.getAnalyser().read(in, skipErrors, embeddings, syntaxErrors, cancel);
        if (astProperties != null && ((process_embedded = (String)astProperties.getValue("process_embedded")) == null || Boolean.valueOf(process_embedded).booleanValue()) && (newRoot = (ASTNode)astProperties.getValue("process", SyntaxContext.create(null, ASTPath.create(root)))) != null) {
            root = newRoot;
        }
        return ASTToken.create((org.netbeans.api.languages.Language)outerLanguage, token.getTypeID(), token.getIdentifier(), token.getOffset(), token.getLength(), Collections.singletonList(root));
    }

    private ASTToken skipEmbedding(ASTToken token, Map<String, List<ASTItem>> embeddings, List<ASTItem> children, String mimeType) {
        List<ASTItem> l = embeddings.get(mimeType);
        if (l == null) {
            l = new ArrayList<ASTItem>();
            embeddings.put(mimeType, l);
            l.addAll(children.subList(0, children.size()));
            LLSyntaxAnalyser.appendGap(l);
        } else {
            ASTToken token1 = (ASTToken)l.get(l.size() - 1);
            ASTToken token2 = (ASTToken)children.get(0);
            if (token1.getTypeID() == token2.getTypeID()) {
                l.remove(l.size() - 1);
                ASTToken joinedToken = LLSyntaxAnalyser.join(token1, token2);
                l.add(joinedToken);
                l.addAll(children.subList(1, children.size()));
            } else {
                l.addAll(children);
            }
            LLSyntaxAnalyser.appendGap(l);
        }
        return ASTToken.create(token.getLanguage(), token.getTypeID(), token.getIdentifier(), token.getOffset(), token.getLength(), Collections.emptyList());
    }

    private static ASTToken join(ASTToken token1, ASTToken token2) {
        List<ASTItem> token1Children = token1.getChildren();
        List<ASTItem> token2Children = token2.getChildren();
        ArrayList<ASTItem> joinedChildren = new ArrayList<ASTItem>();
        if (token1Children.size() > 1 && token2Children.size() > 0) {
            ASTToken t1 = (ASTToken)token1Children.get(token1Children.size() - 2);
            ASTToken t2 = (ASTToken)token2Children.get(0);
            if ("js_string".equals(t1.getTypeName()) && "js_string".equals(t2.getTypeName()) || "css_string".equals(t1.getTypeName()) && "css_string".equals(t2.getTypeName())) {
                joinedChildren.addAll(token1Children.subList(0, token1Children.size() - 2));
                joinedChildren.add(ASTToken.create(t1.getLanguage(), t1.getTypeID(), t1.getIdentifier() + t2.getIdentifier(), t1.getOffset()));
                joinedChildren.addAll(token2Children.subList(1, token2Children.size()));
            } else {
                joinedChildren.addAll(token1Children);
                joinedChildren.addAll(token2Children);
            }
        } else {
            joinedChildren.addAll(token1Children);
            joinedChildren.addAll(token2Children);
        }
        return ASTToken.create(token1.getLanguage(), token1.getTypeID(), "", token1.getOffset(), token2.getEndOffset() - token1.getOffset(), joinedChildren);
    }

    private static void appendGap(List<ASTItem> children) {
        ASTToken lastToken = (ASTToken)children.get(children.size() - 1);
        if (lastToken.getChildren().isEmpty()) {
            return;
        }
        ArrayList<ASTItem> lastTokenChildren = new ArrayList<ASTItem>(lastToken.getChildren());
        lastTokenChildren.add(ASTToken.create(((ASTItem)lastTokenChildren.get(0)).getLanguage(), GAP_TOKEN_TYPE_NAME, "", ((ASTItem)lastTokenChildren.get(lastTokenChildren.size() - 1)).getEndOffset(), 0, null));
        children.remove(children.size() - 1);
        children.add(ASTToken.create(lastToken.getLanguage(), lastToken.getTypeID(), lastToken.getIdentifier(), lastToken.getOffset(), lastToken.getLength(), lastTokenChildren));
    }

    private ASTNode readNoGrammar(TokenInput input, boolean skipErrors, Map<String, List<ASTItem>> embeddings, List<SyntaxError> syntaxErrors, boolean[] cancel) throws ParseException, CancelledException {
        ASTNode root = ASTNode.create(this.language, "S", input.getIndex());
        while (!input.eof()) {
            if (cancel[0]) {
                throw new CancelledException();
            }
            ASTToken token = input.read();
            root.addChildren(this.readEmbeddings(token, skipErrors, embeddings, syntaxErrors, cancel));
        }
        return root;
    }

    private ASTNode readNoGrammar(List tokens, int offset, boolean skipErrors, Map<String, List<ASTItem>> embeddings, List<SyntaxError> syntaxErrors, boolean[] cancel) throws ParseException, CancelledException {
        ASTNode root = ASTNode.create(this.language, "S", offset);
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            if (cancel[0]) {
                throw new CancelledException();
            }
            ASTToken token = (ASTToken)iter.next();
            root.addChildren(this.readEmbeddings(token, skipErrors, embeddings, syntaxErrors, cancel));
        }
        return root;
    }

    private ListIterator readError(ASTNode parentNode, ASTNode root, TokenInput input, ASTToken expectedToken, ListIterator iterator, Stack stack, Map<String, List<ASTItem>> embeddings, List<SyntaxError> syntaxErrors, List<ASTItem> whitespaces, boolean[] cancel) throws ParseException, CancelledException {
        ListIterator newIterator = this.findError(parentNode, parentNode, input, expectedToken, iterator, stack, embeddings, syntaxErrors, cancel);
        if (newIterator != null) {
            return newIterator;
        }
        if (root != parentNode) {
            ASTNode n = root;
            while (n != null) {
                ASTItem item;
                newIterator = this.findError(n, parentNode, input, expectedToken, iterator, stack, embeddings, syntaxErrors, cancel);
                if (newIterator != null) {
                    return newIterator;
                }
                List<ASTItem> children = n.getChildren();
                if (children.isEmpty() || !((item = children.get(children.size() - 1)) instanceof ASTNode) || item == parentNode) break;
                n = (ASTNode)item;
            }
        }
        this.createError(input, expectedToken, syntaxErrors, null);
        if (!input.eof()) {
            if (parentNode != null) {
                parentNode.addChildren(this.readEmbeddings(input.read(), true, embeddings, syntaxErrors, cancel));
            } else {
                if (whitespaces == null) {
                    whitespaces = new ArrayList<ASTItem>();
                }
                whitespaces.add(this.readEmbeddings(input.read(), true, embeddings, syntaxErrors, cancel));
            }
        }
        return iterator;
    }

    private ListIterator findError(ASTNode node, ASTNode parentNode, TokenInput input, ASTToken expectedToken, ListIterator iterator, Stack stack, Map<String, List<ASTItem>> embeddings, List<SyntaxError> syntaxErrors, boolean[] cancel) throws ParseException, CancelledException {
        String id = node == null ? "S" : node.getNT();
        List<Feature> features = this.language.getFeatureList().getFeatures("SYNTAX_ERROR", id);
        if (features.isEmpty()) {
            return null;
        }
        boolean errorCreated = false;
        HashMap<String, String> tokenIdentifierToNt = new HashMap<String, String>();
        for (Feature feature : features) {
            boolean eof = feature.getBoolean("eof", false);
            String nextTokenTypeName = (String)feature.getValue("next_token_type_name");
            String nextTokenIdentifier = (String)feature.getValue("next_token_identifier");
            if (!(eof && input.eof() || !input.eof() && nextTokenTypeName != null && nextTokenTypeName.equals(input.next(1).getTypeName()) || !input.eof() && nextTokenIdentifier != null && nextTokenIdentifier.equals(input.next(1).getIdentifier())) && (eof || nextTokenIdentifier != null || nextTokenTypeName != null)) continue;
            String message = (String)feature.getValue("message");
            String tokenIdentifier = (String)feature.getValue("token_identifier");
            String nt = (String)feature.getValue("nt");
            if (tokenIdentifier != null) {
                tokenIdentifierToNt.put(tokenIdentifier, nt);
            }
            if (message == null || errorCreated) continue;
            this.createError(input, expectedToken, syntaxErrors, message);
            errorCreated = true;
        }
        if (!errorCreated) {
            this.createError(input, expectedToken, syntaxErrors, null);
        }
        if (tokenIdentifierToNt.isEmpty()) {
            if (!input.eof()) {
                parentNode.addChildren(this.readEmbeddings(input.read(), true, embeddings, syntaxErrors, cancel));
            }
            return iterator;
        }
        while (!input.eof() && !tokenIdentifierToNt.containsKey(input.next(1).getIdentifier())) {
            parentNode.addChildren(this.readEmbeddings(input.read(), true, embeddings, syntaxErrors, cancel));
        }
        if (input.eof()) {
            return iterator;
        }
        String nt = (String)tokenIdentifierToNt.get(input.next(1).getIdentifier());
        if (nt != null) {
            String cnt = parentNode.getNT();
            while (!cnt.equals(nt) && !stack.isEmpty()) {
                cnt = ((ASTNode)stack.pop()).getNT();
                iterator = (ListIterator)stack.pop();
            }
        }
        return iterator;
    }

    private void createError(TokenInput input, ASTToken expectedToken, List<SyntaxError> syntaxErrors, String message) {
        ASTToken item;
        ASTToken aSTToken = item = input.eof() ? ASTToken.create(null, 0, "", input.getOffset()) : input.next(1);
        if (message == null) {
            String type;
            message = expectedToken != null ? (expectedToken.getIdentifier() != null ? MessageFormat.format(NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_ID_expected"), expectedToken.getIdentifier()) : ((type = expectedToken.getTypeName()).contains("identifier") ? NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Identifier_expected") : (type.contains("string") ? NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_String_expected") : (type.contains("keyword") ? NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Keyword_expected") : MessageFormat.format(NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Type_expected"), type))))) : (input.eof() ? NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Unexpected_end_of_file") : MessageFormat.format(NbBundle.getMessage(LLSyntaxAnalyser.class, (String)"CTL_Unexpected_token_ID"), input.next(1).getIdentifier()));
        }
        syntaxErrors.add(new SyntaxError(item, message));
    }

    private void initTracing() {
        Feature properties = this.language.getFeatureList().getFeature("PROPERTIES");
        if (properties == null) {
            return;
        }
        try {
            this.traceSteps = Integer.parseInt((String)properties.getValue("traceSteps"));
        }
        catch (NumberFormatException ex) {
            this.traceSteps = -2;
        }
        if (properties.getBoolean("printRules", false)) {
            AnalyserAnalyser.printRules(this.grammarRules, null);
        }
        this.printFirst = properties.getBoolean("printFirst", false);
    }

    private boolean removeNode(ASTNode node) {
        List<ASTItem> l = node.getChildren();
        if (!l.isEmpty()) {
            return false;
        }
        ASTFeatures astFeatures = ASTFeatures.get((Language)node.getLanguage());
        return astFeatures.removeEmpty || astFeatures.removeEmptyN == astFeatures.empty.contains(node.getNT());
    }

    private ASTItem replaceNode(ASTNode node) {
        ASTFeatures astFeatures = ASTFeatures.get((Language)node.getLanguage());
        ASTItem result = null;
        List<ASTItem> l;
        while ((l = node.getChildren()).size() == 1) {
            if (!astFeatures.removeSimple && astFeatures.removeSimpleN != astFeatures.simple.contains(node.getNT())) {
                return result;
            }
            result = l.get(0);
            if (!(result instanceof ASTNode)) {
                return result;
            }
            node = (ASTNode)result;
        }
        return result;
    }

    private boolean removeEmpty(Language language, String nt) {
        ASTFeatures astFeatures = ASTFeatures.get(language);
        return astFeatures.removeEmpty || astFeatures.removeEmptyN == astFeatures.empty.contains(nt);
    }

    private class CancelledException
    extends Exception {
        private CancelledException() {
        }
    }

    public static class T {
        int type;
        String identifier;

        T(ASTToken t) {
            this.type = t.getTypeID();
            this.identifier = t.getIdentifier();
        }

        public boolean equals(Object o) {
            if (!(o instanceof T)) {
                return false;
            }
            return !(((T)o).type != -1 && ((T)o).type != this.type || ((T)o).identifier != null && !((T)o).identifier.equals(this.identifier));
        }

        public int hashCode() {
            return (this.type + 1) * (this.identifier == null ? -1 : this.identifier.hashCode());
        }

        public String toString() {
            if (this.type == -1) {
                return "\"" + this.identifier + "\"";
            }
            if (this.identifier == null) {
                return "<" + this.type + ">";
            }
            return "[" + this.type + "," + this.identifier + "]";
        }

        public String toString(Language language) {
            if (this.type == -1) {
                return "\"" + this.identifier + "\"";
            }
            String typeName = language.getTokenType(this.type);
            if (this.identifier == null) {
                return "<" + typeName + ">";
            }
            return "[" + typeName + "," + this.identifier + "]";
        }
    }
}

