/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui.snippet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.java.source.ui.snippet.MarkupTag;
import org.netbeans.api.java.source.ui.snippet.MarkupTagAttribute;
import org.netbeans.api.java.source.ui.snippet.SourceLineMeta;

public class MarkupTagProcessor {
    private static final List<String> SUPPORTED_SNIPPET_MARKUP_TAGS = Arrays.asList("highlight", "replace", "link");

    public ProcessedTags process(List<SourceLineMeta> parseResult) {
        TreeMap<Integer, List<ApplicableMarkupTag>> markUpTagOnLine = new TreeMap<Integer, List<ApplicableMarkupTag>>();
        TreeMap<Integer, List<Region>> regionTagOnLine = new TreeMap<Integer, List<Region>>();
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<Region> regionList = new ArrayList<Region>();
        int thisLine = 1;
        int nextLine = 1;
        block0: for (SourceLineMeta fullLineInfo : parseResult) {
            ++nextLine;
            if (!regionList.isEmpty()) {
                ArrayList newRegionList = new ArrayList(regionList);
                regionTagOnLine.put(thisLine, newRegionList);
                this.addMarkupTags(thisLine, this.transformRegionAttributeToMarkupTag(newRegionList), markUpTagOnLine);
            }
            if (!fullLineInfo.getThisLineMarkUpTags().isEmpty()) {
                block1: for (MarkupTag markUpTag : fullLineInfo.getThisLineMarkUpTags()) {
                    String regionVal;
                    if (SUPPORTED_SNIPPET_MARKUP_TAGS.contains(markUpTag.getTagName())) {
                        HashMap<String, String> markupAttribute = new HashMap<String, String>();
                        boolean isSubStringOrRegexArrive = false;
                        for (MarkupTagAttribute markUpTagAttribute : markUpTag.getMarkUpTagAttributes()) {
                            if (isSubStringOrRegexArrive && (markUpTagAttribute.getName().equals("substring") || markUpTagAttribute.getName().equals("regex"))) continue;
                            markupAttribute.putIfAbsent(markUpTagAttribute.getName(), markUpTagAttribute.getValue());
                            if (isSubStringOrRegexArrive || !markUpTagAttribute.getName().equals("substring") && !markUpTagAttribute.getName().equals("regex")) continue;
                            isSubStringOrRegexArrive = true;
                        }
                        if (markupAttribute.containsKey("region")) {
                            regionVal = markupAttribute.get("region") != null ? (String)markupAttribute.get("region") : "anonymous";
                            markupAttribute.remove("region");
                            Region region = new Region(regionVal, markupAttribute, markUpTag.getTagName());
                            regionList.add(region);
                            ArrayList<Region> newRegionList = new ArrayList<Region>();
                            newRegionList.add(region);
                            regionTagOnLine.put(markUpTag.isTagApplicableToNextLine() ? nextLine : thisLine, newRegionList);
                            if (!markUpTag.isTagApplicableToNextLine()) {
                                this.addMarkupTags(thisLine, this.transformRegionAttributeToMarkupTag(newRegionList), markUpTagOnLine);
                            }
                        } else {
                            ApplicableMarkupTag markupTag = new ApplicableMarkupTag(markupAttribute, markUpTag.getTagName());
                            ArrayList<ApplicableMarkupTag> markupTagList = new ArrayList<ApplicableMarkupTag>();
                            markupTagList.add(markupTag);
                            this.addMarkupTags(markUpTag.isTagApplicableToNextLine() ? nextLine : thisLine, markupTagList, markUpTagOnLine);
                        }
                    }
                    if (!markUpTag.getTagName().equals("end")) continue;
                    ArrayList<Region> newRegionList = new ArrayList<Region>(regionList);
                    regionTagOnLine.put(thisLine, newRegionList);
                    this.addMarkupTags(thisLine, this.transformRegionAttributeToMarkupTag(newRegionList), markUpTagOnLine);
                    HashMap<String, String> eAttrib = new HashMap<String, String>();
                    for (MarkupTagAttribute markUpTagAttribute : markUpTag.getMarkUpTagAttributes()) {
                        eAttrib.putIfAbsent(markUpTagAttribute.getName(), markUpTagAttribute.getValue());
                    }
                    regionVal = "anonymous";
                    if (eAttrib.containsKey("region")) {
                        regionVal = eAttrib.get("region") == null || ((String)eAttrib.get("region")).trim().isEmpty() ? "anonymous" : (String)eAttrib.get("region");
                        for (int i = regionList.size() - 1; i >= 0; --i) {
                            if (!((Region)regionList.get(i)).getValue().equals(regionVal)) continue;
                            regionList.remove(i);
                            continue block1;
                        }
                        continue;
                    }
                    if (!regionList.isEmpty()) {
                        regionList.remove(regionList.size() - 1);
                        continue;
                    }
                    errorList.add(String.format("error: snippet markup: no region to end @end <sub>^</sub><b><i>%s</b></i>", regionVal));
                    break block0;
                }
            }
            ++thisLine;
        }
        if (!regionList.isEmpty()) {
            for (Region region : regionList) {
                String error = region.markupTagName.equals("end") ? String.format("error: snippet markup: no region to end <b><i>%s %s</b></i>", region.markupTagName, region.value) : String.format("error: snippet markup: unpaired region <b><i>%s %s</b></i>", region.markupTagName, region.value);
                errorList.add(error);
            }
        }
        return new ProcessedTags(markUpTagOnLine, regionTagOnLine, errorList);
    }

    private List<ApplicableMarkupTag> transformRegionAttributeToMarkupTag(List<Region> regionList) {
        ArrayList<ApplicableMarkupTag> markupTag = new ArrayList<ApplicableMarkupTag>();
        regionList.iterator().forEachRemaining(region -> markupTag.add(new ApplicableMarkupTag(region.getAttributes(), region.getMarkupTagName())));
        return markupTag;
    }

    private void addMarkupTags(Integer thisLine, List<ApplicableMarkupTag> markupTagList, Map<Integer, List<ApplicableMarkupTag>> markUpTagOnLine) {
        if (markUpTagOnLine.containsKey(thisLine)) {
            markUpTagOnLine.get(thisLine).addAll(markupTagList);
        } else {
            markUpTagOnLine.put(thisLine, markupTagList);
        }
    }

    public class ProcessedTags {
        private Map<Integer, List<ApplicableMarkupTag>> markUpTagLineMapper;
        private Map<Integer, List<Region>> regionTagLineMapper;
        private List<String> errorList = new ArrayList<String>();

        public ProcessedTags(Map<Integer, List<ApplicableMarkupTag>> markUpTagLineMapper, Map<Integer, List<Region>> regionTagLineMapper, List<String> errorList) {
            this.markUpTagLineMapper = markUpTagLineMapper;
            this.regionTagLineMapper = regionTagLineMapper;
            this.errorList = errorList;
        }

        public Map<Integer, List<ApplicableMarkupTag>> getMarkUpTagLineMapper() {
            return this.markUpTagLineMapper;
        }

        public Map<Integer, List<Region>> getRegionTagLineMapper() {
            return this.regionTagLineMapper;
        }

        public List<String> getErrorList() {
            return this.errorList;
        }
    }

    public class ApplicableMarkupTag {
        private final String markupTagName;
        private Map<String, String> attributes;

        ApplicableMarkupTag(Map<String, String> attributes, String markupTagName) {
            this.attributes = attributes;
            this.markupTagName = markupTagName;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getMarkupTagName() {
            return this.markupTagName;
        }

        public String toString() {
            return "Attrib{attributes=" + this.attributes + '}';
        }
    }

    private class Region {
        private final String markupTagName;
        private final String value;
        private final Map<String, String> attributes;

        Region(String value, Map<String, String> attributes, String markupTagName) {
            this.value = value == null || value.isEmpty() ? "anonymous" : value;
            this.attributes = attributes;
            this.markupTagName = markupTagName;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getValue() {
            return this.value;
        }

        public String getMarkupTagName() {
            return this.markupTagName;
        }

        public String toString() {
            return "Region{value=" + this.value + ", attributes=" + this.attributes + '}';
        }
    }
}

