/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.util.Parameters;

abstract class ProxyArchive
implements Archive {
    private final Archive[] delegates;

    private ProxyArchive(@NonNull Archive[] delegates) {
        Parameters.notNull((CharSequence)"delegates", (Object)delegates);
        this.delegates = delegates;
    }

    @Override
    public JavaFileObject getFile(String name) throws IOException {
        for (Archive delegate : this.delegates) {
            JavaFileObject jfo = delegate.getFile(name);
            if (jfo == null) continue;
            return jfo;
        }
        return null;
    }

    @Override
    public void clear() {
        for (Archive delegate : this.delegates) {
            delegate.clear();
        }
    }

    @Override
    public JavaFileObject create(String relativeName, JavaFileFilterImplementation filter) throws UnsupportedOperationException {
        for (Archive delegate : this.delegates) {
            try {
                return delegate.create(relativeName, filter);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new UnsupportedOperationException("Create operation s not supported by delegates");
    }

    @Override
    public boolean isMultiRelease() {
        for (Archive delegate : this.delegates) {
            if (!delegate.isMultiRelease()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    static ProxyArchive createComposite(Archive ... delegates) {
        return new Composite(delegates);
    }

    @NonNull
    static ProxyArchive createAdditionalPackages(Archive ... delegates) {
        return new AddPkgs(delegates);
    }

    @NonNull
    private static Archive[] getDelegates(@NonNull ProxyArchive pa) {
        return pa.delegates;
    }

    private static boolean isEmpty(@NonNull Iterable<? extends JavaFileObject> it) {
        if (it instanceof Collection) {
            return ((Collection)it).isEmpty();
        }
        return !it.iterator().hasNext();
    }

    private static final class AddPkgs
    extends ProxyArchive {
        AddPkgs(@NonNull Archive[] delegates) {
            super(delegates);
        }

        @Override
        @NonNull
        public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter, boolean recursive) throws IOException {
            for (Archive delegate : ProxyArchive.getDelegates((ProxyArchive)this)) {
                Iterable<JavaFileObject> it = delegate.getFiles(folderName, entry, kinds, filter, recursive);
                if (ProxyArchive.isEmpty(it)) continue;
                return it;
            }
            return Collections.emptyList();
        }
    }

    private static final class Composite
    extends ProxyArchive {
        Composite(@NonNull Archive[] delegates) {
            super(delegates);
        }

        @Override
        @NonNull
        public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter, boolean recursive) throws IOException {
            ArrayList<Iterable<JavaFileObject>> collector = new ArrayList<Iterable<JavaFileObject>>();
            for (Archive delegate : ProxyArchive.getDelegates((ProxyArchive)this)) {
                Iterable<JavaFileObject> it = delegate.getFiles(folderName, entry, kinds, filter, recursive);
                if (ProxyArchive.isEmpty(it)) continue;
                collector.add(it);
            }
            return Iterators.chained(collector);
        }
    }
}

