/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.text.Document;
import javax.tools.JavaFileObject;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.guards.DocumentGuards;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.AssignComments;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.TranslateIdentifier;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.scripting.Scripting;
import org.netbeans.modules.java.source.GeneratorUtilitiesAccessor;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.parsing.AbstractSourceFileObject;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.ParsingUtils;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.DiffContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class GeneratorUtilities {
    private final WorkingCopy copy;
    private static final String GENERATED_METHOD_BODY = "Templates/Classes/Code/GeneratedMethodBody";
    private static final String OVERRIDDEN_METHOD_BODY = "Templates/Classes/Code/OverriddenMethodBody";
    private static final String LAMBDA_BODY = "Templates/Classes/Code/LambdaBody";
    private static final String LAMBDA_EXPRESSION = "Templates/Classes/Code/LambdaExpression";
    private static final String METHOD_RETURN_TYPE = "method_return_type";
    private static final String DEFAULT_RETURN_TYPE_VALUE = "default_return_value";
    private static final String SUPER_METHOD_CALL = "super_method_call";
    private static final String METHOD_NAME = "method_name";
    private static final String CLASS_NAME = "class_name";
    private static final String SIMPLE_CLASS_NAME = "simple_class_name";
    private static final String CLASS_KIND = "class_kind";
    private static final String SCRIPT_ENGINE_ATTR = "javax.script.ScriptEngine";
    private static final String STRING_OUTPUT_MODE_ATTR = "com.sun.script.freemarker.stringOut";
    private static ScriptEngineManager manager;

    private GeneratorUtilities(WorkingCopy copy) {
        this.copy = copy;
    }

    public static GeneratorUtilities get(WorkingCopy copy) {
        return new GeneratorUtilities(copy);
    }

    public CompilationUnitTree createFromTemplate(FileObject sourceRoot, String path, ElementKind kind) throws IOException {
        String[] nameComponent = FileObjects.getFolderAndBaseName(path, '/');
        JavaFileObject sourceFile = FileObjects.templateFileObject(sourceRoot, nameComponent[0], nameComponent[1]);
        FileObject template = FileUtil.getConfigFile((String)this.copy.template(kind));
        FileObject targetFile = this.copy.doCreateFromTemplate(template, sourceFile);
        CompilationUnitTree templateCUT = ParsingUtils.parseArbitrarySource(this.copy.impl.getJavacTask(), FileObjects.sourceFileObject(targetFile, targetFile.getParent()));
        CompilationUnitTree importComments = GeneratorUtilities.get(this.copy).importComments(templateCUT, templateCUT);
        CompilationUnitTree result = this.copy.getTreeMaker().CompilationUnit(importComments.getPackageAnnotations(), sourceRoot, path, importComments.getImports(), importComments.getTypeDecls());
        return result;
    }

    public ClassTree insertClassMember(ClassTree clazz, Tree member) {
        assert (clazz != null && member != null);
        Document doc = null;
        try {
            doc = this.copy.getDocument();
            if (doc == null) {
                doc = this.copy.getSnapshot().getSource().getDocument(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CodeStyle codeStyle = DiffContext.getCodeStyle(this.copy);
        ClassMemberComparator comparator = new ClassMemberComparator(codeStyle);
        SourcePositions sp = this.copy.getTrees().getSourcePositions();
        TreeUtilities utils = this.copy.getTreeUtilities();
        CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
        Tree lastMember = null;
        int idx = -1;
        int gsidx = -1;
        String[] gsnames = codeStyle.keepGettersAndSettersTogether() ? GeneratorUtilities.correspondingGSNames(member) : null;
        int i = 0;
        int minIndex = -1;
        int maxIndex = Integer.MAX_VALUE;
        FieldRefVisitor v = null;
        if (codeStyle.computeMemberDependencies()) {
            if (member.getKind() == Tree.Kind.VARIABLE) {
                VariableTree vt = (VariableTree)member;
                v = new FieldRefVisitor(clazz, vt.getModifiers().getFlags().contains((Object)Modifier.STATIC));
                v.registerTreeName(member, vt.getName());
            }
            if (member.getKind() == Tree.Kind.BLOCK) {
                v = new FieldRefVisitor(clazz, ((BlockTree)member).isStatic());
            }
            if (v != null) {
                try {
                    v.collectNames = true;
                    TreePath classTP = new TreePath(new TreePath(compilationUnit), clazz);
                    v.scan(classTP, null);
                    TreePath treePath = new TreePath(classTP, member);
                    v.collectNames = false;
                    v.scan(treePath, null);
                    Collection<javax.lang.model.element.Name> collection = v.dependencies.get(member);
                    if (collection != null) {
                        for (javax.lang.model.element.Name n : v.dependencies.get(member)) {
                            Tree t = v.namedTrees.get(n);
                            if (t == null) continue;
                            minIndex = Math.max(minIndex, 1 + clazz.getMembers().indexOf(t));
                        }
                    }
                    for (Tree t : v.revDependencies) {
                        maxIndex = Math.min(maxIndex, clazz.getMembers().indexOf(t));
                    }
                    if (minIndex > maxIndex) {
                        maxIndex = -1;
                        minIndex = -1;
                    }
                }
                catch (RuntimeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    throw ex;
                }
            }
        }
        for (Tree tree : clazz.getMembers()) {
            if (!utils.isSynthetic(compilationUnit, tree)) {
                if (gsnames != null && gsidx < 0) {
                    for (String name : gsnames) {
                        if (!name.equals(GeneratorUtilities.name(tree))) continue;
                        if (GeneratorUtilities.isSetter(tree)) {
                            gsidx = codeStyle.sortMembersInGroupsAlphabetically() ? i : i + 1;
                            continue;
                        }
                        if (!GeneratorUtilities.isGetter(tree) && !GeneratorUtilities.isBooleanGetter(tree)) continue;
                        gsidx = i + 1;
                    }
                }
                if (idx < 0 && (codeStyle.getClassMemberInsertionPoint() == CodeStyle.InsertionPoint.FIRST_IN_CATEGORY && comparator.compare(member, tree) <= 0 || comparator.compare(member, tree) < 0)) {
                    DocumentGuards documentGuards = (DocumentGuards)LineDocumentUtils.as((Document)doc, DocumentGuards.class);
                    if (doc == null || documentGuards == null) {
                        idx = i;
                        continue;
                    }
                    int pos = (int)(lastMember != null ? sp.getEndPosition(compilationUnit, lastMember) : sp.getStartPosition(compilationUnit, clazz));
                    pos = documentGuards.adjustPosition(pos, true);
                    long treePos = sp.getStartPosition(compilationUnit, tree);
                    if (treePos < 0L || (long)pos <= treePos) {
                        idx = i;
                    }
                }
            }
            ++i;
            lastMember = tree;
        }
        if (idx < 0) {
            idx = i;
        }
        int n = idx = gsidx < 0 ? idx : gsidx;
        if (minIndex >= 0) {
            idx = Math.max(minIndex, idx);
        }
        if (maxIndex < Integer.MAX_VALUE) {
            idx = Math.min(maxIndex, idx);
        }
        return this.copy.getTreeMaker().insertClassMember(clazz, idx, member);
    }

    /*
     * WARNING - void declaration
     */
    public ClassTree insertClassMembers(ClassTree clazz, List<? extends Tree> members, int offset) {
        void var11_14;
        if (members.isEmpty()) {
            return clazz;
        }
        CodeStyle codeStyle = DiffContext.getCodeStyle(this.copy);
        if (offset < 0 || codeStyle.getClassMemberInsertionPoint() != CodeStyle.InsertionPoint.CARET_LOCATION) {
            return GeneratorUtilities.get(this.copy).insertClassMembers(clazz, members);
        }
        int index = 0;
        SourcePositions sp = this.copy.getTrees().getSourcePositions();
        Document doc = null;
        try {
            doc = this.copy.getDocument();
            if (doc == null) {
                doc = this.copy.getSnapshot().getSource().getDocument(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Tree lastMember = null;
        Tree nextMember = null;
        for (Tree tree : clazz.getMembers()) {
            if ((long)offset <= sp.getStartPosition(this.copy.getCompilationUnit(), tree)) {
                DocumentGuards guards = (DocumentGuards)LineDocumentUtils.as((Document)doc, DocumentGuards.class);
                if (doc == null || guards == null) {
                    nextMember = tree;
                    break;
                }
                int pos = (int)(lastMember != null ? sp.getEndPosition(this.copy.getCompilationUnit(), lastMember) : sp.getStartPosition(this.copy.getCompilationUnit(), clazz));
                if ((long)(pos = guards.adjustPosition(pos, true)) <= sp.getStartPosition(this.copy.getCompilationUnit(), tree)) {
                    nextMember = tree;
                    break;
                }
            }
            ++index;
            lastMember = tree;
        }
        if (lastMember != null) {
            this.moveCommentsAfterOffset(this.copy, lastMember, members.get(0), offset, doc);
        }
        if (nextMember != null) {
            GeneratorUtilities.moveCommentsBeforeOffset(this.copy, nextMember, members.get(members.size() - 1), offset, doc);
        }
        TreeMaker tm = this.copy.getTreeMaker();
        ClassTree classTree = clazz;
        for (int i = members.size() - 1; i >= 0; --i) {
            ClassTree classTree2 = tm.insertClassMember((ClassTree)var11_14, index, members.get(i));
        }
        return var11_14;
    }

    public ClassTree insertClassMember(ClassTree clazz, Tree member, int offset) {
        return this.insertClassMembers(clazz, Collections.singletonList(member), offset);
    }

    private void moveCommentsAfterOffset(WorkingCopy wc, Tree from, Tree to, int offset, Document doc) {
        LinkedList<Comment> toMove = new LinkedList<Comment>();
        int idx = 0;
        int firstToRemove = -1;
        for (Comment comment : wc.getTreeUtilities().getComments(from, false)) {
            int epAfterBlock;
            if (comment.endPos() <= offset) {
                ++idx;
                continue;
            }
            DocumentGuards guards = (DocumentGuards)LineDocumentUtils.as((Document)doc, DocumentGuards.class);
            if (guards != null && (epAfterBlock = guards.adjustPosition(comment.endPos(), true)) >= comment.endPos()) {
                ++idx;
                continue;
            }
            toMove.add(comment);
            if (firstToRemove == -1) {
                firstToRemove = idx;
            }
            ++idx;
        }
        if (toMove.isEmpty()) {
            return;
        }
        GeneratorUtilities.doMoveComments(wc, from, to, offset, toMove, firstToRemove, idx);
    }

    private static void doMoveComments(WorkingCopy wc, Tree from, Tree to, int offset, List<Comment> comments, int fromIdx, int toIdx) {
        boolean before;
        if (comments.isEmpty()) {
            return;
        }
        TreeMaker tm = wc.getTreeMaker();
        Tree tree = from;
        switch (from.getKind()) {
            case METHOD: {
                tree = tm.setLabel(from, ((MethodTree)from).getName());
                break;
            }
            case VARIABLE: {
                tree = tm.setLabel(from, ((VariableTree)from).getName());
                break;
            }
            case BLOCK: {
                tree = tm.Block(((BlockTree)from).getStatements(), ((BlockTree)from).isStatic());
                GeneratorUtilities gu = GeneratorUtilities.get(wc);
                gu.copyComments(from, tree, true);
                gu.copyComments(from, tree, false);
            }
        }
        boolean bl = before = (int)wc.getTrees().getSourcePositions().getStartPosition(wc.getCompilationUnit(), from) >= offset;
        if (fromIdx >= 0 && toIdx >= 0 && toIdx - fromIdx > 0) {
            for (int i = toIdx - 1; i >= fromIdx; --i) {
                tm.removeComment(tree, i, before);
            }
        }
        wc.rewrite(from, tree);
        for (Comment comment : comments) {
            tm.addComment(to, comment, comment.pos() <= offset);
        }
    }

    private static void moveCommentsBeforeOffset(WorkingCopy wc, Tree from, Tree to, int offset, Document doc) {
        LinkedList<Comment> toMove = new LinkedList<Comment>();
        int idx = 0;
        for (Comment comment : wc.getTreeUtilities().getComments(from, true)) {
            int epAfterBlock;
            DocumentGuards guards;
            if (comment.pos() >= offset || comment.endPos() > offset || (guards = (DocumentGuards)LineDocumentUtils.as((Document)doc, DocumentGuards.class)) != null && (epAfterBlock = guards.adjustPosition(comment.pos(), true)) >= comment.endPos()) break;
            toMove.add(comment);
            ++idx;
        }
        if (toMove.size() > 0) {
            GeneratorUtilities.doMoveComments(wc, from, to, offset, toMove, 0, idx);
        }
    }

    public ClassTree insertClassMembers(ClassTree clazz, Iterable<? extends Tree> members) {
        assert (members != null);
        for (Tree tree : members) {
            clazz = this.insertClassMember(clazz, tree);
        }
        return clazz;
    }

    public List<? extends MethodTree> createAllAbstractMethodImplementations(TypeElement clazz) {
        return this.createAbstractMethodImplementations(clazz, this.copy.getElementUtilities().findUnimplementedMethods(clazz));
    }

    public List<? extends MethodTree> createAbstractMethodImplementations(TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        assert (methods != null);
        ArrayList<MethodTree> ret = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : methods) {
            ret.add(this.createAbstractMethodImplementation(clazz, executableElement));
        }
        this.tagFirst(ret);
        return ret;
    }

    public MethodTree createAbstractMethodImplementation(TypeElement clazz, ExecutableElement method) {
        assert (clazz != null && method != null);
        return this.createMethod(method, clazz, true);
    }

    public List<? extends MethodTree> createOverridingMethods(TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        assert (methods != null);
        ArrayList<MethodTree> ret = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : methods) {
            ret.add(this.createOverridingMethod(clazz, executableElement));
        }
        this.tagFirst(ret);
        return ret;
    }

    public MethodTree createOverridingMethod(TypeElement clazz, ExecutableElement method) {
        assert (clazz != null && method != null);
        return this.createMethod(method, clazz, false);
    }

    public MethodTree createMethod(DeclaredType asMemberOf, ExecutableElement method) {
        TreeMaker make = this.copy.getTreeMaker();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        Set<Modifier> mods = method.getModifiers();
        EnumSet<Modifier> flags = mods.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(mods);
        flags.remove((Object)Modifier.ABSTRACT);
        flags.remove((Object)Modifier.NATIVE);
        flags.remove((Object)Modifier.DEFAULT);
        ExecutableType et = (ExecutableType)method.asType();
        try {
            et = (ExecutableType)this.copy.getTypes().asMemberOf(asMemberOf, method);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayList<TypeParameterTree> typeParams = new ArrayList<TypeParameterTree>();
        for (TypeVariable typeVariable : et.getTypeVariables()) {
            ArrayList<ExpressionTree> bounds = new ArrayList<ExpressionTree>();
            TypeMirror bound = typeVariable.getUpperBound();
            if (bound.getKind() != TypeKind.NULL) {
                if (bound.getKind() == TypeKind.DECLARED) {
                    Symbol.ClassSymbol boundSymbol = (Symbol.ClassSymbol)((DeclaredType)bound).asElement();
                    if (boundSymbol.getSimpleName().length() == 0 && (boundSymbol.flags() & 0x1000000L) != 0L) {
                        bounds.add((ExpressionTree)make.Type(boundSymbol.getSuperclass()));
                        for (Type iface : boundSymbol.getInterfaces()) {
                            bounds.add((ExpressionTree)make.Type(iface));
                        }
                    } else if (!boundSymbol.getQualifiedName().contentEquals("java.lang.Object")) {
                        bounds.add((ExpressionTree)make.Type(bound));
                    }
                } else {
                    bounds.add((ExpressionTree)make.Type(bound));
                }
            }
            typeParams.add(make.TypeParameter(typeVariable.asElement().getSimpleName(), bounds));
        }
        Tree returnType = make.Type(et.getReturnType());
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        boolean isVarArgs = method.isVarArgs();
        Iterator<? extends VariableElement> formArgNames = method.getParameters().iterator();
        Iterator<? extends TypeMirror> formArgTypes = et.getParameterTypes().iterator();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        while (formArgNames.hasNext() && formArgTypes.hasNext()) {
            VariableElement formArgName = formArgNames.next();
            TypeMirror formArgType = formArgTypes.next();
            if (isVarArgs && !formArgNames.hasNext()) {
                parameterModifiers = make.Modifiers(0x400000000L, Collections.emptyList());
            }
            String string = GeneratorUtilities.addParamPrefixSuffix(GeneratorUtilities.removeParamPrefixSuffix(formArgName, cs), cs);
            arrayList.add(make.Variable(parameterModifiers, string, this.resolveWildcard(formArgType), null));
        }
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        for (TypeMirror typeMirror : et.getThrownTypes()) {
            throwsList.add((ExpressionTree)make.Type(typeMirror));
        }
        ModifiersTree mt = make.Modifiers(flags, Collections.emptyList());
        return make.Method(mt, (CharSequence)method.getSimpleName(), returnType, typeParams, arrayList, throwsList, "{}", null);
    }

    public MethodTree createConstructor(TypeElement clazz, Iterable<? extends VariableElement> fields, ExecutableElement constructor) {
        return this.createConstructor(clazz, fields, constructor, false);
    }

    public MethodTree createDefaultConstructor(TypeElement clazz, Iterable<? extends VariableElement> fields, ExecutableElement constructor) {
        return this.createConstructor(clazz, fields, constructor, true);
    }

    private MethodTree createConstructor(TypeElement clazz, Iterable<? extends VariableElement> fields, ExecutableElement constructor, boolean isDefault) {
        assert (clazz != null && fields != null);
        TreeMaker make = this.copy.getTreeMaker();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        EnumSet<Modifier> mods = EnumSet.of(clazz.getKind() == ElementKind.ENUM ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        LinkedList<ExpressionStatementTree> statements = new LinkedList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        LinkedList<ExpressionTree> throwsList = new LinkedList<ExpressionTree>();
        LinkedList<TypeParameterTree> typeParams = new LinkedList<TypeParameterTree>();
        for (VariableElement variableElement : fields) {
            TypeMirror typeMirror = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), variableElement);
            if (isDefault) {
                statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableElement.getSimpleName()), make.Literal(GeneratorUtilities.defaultValue(typeMirror)))));
                continue;
            }
            String paramName = GeneratorUtilities.addParamPrefixSuffix(GeneratorUtilities.removeFieldPrefixSuffix(variableElement, cs), cs);
            parameters.add(make.Variable(parameterModifiers, paramName, make.Type(typeMirror), null));
            statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableElement.getSimpleName()), make.Identifier(paramName))));
        }
        if (constructor != null) {
            ExecutableType constructorType;
            ExecutableType executableType = constructorType = clazz.getSuperclass().getKind() == TypeKind.DECLARED && ((DeclaredType)clazz.getSuperclass()).asElement() == constructor.getEnclosingElement() ? (ExecutableType)this.copy.getTypes().asMemberOf((DeclaredType)clazz.getSuperclass(), constructor) : null;
            if (!constructor.getParameters().isEmpty()) {
                Iterator<? extends TypeMirror> parameterTypes;
                ArrayList<ExpressionTree> arrayList = new ArrayList<ExpressionTree>();
                Iterator<? extends VariableElement> iterator = constructor.getParameters().iterator();
                Iterator<? extends TypeMirror> iterator2 = parameterTypes = constructorType != null ? constructorType.getParameterTypes().iterator() : null;
                while (iterator.hasNext()) {
                    TypeMirror typeMirror;
                    VariableElement ve = iterator.next();
                    TypeMirror typeMirror2 = typeMirror = parameterTypes != null ? parameterTypes.next() : ve.asType();
                    if (isDefault) {
                        arrayList.add(make.Literal(GeneratorUtilities.defaultValue(typeMirror)));
                        continue;
                    }
                    String paramName = GeneratorUtilities.addParamPrefixSuffix(GeneratorUtilities.removeParamPrefixSuffix(ve, cs), cs);
                    parameters.add(make.Variable(parameterModifiers, paramName, make.Type(typeMirror), null));
                    arrayList.add(make.Identifier(paramName));
                }
                statements.addFirst(make.ExpressionStatement(make.MethodInvocation(Collections.emptyList(), make.Identifier("super"), arrayList)));
            }
            constructorType = constructorType != null ? constructorType : (ExecutableType)constructor.asType();
            for (TypeMirror typeMirror : constructorType.getThrownTypes()) {
                throwsList.add((ExpressionTree)make.Type(typeMirror));
            }
            for (TypeParameterElement typeParameterElement : constructor.getTypeParameters()) {
                LinkedList<ExpressionTree> boundsList = new LinkedList<ExpressionTree>();
                for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                    boundsList.add((ExpressionTree)make.Type(typeMirror));
                }
                typeParams.add(make.TypeParameter(typeParameterElement.getSimpleName(), boundsList));
            }
        }
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), "<init>", null, typeParams, parameters, throwsList, body, null, constructor != null ? constructor.isVarArgs() : false);
    }

    public MethodTree createConstructor(ClassTree clazz, Iterable<? extends VariableTree> fields) {
        assert (clazz != null && fields != null);
        TreeMaker make = this.copy.getTreeMaker();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        EnumSet<Modifier> mods = EnumSet.of(this.copy.getTreeUtilities().isEnum(clazz) ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> statements = new ArrayList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        for (VariableTree variableTree : fields) {
            String paramName = GeneratorUtilities.addParamPrefixSuffix(GeneratorUtilities.removeFieldPrefixSuffix(variableTree, cs), cs);
            parameters.add(make.Variable(parameterModifiers, paramName, variableTree.getType(), null));
            statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableTree.getName()), make.Identifier(paramName))));
        }
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), (CharSequence)"<init>", null, Collections.emptyList(), parameters, Collections.emptyList(), body, null);
    }

    public MethodTree createGetter(TypeElement clazz, VariableElement field) {
        TypeMirror type;
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        boolean isBoolean = (type = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), field)).getKind() == TypeKind.BOOLEAN;
        String getterName = CodeStyleUtils.computeGetterName(field.getSimpleName(), isBoolean, isStatic, cs);
        BlockTree body = make.Block(Collections.singletonList(make.Return(make.Identifier(field.getSimpleName()))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)getterName, make.Type(type), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    public MethodTree createGetter(VariableTree field) {
        Tree type;
        assert (field != null);
        TreeMaker make = this.copy.getTreeMaker();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        boolean isBoolean = (type = field.getType()).getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)type).getPrimitiveTypeKind() == TypeKind.BOOLEAN;
        String getterName = CodeStyleUtils.computeGetterName(field.getName(), isBoolean, isStatic, cs);
        BlockTree body = make.Block(Collections.singletonList(make.Return(make.Identifier(field.getName()))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)getterName, type, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    public MethodTree createSetter(TypeElement clazz, VariableElement field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), field);
        String setterName = CodeStyleUtils.computeSetterName(field.getSimpleName(), isStatic, cs);
        String paramName = GeneratorUtilities.addParamPrefixSuffix(GeneratorUtilities.removeFieldPrefixSuffix(field, cs), cs);
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), paramName, make.Type(type), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier(field.getEnclosingElement().getSimpleName()) : make.Identifier("this")), name), make.Identifier(paramName)))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)setterName, make.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    public MethodTree createSetter(ClassTree clazz, VariableTree field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getName();
        assert (name.length() > 0);
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        String propName = GeneratorUtilities.removeFieldPrefixSuffix(field, cs);
        String setterName = CodeStyleUtils.computeSetterName(field.getName(), isStatic, cs);
        String paramName = GeneratorUtilities.addParamPrefixSuffix(propName, cs);
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), paramName, field.getType(), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier(clazz.getSimpleName()) : make.Identifier("this")), name), make.Identifier(paramName)))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)setterName, make.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    public BlockTree createDefaultLambdaBody(LambdaExpressionTree lambda, ExecutableElement method) {
        try {
            String bodyTemplate = "{" + GeneratorUtilities.readFromTemplate(LAMBDA_BODY, this.createBindings(null, method)) + "\n}";
            return this.copy.getTreeMaker().createLambdaBody(lambda, bodyTemplate);
        }
        catch (Exception exception) {
            return this.copy.getTreeMaker().Block(Collections.emptyList(), false);
        }
    }

    public ExpressionTree createDefaultLambdaExpression(LambdaExpressionTree lambda, ExecutableElement method) {
        try {
            String bodyTemplate = GeneratorUtilities.readFromTemplate(LAMBDA_EXPRESSION, this.createBindings(null, method));
            return this.copy.getTreeMaker().createLambdaExpression(lambda, bodyTemplate);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isStarImport(ImportTree imp) {
        Tree qualIdent = imp.getQualifiedIdentifier();
        boolean isStar = qualIdent.getKind() == Tree.Kind.MEMBER_SELECT && ((MemberSelectTree)qualIdent).getIdentifier().contentEquals("*");
        return isStar;
    }

    public CompilationUnitTree addImports(CompilationUnitTree cut, Set<? extends Element> toImport) {
        return this.addImports(cut, cut.getImports(), toImport, this.copy.getElements()::getModuleOf);
    }

    /*
     * WARNING - void declaration
     */
    private CompilationUnitTree addImports(CompilationUnitTree cut, List<? extends ImportTree> cutImports, Set<? extends Element> toImport, Function<Element, ModuleElement> moduleOf) {
        void var27_79;
        Object e;
        ExpressionTree packageName;
        assert (cut != null && toImport != null && !toImport.isEmpty());
        ArrayList<Object> elementsToImport = new ArrayList<Object>(toImport.size());
        LinkedHashSet<ModuleElement> modulesToImport = new LinkedHashSet<ModuleElement>();
        HashSet<String> staticImportNames = new HashSet<String>();
        for (Element element : toImport) {
            if (element == null) continue;
            switch (element.getKind()) {
                case MODULE: {
                    modulesToImport.add((ModuleElement)element);
                    elementsToImport.add(element);
                    break;
                }
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    String name = new StringBuilder(((TypeElement)element.getEnclosingElement()).getQualifiedName()).append('.').append(element.getSimpleName()).toString();
                    if (!staticImportNames.add(name)) break;
                }
                default: {
                    elementsToImport.add(element);
                }
            }
        }
        Trees trees = this.copy.getTrees();
        Elements elements = this.copy.getElements();
        ElementUtilities elementUtilities = this.copy.getElementUtilities();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        int treshold = cs.useSingleClassImport() ? cs.countForUsingStarImport() : 1;
        int staticTreshold = cs.countForUsingStaticStarImport();
        LinkedHashMap<PackageElement, Object> pkgCounts = new LinkedHashMap<PackageElement, Object>();
        PackageElement pkg = elements.getPackageElement("java.lang");
        if (pkg != null) {
            pkgCounts.put(pkg, -2);
        }
        PackageElement packageElement = pkg = (packageName = cut.getPackageName()) != null ? (PackageElement)trees.getElement(TreePath.getPath(cut, (Tree)packageName)) : null;
        if (pkg == null && packageName != null) {
            pkg = elements.getPackageElement(elements.getName(packageName.toString()));
        }
        if (pkg == null) {
            pkg = elements.getPackageElement(elements.getName(""));
        }
        pkgCounts.put(pkg, -2);
        LinkedHashMap<Object, Object> typeCounts = new LinkedHashMap<Object, Object>();
        JCTree.JCCompilationUnit jcut = (JCTree.JCCompilationUnit)cut;
        Scope.StarImportScope importScope = new Scope.StarImportScope((Symbol)((Object)pkg));
        if (jcut.moduleImportScope != null) {
            importScope.prependSubScope(((JCTree.JCCompilationUnit)cut).moduleImportScope);
        }
        if (jcut.starImportScope != null) {
            importScope.prependSubScope(((JCTree.JCCompilationUnit)cut).starImportScope);
        }
        if (jcut.packge != null) {
            importScope.prependSubScope(jcut.packge.members_field);
        }
        LinkedHashMap<ModuleElement, Integer> modCounts = jcut.moduleImportScope != null || !modulesToImport.isEmpty() ? new LinkedHashMap<ModuleElement, Integer>() : null;
        HashSet<ModuleElement> transitivelyImportedUsedModules = modCounts != null ? new HashSet<ModuleElement>() : null;
        for (Object e3 : elementsToImport) {
            ModuleElement moduleElement;
            void var26_36;
            void var26_39;
            Integer n;
            boolean bl = false;
            Object el = null;
            switch (e3.getKind()) {
                case PACKAGE: {
                    el = e3;
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case RECORD: {
                    if (e3.getEnclosingElement().getKind() != ElementKind.PACKAGE) break;
                    el = e3.getEnclosingElement();
                    break;
                }
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    bl = true;
                    el = e3.getEnclosingElement();
                    break;
                }
                case MODULE: {
                    if (modCounts == null) break;
                    modCounts.merge((ModuleElement)e3, 1, Integer::sum);
                    break;
                }
                default: {
                    assert (false) : "Illegal element kind: " + e3.getKind();
                    break;
                }
            }
            if (el == null) continue;
            Integer n2 = n = bl ? (Integer)typeCounts.get((TypeElement)el) : (Integer)pkgCounts.get((PackageElement)el);
            if (n == null) {
                Integer n3 = 0;
            }
            if (var26_39.intValue() >= 0) {
                if (el == e3) {
                    Integer n4 = -1;
                } else {
                    void var27_58 = var26_39;
                    Integer n5 = var26_39.intValue() + 1;
                    if (bl) {
                        if (n5 >= staticTreshold) {
                            Integer n6 = -1;
                        }
                    } else if (n5 >= treshold || GeneratorUtilities.checkPackagesForStarImport(((PackageElement)el).getQualifiedName().toString(), cs)) {
                        Integer n7 = -1;
                    }
                }
            }
            if (bl) {
                typeCounts.put((TypeElement)el, var26_36);
                continue;
            }
            pkgCounts.put((PackageElement)el, var26_36);
            if (var26_36.intValue() < -1 || modCounts == null || (moduleElement = moduleOf.apply((Element)e3)) == null) continue;
            modCounts.merge(moduleElement, 1, Integer::sum);
        }
        ArrayList<? extends ImportTree> imports = new ArrayList<ImportTree>(cutImports);
        for (ImportTree importTree : imports) {
            LinkedHashMap<Object, Object> linkedHashMap;
            Integer n;
            int n8;
            if (importTree.isModule() && modCounts != null) {
                ModuleElement m2 = elements.getModuleElement(importTree.getQualifiedIdentifier().toString());
                if (m2 == null) continue;
                modCounts.put(m2, -2);
                GeneratorUtilities.collectTransitivelyImportedUsedModules(m2, modCounts.keySet(), this.copy, transitivelyImportedUsedModules);
                modulesToImport.remove(m2);
                continue;
            }
            e = this.getImportedElement(cut, importTree);
            if (!elementsToImport.contains(e)) {
                void var27_70;
                Integer n9;
                if (importTree.isStatic()) {
                    void var27_65;
                    Integer n10;
                    if (e.getKind().isClass() || e.getKind().isInterface()) {
                        void var26_45;
                        Element element = e;
                        while (var26_45 != null) {
                            TypeMirror typeMirror;
                            Integer n11 = (Integer)typeCounts.get((TypeElement)var26_45);
                            if (n11 != null && staticTreshold == Integer.MAX_VALUE) {
                                typeCounts.put((TypeElement)var26_45, -2);
                            }
                            Element element2 = (typeMirror = ((TypeElement)var26_45).getSuperclass()).getKind() == TypeKind.DECLARED ? ((DeclaredType)typeMirror).asElement() : null;
                        }
                        continue;
                    }
                    TypeElement typeElement = elementUtilities.enclosingTypeElement((Element)e);
                    if (typeElement == null || (n10 = (Integer)typeCounts.get(typeElement)) == null) continue;
                    if (n10 >= 0) {
                        Integer n12 = n10;
                        Integer n13 = n10 + 1;
                        if (n13 >= staticTreshold) {
                            Integer n14 = -1;
                        }
                    }
                    typeCounts.put(typeElement, var27_65);
                    continue;
                }
                Object object = e.getKind() == ElementKind.PACKAGE ? e : ((e.getKind().isClass() || e.getKind().isInterface()) && e.getEnclosingElement().getKind() == ElementKind.PACKAGE ? e.getEnclosingElement() : null);
                if (object == null || (n9 = (Integer)pkgCounts.get((PackageElement)object)) == null) continue;
                if (object == e) {
                    if (treshold == Integer.MAX_VALUE) {
                        Integer n15 = -2;
                    }
                } else if (n9 >= 0) {
                    Integer n16 = n9;
                    Integer n17 = n9 + 1;
                    if (n17 >= treshold) {
                        Integer n18 = -1;
                    }
                }
                pkgCounts.put((PackageElement)object, var27_70);
                continue;
            }
            if (treshold != Integer.MAX_VALUE && staticTreshold != Integer.MAX_VALUE) continue;
            int n19 = n8 = importTree.isStatic() ? staticTreshold : treshold;
            if (!this.isStarImport(importTree) || n8 != Integer.MAX_VALUE || (n = (Integer)(linkedHashMap = importTree.isStatic() ? typeCounts : pkgCounts).get(e)) == null) continue;
            linkedHashMap.put(e, -2);
        }
        Iterator ii = imports.iterator();
        while (ii.hasNext()) {
            void var26_52;
            ImportTree importTree = (ImportTree)ii.next();
            if (importTree.isModule() || !this.isStarImport(importTree)) continue;
            e = this.getImportedElement(cut, importTree);
            if (importTree.isStatic()) {
                Integer n = (Integer)typeCounts.get(e);
            } else {
                Integer n = (Integer)pkgCounts.get(e);
            }
            if (var26_52 == null || var26_52.intValue() < 0) continue;
            ii.remove();
        }
        if (!modulesToImport.isEmpty()) {
            assert (modCounts != null && transitivelyImportedUsedModules != null);
            modulesToImport.removeIf(transitivelyImportedUsedModules::contains);
            for (ModuleElement moduleElement : modulesToImport) {
                for (PackageElement packageElement2 : elementUtilities.transitivelyExportedPackages(moduleElement)) {
                    if (packageElement2 instanceof Symbol) {
                        Symbol symbol = (Symbol)((Object)packageElement2);
                        importScope.appendSubScope(symbol.members());
                    }
                    GeneratorUtilities.collectTransitivelyImportedUsedModule(packageElement2, moduleElement, modCounts.keySet(), transitivelyImportedUsedModules);
                }
                modCounts.replace(moduleElement, -1);
            }
        }
        if (transitivelyImportedUsedModules != null && modCounts != null) {
            transitivelyImportedUsedModules.forEach(m -> modCounts.computeIfPresent((ModuleElement)m, (k, old) -> old != null && old < 0 ? old : Integer.valueOf(-2)));
        }
        HashSet<Object> explicitNamedImports = new HashSet<Object>();
        block22: for (Object element : elementsToImport) {
            if (element.getEnclosingElement() == pkg || !element.getKind().isClass() && !element.getKind().isInterface()) continue;
            for (Symbol symbol : importScope.getSymbolsByName((Name)element.getSimpleName())) {
                if (!symbol.getKind().isClass() && !symbol.getKind().isInterface() || symbol == element) continue;
                explicitNamedImports.add(element);
                continue block22;
            }
        }
        Object var24_31 = null;
        for (Map.Entry entry : pkgCounts.entrySet()) {
            if ((Integer)entry.getValue() == -1) {
                for (Element element : ((PackageElement)entry.getKey()).getEnclosedElements()) {
                    if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
                    for (Symbol sym : importScope.getSymbolsByName((Name)element.getSimpleName())) {
                        void var24_32;
                        if (sym == element) continue;
                        TypeElement te = null;
                        for (Element element3 : elementsToImport) {
                            if (!element3.getKind().isClass() && !element3.getKind().isInterface() || element.getSimpleName() != element3.getSimpleName()) continue;
                            te = (TypeElement)element3;
                            break;
                        }
                        if (te != null) {
                            explicitNamedImports.add(te);
                            continue;
                        }
                        if (var24_32 == null) {
                            Map<javax.lang.model.element.Name, TypeElement> map = this.getUsedTypes(cut);
                        }
                        if (te != null) {
                            explicitNamedImports.add(te);
                            continue;
                        }
                        if (var24_32 == null) {
                            Map<javax.lang.model.element.Name, TypeElement> map = this.getUsedTypes(cut);
                        }
                        if ((te = (TypeElement)var24_32.get(element.getSimpleName())) == null) continue;
                        elementsToImport.add(te);
                        explicitNamedImports.add(te);
                    }
                }
            }
            if ((Integer)entry.getValue() >= 0 || !(entry.getKey() instanceof Symbol)) continue;
            importScope.prependSubScope(((Symbol)entry.getKey()).members());
        }
        ImportsComparator comparator = new ImportsComparator(cs);
        elementsToImport.sort(comparator);
        TreeMaker treeMaker = this.copy.getTreeMaker();
        int n = elementsToImport.size() - 1;
        int n20 = imports.size() - 1;
        while (var27_79 >= 0) {
            void var28_88;
            ImportTree nImport;
            int cnt;
            Element currentToImportElement = (Element)elementsToImport.get((int)var27_79);
            boolean isStatic = false;
            Element el = null;
            switch (currentToImportElement.getKind()) {
                case PACKAGE: {
                    el = currentToImportElement;
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case RECORD: {
                    if (currentToImportElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) break;
                    el = currentToImportElement.getEnclosingElement();
                    break;
                }
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    isStatic = true;
                    el = currentToImportElement.getEnclosingElement();
                }
            }
            if (explicitNamedImports.contains(currentToImportElement)) {
                cnt = 0;
            } else {
                Integer n21;
                Integer n22 = el == null ? null : (n21 = isStatic ? (Integer)typeCounts.get((TypeElement)el) : (Integer)pkgCounts.get((PackageElement)el));
                if (isStatic) {
                    cnt = n21 == null ? 0 : n21;
                } else {
                    int modCount = 0;
                    if (modCounts != null) {
                        Integer mc;
                        ModuleElement m4 = moduleOf.apply(currentToImportElement);
                        Integer n23 = mc = m4 == null ? null : (Integer)modCounts.get(m4);
                        if (mc != null && mc < 0 && (modCount = mc.intValue()) == -1) {
                            currentToImportElement = m4;
                            el = null;
                            modCounts.put(m4, -2);
                        }
                    }
                    int n24 = modCount < 0 ? modCount : (cnt = n21 == null ? 0 : n21);
                }
            }
            if (cnt == -2) {
                --var27_79;
                continue;
            }
            if (cnt == -1 && el != null) {
                currentToImportElement = el;
                if (isStatic) {
                    typeCounts.put((TypeElement)el, -2);
                } else {
                    pkgCounts.put((PackageElement)el, -2);
                }
            }
            boolean bl = currentToImportElement.getKind() == ElementKind.PACKAGE || isStatic && (currentToImportElement.getKind().isClass() || currentToImportElement.getKind().isInterface());
            ExpressionTree qualIdent = this.qualIdentFor(currentToImportElement);
            if (bl) {
                qualIdent = treeMaker.MemberSelect(qualIdent, elements.getName("*"));
            }
            ImportTree importTree = nImport = currentToImportElement.getKind() == ElementKind.MODULE ? treeMaker.ImportModule(qualIdent) : treeMaker.Import(qualIdent, isStatic);
            while (var28_88 >= 0) {
                ImportTree imp = (ImportTree)imports.get((int)var28_88);
                Element impElement = this.getImportedElement(cut, imp);
                Element element = imp.isStatic() ? (impElement.getKind().isClass() || impElement.getKind().isInterface() ? impElement : elementUtilities.enclosingTypeElement(impElement)) : (impElement.getKind() == ElementKind.PACKAGE ? impElement : (el = (impElement.getKind().isClass() || impElement.getKind().isInterface()) && impElement.getEnclosingElement().getKind() == ElementKind.PACKAGE ? impElement.getEnclosingElement() : null));
                if (isStatic == imp.isStatic() && (currentToImportElement == impElement || bl && currentToImportElement == el)) {
                    imports.remove((int)var28_88);
                } else if (comparator.compare(nImport, imp) > 0) break;
                --var28_88;
            }
            imports.add((int)(var28_88 + true), nImport);
            --var27_79;
        }
        return treeMaker.CompilationUnit(cut.getPackage(), imports, cut.getTypeDecls(), cut.getSourceFile());
    }

    private static void collectTransitivelyImportedUsedModules(ModuleElement importedModule, Set<ModuleElement> usedModules, CompilationInfo info, Set<ModuleElement> transitivelyImportedUsedModules) {
        if (importedModule != null) {
            if (transitivelyImportedUsedModules.contains(importedModule)) {
                return;
            }
            for (PackageElement pack : info.getElementUtilities().transitivelyExportedPackages(importedModule)) {
                GeneratorUtilities.collectTransitivelyImportedUsedModule(pack, importedModule, usedModules, transitivelyImportedUsedModules);
            }
        }
    }

    private static void collectTransitivelyImportedUsedModule(PackageElement transitivePackage, ModuleElement importedModule, Set<ModuleElement> usedModules, Set<ModuleElement> transitivelyImportedUsedModules) {
        ModuleElement transitiveModule;
        Element element = transitivePackage.getEnclosingElement();
        if (element instanceof ModuleElement && (transitiveModule = (ModuleElement)element) != importedModule && usedModules.contains(transitiveModule)) {
            transitivelyImportedUsedModules.add(transitiveModule);
        }
    }

    public <T extends Tree> T importFQNs(T original) {
        return TranslateIdentifier.importFQNs(this.copy, original);
    }

    public <T extends Tree> T importComments(T original, CompilationUnitTree cut) {
        return GeneratorUtilities.importComments(this.copy, original, cut);
    }

    static <T extends Tree> T importComments(CompilationInfo info, T original, CompilationUnitTree cut) {
        try {
            CommentSetImpl comments = CommentHandlerService.instance(info.impl.getJavacTask().getContext()).getComments(original);
            if (comments.areCommentsMapped()) {
                return original;
            }
            JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)cut;
            TokenHierarchy tokens = unit.getSourceFile() instanceof AbstractSourceFileObject ? ((AbstractSourceFileObject)unit.getSourceFile()).getTokenHierarchy() : TokenHierarchy.create((CharSequence)unit.getSourceFile().getCharContent(true), (Language)JavaTokenId.language());
            TokenSequence seq = tokens.tokenSequence(JavaTokenId.language());
            TreePath tp = TreePath.getPath(cut, original);
            Object toMap = original;
            Tree mapTarget = null;
            if (tp != null && original.getKind() != Tree.Kind.COMPILATION_UNIT) {
                TreePath p2;
                boolean first = true;
                block5: for (p2 = tp; p2 != null; p2 = p2.getParentPath()) {
                    Tree.Kind k = p2.getLeaf().getKind();
                    if (StatementTree.class.isAssignableFrom(k.asInterface())) {
                        mapTarget = p2.getLeaf();
                        p2 = p2.getParentPath();
                        break;
                    }
                    switch (p2.getLeaf().getKind()) {
                        case METHOD: 
                        case VARIABLE: 
                        case BLOCK: 
                        case CLASS: 
                        case INTERFACE: 
                        case ENUM: 
                        case RECORD: {
                            if (mapTarget == null) {
                                mapTarget = p2.getLeaf();
                            }
                            if (!first) break block5;
                            p2 = p2.getParentPath();
                            break block5;
                        }
                        default: {
                            first = false;
                            continue block5;
                        }
                    }
                }
                if (p2 != null) {
                    toMap = p2.getLeaf();
                }
                if (toMap == tp.getLeaf()) {
                    toMap = tp.getParentPath().getLeaf();
                }
            }
            if (mapTarget == null) {
                mapTarget = original;
            }
            AssignComments translator = new AssignComments(info, mapTarget, (TokenSequence<JavaTokenId>)seq, unit);
            translator.scan((Tree)toMap, null);
            return original;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return original;
        }
    }

    public void copyComments(Tree source, Tree target, boolean preceding) {
        CommentHandlerService handler = CommentHandlerService.instance(this.copy.impl.getJavacTask().getContext());
        CommentSetImpl s = handler.getComments(source);
        TreeUtilities.ensureCommentsMapped(this.copy, source, s);
        CommentSetImpl t = handler.getComments(target);
        if (preceding) {
            t.addComments(CommentSet.RelativePosition.PRECEDING, this.copy.useComments(s.getComments(CommentSet.RelativePosition.PRECEDING)));
            t.addComments(CommentSet.RelativePosition.INNER, this.copy.useComments(s.getComments(CommentSet.RelativePosition.INNER)));
        } else {
            t.addComments(CommentSet.RelativePosition.INLINE, this.copy.useComments(s.getComments(CommentSet.RelativePosition.INLINE)));
            t.addComments(CommentSet.RelativePosition.TRAILING, this.copy.useComments(s.getComments(CommentSet.RelativePosition.TRAILING)));
        }
    }

    public ModifiersTree appendToAnnotationValue(ModifiersTree modifiers, TypeElement annotation, String attributeName, ExpressionTree ... attributeValuesToAdd) {
        return (ModifiersTree)this.appendToAnnotationValue((Tree)modifiers, annotation, attributeName, attributeValuesToAdd);
    }

    public CompilationUnitTree appendToAnnotationValue(CompilationUnitTree compilationUnit, TypeElement annotation, String attributeName, ExpressionTree ... attributeValuesToAdd) {
        return (CompilationUnitTree)this.appendToAnnotationValue((Tree)compilationUnit, annotation, attributeName, attributeValuesToAdd);
    }

    /*
     * WARNING - void declaration
     */
    private Tree appendToAnnotationValue(Tree modifiers, TypeElement annotation, String attributeName, ExpressionTree ... attributeValuesToAdd) {
        void var8_11;
        TreeMaker make = this.copy.getTreeMaker();
        List<? extends AnnotationTree> annotations = null;
        if (modifiers.getKind() == Tree.Kind.MODIFIERS) {
            annotations = ((ModifiersTree)modifiers).getAnnotations();
        } else if (modifiers.getKind() == Tree.Kind.COMPILATION_UNIT) {
            annotations = ((CompilationUnitTree)modifiers).getPackageAnnotations();
        } else {
            throw new IllegalStateException();
        }
        for (AnnotationTree annotationTree : annotations) {
            TreePath tp = new TreePath(new TreePath(this.copy.getCompilationUnit()), annotationTree.getAnnotationType());
            Element e = this.copy.getTrees().getElement(tp);
            if (!annotation.equals(e)) continue;
            List<? extends ExpressionTree> arguments = annotationTree.getArguments();
            for (ExpressionTree expressionTree : arguments) {
                ExpressionTree expression;
                if (expressionTree.getKind() == Tree.Kind.ASSIGNMENT) {
                    AssignmentTree assignment = (AssignmentTree)expressionTree;
                    if (!((IdentifierTree)assignment.getVariable()).getName().contentEquals(attributeName)) continue;
                    expression = assignment.getExpression();
                } else {
                    if (!"value".equals(attributeName)) continue;
                    expression = expressionTree;
                }
                List<ExpressionTree> currentValues = expression.getKind() == Tree.Kind.NEW_ARRAY ? ((NewArrayTree)expression).getInitializers() : Collections.singletonList(expression);
                assert (currentValues != null);
                ArrayList<ExpressionTree> values = new ArrayList<ExpressionTree>(currentValues);
                values.addAll(Arrays.asList(attributeValuesToAdd));
                NewArrayTree newAssignment = make.NewArray(null, Collections.emptyList(), values);
                return this.copy.getTreeUtilities().translate(modifiers, Collections.singletonMap(expression, newAssignment));
            }
            AnnotationTree newAnnotation = make.addAnnotationAttrValue(annotationTree, make.Assignment(make.Identifier(attributeName), make.NewArray(null, Collections.emptyList(), Arrays.asList(attributeValuesToAdd))));
            return this.copy.getTreeUtilities().translate(modifiers, Collections.singletonMap(annotationTree, newAnnotation));
        }
        ExpressionTree attribute = attributeValuesToAdd.length > 1 ? make.NewArray(null, Collections.emptyList(), Arrays.asList(attributeValuesToAdd)) : attributeValuesToAdd[0];
        if ("value".equals(attributeName)) {
            ExpressionTree expressionTree = attribute;
        } else {
            AssignmentTree assignmentTree = make.Assignment(make.Identifier(attributeName), attribute);
        }
        AnnotationTree newAnnotation = make.Annotation(make.QualIdent(annotation), Collections.singletonList(var8_11));
        if (modifiers.getKind() == Tree.Kind.MODIFIERS) {
            return make.addModifiersAnnotation((ModifiersTree)modifiers, newAnnotation);
        }
        if (modifiers.getKind() == Tree.Kind.COMPILATION_UNIT) {
            return make.addPackageAnnotation((CompilationUnitTree)modifiers, newAnnotation);
        }
        throw new IllegalStateException();
    }

    private MethodTree createMethod(ExecutableElement element, TypeElement clazz, boolean isImplement) {
        MethodTree method;
        boolean isAbstract;
        TreeMaker make = this.copy.getTreeMaker();
        MethodTree prototype = this.createMethod((DeclaredType)clazz.asType(), element);
        ModifiersTree mt = prototype.getModifiers();
        if (GeneratorUtilities.supportsOverride(this.copy) && this.copy.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0) {
            boolean generate = true;
            if (this.copy.getSourceVersion().compareTo(SourceVersion.RELEASE_5) == 0) {
                boolean bl = generate = !element.getEnclosingElement().getKind().isInterface();
            }
            if (generate) {
                mt = make.addModifiersAnnotation(prototype.getModifiers(), make.Annotation(make.Identifier("Override"), Collections.emptyList()));
            }
        }
        Object bodyTemplate = null;
        if (isImplement && clazz.getKind().isInterface()) {
            mt = make.addModifiersModifier(mt, Modifier.DEFAULT);
        }
        boolean replaceable = this.copy.getTrees().getTree(clazz).getKind() == Tree.Kind.RECORD && this.copy.getElementUtilities().isSynthetic(element);
        boolean bl = isAbstract = element.getModifiers().contains((Object)Modifier.ABSTRACT) || replaceable;
        if (isImplement || clazz.getKind().isClass() && (!isAbstract || !clazz.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            try {
                bodyTemplate = "{" + GeneratorUtilities.readFromTemplate(isAbstract ? GENERATED_METHOD_BODY : OVERRIDDEN_METHOD_BODY, this.createBindings(clazz, element)) + "\n}";
            }
            catch (Exception e) {
                bodyTemplate = "{}";
            }
        } else if (clazz.getKind().isClass()) {
            mt = make.addModifiersModifier(mt, Modifier.ABSTRACT);
        }
        if ((method = make.Method(mt, (CharSequence)prototype.getName(), prototype.getReturnType(), prototype.getTypeParameters(), prototype.getParameters(), prototype.getThrows(), (String)bodyTemplate, null)).getBody() != null) {
            if (GeneratorUtilities.containsErrors(method.getBody())) {
                this.copy.rewrite(method.getBody(), make.Block(Collections.emptyList(), false));
            } else {
                Trees trees = this.copy.getTrees();
                TreePath path = trees.getPath(clazz);
                if (path == null) {
                    path = new TreePath(this.copy.getCompilationUnit());
                }
                Scope s = trees.getScope(path);
                BlockTree body = method.getBody();
                this.copy.getTreeUtilities().attributeTree(body, s);
                body = this.importFQNs(body);
                this.copy.rewrite(method.getBody(), body);
            }
        }
        return method;
    }

    private static Object defaultValue(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return false;
            }
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return 0;
            }
        }
        return null;
    }

    private static boolean supportsOverride(CompilationInfo info) {
        return info.getElements().getTypeElement("java.lang.Override") != null;
    }

    private Tree resolveWildcard(TypeMirror type) {
        Tree result;
        TreeMaker make = this.copy.getTreeMaker();
        if (type != null && type.getKind() == TypeKind.WILDCARD) {
            WildcardType wt = (WildcardType)type;
            TypeMirror bound = wt.getSuperBound();
            if (bound == null) {
                bound = wt.getExtendsBound();
            }
            if (bound == null) {
                return make.Type("java.lang.Object");
            }
            result = make.Type(bound);
        } else {
            result = make.Type(type);
        }
        final IdentityHashMap translate = new IdentityHashMap();
        new ErrorAwareTreeScanner<Void, Void>(){

            @Override
            public Void visitWildcard(WildcardTree node, Void p) {
                Tree bound = node.getBound();
                if (bound != null && (bound.getKind() == Tree.Kind.EXTENDS_WILDCARD || bound.getKind() == Tree.Kind.SUPER_WILDCARD)) {
                    translate.put(bound, ((WildcardTree)bound).getBound());
                }
                return (Void)super.visitWildcard(node, p);
            }
        }.scan(result, null);
        return this.copy.getTreeUtilities().translate(result, translate);
    }

    private Element getImportedElement(CompilationUnitTree cut, ImportTree imp) {
        Element element;
        TreePath found;
        Trees trees = this.copy.getTrees();
        Tree qualIdent = imp.getQualifiedIdentifier();
        if (qualIdent.getKind() != Tree.Kind.MEMBER_SELECT) {
            Element element2 = trees.getElement(TreePath.getPath(cut, qualIdent));
            if (element2 == null) {
                String fqn = qualIdent.toString();
                if (fqn.endsWith(".*")) {
                    fqn = fqn.substring(0, fqn.length() - 2);
                }
                element2 = this.getElementByFQN(cut, fqn);
            }
            return element2;
        }
        javax.lang.model.element.Name name = ((MemberSelectTree)qualIdent).getIdentifier();
        if ("*".contentEquals(name)) {
            Element element3 = trees.getElement(TreePath.getPath(cut, (Tree)((MemberSelectTree)qualIdent).getExpression()));
            if (element3 == null) {
                element3 = this.getElementByFQN(cut, ((MemberSelectTree)qualIdent).getExpression().toString());
            }
            return element3;
        }
        if (imp.isStatic()) {
            Element parent = trees.getElement(TreePath.getPath(cut, (Tree)((MemberSelectTree)qualIdent).getExpression()));
            if (parent == null) {
                parent = this.getElementByFQN(cut, ((MemberSelectTree)qualIdent).getExpression().toString());
            }
            if (parent != null && (parent.getKind().isClass() || parent.getKind().isInterface())) {
                Scope s = trees.getScope(new TreePath(this.copy.getCompilationUnit()));
                for (Element element2 : parent.getEnclosedElements()) {
                    if (name != element2.getSimpleName() || !element2.getModifiers().contains((Object)Modifier.STATIC) || !trees.isAccessible(s, element2, (DeclaredType)parent.asType())) continue;
                    return element2;
                }
                return parent;
            }
        }
        if ((found = TreePath.getPath(cut, qualIdent)) == null) {
            found = new TreePath(new TreePath(new TreePath(cut), imp), qualIdent);
        }
        if ((element = trees.getElement(found)) == null) {
            element = this.getElementByFQN(cut, qualIdent.toString());
        }
        return element;
    }

    private Element getElementByFQN(CompilationUnitTree cut, String fqn) {
        Elements elements = this.copy.getElements();
        QualifiedNameable element = elements.getTypeElement(fqn);
        if (element == null) {
            element = elements.getPackageElement(fqn);
        }
        if (element == null) {
            element = Symtab.instance(this.copy.impl.getJavacTask().getContext()).enterClass(Modules.instance(this.copy.impl.getJavacTask().getContext()).getDefaultModule(), (Name)elements.getName(fqn));
        }
        return element;
    }

    private Map<javax.lang.model.element.Name, TypeElement> getUsedTypes(CompilationUnitTree cut) {
        final Trees trees = this.copy.getTrees();
        final HashMap<javax.lang.model.element.Name, TypeElement> map = new HashMap<javax.lang.model.element.Name, TypeElement>();
        new ErrorAwareTreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element element;
                if (!map.containsKey(node.getName()) && (element = trees.getElement(this.getCurrentPath())) != null && (element.getKind().isClass() || element.getKind().isInterface()) && element.asType().getKind() != TypeKind.ERROR) {
                    map.put(node.getName(), (TypeElement)element);
                }
                return (Void)super.visitIdentifier(node, p);
            }

            @Override
            public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
                this.scan(node.getPackageAnnotations(), p);
                return (Void)this.scan(node.getTypeDecls(), p);
            }
        }.scan(cut, null);
        return map;
    }

    private ExpressionTree qualIdentFor(Element e) {
        TreeMaker tm = this.copy.getTreeMaker();
        if (e.getKind() == ElementKind.MODULE) {
            return this.qualIdentFor(((ModuleElement)e).getQualifiedName().toString());
        }
        if (e.getKind() == ElementKind.PACKAGE) {
            String name = ((PackageElement)e).getQualifiedName().toString();
            if (e instanceof Symbol) {
                int lastDot = name.lastIndexOf(46);
                if (lastDot < 0) {
                    return tm.Identifier(e);
                }
                return tm.MemberSelect(this.qualIdentFor(name.substring(0, lastDot)), e);
            }
            return this.qualIdentFor(name);
        }
        Element ee = e.getEnclosingElement();
        if (e instanceof Symbol) {
            return ee.getSimpleName().length() > 0 ? tm.MemberSelect(this.qualIdentFor(ee), e) : tm.Identifier(e);
        }
        return ee.getSimpleName().length() > 0 ? tm.MemberSelect(this.qualIdentFor(ee), e.getSimpleName()) : tm.Identifier(e.getSimpleName());
    }

    private ExpressionTree qualIdentFor(String name) {
        Elements elements = this.copy.getElements();
        TreeMaker tm = this.copy.getTreeMaker();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return tm.Identifier(elements.getName(name));
        }
        return tm.MemberSelect(this.qualIdentFor(name.substring(0, lastDot)), elements.getName(name.substring(lastDot + 1)));
    }

    private Map<String, Object> createBindings(TypeElement clazz, ExecutableElement element) {
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        if (clazz != null) {
            bindings.put(CLASS_NAME, clazz.getQualifiedName().toString());
            bindings.put(SIMPLE_CLASS_NAME, clazz.getSimpleName().toString());
            bindings.put(CLASS_KIND, clazz.getKind().toString());
        }
        if (element != null) {
            bindings.put(METHOD_NAME, element.getSimpleName().toString());
            bindings.put(METHOD_RETURN_TYPE, element.getReturnType().toString());
            Object value = switch (element.getReturnType().getKind()) {
                case TypeKind.BOOLEAN -> "false";
                case TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT -> 0;
                default -> "null";
            };
            if (clazz != null && clazz.getKind() == ElementKind.RECORD) {
                bindings.put(DEFAULT_RETURN_TYPE_VALUE, element.getSimpleName());
            } else {
                bindings.put(DEFAULT_RETURN_TYPE_VALUE, value);
            }
        }
        if (clazz != null && element != null) {
            StringBuilder sb = new StringBuilder();
            if (element.isDefault() && element.getEnclosingElement().getKind().isInterface()) {
                Types types = this.copy.getTypes();
                Context ctx = this.copy.impl.getJavacTask().getContext();
                com.sun.tools.javac.code.Types typesImpl = com.sun.tools.javac.code.Types.instance(ctx);
                Type enclType = typesImpl.asSuper((Type)clazz.asType(), ((Type)element.getEnclosingElement().asType()).tsym);
                if (!types.isSubtype(clazz.getSuperclass(), enclType)) {
                    TypeMirror selected = enclType;
                    for (TypeMirror typeMirror : clazz.getInterfaces()) {
                        if (!types.isSubtype(typeMirror, selected) || types.isSameType(typeMirror, enclType)) continue;
                        selected = typeMirror;
                        break;
                    }
                    sb.append(((DeclaredType)selected).asElement().getSimpleName()).append('.');
                }
            }
            sb.append("super.").append(element.getSimpleName()).append('(');
            Iterator<? extends VariableElement> it = element.getParameters().iterator();
            while (it.hasNext()) {
                VariableElement ve = it.next();
                sb.append(GeneratorUtilities.addParamPrefixSuffix(GeneratorUtilities.removeParamPrefixSuffix(ve, cs), cs));
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(')');
            bindings.put(SUPER_METHOD_CALL, sb);
        }
        return bindings;
    }

    private static String name(Tree tree) {
        switch (tree.getKind()) {
            case VARIABLE: {
                return ((VariableTree)tree).getName().toString();
            }
            case METHOD: {
                return ((MethodTree)tree).getName().toString();
            }
            case CLASS: {
                return ((ClassTree)tree).getSimpleName().toString();
            }
            case IDENTIFIER: {
                return ((IdentifierTree)tree).getName().toString();
            }
            case MEMBER_SELECT: {
                return GeneratorUtilities.name(((MemberSelectTree)tree).getExpression()) + "." + ((MemberSelectTree)tree).getIdentifier();
            }
        }
        return "";
    }

    private static String[] correspondingGSNames(Tree member) {
        if (GeneratorUtilities.isSetter(member)) {
            String name = GeneratorUtilities.name(member);
            VariableTree param = ((MethodTree)member).getParameters().get(0);
            if (param.getType().getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)param.getType()).getPrimitiveTypeKind() == TypeKind.BOOLEAN) {
                return new String[]{"g" + name.substring(1), "is" + name.substring(3)};
            }
            return new String[]{"g" + name.substring(1)};
        }
        if (GeneratorUtilities.isGetter(member)) {
            return new String[]{"s" + GeneratorUtilities.name(member).substring(1)};
        }
        if (GeneratorUtilities.isBooleanGetter(member)) {
            return new String[]{"set" + GeneratorUtilities.name(member).substring(2)};
        }
        return null;
    }

    private static boolean isSetter(Tree member) {
        return member.getKind() == Tree.Kind.METHOD && GeneratorUtilities.name(member).startsWith("set") && ((MethodTree)member).getParameters().size() == 1 && ((MethodTree)member).getReturnType().getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)((MethodTree)member).getReturnType()).getPrimitiveTypeKind() == TypeKind.VOID;
    }

    private static boolean isGetter(Tree member) {
        return member.getKind() == Tree.Kind.METHOD && GeneratorUtilities.name(member).startsWith("get") && ((MethodTree)member).getParameters().isEmpty() && (((MethodTree)member).getReturnType().getKind() != Tree.Kind.PRIMITIVE_TYPE || ((PrimitiveTypeTree)((MethodTree)member).getReturnType()).getPrimitiveTypeKind() != TypeKind.VOID);
    }

    private static boolean isBooleanGetter(Tree member) {
        return member.getKind() == Tree.Kind.METHOD && GeneratorUtilities.name(member).startsWith("is") && ((MethodTree)member).getParameters().isEmpty() && ((MethodTree)member).getReturnType().getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)((MethodTree)member).getReturnType()).getPrimitiveTypeKind() == TypeKind.BOOLEAN;
    }

    private static String removeFieldPrefixSuffix(VariableElement var, CodeStyle cs) {
        boolean isStatic = var.getModifiers().contains((Object)Modifier.STATIC);
        return CodeStyleUtils.removePrefixSuffix(var.getSimpleName(), isStatic ? cs.getStaticFieldNamePrefix() : cs.getFieldNamePrefix(), isStatic ? cs.getStaticFieldNameSuffix() : cs.getFieldNameSuffix());
    }

    private static String removeFieldPrefixSuffix(VariableTree var, CodeStyle cs) {
        boolean isStatic = var.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        return CodeStyleUtils.removePrefixSuffix(var.getName(), isStatic ? cs.getStaticFieldNamePrefix() : cs.getFieldNamePrefix(), isStatic ? cs.getStaticFieldNameSuffix() : cs.getFieldNameSuffix());
    }

    private static String addParamPrefixSuffix(CharSequence name, CodeStyle cs) {
        return CodeStyleUtils.addPrefixSuffix(name, cs.getParameterNamePrefix(), cs.getParameterNameSuffix());
    }

    private static String removeParamPrefixSuffix(VariableElement var, CodeStyle cs) {
        return CodeStyleUtils.removePrefixSuffix(var.getSimpleName(), cs.getParameterNamePrefix(), cs.getParameterNameSuffix());
    }

    private void tagFirst(List<MethodTree> methods) {
        BlockTree body;
        if (methods.size() > 0 && (body = methods.get(0).getBody()) != null && !body.getStatements().isEmpty()) {
            this.copy.tag(body.getStatements().get(0), "methodBodyTag");
        }
    }

    static boolean checkPackagesForStarImport(String pkgName, CodeStyle cs) {
        for (String s : cs.getPackagesForStarImport()) {
            if (!(s.endsWith(".*") ? pkgName.startsWith(s = s.substring(0, s.length() - 2)) : pkgName.equals(s))) continue;
            return true;
        }
        return false;
    }

    private static String readFromTemplate(String pathToTemplate, Map<String, Object> values) throws IOException, ScriptException {
        FileObject template = FileUtil.getConfigFile((String)pathToTemplate);
        Charset sourceEnc = FileEncodingQuery.getEncoding((FileObject)template);
        ScriptEngine eng = GeneratorUtilities.engine(template);
        ScriptContext context = eng.getContext();
        context.getBindings(100).putAll((Map<? extends String, ? extends Object>)values);
        context.setAttribute(FileObject.class.getName(), template, 100);
        context.setAttribute("javax.script.filename", template.getNameExt(), 100);
        context.setAttribute(STRING_OUTPUT_MODE_ATTR, true, 100);
        try (InputStreamReader is = new InputStreamReader(template.getInputStream(), sourceEnc);){
            String string = (String)eng.eval(is);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptEngine engine(FileObject fo) {
        Object obj = fo.getAttribute(SCRIPT_ENGINE_ATTR);
        if (obj instanceof ScriptEngine) {
            return (ScriptEngine)obj;
        }
        if (obj instanceof String) {
            Class<GeneratorUtilities> clazz = GeneratorUtilities.class;
            synchronized (GeneratorUtilities.class) {
                if (manager == null) {
                    manager = Scripting.createManager();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return manager.getEngineByName((String)obj);
            }
        }
        return null;
    }

    private static boolean containsErrors(Tree tree) {
        Boolean b = new ErrorAwareTreeScanner<Boolean, Boolean>(){

            @Override
            public Boolean visitErroneous(ErroneousTree node, Boolean p) {
                return true;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                if (r1 == null) {
                    r1 = false;
                }
                if (r2 == null) {
                    r2 = false;
                }
                return r1 != false || r2 != false;
            }

            @Override
            public Boolean scan(Tree node, Boolean p) {
                return p != false ? p : (Boolean)super.scan(node, p);
            }
        }.scan(tree, false);
        return b != null ? b : false;
    }

    static {
        GeneratorUtilitiesAccessor.setInstance(new GeneratorUtilitiesAccessor(){

            @Override
            public CompilationUnitTree addImports(GeneratorUtilities gu, CompilationUnitTree cut, List<? extends ImportTree> cutImports, Set<? extends Element> toImport, Function<Element, ModuleElement> moduleOf) {
                return gu.addImports(cut, cutImports, toImport, moduleOf);
            }
        });
    }

    private static class ClassMemberComparator
    implements Comparator<Tree> {
        private final CodeStyle.MemberGroups groups;
        private final boolean sortMembersAlpha;
        private final boolean keepGASTogether;

        public ClassMemberComparator(CodeStyle cs) {
            this.groups = cs.getClassMemberGroups();
            this.sortMembersAlpha = cs.sortMembersInGroupsAlphabetically();
            this.keepGASTogether = cs.keepGettersAndSettersTogether();
        }

        @Override
        public int compare(Tree tree1, Tree tree2) {
            if (tree1 == tree2) {
                return 0;
            }
            int diff = this.groups.getGroupId(tree1) - this.groups.getGroupId(tree2);
            if (diff == 0 && this.sortMembersAlpha) {
                Object name1 = GeneratorUtilities.name(tree1);
                Object name2 = GeneratorUtilities.name(tree2);
                if (this.keepGASTogether) {
                    if (GeneratorUtilities.isSetter(tree1)) {
                        name1 = "g" + ((String)name1).substring(1) + "+1";
                    }
                    if (GeneratorUtilities.isSetter(tree2)) {
                        name2 = "g" + ((String)name2).substring(1) + "+1";
                    }
                }
                diff = ((String)name1).compareTo((String)name2);
            }
            return diff;
        }
    }

    private class FieldRefVisitor
    extends ErrorAwareTreePathScanner {
        private final ClassTree clazz;
        private Set<javax.lang.model.element.Name> fieldNames = new HashSet<javax.lang.model.element.Name>();
        private boolean staticFields;
        private boolean collectNames;
        private javax.lang.model.element.Name insertedName;
        private Collection<Tree> revDependencies = new ArrayList<Tree>();
        private Map<Tree, Collection<javax.lang.model.element.Name>> dependencies = new HashMap<Tree, Collection<javax.lang.model.element.Name>>();
        private Map<javax.lang.model.element.Name, Tree> namedTrees = new HashMap<javax.lang.model.element.Name, Tree>();
        private Tree member;

        public FieldRefVisitor(ClassTree clazz, boolean stat) {
            this.clazz = clazz;
            this.staticFields = stat;
        }

        void registerTreeName(Tree t, javax.lang.model.element.Name n) {
            this.fieldNames.add(n);
            this.namedTrees.put(n, t);
            this.insertedName = n;
        }

        private void addDependency(javax.lang.model.element.Name n) {
            Collection<javax.lang.model.element.Name> deps = this.dependencies.get(this.member);
            if (deps == null) {
                deps = new ArrayList<javax.lang.model.element.Name>(3);
                this.dependencies.put(this.member, deps);
            }
            deps.add(n);
        }

        @Override
        public Object visitAnnotatedType(AnnotatedTypeTree node, Object p) {
            return null;
        }

        @Override
        public Object visitTypeParameter(TypeParameterTree node, Object p) {
            return null;
        }

        @Override
        public Object visitArrayType(ArrayTypeTree node, Object p) {
            return null;
        }

        @Override
        public Object visitInstanceOf(InstanceOfTree node, Object p) {
            return null;
        }

        @Override
        public Object visitBreak(BreakTree node, Object p) {
            return null;
        }

        @Override
        public Object visitTypeCast(TypeCastTree node, Object p) {
            return this.scan(node.getExpression(), p);
        }

        @Override
        public Object visitCase(CaseTree node, Object p) {
            return this.scan(node.getStatements(), p);
        }

        @Override
        public Object visitLabeledStatement(LabeledStatementTree node, Object p) {
            return this.scan(node.getStatement(), p);
        }

        @Override
        public Object visitAnnotation(AnnotationTree node, Object p) {
            return null;
        }

        @Override
        public Object visitParameterizedType(ParameterizedTypeTree node, Object p) {
            return null;
        }

        @Override
        public Object visitNewArray(NewArrayTree node, Object p) {
            this.scan(node.getDimensions(), p);
            return this.scan(node.getInitializers(), p);
        }

        @Override
        public Object visitNewClass(NewClassTree node, Object p) {
            return this.scan(node.getArguments(), p);
        }

        @Override
        public Object visitIdentifier(IdentifierTree node, Object p) {
            if (!this.fieldNames.contains(node.getName())) {
                return null;
            }
            boolean ok = false;
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            switch (parent.getKind()) {
                case MEMBER_SELECT: {
                    ok = ((MemberSelectTree)parent).getExpression() != node;
                    break;
                }
                case ASSIGNMENT: {
                    boolean bl = ok = ((AssignmentTree)parent).getVariable() == node;
                }
            }
            if (ok) {
                return null;
            }
            if (!ok) {
                if (this.collectNames) {
                    if (node.getName().equals(this.insertedName)) {
                        this.revDependencies.add(this.member);
                    }
                } else {
                    this.addDependency(node.getName());
                }
            }
            return null;
        }

        @Override
        public Object visitMemberSelect(MemberSelectTree node, Object p) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (this.fieldNames.contains(node.getIdentifier())) {
                // empty if block
            }
            Object o = super.visitMemberSelect(node, p);
            return o;
        }

        @Override
        public Object visitVariable(VariableTree node, Object p) {
            Tree parent;
            Tree.Kind k;
            if (node.getModifiers().getFlags().contains((Object)Modifier.STATIC) != this.staticFields) {
                return null;
            }
            if (this.collectNames) {
                this.fieldNames.add(node.getName());
                this.namedTrees.put(node.getName(), node);
            }
            if ((k = (parent = this.getCurrentPath().getParentPath().getLeaf()).getKind()) == Tree.Kind.CLASS || k == Tree.Kind.INTERFACE || k == Tree.Kind.ENUM) {
                this.member = node;
            }
            Object o = this.scan(node.getInitializer(), p);
            return o;
        }

        @Override
        public Object visitBlock(BlockTree node, Object p) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            Tree.Kind k = parent.getKind();
            if (k == Tree.Kind.CLASS || k == Tree.Kind.INTERFACE || k == Tree.Kind.ENUM) {
                this.member = node;
                return super.visitBlock(node, p);
            }
            return p;
        }

        @Override
        public Object visitMethod(MethodTree node, Object p) {
            return p;
        }

        @Override
        public Object visitClass(ClassTree node, Object p) {
            if (node == this.clazz) {
                return super.visitClass(node, p);
            }
            return p;
        }
    }

    private static class ImportsComparator
    implements Comparator<Object> {
        private final CodeStyle.ImportGroups groups;

        private ImportsComparator(CodeStyle cs) {
            this.groups = cs.getImportGroups();
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            boolean isStatic1 = false;
            boolean isModule1 = false;
            StringBuilder sb1 = new StringBuilder();
            if (o1 instanceof ImportTree) {
                ImportTree it1 = (ImportTree)o1;
                isStatic1 = it1.isStatic();
                isModule1 = it1.isModule();
                sb1.append(it1.getQualifiedIdentifier().toString());
            } else if (o1 instanceof Element) {
                Element e1 = (Element)o1;
                if (e1.getKind().isField() || e1.getKind() == ElementKind.METHOD) {
                    sb1.append('.').append(e1.getSimpleName());
                    e1 = e1.getEnclosingElement();
                    isStatic1 = true;
                }
                if (e1.getKind().isClass() || e1.getKind().isInterface()) {
                    sb1.insert(0, ((TypeElement)e1).getQualifiedName());
                } else if (e1.getKind() == ElementKind.PACKAGE) {
                    sb1.insert(0, ((PackageElement)e1).getQualifiedName());
                } else if (e1.getKind() == ElementKind.MODULE) {
                    isModule1 = true;
                    sb1.insert(0, ((ModuleElement)e1).getQualifiedName());
                }
            }
            String s1 = sb1.toString();
            boolean isStatic2 = false;
            boolean isModule2 = false;
            StringBuilder sb2 = new StringBuilder();
            if (o2 instanceof ImportTree) {
                ImportTree it2 = (ImportTree)o2;
                isStatic2 = it2.isStatic();
                isModule2 = it2.isModule();
                sb2.append(it2.getQualifiedIdentifier().toString());
            } else if (o2 instanceof Element) {
                Element e2 = (Element)o2;
                if (e2.getKind().isField() || e2.getKind() == ElementKind.METHOD) {
                    sb2.append('.').append(e2.getSimpleName());
                    e2 = e2.getEnclosingElement();
                    isStatic2 = true;
                }
                if (e2.getKind().isClass() || e2.getKind().isInterface()) {
                    sb2.insert(0, ((TypeElement)e2).getQualifiedName());
                } else if (e2.getKind() == ElementKind.PACKAGE) {
                    sb2.insert(0, ((PackageElement)e2).getQualifiedName());
                } else if (e2.getKind() == ElementKind.MODULE) {
                    isModule2 = true;
                    sb2.insert(0, ((ModuleElement)e2).getQualifiedName());
                }
            }
            String s2 = sb2.toString();
            int bal = isModule1 ? (isModule2 ? 0 : 1) : (isModule2 ? -1 : this.groups.getGroupId(s1, isStatic1) - this.groups.getGroupId(s2, isStatic2));
            return bal == 0 ? s1.compareTo(s2) : bal;
        }
    }
}

