/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.tools.javac.code.Symbol;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Module;
import org.netbeans.modules.java.source.base.Bundle;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Convertors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class JavadocHelper {
    private static final Logger LOG = Logger.getLogger(JavadocHelper.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(JavadocHelper.class.getName(), 1);
    private static final int DEFAULT_REMOTE_CONNECTION_TIMEOUT = 30;
    private static final int DEFAULT_REMOTE_FILE_CONTENT_CACHE_SIZE = 50;
    private static final int REMOTE_FILE_CONTENT_CACHE_SIZE = Integer.getInteger("JavadocHelper.remoteCache.size", 50);
    private static final int REMOTE_CONNECTION_TIMEOUT = Integer.getInteger("JavadocHelper.remote.timeOut", 30) * 1000;
    private static final String PACKAGE_SUMMARY = "package-summary";
    private static final Set<String> knownGoodRoots = Collections.synchronizedSet(new HashSet());

    private JavadocHelper() {
    }

    private static boolean isRemote(URL url) {
        return url.getProtocol().startsWith("http") || url.getProtocol().startsWith("ftp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static InputStream openStream(@NonNull URL url, @NullAllowed String message) throws IOException {
        ProgressHandle progress = null;
        if (message != null) {
            progress = ProgressHandle.createHandle((String)message);
            progress.start();
        }
        try {
            FileObject f;
            if (url.getProtocol().equals("jar") && (f = URLMapper.findFileObject((URL)url)) != null) {
                InputStream inputStream = f.getInputStream();
                return inputStream;
            }
            if (JavadocHelper.isRemote(url)) {
                LOG.log(Level.FINE, "opening network stream: {0}", url);
            }
            URLConnection c = url.openConnection();
            c.setConnectTimeout(REMOTE_CONNECTION_TIMEOUT);
            InputStream inputStream = c.getInputStream();
            return inputStream;
        }
        finally {
            if (progress != null) {
                progress.finish();
            }
        }
    }

    public static TextStream getJavadoc(Element element, @NullAllowed Callable<Boolean> cancel) {
        return JavadocHelper.getJavadoc(element, true, cancel);
    }

    public static TextStream getJavadoc(Element element, boolean allowRemoteJavadoc, @NullAllowed Callable<Boolean> cancel) {
        try {
            List<TextStream> res = JavadocHelper.getJavadoc(element, allowRemoteJavadoc ? RemoteJavadocPolicy.USE : RemoteJavadocPolicy.IGNORE, cancel);
            return res.isEmpty() ? null : res.get(0);
        }
        catch (RemoteJavadocException rje) {
            throw new IllegalStateException("Never thrown", rje);
        }
    }

    @NonNull
    public static List<TextStream> getJavadoc(@NonNull Element element, @NonNull RemoteJavadocPolicy remoteJavadocPolicy, @NullAllowed Callable<Boolean> cancel) throws RemoteJavadocException {
        Parameters.notNull((CharSequence)"element", (Object)element);
        Parameters.notNull((CharSequence)"remoteJavadocPolicy", (Object)((Object)remoteJavadocPolicy));
        return JavadocHelper.doGetJavadoc(element, remoteJavadocPolicy, cancel);
    }

    public static TextStream getJavadoc(Element element) {
        return JavadocHelper.getJavadoc(element, null);
    }

    @CheckForNull
    public static String getCharSet(ChangedCharSetException e) {
        String spec = e.getCharSetSpec();
        if (e.keyEqualsCharSet()) {
            return spec;
        }
        int index = spec.indexOf(";");
        if (index != -1) {
            spec = spec.substring(index + 1);
        }
        spec = spec.toLowerCase();
        StringTokenizer st = new StringTokenizer(spec, " \t=", true);
        boolean foundCharSet = false;
        boolean foundEquals = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(" ") || token.equals("\t")) continue;
            if (!foundCharSet && !foundEquals && token.equals("charset")) {
                foundCharSet = true;
                continue;
            }
            if (!foundEquals && token.equals("=")) {
                foundEquals = true;
                continue;
            }
            if (foundEquals && foundCharSet) {
                return token;
            }
            foundCharSet = false;
            foundEquals = false;
        }
        return null;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private static List<TextStream> doGetJavadoc(Element element, final RemoteJavadocPolicy remoteJavadocPolicy, Callable<Boolean> cancel) throws RemoteJavadocException {
        String pageName;
        String pkgName;
        if (element == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getJavadoc");
        }
        Symbol.ClassSymbol clsSym = null;
        String moduleName = null;
        boolean buildFragment = false;
        if (element.getKind() == ElementKind.PACKAGE) {
            List<? extends Element> els = element.getEnclosedElements();
            for (Element element2 : els) {
                if (!element2.getKind().isClass() && !element2.getKind().isInterface()) continue;
                clsSym = (Symbol.ClassSymbol)element2;
                break;
            }
            if (clsSym == null) {
                return Collections.emptyList();
            }
            moduleName = JavadocHelper.moduleNameFor(element);
            pkgName = FileObjects.convertPackage2Folder(((PackageElement)element).getQualifiedName().toString());
            pageName = PACKAGE_SUMMARY;
        } else {
            if (element.getKind() == ElementKind.MODULE) {
                return Collections.emptyList();
            }
            Element e = element;
            StringBuilder sb = new StringBuilder();
            while (e.getKind() != ElementKind.PACKAGE) {
                if (e.getKind().isClass() || e.getKind().isInterface()) {
                    if (sb.length() > 0) {
                        sb.insert(0, '.');
                    }
                    sb.insert(0, e.getSimpleName());
                    if (clsSym == null) {
                        clsSym = (Symbol.ClassSymbol)e;
                    }
                }
                e = e.getEnclosingElement();
            }
            if (clsSym == null) {
                return Collections.emptyList();
            }
            moduleName = JavadocHelper.moduleNameFor(e);
            pkgName = FileObjects.convertPackage2Folder(((PackageElement)e).getQualifiedName().toString());
            pageName = sb.toString();
            boolean bl = buildFragment = element != clsSym;
        }
        if (clsSym.completer != null) {
            clsSym.complete();
        }
        if (clsSym.classfile != null) {
            try {
                boolean sync;
                final URL classFile = clsSym.classfile.toUri().toURL();
                final String moduleNameF = moduleName;
                final String string = pkgName;
                final String pageNameF = pageName;
                final Collection<Object> fragment = buildFragment ? JavadocHelper.getFragment(element) : Collections.emptySet();
                Callable<List<TextStream>> action = new Callable<List<TextStream>>(){

                    @Override
                    @NonNull
                    public List<TextStream> call() throws Exception {
                        return JavadocHelper.findJavadoc(classFile, moduleNameF, string, pageNameF, fragment, remoteJavadocPolicy);
                    }
                };
                boolean bl = sync = cancel == null || remoteJavadocPolicy != RemoteJavadocPolicy.USE;
                if (sync) {
                    return (List)action.call();
                }
                Future future = RP.submit((Callable)action);
                while (true) {
                    if (cancel != null && cancel.call().booleanValue()) {
                        future.cancel(false);
                        break;
                    }
                    try {
                        return (List)future.get(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException timeoutException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                if (t instanceof ExecutionException) {
                    t = ((ExecutionException)t).getCause();
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (t instanceof RemoteJavadocException) {
                    throw (RemoteJavadocException)t;
                }
                if (t instanceof InterruptedException) {
                    LOG.log(Level.INFO, "The HTTP Javadoc timeout expired ({0}s), to increase the timeout set the JavadocHelper.remote.timeOut property.", REMOTE_CONNECTION_TIMEOUT / 1000);
                }
                LOG.log(Level.INFO, null, t);
            }
        }
        return Collections.emptyList();
    }

    private static String moduleNameFor(Element element) {
        Element e = element;
        while (e != null && e.getKind() != ElementKind.MODULE) {
            e = element.getEnclosingElement();
        }
        if (e == null) {
            return null;
        }
        String name = ((ModuleElement)e).getQualifiedName().toString();
        if (!name.isEmpty()) {
            return name;
        }
        return null;
    }

    @NonNull
    private static List<TextStream> findJavadoc(@NonNull URL classFile, String moduleName, @NonNull String pkgName, @NonNull String pageName, @NonNull Collection<? extends CharSequence> fragment, @NonNull RemoteJavadocPolicy remoteJavadocPolicy) throws RemoteJavadocException, InterruptedException {
        ArrayList<TextStream> resList;
        block52: {
            resList = new ArrayList<TextStream>();
            URL sourceRoot = null;
            HashSet<URL> binaries = new HashSet<URL>();
            try {
                FileObject sourceFo;
                FileObject fo = URLMapper.findFileObject((URL)classFile);
                StringTokenizer tk = new StringTokenizer(pkgName, "/");
                for (int i = 0; fo != null && i <= tk.countTokens(); fo = fo.getParent(), ++i) {
                }
                if (fo != null) {
                    URL url = CachingArchiveProvider.getDefault().mapCtSymToJar(fo.toURL());
                    sourceRoot = JavaIndex.getSourceRootForClassFolder(url);
                    if (sourceRoot == null) {
                        binaries.add(url);
                    } else {
                        binaries.add(sourceRoot);
                    }
                }
                if (sourceRoot != null && (sourceFo = URLMapper.findFileObject(sourceRoot)) != null) {
                    ClassPath exec = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/execute");
                    ClassPath compile = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/compile");
                    ClassPath source = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/source");
                    if (exec == null) {
                        exec = compile;
                        compile = null;
                    }
                    if (exec != null && source != null) {
                        HashSet<URL> roots = new HashSet<URL>();
                        for (ClassPath.Entry e : exec.entries()) {
                            roots.add(e.getURL());
                        }
                        if (compile != null) {
                            for (ClassPath.Entry e : compile.entries()) {
                                roots.remove(e.getURL());
                            }
                        }
                        List<FileObject> sourceRoots = Arrays.asList(source.getRoots());
                        block26: for (URL e : roots) {
                            FileObject[] res;
                            for (FileObject r : res = SourceForBinaryQuery.findSourceRoots((URL)e).getRoots()) {
                                if (!sourceRoots.contains(r)) continue;
                                binaries.add(e);
                                continue block26;
                            }
                        }
                    }
                }
                for (URL binary : binaries) {
                    URL[] result;
                    JavadocForBinaryQuery.Result javadocResult = JavadocForBinaryQuery.findJavadoc((URL)binary);
                    block29: for (URL root : result = javadocResult.getRoots()) {
                        boolean speculative;
                        block51: {
                            InputStream is;
                            URL url;
                            block50: {
                                boolean useKnownGoodRoots;
                                if (!root.toExternalForm().endsWith("/")) {
                                    LOG.log(Level.WARNING, "JavadocForBinaryQuery.Result: {0} returned non-folder URL: {1}, ignoring", new Object[]{javadocResult.getClass(), root.toExternalForm()});
                                    continue;
                                }
                                boolean isRemote = JavadocHelper.isRemote(root);
                                speculative = false;
                                if (isRemote) {
                                    switch (remoteJavadocPolicy) {
                                        case EXCEPTION: {
                                            throw new RemoteJavadocException(root);
                                        }
                                        case IGNORE: {
                                            continue block29;
                                        }
                                        case USE: {
                                            break;
                                        }
                                        case SPECULATIVE: {
                                            speculative = true;
                                            break;
                                        }
                                        default: {
                                            throw new IllegalArgumentException(remoteJavadocPolicy.name());
                                        }
                                    }
                                }
                                url = moduleName != null ? new URL(root, moduleName + "/" + pkgName + "/" + pageName + ".html") : new URL(root, pkgName + "/" + pageName + ".html");
                                is = null;
                                String rootS = root.toString();
                                boolean bl = useKnownGoodRoots = result.length == 1 && isRemote;
                                if (useKnownGoodRoots && knownGoodRoots.contains(rootS)) {
                                    LOG.log(Level.FINE, "assumed valid Javadoc stream at {0}", url);
                                } else if (!speculative || !isRemote) {
                                    try {
                                        try {
                                            is = JavadocHelper.openStream(url, Bundle.LBL_HTTPJavadocDownload());
                                        }
                                        catch (InterruptedIOException iioe) {
                                            throw iioe;
                                        }
                                        catch (IOException x) {
                                            if (moduleName == null) {
                                                URL moduleInfo = new URL(binary, "module-info.class");
                                                try (InputStream inputStream = moduleInfo.openStream();){
                                                    ClassFile clazz = new ClassFile(inputStream, false);
                                                    Module module = clazz.getModule();
                                                    if (module == null) {
                                                        throw x;
                                                    }
                                                    String modName = module.getName();
                                                    if (modName == null) {
                                                        throw x;
                                                    }
                                                    url = new URL(root, modName + "/" + pkgName + "/" + pageName + ".html");
                                                }
                                            } else {
                                                url = new URL(root, pkgName + "/" + pageName + ".html");
                                            }
                                            is = JavadocHelper.openStream(url, Bundle.LBL_HTTPJavadocDownload());
                                        }
                                        if (!useKnownGoodRoots) break block50;
                                        knownGoodRoots.add(rootS);
                                        LOG.log(Level.FINE, "found valid Javadoc stream at {0}", url);
                                    }
                                    catch (InterruptedIOException iioe) {
                                        throw new InterruptedException();
                                    }
                                    catch (IOException x) {
                                        LOG.log(Level.FINE, "invalid Javadoc stream at {0}: {1}", new Object[]{url, x});
                                        continue;
                                    }
                                }
                            }
                            if (!fragment.isEmpty()) {
                                try {
                                    ArrayList<URL> urls = new ArrayList<URL>(fragment.size());
                                    for (CharSequence charSequence : fragment) {
                                        String encodedfragment = URLEncoder.encode(charSequence.toString(), "UTF-8").replace("+", "%20");
                                        urls.add(new URI(url.toExternalForm() + "#" + encodedfragment).toURL());
                                    }
                                    resList.add(new TextStream(urls, root, is));
                                    if (speculative) break block51;
                                    break block52;
                                }
                                catch (URISyntaxException x) {
                                    LOG.log(Level.INFO, null, x);
                                    break block51;
                                }
                                catch (UnsupportedEncodingException x) {
                                    LOG.log(Level.INFO, null, x);
                                    break block51;
                                }
                                catch (MalformedURLException x) {
                                    LOG.log(Level.INFO, null, x);
                                    break block51;
                                }
                            }
                            resList.add(new TextStream(Collections.singleton(url), root, is));
                        }
                        if (speculative) {
                            continue;
                        }
                        break block52;
                    }
                }
            }
            catch (MalformedURLException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        return resList;
    }

    @NonNull
    private static Collection<? extends CharSequence> getFragment(Element e) {
        FragmentBuilder fb = new FragmentBuilder(e.getKind());
        if (!e.getKind().isClass() && !e.getKind().isInterface()) {
            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                fb.constructor(e.getEnclosingElement().getSimpleName());
            } else {
                fb.append(e.getSimpleName());
            }
            if (e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement ee = (ExecutableElement)e;
                fb.append("(");
                Iterator<? extends VariableElement> it = ee.getParameters().iterator();
                while (it.hasNext()) {
                    VariableElement param = it.next();
                    JavadocHelper.appendType(fb, param.asType(), ee.isVarArgs() && !it.hasNext());
                    if (!it.hasNext()) continue;
                    fb.append(", ");
                }
                fb.append(")");
            }
        }
        return fb.getFragments();
    }

    private static void appendType(FragmentBuilder fb, TypeMirror type, boolean varArg) {
        switch (type.getKind()) {
            case ARRAY: {
                JavadocHelper.appendType(fb, ((ArrayType)type).getComponentType(), false);
                fb.append(varArg ? "..." : "[]");
                break;
            }
            case DECLARED: {
                fb.append(((TypeElement)((DeclaredType)type).asElement()).getQualifiedName());
                break;
            }
            default: {
                fb.append(type.toString());
            }
        }
    }

    public static final class TextStream {
        private static Map<URI, byte[]> remoteFileContentCache = Collections.synchronizedMap(new LinkedHashMap<URI, byte[]>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<URI, byte[]> eldest) {
                return this.size() > REMOTE_FILE_CONTENT_CACHE_SIZE;
            }
        });
        private static final Map<URI, Integer> jdocCache = new ConcurrentHashMap<URI, Integer>();
        private static final Set<String> docLet1 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("constructor_summary", "method_summary", "field_detail", "constructor_detail", "method_detail")));
        private static final Set<String> docLet2 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("constructor.summary", "method.summary", "field.detail", "constructor.detail", "method.detail")));
        private final List<? extends URL> urls;
        private final AtomicReference<InputStream> stream = new AtomicReference();
        private URI jdocRoot = null;
        private byte[] cache;

        public TextStream(@NonNull URL url) {
            Parameters.notNull((CharSequence)"url", (Object)url);
            this.urls = Collections.singletonList(url);
        }

        TextStream(@NonNull Collection<? extends URL> urls) {
            Parameters.notNull((CharSequence)"urls", urls);
            ArrayList<URL> tmpUrls = new ArrayList<URL>(urls.size());
            for (URL uRL : urls) {
                Parameters.notNull((CharSequence)"urls[]", (Object)uRL);
                tmpUrls.add(uRL);
            }
            if (tmpUrls.isEmpty()) {
                throw new IllegalArgumentException("At least one URL has to be given.");
            }
            this.urls = Collections.unmodifiableList(tmpUrls);
        }

        TextStream(@NonNull Collection<? extends URL> urls, @NonNull URL root, InputStream stream) {
            this(urls);
            try {
                this.jdocRoot = root.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.stream.set(stream);
        }

        @CheckForNull
        public URL getLocation() {
            try {
                return this.getLocation(RemoteJavadocPolicy.USE);
            }
            catch (RemoteJavadocException e) {
                throw new IllegalStateException(e);
            }
        }

        @CheckForNull
        public URL getLocation(@NonNull RemoteJavadocPolicy rjp) throws RemoteJavadocException {
            Integer index;
            if (this.urls.isEmpty()) {
                return null;
            }
            Integer n = index = this.jdocRoot == null ? null : jdocCache.get(this.jdocRoot);
            if (index == null || index >= this.urls.size()) {
                switch (rjp) {
                    case USE: {
                        break;
                    }
                    case EXCEPTION: {
                        if (!this.isRemote()) break;
                        throw new RemoteJavadocException(this.urls.get(0));
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Unsupported RemoteJavadocPolicy: %s", new Object[]{rjp}));
                    }
                }
                try {
                    String charset = null;
                    while (true) {
                        BufferedReader reader = new BufferedReader(charset == null ? new InputStreamReader(this.openStream()) : new InputStreamReader(this.openStream(), charset));
                        try {
                            if (this.urls.size() > 1) {
                                reader.mark(256);
                                String line = reader.readLine();
                                if (line.contains("<!DOCTYPE") && line.contains("HTML>")) {
                                    index = 2;
                                    if (this.jdocRoot != null) {
                                        jdocCache.put(this.jdocRoot, index);
                                    }
                                    break;
                                }
                                reader.reset();
                                ParserDelegator parser = new ParserDelegator();
                                final int[] state = new int[]{-1};
                                try {
                                    ((HTMLEditorKit.Parser)parser).parse(reader, new HTMLEditorKit.ParserCallback(){

                                        @Override
                                        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                                            String attrName;
                                            if (state[0] == -1 && t == HTML.Tag.A && (attrName = (String)a.getAttribute(HTML.Attribute.NAME)) != null) {
                                                if (docLet1.contains(attrName)) {
                                                    state[0] = 0;
                                                } else if (docLet2.contains(attrName)) {
                                                    state[0] = 1;
                                                }
                                            }
                                        }
                                    }, charset != null);
                                    index = state[0] == -1 ? 0 : state[0];
                                    if (this.jdocRoot != null) {
                                        jdocCache.put(this.jdocRoot, index);
                                    }
                                    break;
                                }
                                catch (ChangedCharSetException e) {
                                    if (charset == null) {
                                        charset = JavadocHelper.getCharSet(e);
                                        continue;
                                    }
                                    throw new IOException(e);
                                }
                            }
                            index = 0;
                        }
                        finally {
                            reader.close();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    return null;
                }
            }
            assert (index != null && index != -1);
            return this.urls.get(index);
        }

        @NonNull
        public List<? extends URL> getLocations() {
            return this.urls;
        }

        @CheckForNull
        public URL getDocRoot() {
            try {
                if (this.jdocRoot != null) {
                    return this.jdocRoot.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return null;
        }

        public void close() {
            InputStream is = this.stream.getAndSet(null);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, null, x);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized InputStream openStream() throws IOException {
            if (this.cache != null) {
                LOG.log(Level.FINE, "loaded cached content for {0}", this.getFirstLocation());
                return new ByteArrayInputStream(this.cache);
            }
            assert (!this.isRemote() || !EventQueue.isDispatchThread());
            InputStream uncached = this.stream.getAndSet(null);
            if (this.isRemote()) {
                try {
                    byte[] data;
                    URI fileURI = this.getFileURI();
                    byte[] byArray = data = fileURI == null ? null : remoteFileContentCache.get(fileURI);
                    if (data == null) {
                        if (uncached == null) {
                            uncached = JavadocHelper.openStream(this.getFirstLocation(), Bundle.LBL_HTTPJavadocDownload());
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(20480);
                        FileUtil.copy((InputStream)uncached, (OutputStream)baos);
                        data = baos.toByteArray();
                        if (fileURI != null) {
                            remoteFileContentCache.put(fileURI, data);
                        }
                    }
                    this.cache = data;
                }
                finally {
                    if (uncached != null) {
                        uncached.close();
                    }
                }
                LOG.log(Level.FINE, "cached content for {0} ({1}k)", new Object[]{this.getFirstLocation(), this.cache.length / 1024});
                return new ByteArrayInputStream(this.cache);
            }
            if (uncached == null) {
                uncached = JavadocHelper.openStream(this.getFirstLocation(), null);
            }
            return uncached;
        }

        public boolean isRemote() {
            return JavadocHelper.isRemote(this.getFirstLocation());
        }

        private URL getFirstLocation() {
            return this.urls.iterator().next();
        }

        @CheckForNull
        private URI getFileURI() {
            URL location = this.getFirstLocation();
            String surl = location.toString();
            int index = surl.lastIndexOf(35);
            try {
                return index < 0 ? location.toURI() : new URI(surl.substring(0, index));
            }
            catch (URISyntaxException use) {
                return null;
            }
        }
    }

    public static enum RemoteJavadocPolicy {
        USE,
        IGNORE,
        EXCEPTION,
        SPECULATIVE;

    }

    public static final class RemoteJavadocException
    extends Exception {
        private final URL root;

        public RemoteJavadocException(@NullAllowed URL root) {
            this.root = root;
        }

        @CheckForNull
        public URL getRoot() {
            return this.root;
        }
    }

    private static final class FragmentBuilder {
        private static final List<Convertor<CharSequence, CharSequence>> FILTERS;
        private final StringBuilder[] sbs;

        FragmentBuilder(@NonNull ElementKind kind) {
            int size = FILTERS.size();
            this.sbs = new StringBuilder[size];
            for (int i = 0; i < this.sbs.length; ++i) {
                this.sbs[i] = new StringBuilder();
            }
        }

        @NonNull
        FragmentBuilder constructor(@NonNull CharSequence text) {
            for (int i = 0; i < this.sbs.length; ++i) {
                CharSequence constructor = i >= 2 ? "<init>" : text;
                this.sbs[i].append((CharSequence)FILTERS.get(i).convert((Object)constructor));
            }
            return this;
        }

        @NonNull
        FragmentBuilder append(@NonNull CharSequence text) {
            for (int i = 0; i < this.sbs.length; ++i) {
                this.sbs[i].append((CharSequence)FILTERS.get(i).convert((Object)text));
            }
            return this;
        }

        @NonNull
        Collection<? extends CharSequence> getFragments() {
            ArrayList<String> res = new ArrayList<String>(this.sbs.length);
            for (StringBuilder sb : this.sbs) {
                res.add(sb.toString());
            }
            return Collections.unmodifiableCollection(res);
        }

        static {
            ArrayList<Convertor> tmp = new ArrayList<Convertor>();
            tmp.add(Convertors.identity());
            tmp.add(new JDoc8025633());
            tmp.add(new JDoc8046068());
            FILTERS = Collections.unmodifiableList(tmp);
        }

        private static final class JDoc8025633
        implements Convertor<CharSequence, CharSequence> {
            private JDoc8025633() {
            }

            @NonNull
            public CharSequence convert(@NonNull CharSequence text) {
                StringBuilder sb = new StringBuilder();
                block7: for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    switch (c) {
                        case '(': 
                        case ')': 
                        case ',': 
                        case '<': 
                        case '>': {
                            sb.append('-');
                            continue block7;
                        }
                        case ' ': 
                        case '[': {
                            continue block7;
                        }
                        case ']': {
                            sb.append(":A");
                            continue block7;
                        }
                        case '$': {
                            if (i == 0) {
                                sb.append("Z:Z");
                            }
                            sb.append(":D");
                            continue block7;
                        }
                        case '_': {
                            if (i == 0) {
                                sb.append("Z:Z");
                            }
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
        }

        private static final class JDoc8046068
        implements Convertor<CharSequence, CharSequence> {
            private JDoc8046068() {
            }

            @NonNull
            public CharSequence convert(@NonNull CharSequence text) {
                return text.toString().replace(" ", "");
            }
        }
    }
}

