/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseLabelTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.GuardedPatternTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedPatternTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.guards.DocumentGuards;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.NoJavacHelper;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Pair;

public class Reformatter
implements ReformatTask {
    private static final Object CT_HANDLER_DOC_PROPERTY = "code-template-insert-handler";
    private Source source;
    private org.netbeans.modules.editor.indent.spi.Context context;
    private CompilationController controller;
    private Embedding currentEmbedding;
    private Document doc;

    public Reformatter(Source source, org.netbeans.modules.editor.indent.spi.Context context) {
        this.source = source;
        this.context = context;
        this.doc = context.document();
    }

    public void reformat() throws BadLocationException {
        CodeStyle cs = (CodeStyle)this.doc.getProperty(CodeStyle.class);
        if (cs == null) {
            cs = CodeStyle.getDefault(this.doc);
        }
        java.util.List indentRegions = this.context.indentRegions();
        Collections.reverse(indentRegions);
        for (Context.Region region : indentRegions) {
            if (!this.initRegionData(region)) continue;
            this.reformatImpl(region, cs);
        }
    }

    public static String reformat(String text, CodeStyle style) {
        return Reformatter.reformat(text, style, style.getRightMargin());
    }

    public static String reformat(String text, CodeStyle style, int rightMargin) {
        StringBuilder sb = new StringBuilder(text);
        ClassPath empty = ClassPathSupport.createClassPath((URL[])new URL[0]);
        ClasspathInfo cpInfo = ClasspathInfo.create(JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries(), empty, empty);
        JavacTaskImpl javacTask = JavacParser.createJavacTask(cpInfo, null, null, null, null, null, null, null, Arrays.asList(FileObjects.memoryFileObject("", "Scratch.java", text)));
        Context ctx = javacTask.getContext();
        JavaCompiler.instance((Context)ctx).genEndPos = true;
        CompilationUnitTree tree = javacTask.parse().iterator().next();
        DocSourcePositions sp = JavacTrees.instance(ctx).getSourcePositions();
        TokenSequence tokens = TokenHierarchy.create((CharSequence)text, (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
        for (Diff diff : Pretty.reformat(text, (TokenSequence<JavaTokenId>)tokens, new TreePath(tree), sp, style, rightMargin)) {
            int start = diff.getStartOffset();
            int end = diff.getEndOffset();
            sb.delete(start, end);
            String t = diff.getText();
            if (t == null || t.length() <= 0) continue;
            sb.insert(start, t);
        }
        return sb.toString();
    }

    private boolean initRegionData(final Context.Region region) {
        if (this.controller == null || this.currentEmbedding != null && (!this.currentEmbedding.containsOriginalOffset(region.getStartOffset()) || !this.currentEmbedding.containsOriginalOffset(region.getEndOffset()))) {
            try {
                if ("text/x-java".equals(this.context.mimePath())) {
                    this.controller = JavaSourceAccessor.getINSTANCE().createCompilationController(this.source, null);
                } else {
                    ParserManager.parse(Collections.singletonList(this.source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            Parser.Result result = this.findEmbeddedJava(resultIterator);
                            if (result != null) {
                                Reformatter.this.controller = CompilationController.get(result);
                            }
                        }

                        private Parser.Result findEmbeddedJava(ResultIterator theMess) throws ParseException {
                            LinkedList<Embedding> todo = new LinkedList<Embedding>();
                            for (Embedding embedding : theMess.getEmbeddings()) {
                                if ("text/x-java".equals(embedding.getMimeType()) && embedding.containsOriginalOffset(region.getStartOffset()) && embedding.containsOriginalOffset(region.getEndOffset())) {
                                    return theMess.getResultIterator(Reformatter.this.currentEmbedding = embedding).getParserResult();
                                }
                                todo.add(embedding);
                            }
                            for (Embedding embedding : todo) {
                                Parser.Result result = this.findEmbeddedJava(theMess.getResultIterator(embedding));
                                if (result == null) continue;
                                return result;
                            }
                            return null;
                        }
                    });
                }
                if (this.controller == null) {
                    return false;
                }
                this.controller.toPhase(JavaSource.Phase.PARSED);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private void reformatImpl(Context.Region region, CodeStyle cs) throws BadLocationException {
        boolean templateEdit = this.doc.getProperty(CT_HANDLER_DOC_PROPERTY) != null;
        int startOffset = region.getStartOffset();
        int endOffset = region.getEndOffset();
        startOffset = this.controller.getSnapshot().getEmbeddedOffset(startOffset);
        if (startOffset < 0) {
            return;
        }
        endOffset = this.controller.getSnapshot().getEmbeddedOffset(endOffset);
        if (endOffset < 0) {
            return;
        }
        int embeddingOffset = -1;
        int firstLineIndent = -1;
        if (!"text/x-java".equals(this.context.mimePath())) {
            firstLineIndent = this.context.lineIndent(this.context.lineStartOffset(region.getStartOffset()));
            TokenSequence ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            if (ts != null) {
                String t;
                ts.move(startOffset);
                if (ts.moveNext()) {
                    if (ts.token().id() == JavaTokenId.WHITESPACE) {
                        t = ts.token().text().toString();
                        if (ts.offset() < startOffset) {
                            t = t.substring(startOffset - ts.offset());
                        }
                        if (t.indexOf(10) < 0) {
                            embeddingOffset = ts.offset() + ts.token().length();
                        }
                    } else {
                        embeddingOffset = startOffset;
                    }
                }
                ts.move(endOffset);
                if (ts.moveNext() && ts.token().id() == JavaTokenId.WHITESPACE) {
                    int i;
                    t = ts.token().text().toString();
                    if (ts.offset() + t.length() > endOffset) {
                        t = t.substring(0, endOffset - ts.offset());
                    }
                    if ((i = t.lastIndexOf(10)) >= 0) {
                        endOffset -= t.length() - i;
                    }
                }
            }
        }
        if (startOffset >= endOffset) {
            return;
        }
        TreePath path = this.getCommonPath(startOffset, endOffset);
        if (path == null) {
            return;
        }
        DocumentGuards guards = (DocumentGuards)LineDocumentUtils.as((Document)this.doc, DocumentGuards.class);
        for (Diff diff : Pretty.reformat(this.controller, path, cs, startOffset, endOffset, templateEdit, firstLineIndent)) {
            int idx2;
            int idx1;
            int idx;
            String t;
            TokenSequence ts;
            int start = diff.getStartOffset();
            int end = diff.getEndOffset();
            String text = diff.getText();
            if (startOffset > end || endOffset < start || endOffset == start && endOffset < this.doc.getLength() && (text == null || !text.trim().equals("}")) || embeddingOffset >= start || guards != null && guards.isPositionGuarded(start, false)) continue;
            if (startOffset >= start) {
                if (text != null && text.length() > 0) {
                    ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    if (ts == null || (ts.move(startOffset) != 0 ? !ts.moveNext() && !ts.movePrevious() : !ts.movePrevious() && !ts.moveNext())) continue;
                    if (ts.token().id() == JavaTokenId.WHITESPACE) {
                        t = ts.token().text().toString();
                        t = t.substring(0, startOffset - ts.offset());
                        if (ts.movePrevious() && ts.token().id() == JavaTokenId.LINE_COMMENT) {
                            t = "\n" + t;
                        }
                        if (templateEdit) {
                            idx = t.lastIndexOf(10);
                            if (idx >= 0) {
                                t = t.substring(idx + 1);
                                idx = text.lastIndexOf(10);
                                if (idx >= 0) {
                                    text = text.substring(idx + 1);
                                }
                                text = text.trim().length() > 0 ? null : (text.length() > t.length() ? text.substring(t.length()) : null);
                            } else {
                                text = null;
                            }
                        } else {
                            idx1 = 0;
                            idx2 = 0;
                            int lastIdx1 = 0;
                            int lastIdx2 = 0;
                            while ((idx1 = t.indexOf(10, lastIdx1)) >= 0 && (idx2 = text.indexOf(10, lastIdx2)) >= 0) {
                                lastIdx1 = idx1 + 1;
                                lastIdx2 = idx2 + 1;
                            }
                            idx2 = text.lastIndexOf(10);
                            if (idx2 >= 0 && idx2 >= lastIdx2) {
                                if (lastIdx1 == 0) {
                                    t = null;
                                } else {
                                    text = text.substring(idx2 + 1);
                                    t = t.substring(lastIdx1);
                                }
                            } else {
                                idx1 = t.lastIndexOf(10);
                                if (idx1 >= 0 && idx1 >= lastIdx1) {
                                    t = t.substring(idx1 + 1);
                                    text = text.substring(lastIdx2);
                                } else {
                                    t = t.substring(lastIdx1);
                                    text = text.substring(lastIdx2);
                                }
                            }
                            if (text != null && t != null) {
                                text = text.length() > t.length() ? text.substring(t.length()) : null;
                            }
                        }
                    } else if (startOffset > 0) continue;
                }
                start = startOffset;
            }
            if (endOffset < end) {
                if (text != null && text.length() > 0 && !templateEdit && (ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language())) != null) {
                    ts.move(endOffset);
                    t = null;
                    if (ts.moveNext()) {
                        switch ((JavaTokenId)ts.token().id()) {
                            case WHITESPACE: {
                                t = ts.token().text().toString();
                                t = t.substring(endOffset - ts.offset());
                                break;
                            }
                            case JAVADOC_COMMENT: 
                            case BLOCK_COMMENT: {
                                t = ts.token().text().toString();
                                for (idx = endOffset - ts.offset(); idx < t.length() && t.charAt(idx) <= ' '; ++idx) {
                                }
                                t = t.substring(endOffset - ts.offset(), idx);
                            }
                        }
                    }
                    if (t != null) {
                        while ((idx1 = t.lastIndexOf(10)) >= 0 && (idx2 = text.lastIndexOf(10)) >= 0) {
                            t = t.substring(0, idx1);
                            text = text.substring(0, idx2);
                        }
                        text = text.length() > t.length() ? text.substring(0, text.length() - t.length()) : null;
                    }
                }
                end = endOffset;
            }
            start = this.controller.getSnapshot().getOriginalOffset(start);
            end = this.controller.getSnapshot().getOriginalOffset(end);
            if (start == -1 || end == -1 || start < region.getStartOffset() || end > region.getEndOffset()) continue;
            if (end - start > 0) {
                this.doc.remove(start, end - start);
            }
            if (text == null || text.length() <= 0) continue;
            this.doc.insertString(start, text, null);
        }
    }

    public ExtraLock reformatLock() {
        return "text/x-java".equals(this.source.getMimeType()) ? null : new ExtraLock(){

            public void lock() {
                Utilities.acquireParserLock();
            }

            public void unlock() {
                Utilities.releaseParserLock();
            }
        };
    }

    private TreePath getCommonPath(int startOffset, int endOffset) {
        TreeUtilities tu = this.controller.getTreeUtilities();
        TreePath startPath = tu.pathFor(startOffset);
        List<Tree> reverseStartPath = List.nil();
        for (Tree t : startPath) {
            reverseStartPath = reverseStartPath.prepend(t);
        }
        TreePath endPath = tu.pathFor(endOffset);
        List<Tree> reverseEndPath = List.nil();
        for (Tree t : endPath) {
            reverseEndPath = reverseEndPath.prepend(t);
        }
        TreePath path = null;
        TreePath statementPath = null;
        while (reverseStartPath.head != null && reverseStartPath.head == reverseEndPath.head) {
            TreePath treePath = path = reverseStartPath.head instanceof CompilationUnitTree ? new TreePath((CompilationUnitTree)reverseStartPath.head) : new TreePath(path, (Tree)reverseStartPath.head);
            if (reverseStartPath.head instanceof StatementTree) {
                statementPath = path;
            }
            reverseStartPath = reverseStartPath.tail;
            reverseEndPath = reverseEndPath.tail;
        }
        return statementPath != null ? statementPath : path;
    }

    private static class Diff {
        private int start;
        private int end;
        private String text;

        private Diff(int start, int end, String text) {
            this.start = start;
            this.end = end;
            this.text = text;
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Diff<" + this.start + "," + this.end + ">:" + this.text;
        }
    }

    private static class Pretty
    extends ErrorAwareTreePathScanner<Boolean, Void> {
        private static final String OPERATOR = "operator";
        private static final String EMPTY = "";
        private static final String SPACE = " ";
        private static final String NEWLINE = "\n";
        private static final String LEADING_STAR = "*";
        private static final String P_TAG = "<p>";
        private static final String END_P_TAG = "<p/>";
        private static final String CODE_TAG = "<code>";
        private static final String CODE_END_TAG = "</code>";
        private static final String PRE_TAG = "<pre>";
        private static final String PRE_END_TAG = "</pre>";
        private static final String JDOC_CODE_TAG = "@code";
        private static final String JDOC_DOCROOT_TAG = "@docRoot";
        private static final String JDOC_EXCEPTION_TAG = "@exception";
        private static final String JDOC_INHERITDOC_TAG = "@inheritDoc";
        private static final String JDOC_LINK_TAG = "@link";
        private static final String JDOC_LINKPLAIN_TAG = "@linkplain";
        private static final String JDOC_LITERAL_TAG = "@literal";
        private static final String JDOC_PARAM_TAG = "@param";
        private static final String JDOC_RETURN_TAG = "@return";
        private static final String JDOC_THROWS_TAG = "@throws";
        private static final String JDOC_VALUE_TAG = "@value";
        private static final String JDOC_SNIPPET_TAG = "@snippet";
        private static final String ERROR = "<error>";
        private final String fText;
        private final SourcePositions sp;
        private final CodeStyle cs;
        private final int rightMargin;
        private final int tabSize;
        private final int indentSize;
        private final int continuationIndentSize;
        private final boolean expandTabToSpaces;
        private TokenSequence<JavaTokenId> tokens;
        private int indent;
        private boolean continuationIndent;
        private int col;
        private int endPos;
        private int maxPreservedBlankLines;
        private int lastBlankLines;
        private int lastBlankLinesTokenIndex;
        private Diff lastBlankLinesDiff;
        private int lastNewLineOffset;
        private boolean afterAnnotation;
        private boolean wrapAnnotation;
        private WrapAbort checkWrap;
        private boolean fieldGroup;
        private boolean templateEdit;
        private final LinkedList<Diff> diffs = new LinkedList();
        private DanglingElseChecker danglingElseChecker = new DanglingElseChecker();
        private CompilationUnitTree root;
        private int startOffset;
        private int endOffset;
        private int tpLevel;
        private boolean eof = false;
        private boolean bof = false;
        private boolean insideAnnotation = false;
        private int lastIndent = 0;
        private boolean isLastIndentContinuation = false;

        private Pretty(CompilationInfo info, TreePath path, CodeStyle cs, int startOffset, int endOffset, boolean templateEdit) {
            this(info.getText(), (TokenSequence<JavaTokenId>)info.getTokenHierarchy().tokenSequence(JavaTokenId.language()), path, info.getTrees().getSourcePositions(), cs, startOffset, endOffset, cs.getRightMargin());
            this.templateEdit = templateEdit;
        }

        private Pretty(String text, TokenSequence<JavaTokenId> tokens, TreePath path, SourcePositions sp, CodeStyle cs, int startOffset, int endOffset, int rightMargin) {
            this.fText = text;
            this.sp = sp;
            this.cs = cs;
            this.rightMargin = rightMargin > 0 ? rightMargin : Integer.MAX_VALUE;
            this.tabSize = cs.getTabSize();
            this.indentSize = cs.getIndentSize();
            this.continuationIndentSize = cs.getContinuationIndentSize();
            this.expandTabToSpaces = cs.expandTabToSpaces();
            this.maxPreservedBlankLines = this.insideBlock(path) ? cs.getMaximumBlankLinesInCode() : cs.getMaximumBlankLinesInDeclarations();
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            this.lastNewLineOffset = -1;
            this.afterAnnotation = false;
            this.wrapAnnotation = false;
            this.fieldGroup = false;
            Tree tree = path.getLeaf();
            this.lastIndent = tokens != null ? this.getIndentLevel(tokens, path) : 0;
            this.col = this.indent = this.lastIndent;
            this.tokens = tokens;
            if (tree.getKind() == Tree.Kind.COMPILATION_UNIT) {
                tokens.moveEnd();
                tokens.movePrevious();
            } else {
                tokens.move((int)sp.getEndPosition(path.getCompilationUnit(), tree));
                if (!tokens.moveNext()) {
                    tokens.movePrevious();
                }
            }
            this.endPos = tokens.offset();
            if (tree.getKind() == Tree.Kind.COMPILATION_UNIT) {
                tokens.moveStart();
                this.bof = true;
            } else {
                tokens.move((int)sp.getStartPosition(path.getCompilationUnit(), tree));
            }
            tokens.moveNext();
            this.root = path.getCompilationUnit();
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.tpLevel = 0;
        }

        public static LinkedList<Diff> reformat(CompilationInfo info, TreePath path, CodeStyle cs, int startOffset, int endOffset, boolean templateEdit, int firstLineIndent) {
            Pretty pretty = new Pretty(info, path, cs, startOffset, endOffset, templateEdit);
            if (pretty.indent >= 0) {
                if (firstLineIndent >= 0) {
                    pretty.indent = pretty.lastIndent = firstLineIndent;
                }
                pretty.scan(path, null);
            }
            if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                int cnt;
                CompilationUnitTree cut = (CompilationUnitTree)path.getLeaf();
                java.util.List<? extends Tree> typeDecls = cut.getTypeDecls();
                int size = typeDecls.size();
                int n = cnt = size > 0 && TreeUtilities.CLASS_TREE_KINDS.contains((Object)typeDecls.get(size - 1).getKind()) ? cs.getBlankLinesAfterClass() : 1;
                if (cnt < 1) {
                    cnt = 1;
                }
                String s = pretty.getNewlines(cnt);
                pretty.tokens.moveEnd();
                pretty.tokens.movePrevious();
                if (pretty.tokens.token().id() != JavaTokenId.WHITESPACE) {
                    if (!pretty.tokens.token().text().toString().endsWith(s)) {
                        String text = info.getText();
                        pretty.diffs.addFirst(new Diff(text.length(), text.length(), s));
                    }
                } else if (!s.contentEquals(pretty.tokens.token().text())) {
                    pretty.diffs.addFirst(new Diff(pretty.tokens.offset(), pretty.tokens.offset() + pretty.tokens.token().length(), s));
                }
            }
            return pretty.diffs;
        }

        public static LinkedList<Diff> reformat(String text, TokenSequence<JavaTokenId> tokens, TreePath path, SourcePositions sp, CodeStyle cs, int rightMargin) {
            int cnt;
            Pretty pretty = new Pretty(text, tokens, path, sp, cs, 0, text.length(), rightMargin);
            pretty.scan(path, null);
            CompilationUnitTree cut = (CompilationUnitTree)path.getLeaf();
            java.util.List<? extends Tree> typeDecls = cut.getTypeDecls();
            int size = typeDecls.size();
            int n = cnt = size > 0 && TreeUtilities.CLASS_TREE_KINDS.contains((Object)typeDecls.get(size - 1).getKind()) ? cs.getBlankLinesAfterClass() : 1;
            if (cnt < 1) {
                cnt = 1;
            }
            String s = pretty.getNewlines(cnt);
            tokens.moveEnd();
            tokens.movePrevious();
            if (tokens.token().id() != JavaTokenId.WHITESPACE) {
                pretty.diffs.addFirst(new Diff(text.length(), text.length(), s));
            } else if (!s.contentEquals(tokens.token().text())) {
                pretty.diffs.addFirst(new Diff(tokens.offset(), tokens.offset() + tokens.token().length(), s));
            }
            return pretty.diffs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean scan(Tree tree, Void p) {
            int lastEndPos = this.endPos;
            if (tree != null && tree.getKind() != Tree.Kind.COMPILATION_UNIT) {
                this.endPos = tree instanceof FakeBlock ? Integer.MAX_VALUE : (int)this.sp.getEndPosition(this.getCurrentPath().getCompilationUnit(), tree);
                if (tree.getKind() != Tree.Kind.ERRONEOUS && tree.getKind() != Tree.Kind.BLOCK && (tree.getKind() != Tree.Kind.CLASS || this.getCurrentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) && tree.getKind() != Tree.Kind.NEW_ARRAY) {
                    int startPos = (int)this.sp.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree);
                    if (startPos >= 0 && startPos > this.tokens.offset()) {
                        this.tokens.move(startPos);
                        if (!this.tokens.moveNext()) {
                            this.tokens.movePrevious();
                        }
                    }
                    if (startPos >= this.endPos) {
                        this.endPos = -1;
                    }
                }
            }
            try {
                if (this.endPos < 0) {
                    Boolean startPos = false;
                    return startPos;
                }
                if (this.tokens.offset() > this.endPos) {
                    Boolean startPos = true;
                    return startPos;
                }
                Boolean ret = (Boolean)super.scan(tree, p);
                Boolean bl = ret != null ? ret : true;
                return bl;
            }
            finally {
                this.endPos = lastEndPos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitCompilationUnit(CompilationUnitTree node, Void p) {
            java.util.List<? extends ImportTree> imports;
            ExpressionTree pkg = node.getPackageName();
            if (pkg != null) {
                this.blankLines(this.cs.getBlankLinesBeforePackage());
                if (!node.getPackageAnnotations().isEmpty()) {
                    this.wrapList(this.cs.wrapAnnotations(), false, false, JavaTokenId.COMMA, node.getPackageAnnotations());
                    this.newline();
                }
                this.accept(JavaTokenId.PACKAGE, new JavaTokenId[0]);
                boolean old = this.continuationIndent;
                try {
                    this.continuationIndent = true;
                    this.space();
                    this.scan((Tree)pkg, p);
                    this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
                }
                finally {
                    this.continuationIndent = old;
                }
                this.blankLines(this.cs.getBlankLinesAfterPackage());
            }
            if ((imports = node.getImports()) != null && !imports.isEmpty()) {
                this.blankLines(this.cs.getBlankLinesBeforeImports());
                for (ImportTree importTree : imports) {
                    this.newline();
                    this.scan((Tree)importTree, p);
                }
                this.blankLines(this.cs.getBlankLinesAfterImports());
            }
            boolean semiRead = false;
            for (Tree tree : node.getTypeDecls()) {
                Diff d;
                if (semiRead && tree.getKind() == Tree.Kind.EMPTY_STATEMENT) continue;
                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                    this.blankLines(this.cs.getBlankLinesBeforeClass());
                }
                this.scan(tree, p);
                int index = this.tokens.index();
                int c = this.col;
                Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) == JavaTokenId.SEMICOLON) {
                    semiRead = true;
                } else {
                    this.rollback(index, c, d);
                    semiRead = false;
                }
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                this.blankLines(this.cs.getBlankLinesAfterClass());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitModule(ModuleTree node, Void p) {
            Diff diff;
            if (node.getModuleType() == ModuleTree.ModuleKind.OPEN) {
                this.accept(JavaTokenId.OPEN, new JavaTokenId[0]);
                this.space();
            }
            this.accept(JavaTokenId.MODULE, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.space();
                this.scan((Tree)node.getName(), p);
            }
            finally {
                this.continuationIndent = old;
            }
            CodeStyle.BracePlacement bracePlacement = this.cs.getModuleDeclBracePlacement();
            boolean spaceBeforeLeftBrace = this.cs.spaceBeforeModuleDeclLeftBrace();
            int oldIndent = this.indent = this.lastIndent;
            int halfIndent = this.lastIndent;
            switch (bracePlacement) {
                case SAME_LINE: {
                    this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE: {
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE_HALF_INDENTED: {
                    int oldLast = this.lastIndent;
                    halfIndent = this.indent = this.lastIndent + (this.indentSize >> 1);
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = oldLast + this.indentSize;
                    break;
                }
                case NEW_LINE_INDENTED: {
                    halfIndent = this.indent = this.lastIndent + this.indentSize;
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                }
            }
            if (node.getDirectives().isEmpty()) {
                this.newline();
            } else {
                if (!this.cs.indentTopLevelClassMembers()) {
                    this.indent = oldIndent;
                }
                this.blankLines(this.cs.getBlankLinesAfterModuleHeader());
                boolean first = true;
                for (Tree tree : node.getDirectives()) {
                    if (!first) {
                        this.blankLines(this.cs.getBlankLinesBeforeModuleDirectives());
                    }
                    this.scan(tree, p);
                    this.blankLines(this.cs.getBlankLinesAfterModuleDirectives());
                }
                if (this.lastBlankLinesTokenIndex < 0) {
                    this.newline();
                }
                this.blankLines(this.cs.getBlankLinesBeforeModuleClosingBrace());
            }
            this.indent = halfIndent;
            Diff diff2 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            if (diff != null && diff.end == this.tokens.offset()) {
                String spaces;
                if (diff.text != null) {
                    int idx = diff.text.lastIndexOf(10);
                    if (idx < 0) {
                        diff.text = this.getIndent();
                    } else {
                        diff.text = diff.text.substring(0, idx + 1) + this.getIndent();
                    }
                }
                String string = spaces = diff.text != null ? diff.text : this.getIndent();
                if (spaces.equals(this.fText.substring(diff.start, diff.end))) {
                    this.diffs.removeFirst();
                }
            } else if (this.tokens.movePrevious()) {
                if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                    String text = this.tokens.token().text().toString();
                    int n = text.lastIndexOf(10);
                    if (n >= 0) {
                        text = text.substring(n + 1);
                        String ind = this.getIndent();
                        if (!ind.equals(text)) {
                            this.addDiff(new Diff(this.tokens.offset() + n + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                        }
                    } else if (this.tokens.movePrevious()) {
                        if (this.tokens.token().id() == JavaTokenId.LINE_COMMENT) {
                            this.tokens.moveNext();
                            String ind = this.getIndent();
                            if (!ind.equals(text)) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset() + this.tokens.token().length(), ind));
                            }
                        } else {
                            this.tokens.moveNext();
                        }
                    }
                }
                this.tokens.moveNext();
            }
            this.col = this.indent();
            this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
            this.indent = this.lastIndent = oldIndent;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitExports(ExportsTree node, Void p) {
            this.accept(JavaTokenId.EXPORTS, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.space();
                this.scan((Tree)node.getPackageName(), p);
                if (node.getModuleNames() != null) {
                    this.wrapToken(this.cs.wrapExportsToKeyword(), 1, JavaTokenId.TO, new JavaTokenId[0]);
                    this.wrapList(this.cs.wrapExportsToList(), this.cs.alignMultilineExports(), true, JavaTokenId.COMMA, node.getModuleNames());
                }
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitOpens(OpensTree node, Void p) {
            this.accept(JavaTokenId.OPENS, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.space();
                this.scan((Tree)node.getPackageName(), p);
                if (node.getModuleNames() != null) {
                    this.wrapToken(this.cs.wrapOpensToKeyword(), 1, JavaTokenId.TO, new JavaTokenId[0]);
                    this.wrapList(this.cs.wrapOpensToList(), this.cs.alignMultilineOpens(), true, JavaTokenId.COMMA, node.getModuleNames());
                }
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitProvides(ProvidesTree node, Void p) {
            this.accept(JavaTokenId.PROVIDES, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.space();
                this.scan((Tree)node.getServiceName(), p);
                if (node.getImplementationNames() != null) {
                    this.wrapToken(this.cs.wrapProvidesWithKeyword(), 1, JavaTokenId.WITH, new JavaTokenId[0]);
                    this.wrapList(this.cs.wrapProvidesWithList(), this.cs.alignMultilineProvides(), true, JavaTokenId.COMMA, node.getImplementationNames());
                }
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitRequires(RequiresTree node, Void p) {
            this.accept(JavaTokenId.REQUIRES, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.space();
                if (node.isStatic() || node.isTransitive()) {
                    JavaTokenId id = this.accept(JavaTokenId.STATIC, JavaTokenId.TRANSITIVE);
                    this.space();
                    switch (id) {
                        case STATIC: {
                            if (!node.isTransitive()) break;
                            this.accept(JavaTokenId.TRANSITIVE, new JavaTokenId[0]);
                            this.space();
                            break;
                        }
                        case TRANSITIVE: {
                            if (!node.isStatic()) break;
                            this.accept(JavaTokenId.STATIC, new JavaTokenId[0]);
                            this.space();
                        }
                    }
                }
                this.scan((Tree)node.getModuleName(), p);
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitUses(UsesTree node, Void p) {
            this.accept(JavaTokenId.USES, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.space();
                this.scan((Tree)node.getServiceName(), p);
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitImport(ImportTree node, Void p) {
            this.accept(JavaTokenId.IMPORT, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.space();
                if (node.isStatic()) {
                    this.accept(JavaTokenId.STATIC, new JavaTokenId[0]);
                    this.space();
                }
                this.scan(node.getQualifiedIdentifier(), p);
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitClass(ClassTree node, Void p) {
            Diff diff;
            if (node.getKind() == Tree.Kind.RECORD) {
                return this.scanRecord(node, p);
            }
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (!(parent.getKind() == Tree.Kind.NEW_CLASS || parent.getKind() == Tree.Kind.VARIABLE && this.isEnumerator((VariableTree)parent))) {
                boolean old = this.continuationIndent;
                try {
                    Object perms;
                    java.util.List<? extends Tree> impls;
                    Tree ext;
                    java.util.List<? extends TypeParameterTree> tparams;
                    ModifiersTree mods = node.getModifiers();
                    if (mods != null) {
                        if (this.scan((Tree)mods, p).booleanValue()) {
                            this.continuationIndent = true;
                            if (this.cs.placeNewLineAfterModifiers()) {
                                this.newline();
                            } else {
                                this.space();
                            }
                        } else if (this.afterAnnotation) {
                            this.newline();
                        }
                        this.afterAnnotation = false;
                    }
                    JavaTokenId id = this.accept(JavaTokenId.CLASS, JavaTokenId.INTERFACE, JavaTokenId.ENUM, JavaTokenId.AT);
                    this.continuationIndent = true;
                    if (id == JavaTokenId.AT) {
                        this.accept(JavaTokenId.INTERFACE, new JavaTokenId[0]);
                    }
                    this.space();
                    if (!ERROR.contentEquals(node.getSimpleName())) {
                        this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
                    }
                    if ((tparams = node.getTypeParameters()) != null && !tparams.isEmpty()) {
                        JavaTokenId accepted;
                        if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                            ++this.tpLevel;
                        }
                        Iterator<? extends TypeParameterTree> it = tparams.iterator();
                        while (it.hasNext()) {
                            TypeParameterTree tparam = it.next();
                            this.scan((Tree)tparam, p);
                            if (!it.hasNext()) continue;
                            this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                            this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                            this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                        }
                        if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                            switch (accepted) {
                                case GTGTGT: {
                                    this.tpLevel -= 3;
                                    break;
                                }
                                case GTGT: {
                                    this.tpLevel -= 2;
                                    break;
                                }
                                case GT: {
                                    --this.tpLevel;
                                }
                            }
                        }
                    }
                    if ((ext = node.getExtendsClause()) != null) {
                        this.wrapToken(this.cs.wrapExtendsImplementsKeyword(), 1, JavaTokenId.EXTENDS, new JavaTokenId[0]);
                        this.spaces(1, true);
                        this.scan(ext, p);
                    }
                    if ((impls = node.getImplementsClause()) != null && !impls.isEmpty()) {
                        this.wrapToken(this.cs.wrapExtendsImplementsKeyword(), 1, id == JavaTokenId.INTERFACE ? JavaTokenId.EXTENDS : JavaTokenId.IMPLEMENTS, new JavaTokenId[0]);
                        this.wrapList(this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements(), true, JavaTokenId.COMMA, impls);
                    }
                    if ((perms = node.getPermitsClause()) != null && !perms.isEmpty()) {
                        this.wrapToken(this.cs.wrapExtendsImplementsKeyword(), 1, JavaTokenId.EXTENDS, new JavaTokenId[0]);
                        this.wrapList(this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements(), true, JavaTokenId.COMMA, (java.util.List<? extends Tree>)perms);
                    }
                }
                finally {
                    this.continuationIndent = old;
                }
            }
            CodeStyle.BracePlacement bracePlacement = this.cs.getClassDeclBracePlacement();
            boolean spaceBeforeLeftBrace = this.cs.spaceBeforeClassDeclLeftBrace();
            int old = this.indent = this.lastIndent;
            int halfIndent = this.lastIndent;
            switch (bracePlacement) {
                case SAME_LINE: {
                    this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE: {
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE_HALF_INDENTED: {
                    int oldLast = this.lastIndent;
                    halfIndent = this.indent = this.lastIndent + (this.indentSize >> 1);
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = oldLast + this.indentSize;
                    break;
                }
                case NEW_LINE_INDENTED: {
                    halfIndent = this.indent = this.lastIndent + this.indentSize;
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                }
            }
            int lastMaxPreservedBlankLines = this.maxPreservedBlankLines;
            this.maxPreservedBlankLines = this.cs.getMaximumBlankLinesInDeclarations();
            boolean emptyClass = true;
            for (Tree tree : node.getMembers()) {
                if (this.isSynthetic(this.getCurrentPath().getCompilationUnit(), tree)) continue;
                emptyClass = false;
                break;
            }
            if (emptyClass) {
                this.newline();
            } else {
                if (!this.cs.indentTopLevelClassMembers()) {
                    this.indent = old;
                }
                this.blankLines(node.getSimpleName().length() == 0 ? this.cs.getBlankLinesAfterAnonymousClassHeader() : (node.getKind() == Tree.Kind.ENUM ? this.cs.getBlankLinesAfterEnumHeader() : this.cs.getBlankLinesAfterClassHeader()));
                JavaTokenId id = null;
                boolean bl = true;
                boolean semiRead = false;
                block23: for (Tree tree : node.getMembers()) {
                    boolean bl2;
                    if (this.isSynthetic(this.getCurrentPath().getCompilationUnit(), tree)) continue;
                    switch (tree.getKind()) {
                        case VARIABLE: {
                            Diff d;
                            int c;
                            int index;
                            if (this.isEnumerator((VariableTree)tree)) {
                                this.wrapTree(this.cs.wrapEnumConstants(), -1, id == JavaTokenId.COMMA ? 1 : 0, tree);
                                index = this.tokens.index();
                                c = this.col;
                                d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                id = this.accept(JavaTokenId.COMMA, JavaTokenId.SEMICOLON);
                                if (id == JavaTokenId.COMMA) {
                                    index = this.tokens.index();
                                    c = this.col;
                                    Diff diff2 = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                    if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) != null) break;
                                    this.rollback(index, c, d);
                                    break;
                                }
                                if (id == JavaTokenId.SEMICOLON) {
                                    this.blankLines(this.cs.getBlankLinesAfterFields());
                                    break;
                                }
                                this.rollback(index, c, d);
                                this.blankLines(this.cs.getBlankLinesAfterFields());
                                break;
                            }
                            boolean b = this.tokens.moveNext();
                            if (!b) break;
                            this.tokens.movePrevious();
                            if (!this.fieldGroup && !bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeFields());
                            }
                            this.scan(tree, p);
                            if (this.fieldGroup) break;
                            this.blankLines(this.cs.getBlankLinesAfterFields());
                            break;
                        }
                        case METHOD: {
                            if (!bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeMethods());
                            }
                            this.scan(tree, p);
                            this.blankLines(this.cs.getBlankLinesAfterMethods());
                            break;
                        }
                        case BLOCK: {
                            Diff d;
                            int c;
                            int index;
                            if (semiRead && !((BlockTree)tree).isStatic() && ((BlockTree)tree).getStatements().isEmpty()) {
                                semiRead = false;
                                continue block23;
                            }
                            if (!bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeMethods());
                                index = this.tokens.index();
                                c = this.col;
                                Diff diff3 = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) == JavaTokenId.SEMICOLON) continue block23;
                                this.rollback(index, c, d);
                            }
                            this.scan(tree, p);
                            this.blankLines(this.cs.getBlankLinesAfterMethods());
                            break;
                        }
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            Diff d;
                            if (!bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeClass());
                            }
                            this.scan(tree, p);
                            int index = this.tokens.index();
                            int c = this.col;
                            Diff diff4 = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                            if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) == JavaTokenId.SEMICOLON) {
                                semiRead = true;
                            } else {
                                this.rollback(index, c, d);
                                semiRead = false;
                            }
                            this.blankLines(this.cs.getBlankLinesAfterClass());
                            break;
                        }
                        case RECORD: {
                            if (!bl2) {
                                this.blankLines(this.cs.getBlankLinesBeforeMethods());
                            }
                            this.scanRecord((ClassTree)tree, p);
                            this.blankLines(this.cs.getBlankLinesAfterMethods());
                        }
                    }
                    bl2 = false;
                }
                if (this.lastBlankLinesTokenIndex < 0) {
                    this.newline();
                }
                this.blankLines(node.getSimpleName().length() == 0 ? this.cs.getBlankLinesBeforeAnonymousClassClosingBrace() : (node.getKind() == Tree.Kind.ENUM ? this.cs.getBlankLinesBeforeEnumClosingBrace() : this.cs.getBlankLinesBeforeClassClosingBrace()));
            }
            this.indent = halfIndent;
            Diff diff5 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            if (diff != null && diff.end == this.tokens.offset()) {
                String string;
                if (diff.text != null) {
                    int n = diff.text.lastIndexOf(10);
                    if (n < 0) {
                        diff.text = this.getIndent();
                    } else {
                        diff.text = diff.text.substring(0, n + 1) + this.getIndent();
                    }
                }
                String string2 = string = diff.text != null ? diff.text : this.getIndent();
                if (string.equals(this.fText.substring(diff.start, diff.end))) {
                    this.diffs.removeFirst();
                }
            } else if (this.tokens.movePrevious()) {
                if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                    String ind;
                    String string = this.tokens.token().text().toString();
                    int idx = string.lastIndexOf(10);
                    if (idx >= 0) {
                        String string3 = string.substring(idx + 1);
                        ind = this.getIndent();
                        if (!ind.equals(string3)) {
                            this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                        }
                    } else if (this.tokens.movePrevious()) {
                        if (this.tokens.token().id() == JavaTokenId.LINE_COMMENT) {
                            this.tokens.moveNext();
                            ind = this.getIndent();
                            if (!ind.equals(string)) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset() + this.tokens.token().length(), ind));
                            }
                        } else {
                            this.tokens.moveNext();
                        }
                    }
                }
                this.tokens.moveNext();
            }
            this.col = this.indent();
            this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
            this.maxPreservedBlankLines = lastMaxPreservedBlankLines;
            this.indent = this.lastIndent = old;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitVariable(VariableTree node, Void p) {
            block46: {
                boolean old = this.continuationIndent;
                try {
                    ExpressionTree init;
                    Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                    boolean insideForTryOrCatch = EnumSet.of(Tree.Kind.FOR_LOOP, Tree.Kind.TRY, Tree.Kind.CATCH).contains((Object)parent.getKind());
                    ModifiersTree mods = node.getModifiers();
                    if (mods != null && !this.fieldGroup && this.sp.getStartPosition(this.root, mods) < this.sp.getEndPosition(this.root, mods)) {
                        if (this.scan((Tree)mods, p).booleanValue()) {
                            if (!insideForTryOrCatch) {
                                this.continuationIndent = true;
                                if (this.cs.placeNewLineAfterModifiers()) {
                                    this.newline();
                                } else {
                                    this.space();
                                }
                            } else {
                                this.space();
                            }
                        } else if (this.afterAnnotation) {
                            CodeStyle.WrapStyle newWrapStyle = this.cs.wrapAnnotations();
                            if (parent instanceof ClassTree) {
                                for (Tree tree : ((ClassTree)parent).getMembers()) {
                                    if (tree.getKind() != Tree.Kind.RECORD) continue;
                                    ClassTree cls = (ClassTree)tree;
                                    for (Tree tree2 : cls.getMembers()) {
                                        if (!tree2.equals(this.getCurrentPath().getLeaf())) continue;
                                        newWrapStyle = CodeStyle.WrapStyle.WRAP_NEVER;
                                    }
                                }
                            }
                            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) || parent.getKind() == Tree.Kind.BLOCK) {
                                switch (newWrapStyle) {
                                    case WRAP_ALWAYS: {
                                        this.newline();
                                        break;
                                    }
                                    case WRAP_IF_LONG: {
                                        if (this.col >= this.rightMargin) {
                                            this.newline();
                                            break;
                                        }
                                        this.spaces(1, true);
                                        break;
                                    }
                                    case WRAP_NEVER: {
                                        this.spaces(1, true);
                                    }
                                }
                            } else {
                                this.space();
                            }
                        }
                        this.afterAnnotation = false;
                    }
                    if (this.isEnumerator(node)) {
                        java.util.List<? extends ExpressionTree> args;
                        this.continuationIndent = true;
                        this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
                        init = node.getInitializer();
                        if (init == null || init.getKind() != Tree.Kind.NEW_CLASS) break block46;
                        NewClassTree nct = (NewClassTree)init;
                        int n = this.tokens.index();
                        int c = this.col;
                        Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                        this.spaces(this.cs.spaceBeforeMethodCallParen() ? 1 : 0);
                        JavaTokenId javaTokenId = this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                        if (javaTokenId != JavaTokenId.LPAREN) {
                            this.rollback(n, c, d);
                        }
                        if ((args = nct.getArguments()) != null && !args.isEmpty()) {
                            int oldIndent = this.indent;
                            int oldLastIndent = this.lastIndent;
                            boolean continuation = this.isLastIndentContinuation;
                            if (continuation) {
                                this.indent = this.indent();
                                this.isLastIndentContinuation = false;
                            }
                            try {
                                this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                                this.wrapList(this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs(), false, JavaTokenId.COMMA, args);
                            }
                            finally {
                                this.indent = oldIndent;
                                this.lastIndent = oldLastIndent;
                                this.continuationIndent = this.isLastIndentContinuation = continuation;
                            }
                            this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                        }
                        if (javaTokenId == JavaTokenId.LPAREN) {
                            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
                        }
                        this.continuationIndent = false;
                        ClassTree body = nct.getClassBody();
                        if (body != null) {
                            this.scan((Tree)body, p);
                        }
                        break block46;
                    }
                    if (!insideForTryOrCatch) {
                        this.continuationIndent = true;
                    }
                    if (node.getType() == null || this.tokens.token().id() == JavaTokenId.VAR || this.scan(node.getType(), p).booleanValue()) {
                        if (node.getType() != null && this.tokens.token().id() != JavaTokenId.VAR) {
                            this.spaces(1, this.fieldGroup);
                        } else if (this.tokens.token().id() == JavaTokenId.VAR) {
                            this.addDiff(new Diff(this.tokens.offset() + 3, this.tokens.offset() + 3, SPACE));
                            this.tokens.moveNext();
                        }
                        if (!ERROR.contentEquals(node.getName())) {
                            this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
                        }
                    }
                    if ((init = node.getInitializer()) != null) {
                        int alignIndent = -1;
                        if (this.cs.alignMultilineAssignment()) {
                            alignIndent = this.col;
                            if (!ERROR.contentEquals(node.getName())) {
                                alignIndent -= node.getName().length();
                            }
                        }
                        if (this.cs.wrapAfterAssignOps()) {
                            boolean bl = this.spaces(this.cs.spaceAroundAssignOps() ? 1 : 0, false);
                            if (this.accept(JavaTokenId.EQ, new JavaTokenId[0]) == JavaTokenId.EQ && bl) {
                                this.newline();
                            }
                            if (init.getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)init).getType() == null) {
                                if (this.cs.getOtherBracePlacement() == CodeStyle.BracePlacement.SAME_LINE) {
                                    this.spaces(this.cs.spaceAroundAssignOps() ? 1 : 0);
                                }
                                this.scan((Tree)init, p);
                            } else {
                                this.wrapTree(this.cs.wrapAssignOps(), alignIndent, !bl && this.cs.spaceAroundAssignOps() ? 1 : 0, init);
                            }
                        } else {
                            this.wrapOperatorAndTree(this.cs.wrapAssignOps(), alignIndent, this.cs.spaceAroundAssignOps() ? 1 : 0, init);
                        }
                    }
                    this.fieldGroup = this.accept(JavaTokenId.SEMICOLON, JavaTokenId.COMMA) == JavaTokenId.COMMA;
                }
                finally {
                    this.continuationIndent = old;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Boolean scanRecord(ClassTree node, Void p) {
            boolean old = this.continuationIndent;
            int oldIndent = this.indent;
            try {
                java.util.List<? extends TypeParameterTree> tparams;
                this.continuationIndent = true;
                ModifiersTree mods = node.getModifiers();
                if (mods != null) {
                    if (this.scan((Tree)mods, p).booleanValue()) {
                        if (this.cs.placeNewLineAfterModifiers()) {
                            this.newline();
                        } else {
                            this.space();
                        }
                    } else if (this.afterAnnotation) {
                        this.newline();
                    }
                    this.afterAnnotation = false;
                }
                this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
                this.space();
                if (!ERROR.contentEquals(node.getSimpleName())) {
                    this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
                }
                if ((tparams = node.getTypeParameters()) != null && !tparams.isEmpty()) {
                    JavaTokenId accepted;
                    if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                        ++this.tpLevel;
                    }
                    Iterator<? extends TypeParameterTree> it = tparams.iterator();
                    while (it.hasNext()) {
                        TypeParameterTree tparam = it.next();
                        this.scan((Tree)tparam, p);
                        if (!it.hasNext()) continue;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                        switch (accepted) {
                            case GTGTGT: {
                                this.tpLevel -= 3;
                                break;
                            }
                            case GTGT: {
                                this.tpLevel -= 2;
                                break;
                            }
                            case GT: {
                                --this.tpLevel;
                            }
                        }
                    }
                    this.spaces(0, true);
                }
                this.spaces(this.cs.spaceBeforeMethodDeclParen() ? 1 : 0);
                this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                java.util.List<? extends Tree> members = node.getMembers();
                ArrayList<Tree> recParams = new ArrayList<Tree>();
                for (Tree tree : members) {
                    ModifiersTree modifiers;
                    Set<Modifier> modifierSet;
                    if (tree.getKind() != Tree.Kind.VARIABLE || (modifierSet = (modifiers = ((VariableTree)tree).getModifiers()).getFlags()).contains((Object)Modifier.STATIC)) continue;
                    recParams.add(tree);
                }
                if (!recParams.isEmpty()) {
                    this.spaces(this.cs.spaceWithinMethodDeclParens() ? 1 : 0, true);
                    this.wrapList(this.cs.wrapMethodParams(), this.cs.alignMultilineMethodParams(), false, JavaTokenId.COMMA, recParams);
                }
                this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
                java.util.List<? extends Tree> impls = node.getImplementsClause();
                if (impls != null && !impls.isEmpty()) {
                    this.wrapToken(this.cs.wrapExtendsImplementsKeyword(), 1, JavaTokenId.IMPLEMENTS, new JavaTokenId[0]);
                    this.wrapList(this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements(), true, JavaTokenId.COMMA, impls);
                }
                int n = this.lastIndent;
                int lastMaxPreservedBlankLines = this.maxPreservedBlankLines;
                this.maxPreservedBlankLines = this.cs.getMaximumBlankLinesInDeclarations();
                this.classLeftBracePlacement();
                this.continuationIndent = old;
                try {
                    if (members != null && !members.isEmpty()) {
                        boolean isFirstMember = true;
                        this.blankLines(node.getSimpleName().length() == 0 ? 0 : this.cs.getBlankLinesAfterClassHeader());
                        for (Tree tree : members) {
                            if (recParams.contains(tree)) continue;
                            this.blankLines(0);
                            switch (tree.getKind()) {
                                case VARIABLE: {
                                    boolean b = this.tokens.moveNext();
                                    if (!b) break;
                                    this.tokens.movePrevious();
                                    if (!isFirstMember) {
                                        this.blankLines(this.cs.getBlankLinesBeforeFields());
                                    }
                                    this.scan(tree, p);
                                    this.blankLines(this.cs.getBlankLinesAfterFields());
                                    break;
                                }
                                default: {
                                    if (!isFirstMember) {
                                        this.blankLines(this.cs.getBlankLinesBeforeMethods());
                                    }
                                    this.scan(tree, p);
                                    this.blankLines(this.cs.getBlankLinesAfterMethods());
                                }
                            }
                            if (!isFirstMember) continue;
                            isFirstMember = false;
                        }
                        this.spaces(this.cs.spaceWithinMethodDeclParens() ? 1 : 0, true);
                    }
                }
                finally {
                    this.indent = oldIndent;
                    this.lastIndent = n;
                    this.continuationIndent = old;
                    this.maxPreservedBlankLines = lastMaxPreservedBlankLines;
                }
                this.newline();
                this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        private void classLeftBracePlacement() {
            CodeStyle.BracePlacement bracePlacement = this.cs.getClassDeclBracePlacement();
            boolean spaceBeforeLeftBrace = this.cs.spaceBeforeClassDeclLeftBrace();
            int old = this.indent = this.lastIndent;
            int halfIndent = this.lastIndent;
            switch (bracePlacement) {
                case SAME_LINE: {
                    this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE: {
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE_HALF_INDENTED: {
                    int oldLast = this.lastIndent;
                    halfIndent = this.indent = this.lastIndent + (this.indentSize >> 1);
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = oldLast + this.indentSize;
                    break;
                }
                case NEW_LINE_INDENTED: {
                    halfIndent = this.indent = this.lastIndent + this.indentSize;
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitMethod(MethodTree node, Void p) {
            boolean old = this.continuationIndent;
            try {
                Tree init;
                Tree retType;
                java.util.List<? extends TypeParameterTree> tparams;
                ModifiersTree mods = node.getModifiers();
                if (mods != null) {
                    if (this.scan((Tree)mods, p).booleanValue()) {
                        this.continuationIndent = true;
                        if (this.cs.placeNewLineAfterModifiers()) {
                            this.newline();
                        } else {
                            this.space();
                        }
                    } else {
                        this.newline();
                    }
                    this.afterAnnotation = false;
                }
                if ((tparams = node.getTypeParameters()) != null && !tparams.isEmpty()) {
                    JavaTokenId accepted;
                    if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                        ++this.tpLevel;
                    }
                    this.continuationIndent = true;
                    Iterator<? extends TypeParameterTree> it = tparams.iterator();
                    while (it.hasNext()) {
                        TypeParameterTree tparam = it.next();
                        this.scan((Tree)tparam, p);
                        if (!it.hasNext()) continue;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                        switch (accepted) {
                            case GTGTGT: {
                                this.tpLevel -= 3;
                                break;
                            }
                            case GTGT: {
                                this.tpLevel -= 2;
                                break;
                            }
                            case GT: {
                                --this.tpLevel;
                            }
                        }
                    }
                    this.spaces(1, true);
                }
                if ((retType = node.getReturnType()) != null) {
                    this.scan(retType, p);
                    this.continuationIndent = true;
                    this.spaces(1, true);
                }
                if (!ERROR.contentEquals(node.getName())) {
                    this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
                }
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeMethodDeclParen() ? 1 : 0);
                this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                java.util.List<? extends VariableTree> params = node.getParameters();
                if (params != null && !params.isEmpty()) {
                    int oldIndent = this.indent;
                    int oldLastIndent = this.lastIndent;
                    boolean continuation = this.isLastIndentContinuation;
                    if (continuation) {
                        this.indent = this.indent();
                        this.isLastIndentContinuation = false;
                    }
                    try {
                        this.spaces(this.cs.spaceWithinMethodDeclParens() ? 1 : 0, true);
                        this.wrapList(this.cs.wrapMethodParams(), this.cs.alignMultilineMethodParams(), false, JavaTokenId.COMMA, params);
                    }
                    finally {
                        this.indent = oldIndent;
                        this.lastIndent = oldLastIndent;
                        this.continuationIndent = this.isLastIndentContinuation = continuation;
                    }
                    this.spaces(this.cs.spaceWithinMethodDeclParens() ? 1 : 0, true);
                }
                this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
                this.continuationIndent = true;
                java.util.List<? extends ExpressionTree> threxs = node.getThrows();
                if (threxs != null && !threxs.isEmpty()) {
                    this.wrapToken(this.cs.wrapThrowsKeyword(), 1, JavaTokenId.THROWS, new JavaTokenId[0]);
                    this.wrapList(this.cs.wrapThrowsList(), this.cs.alignMultilineThrows(), true, JavaTokenId.COMMA, threxs);
                }
                if ((init = node.getDefaultValue()) != null) {
                    this.spaces(1, true);
                    this.accept(JavaTokenId.DEFAULT, new JavaTokenId[0]);
                    this.space();
                    this.scan(init, p);
                }
            }
            finally {
                this.continuationIndent = old;
            }
            BlockTree body = node.getBody();
            if (body != null) {
                this.scan((Tree)body, p);
            } else {
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            return true;
        }

        @Override
        public Boolean visitModifiers(ModifiersTree node, Void p) {
            boolean isStandalone;
            boolean ret = true;
            JavaTokenId id = null;
            this.afterAnnotation = false;
            Iterator<? extends AnnotationTree> annotations = node.getAnnotations().iterator();
            TreePath path = this.getCurrentPath().getParentPath();
            Tree parent = path.getLeaf();
            Tree grandParent = (path = path.getParentPath()) != null ? path.getLeaf() : parent;
            boolean bl = isStandalone = parent.getKind() != Tree.Kind.VARIABLE || TreeUtilities.CLASS_TREE_KINDS.contains((Object)grandParent.getKind()) || grandParent.getKind() == Tree.Kind.BLOCK;
            while (this.tokens.offset() < this.endPos) {
                if (this.afterAnnotation) {
                    if (!isStandalone) {
                        this.spaces(1, true);
                    } else {
                        switch (this.cs.wrapAnnotations()) {
                            case WRAP_ALWAYS: {
                                this.newline();
                                break;
                            }
                            case WRAP_IF_LONG: {
                                if (this.col >= this.rightMargin) {
                                    this.newline();
                                    break;
                                }
                                this.spaces(1, true);
                                break;
                            }
                            case WRAP_NEVER: {
                                this.spaces(1, true);
                            }
                        }
                    }
                } else if (id != null) {
                    this.space();
                }
                int index = this.tokens.index();
                int c = this.col;
                Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                int lbl = this.lastBlankLines;
                int lblti = this.lastBlankLinesTokenIndex;
                Diff lbld = this.lastBlankLinesDiff;
                id = this.accept(JavaTokenId.PRIVATE, JavaTokenId.PROTECTED, JavaTokenId.PUBLIC, JavaTokenId.STATIC, JavaTokenId.DEFAULT, JavaTokenId.TRANSIENT, JavaTokenId.FINAL, JavaTokenId.ABSTRACT, JavaTokenId.NATIVE, JavaTokenId.VOLATILE, JavaTokenId.SYNCHRONIZED, JavaTokenId.STRICTFP, JavaTokenId.AT);
                if (id == null) break;
                if (id == JavaTokenId.AT) {
                    if (annotations.hasNext()) {
                        this.rollback(index, c, d);
                        this.lastBlankLines = lbl;
                        this.lastBlankLinesTokenIndex = lblti;
                        this.lastBlankLinesDiff = lbld;
                        boolean bl2 = this.wrapAnnotation = this.cs.wrapAnnotations() == CodeStyle.WrapStyle.WRAP_ALWAYS;
                        if (!isStandalone || !this.afterAnnotation) {
                            this.scan((Tree)annotations.next(), p);
                        } else {
                            this.wrapTree(this.cs.wrapAnnotations(), -1, 0, annotations.next());
                        }
                        this.wrapAnnotation = false;
                        this.afterAnnotation = true;
                        ret = false;
                        continue;
                    }
                    this.afterAnnotation = false;
                    ret = false;
                    continue;
                }
                this.afterAnnotation = false;
                ret = true;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitAnnotation(AnnotationTree node, Void p) {
            this.accept(JavaTokenId.AT, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.spaces(0, true);
                this.scan(node.getAnnotationType(), p);
                java.util.List<? extends ExpressionTree> args = node.getArguments();
                this.spaces(this.cs.spaceBeforeAnnotationParen() ? 1 : 0);
                this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                if (args != null && !args.isEmpty()) {
                    boolean oldInsideAnnotation = this.insideAnnotation;
                    this.insideAnnotation = true;
                    int oldIndent = this.indent;
                    int oldLastIndent = this.lastIndent;
                    boolean continuation = this.isLastIndentContinuation;
                    if (continuation) {
                        this.indent = this.indent();
                        this.isLastIndentContinuation = false;
                    }
                    try {
                        this.spaces(0, true);
                        this.wrapList(this.cs.wrapAnnotationArgs(), this.cs.alignMultilineAnnotationArgs(), this.cs.spaceWithinAnnotationParens(), JavaTokenId.COMMA, args);
                    }
                    finally {
                        this.indent = oldIndent;
                        this.lastIndent = oldLastIndent;
                        this.continuationIndent = this.isLastIndentContinuation = continuation;
                        this.insideAnnotation = oldInsideAnnotation;
                    }
                    this.spaces(this.cs.spaceWithinAnnotationParens() ? 1 : 0, true);
                }
                this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        @Override
        public Boolean visitAnnotatedType(AnnotatedTypeTree node, Void p) {
            java.util.List<? extends AnnotationTree> annotations = node.getAnnotations();
            if (annotations != null && !annotations.isEmpty()) {
                switch (node.getUnderlyingType().getKind()) {
                    case MEMBER_SELECT: {
                        MemberSelectTree mst = (MemberSelectTree)node.getUnderlyingType();
                        this.scan((Tree)mst.getExpression(), p);
                        this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                        this.spaces(0);
                        Iterator<? extends AnnotationTree> it = annotations.iterator();
                        while (it.hasNext()) {
                            this.scan((Tree)it.next(), p);
                            if (!it.hasNext()) continue;
                            this.spaces(1, true);
                        }
                        this.space();
                        if (ERROR.contentEquals(mst.getIdentifier())) {
                            while (this.tokens.offset() < this.endPos) {
                                int len = this.tokens.token().length();
                                if (this.tokens.token().id() == JavaTokenId.WHITESPACE && this.tokens.offset() + len >= this.endPos) break;
                                this.col += len;
                                if (this.tokens.moveNext()) continue;
                            }
                            this.lastBlankLines = -1;
                            this.lastBlankLinesTokenIndex = -1;
                            this.lastBlankLinesDiff = null;
                        } else {
                            this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE, JavaTokenId.STAR, JavaTokenId.THIS, JavaTokenId.SUPER, JavaTokenId.CLASS);
                        }
                        return true;
                    }
                    case ARRAY_TYPE: {
                        ArrayTypeTree att = (ArrayTypeTree)((Object)node.getUnderlyingType());
                        boolean ret = this.scan(att.getType(), p);
                        this.space();
                        Iterator<? extends AnnotationTree> it = annotations.iterator();
                        while (it.hasNext()) {
                            this.scan((Tree)it.next(), p);
                            if (!it.hasNext()) continue;
                            this.spaces(1, true);
                        }
                        this.space();
                        JavaTokenId id = this.accept(JavaTokenId.LBRACKET, JavaTokenId.ELLIPSIS);
                        if (id == JavaTokenId.ELLIPSIS) {
                            return ret;
                        }
                        this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
                        return ret;
                    }
                }
                Iterator<? extends AnnotationTree> it = annotations.iterator();
                while (it.hasNext()) {
                    this.scan((Tree)it.next(), p);
                    if (!it.hasNext()) continue;
                    this.spaces(1, true);
                }
                this.space();
            }
            this.scan((Tree)node.getUnderlyingType(), p);
            return true;
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterTree node, Void p) {
            java.util.List<? extends Tree> bounds;
            java.util.List<? extends AnnotationTree> annotations = node.getAnnotations();
            if (annotations != null && !annotations.isEmpty()) {
                Iterator<? extends AnnotationTree> it = annotations.iterator();
                while (it.hasNext()) {
                    this.scan((Tree)it.next(), p);
                    if (!it.hasNext()) continue;
                    this.spaces(1, true);
                }
                this.space();
            }
            if (!ERROR.contentEquals(node.getName())) {
                this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
            }
            if ((bounds = node.getBounds()) != null && !bounds.isEmpty()) {
                this.space();
                this.accept(JavaTokenId.EXTENDS, new JavaTokenId[0]);
                this.space();
                Iterator<? extends Tree> it = bounds.iterator();
                while (it.hasNext()) {
                    Tree bound = it.next();
                    this.scan(bound, p);
                    if (!it.hasNext()) continue;
                    this.space();
                    this.accept(JavaTokenId.AMP, new JavaTokenId[0]);
                    this.space();
                }
            }
            return true;
        }

        @Override
        public Boolean visitParameterizedType(ParameterizedTypeTree node, Void p) {
            JavaTokenId accepted;
            boolean ltRead;
            block10: {
                Diff d;
                this.scan(node.getType(), p);
                int index = this.tokens.index();
                int c = this.col;
                Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                    ++this.tpLevel;
                    ltRead = true;
                } else {
                    this.rollback(index, c, d);
                    ltRead = false;
                }
                java.util.List<? extends Tree> targs = node.getTypeArguments();
                if (targs != null && !targs.isEmpty()) {
                    Iterator<? extends Tree> it = targs.iterator();
                    Tree targ = it.hasNext() ? it.next() : null;
                    while (true) {
                        this.scan(targ, p);
                        Tree tree = targ = it.hasNext() ? it.next() : null;
                        if (targ == null) break block10;
                        if (targ.getKind() == Tree.Kind.ERRONEOUS && ((ErroneousTree)targ).getErrorTrees().isEmpty() && !it.hasNext()) break;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    this.scan(targ, p);
                    return true;
                }
            }
            if (ltRead && this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                switch (accepted) {
                    case GTGTGT: {
                        this.tpLevel -= 3;
                        break;
                    }
                    case GTGT: {
                        this.tpLevel -= 2;
                        break;
                    }
                    case GT: {
                        --this.tpLevel;
                    }
                }
            }
            return true;
        }

        @Override
        public Boolean visitWildcard(WildcardTree node, Void p) {
            this.accept(JavaTokenId.QUESTION, new JavaTokenId[0]);
            Tree bound = node.getBound();
            if (bound != null) {
                this.space();
                this.accept(JavaTokenId.EXTENDS, JavaTokenId.SUPER);
                this.space();
                this.scan(bound, p);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitBlock(BlockTree node, Void p) {
            CodeStyle.BracePlacement bracePlacement;
            if (node.isStatic()) {
                this.accept(JavaTokenId.STATIC, new JavaTokenId[0]);
            }
            boolean spaceBeforeLeftBrace = false;
            switch (this.getCurrentPath().getParentPath().getLeaf().getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    if (!node.isStatic()) break;
                    spaceBeforeLeftBrace = this.cs.spaceBeforeStaticInitLeftBrace();
                    break;
                }
                case METHOD: {
                    bracePlacement = this.cs.getMethodDeclBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeMethodDeclLeftBrace();
                    break;
                }
                case LAMBDA_EXPRESSION: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    break;
                }
                case TRY: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    if (((TryTree)this.getCurrentPath().getParentPath().getLeaf()).getBlock() == node) {
                        spaceBeforeLeftBrace = this.cs.spaceBeforeTryLeftBrace();
                        break;
                    }
                    spaceBeforeLeftBrace = this.cs.spaceBeforeFinallyLeftBrace();
                    break;
                }
                case CATCH: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeCatchLeftBrace();
                    break;
                }
                case WHILE_LOOP: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeWhileLeftBrace();
                    break;
                }
                case FOR_LOOP: 
                case ENHANCED_FOR_LOOP: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeForLeftBrace();
                    break;
                }
                case DO_WHILE_LOOP: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeDoLeftBrace();
                    break;
                }
                case IF: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    if (((IfTree)this.getCurrentPath().getParentPath().getLeaf()).getThenStatement() == node) {
                        spaceBeforeLeftBrace = this.cs.spaceBeforeIfLeftBrace();
                        break;
                    }
                    spaceBeforeLeftBrace = this.cs.spaceBeforeElseLeftBrace();
                    break;
                }
                case SYNCHRONIZED: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = this.cs.spaceBeforeSynchronizedLeftBrace();
                    break;
                }
                case CASE: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                    spaceBeforeLeftBrace = true;
                    break;
                }
                default: {
                    bracePlacement = this.cs.getOtherBracePlacement();
                }
            }
            int old = this.lastIndent;
            int halfIndent = this.lastIndent;
            switch (bracePlacement) {
                case SAME_LINE: {
                    this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                    if (node instanceof FakeBlock) {
                        this.appendToDiff("{");
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.lastBlankLinesDiff = null;
                    } else {
                        this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    }
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE: {
                    this.newline();
                    if (node instanceof FakeBlock) {
                        this.indent = this.lastIndent + this.indentSize;
                        this.appendToDiff("{");
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.lastBlankLinesDiff = null;
                        break;
                    }
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE_HALF_INDENTED: {
                    int oldLast = this.lastIndent;
                    halfIndent = this.indent = this.lastIndent + (this.indentSize >> 1);
                    this.newline();
                    if (node instanceof FakeBlock) {
                        this.indent = oldLast + this.indentSize;
                        this.appendToDiff("{");
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.lastBlankLinesDiff = null;
                        break;
                    }
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    this.indent = oldLast + this.indentSize;
                    break;
                }
                case NEW_LINE_INDENTED: {
                    halfIndent = this.indent = this.lastIndent + this.indentSize;
                    this.newline();
                    if (node instanceof FakeBlock) {
                        this.appendToDiff("{");
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.lastBlankLinesDiff = null;
                        break;
                    }
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                }
            }
            boolean isEmpty = true;
            int lastMaxPreservedBlankLines = this.maxPreservedBlankLines;
            this.maxPreservedBlankLines = this.cs.getMaximumBlankLinesInCode();
            for (StatementTree statementTree : node.getStatements()) {
                if (this.isSynthetic(this.getCurrentPath().getCompilationUnit(), statementTree)) continue;
                isEmpty = false;
                if (statementTree.getKind() == Tree.Kind.LABELED_STATEMENT && this.cs.absoluteLabelIndent()) {
                    int o = this.indent;
                    int oLDiff = this.lastIndent - this.indent;
                    boolean oCI = this.continuationIndent;
                    try {
                        this.indent = 0;
                        this.continuationIndent = false;
                        if (node instanceof FakeBlock) {
                            this.appendToDiff(this.getNewlines(1) + this.getIndent());
                            this.col = this.indent();
                        } else {
                            this.newline();
                        }
                        oLDiff = this.lastIndent - this.indent;
                    }
                    finally {
                        this.indent = o;
                        this.lastIndent = oLDiff + this.indent;
                        this.continuationIndent = oCI;
                    }
                } else if (node instanceof FakeBlock) {
                    this.appendToDiff(this.getNewlines(1) + this.getIndent());
                    this.col = this.indent();
                } else if (statementTree.getKind() == Tree.Kind.EMPTY_STATEMENT || statementTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && ((ExpressionStatementTree)statementTree).getExpression().getKind() == Tree.Kind.ERRONEOUS) {
                    this.spaces(0, true);
                } else if (!this.fieldGroup || statementTree.getKind() != Tree.Kind.VARIABLE) {
                    this.newline();
                }
                this.scan((Tree)statementTree, p);
            }
            if (isEmpty) {
                this.newline();
            }
            if (node instanceof FakeBlock) {
                boolean bl;
                this.indent = halfIndent;
                int i = this.tokens.index();
                boolean bl2 = true;
                block28: while (bl) {
                    switch ((JavaTokenId)this.tokens.token().id()) {
                        case WHITESPACE: {
                            if (this.tokens.token().text().toString().indexOf(10) < 0) {
                                this.tokens.moveNext();
                                continue block28;
                            }
                            bl = false;
                            this.appendToDiff(NEWLINE);
                            this.col = 0;
                            continue block28;
                        }
                        case LINE_COMMENT: {
                            bl = false;
                        }
                        case BLOCK_COMMENT: {
                            this.tokens.moveNext();
                            continue block28;
                        }
                    }
                    if (this.tokens.index() != i) {
                        this.tokens.moveIndex(i);
                        this.tokens.moveNext();
                    }
                    bl = false;
                    this.appendToDiff(NEWLINE);
                    this.col = 0;
                }
                this.appendToDiff(this.getIndent() + "}");
                this.col = this.indent() + 1;
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
            } else {
                Diff diff;
                this.newline();
                this.indent = halfIndent;
                Diff diff2 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (diff != null && diff.end == this.tokens.offset()) {
                    String string;
                    if (diff.text != null) {
                        int n = diff.text.lastIndexOf(10);
                        if (n < 0) {
                            diff.text = this.getIndent();
                        } else {
                            diff.text = diff.text.substring(0, n + 1) + this.getIndent();
                        }
                    }
                    String string2 = string = diff.text != null ? diff.text : this.getIndent();
                    if (string.equals(this.fText.substring(diff.start, diff.end))) {
                        this.diffs.removeFirst();
                    }
                } else if (this.tokens.movePrevious()) {
                    if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                        String string = this.tokens.token().text().toString();
                        int idx = string.lastIndexOf(10);
                        if (idx >= 0) {
                            String string3 = string.substring(idx + 1);
                            String ind = this.getIndent();
                            if (!ind.equals(string3)) {
                                this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                            }
                        } else if (this.tokens.movePrevious()) {
                            if (this.tokens.token().id() == JavaTokenId.LINE_COMMENT) {
                                this.tokens.moveNext();
                                String ind = this.getIndent();
                                if (!ind.equals(string)) {
                                    this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset() + this.tokens.token().length(), ind));
                                }
                            } else {
                                this.tokens.moveNext();
                            }
                        }
                    }
                    this.tokens.moveNext();
                }
                this.col = this.indent();
                this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
            }
            this.maxPreservedBlankLines = lastMaxPreservedBlankLines;
            this.indent = this.lastIndent = old;
            return true;
        }

        @Override
        public Boolean visitMemberSelect(MemberSelectTree node, Void p) {
            this.scan((Tree)node.getExpression(), p);
            if (ERROR.contentEquals(node.getIdentifier())) {
                while (this.tokens.offset() < this.endPos) {
                    int len = this.tokens.token().length();
                    if (this.tokens.token().id() == JavaTokenId.WHITESPACE && this.tokens.offset() + len >= this.endPos) break;
                    this.col += len;
                    if (this.tokens.moveNext()) continue;
                }
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
            } else {
                this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE, JavaTokenId.STAR, JavaTokenId.THIS, JavaTokenId.SUPER, JavaTokenId.CLASS);
            }
            return true;
        }

        @Override
        public Boolean visitMemberReference(MemberReferenceTree node, Void p) {
            JavaTokenId accepted;
            boolean ltRead;
            block13: {
                Diff d;
                this.scan((Tree)node.getQualifierExpression(), p);
                this.spaces(this.cs.spaceAroundMethodReferenceDoubleColon() ? 1 : 0);
                this.accept(JavaTokenId.COLONCOLON, new JavaTokenId[0]);
                this.spaces(this.cs.spaceAroundMethodReferenceDoubleColon() ? 1 : 0);
                int index = this.tokens.index();
                int c = this.col;
                Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                    ++this.tpLevel;
                    ltRead = true;
                } else {
                    this.rollback(index, c, d);
                    ltRead = false;
                }
                java.util.List<? extends ExpressionTree> targs = node.getTypeArguments();
                if (targs != null && !targs.isEmpty()) {
                    Iterator<? extends ExpressionTree> it = targs.iterator();
                    Tree targ = it.hasNext() ? (Tree)it.next() : null;
                    while (true) {
                        this.scan(targ, p);
                        Tree tree = targ = it.hasNext() ? (Tree)it.next() : null;
                        if (targ == null) break block13;
                        if (targ.getKind() == Tree.Kind.ERRONEOUS && ((ErroneousTree)targ).getErrorTrees().isEmpty() && !it.hasNext()) break;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    this.scan(targ, p);
                    return true;
                }
            }
            if (ltRead && this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                switch (accepted) {
                    case GTGTGT: {
                        this.tpLevel -= 3;
                        break;
                    }
                    case GTGT: {
                        this.tpLevel -= 2;
                        break;
                    }
                    case GT: {
                        --this.tpLevel;
                    }
                }
            }
            if (ERROR.contentEquals(node.getName())) {
                while (this.tokens.offset() < this.endPos) {
                    int len = this.tokens.token().length();
                    if (this.tokens.token().id() == JavaTokenId.WHITESPACE && this.tokens.offset() + len >= this.endPos) break;
                    this.col += len;
                    if (this.tokens.moveNext()) continue;
                }
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
            } else {
                this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE, JavaTokenId.NEW);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitLambdaExpression(LambdaExpressionTree node, Void p) {
            int oldLastIndent;
            int oldIndent;
            boolean old;
            JavaTokenId accepted;
            java.util.List<? extends VariableTree> params = node.getParameters();
            JavaTokenId javaTokenId = accepted = params != null && params.size() == 1 ? this.accept(JavaTokenId.LPAREN, JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE) : this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            if (accepted == JavaTokenId.LPAREN) {
                old = this.continuationIndent;
                try {
                    if (params != null && !params.isEmpty()) {
                        oldIndent = this.indent;
                        oldLastIndent = this.lastIndent;
                        boolean continuation = this.isLastIndentContinuation;
                        if (continuation) {
                            this.indent = this.indent();
                            this.isLastIndentContinuation = false;
                        }
                        try {
                            this.spaces(this.cs.spaceWithinLambdaParens() ? 1 : 0, true);
                            this.wrapList(this.cs.wrapLambdaParams(), this.cs.alignMultilineLambdaParams(), false, JavaTokenId.COMMA, params);
                        }
                        finally {
                            this.indent = oldIndent;
                            this.lastIndent = oldLastIndent;
                            this.continuationIndent = this.isLastIndentContinuation = continuation;
                        }
                        this.spaces(this.cs.spaceWithinLambdaParens() ? 1 : 0);
                    }
                    this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
                }
                finally {
                    this.continuationIndent = old;
                }
            }
            if (this.cs.wrapAfterLambdaArrow()) {
                boolean containedNewLine = this.spaces(this.cs.spaceAroundLambdaArrow() ? 1 : 0, false);
                if (this.accept(JavaTokenId.ARROW, new JavaTokenId[0]) != null) {
                    this.col += 2;
                    this.lastBlankLines = -1;
                    this.lastBlankLinesTokenIndex = -1;
                    if (containedNewLine) {
                        this.newline();
                    }
                }
                boolean old2 = this.continuationIndent;
                int oldIndent2 = this.indent;
                int oldLastIndent2 = this.lastIndent;
                boolean oldLastIndentContinuation = this.isLastIndentContinuation;
                if (node.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT && this.continuationIndent) {
                    this.lastIndent = this.indent;
                    this.continuationIndent = false;
                }
                try {
                    this.wrapTree(this.cs.wrapLambdaArrow(), -1, this.cs.spaceAroundLambdaArrow() ? 1 : 0, node.getBody());
                }
                finally {
                    this.continuationIndent = old2;
                    this.indent = oldIndent2;
                    this.lastIndent = oldLastIndent2;
                    this.isLastIndentContinuation = oldLastIndentContinuation;
                }
            }
            old = this.continuationIndent;
            oldIndent = this.indent;
            oldLastIndent = this.lastIndent;
            boolean oldLastIndentContinuation = this.isLastIndentContinuation;
            if (node.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT && this.continuationIndent) {
                this.lastIndent = this.indent;
                this.indent += this.continuationIndentSize;
                this.continuationIndent = false;
            }
            try {
                this.wrapOperatorAndTree(this.cs.wrapLambdaArrow(), -1, this.cs.spaceAroundLambdaArrow() ? 1 : 0, this.cs.spaceAroundLambdaArrow() ? 1 : 0, this.lastIndent, node.getBody());
            }
            finally {
                this.continuationIndent = old;
                this.indent = oldIndent;
                this.lastIndent = oldLastIndent;
                this.isLastIndentContinuation = oldLastIndentContinuation;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
            block17: {
                block16: {
                    ExpressionTree ms = node.getMethodSelect();
                    if (ms.getKind() != Tree.Kind.MEMBER_SELECT) break block16;
                    int old = this.indent;
                    if (this.isLastIndentContinuation) {
                        this.indent += this.continuationIndentSize;
                        this.isLastIndentContinuation = false;
                    }
                    ExpressionTree exp = ((MemberSelectTree)ms).getExpression();
                    this.scan((Tree)exp, p);
                    CodeStyle.WrapStyle wrapStyle = this.cs.wrapChainedMethodCalls();
                    if (wrapStyle == CodeStyle.WrapStyle.WRAP_ALWAYS && exp.getKind() != Tree.Kind.METHOD_INVOCATION) {
                        wrapStyle = CodeStyle.WrapStyle.WRAP_IF_LONG;
                    }
                    switch (wrapStyle) {
                        case WRAP_ALWAYS: {
                            if (this.cs.wrapAfterDotInChainedMethodCalls()) {
                                this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                                this.newline();
                            } else {
                                this.newline();
                                this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                            }
                            this.scanMethodCall(node);
                            break;
                        }
                        case WRAP_IF_LONG: {
                            int index = this.tokens.index();
                            int c = this.col;
                            Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                            int o = this.tokens.offset();
                            WrapAbort oldCheckWrap = this.checkWrap;
                            this.checkWrap = new WrapAbort(o);
                            try {
                                this.spaces(0, true);
                                this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                                this.spaces(0, true);
                                this.scanMethodCall(node);
                            }
                            catch (WrapAbort wrapAbort) {
                            }
                            finally {
                                this.checkWrap = oldCheckWrap;
                            }
                            if (this.col <= this.rightMargin || o < this.lastNewLineOffset) break;
                            this.rollback(index, c, d);
                            if (this.cs.wrapAfterDotInChainedMethodCalls()) {
                                this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                                this.newline();
                            } else {
                                this.newline();
                                this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                            }
                            this.scanMethodCall(node);
                            break;
                        }
                        case WRAP_NEVER: {
                            this.spaces(0, true);
                            this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                            this.spaces(0, true);
                            this.scanMethodCall(node);
                        }
                    }
                    this.indent = old;
                    break block17;
                }
                this.scanMethodCall(node);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitNewClass(NewClassTree node, Void p) {
            block23: {
                ExpressionTree encl = node.getEnclosingExpression();
                if (encl != null) {
                    this.scan((Tree)encl, p);
                    this.accept(JavaTokenId.DOT, new JavaTokenId[0]);
                }
                this.accept(JavaTokenId.NEW, new JavaTokenId[0]);
                this.space();
                java.util.List<? extends Tree> targs = node.getTypeArguments();
                if (targs != null && !targs.isEmpty()) {
                    JavaTokenId accepted;
                    if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                        ++this.tpLevel;
                    }
                    Iterator<? extends Tree> it = targs.iterator();
                    while (it.hasNext()) {
                        Tree targ = it.next();
                        this.scan(targ, p);
                        if (!it.hasNext()) continue;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                        switch (accepted) {
                            case GTGTGT: {
                                this.tpLevel -= 3;
                                break;
                            }
                            case GTGT: {
                                this.tpLevel -= 2;
                                break;
                            }
                            case GT: {
                                --this.tpLevel;
                            }
                        }
                    }
                }
                this.scan((Tree)node.getIdentifier(), p);
                this.spaces(this.cs.spaceBeforeMethodCallParen() ? 1 : 0);
                this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                boolean old = this.continuationIndent;
                try {
                    int oldLastIndent;
                    int oldIndent;
                    java.util.List<? extends ExpressionTree> args = node.getArguments();
                    if (args != null && !args.isEmpty()) {
                        oldIndent = this.indent;
                        oldLastIndent = this.lastIndent;
                        boolean continuation = this.isLastIndentContinuation;
                        if (continuation) {
                            this.indent = this.indent();
                            this.isLastIndentContinuation = false;
                        }
                        try {
                            this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                            this.wrapList(this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs(), false, JavaTokenId.COMMA, args);
                        }
                        finally {
                            this.indent = oldIndent;
                            this.lastIndent = oldLastIndent;
                            this.continuationIndent = this.isLastIndentContinuation = continuation;
                        }
                        this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                    }
                    this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
                    this.continuationIndent = old;
                    oldIndent = this.indent;
                    oldLastIndent = this.lastIndent;
                    boolean oldLastIndentContinuation = this.isLastIndentContinuation;
                    ClassTree body = node.getClassBody();
                    if (body == null) break block23;
                    if (this.continuationIndent) {
                        this.lastIndent = this.indent;
                        this.continuationIndent = false;
                    }
                    try {
                        this.scan((Tree)body, p);
                    }
                    finally {
                        this.indent = oldIndent;
                        this.lastIndent = oldLastIndent;
                        this.isLastIndentContinuation = oldLastIndentContinuation;
                    }
                }
                finally {
                    this.continuationIndent = old;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitAssert(AssertTree node, Void p) {
            this.accept(JavaTokenId.ASSERT, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.space();
                this.scan((Tree)node.getCondition(), p);
                ExpressionTree detail = node.getDetail();
                if (detail != null) {
                    this.spaces(this.cs.spaceBeforeColon() ? 1 : 0);
                    this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
                    this.wrapTree(this.cs.wrapAssert(), -1, this.cs.spaceAfterColon() ? 1 : 0, detail);
                }
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitReturn(ReturnTree node, Void p) {
            this.accept(JavaTokenId.RETURN, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                ExpressionTree exp = node.getExpression();
                if (exp != null) {
                    this.space();
                    this.scan((Tree)exp, p);
                }
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitThrow(ThrowTree node, Void p) {
            this.accept(JavaTokenId.THROW, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                ExpressionTree exp = node.getExpression();
                if (exp != null) {
                    this.space();
                    this.scan((Tree)exp, p);
                }
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitTry(TryTree node, Void p) {
            this.accept(JavaTokenId.TRY, new JavaTokenId[0]);
            java.util.List<? extends Tree> res = node.getResources();
            if (res != null && !res.isEmpty()) {
                boolean old = this.continuationIndent;
                try {
                    Diff d;
                    this.continuationIndent = true;
                    this.spaces(this.cs.spaceBeforeTryParen() ? 1 : 0);
                    this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                    this.spaces(this.cs.spaceWithinTryParens() ? 1 : 0, true);
                    this.wrapList(this.cs.wrapTryResources(), this.cs.alignMultilineTryResources(), false, JavaTokenId.SEMICOLON, res);
                    int n = this.tokens.index();
                    int c = this.col;
                    Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    if (this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]) == null) {
                        this.rollback(n, c, d);
                    }
                    this.spaces(this.cs.spaceWithinTryParens() ? 1 : 0);
                    this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
                }
                finally {
                    this.continuationIndent = old;
                }
            }
            this.scan((Tree)node.getBlock(), p);
            for (CatchTree catchTree : node.getCatches()) {
                if (this.cs.placeCatchOnNewLine()) {
                    this.newline();
                } else {
                    this.spaces(this.cs.spaceBeforeCatch() ? 1 : 0);
                }
                this.scan((Tree)catchTree, p);
            }
            BlockTree finallyBlockTree = node.getFinallyBlock();
            if (finallyBlockTree != null) {
                if (this.cs.placeFinallyOnNewLine()) {
                    this.newline();
                } else {
                    this.spaces(this.cs.spaceBeforeFinally() ? 1 : 0);
                }
                this.accept(JavaTokenId.FINALLY, new JavaTokenId[0]);
                this.scan((Tree)finallyBlockTree, p);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitCatch(CatchTree node, Void p) {
            this.accept(JavaTokenId.CATCH, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeCatchParen() ? 1 : 0);
                this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                this.spaces(this.cs.spaceWithinCatchParens() ? 1 : 0);
                this.scan((Tree)node.getParameter(), p);
                this.spaces(this.cs.spaceWithinCatchParens() ? 1 : 0);
                this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            this.scan((Tree)node.getBlock(), p);
            return true;
        }

        @Override
        public Boolean visitUnionType(UnionTypeTree node, Void p) {
            java.util.List<? extends Tree> alts = node.getTypeAlternatives();
            if (alts != null && !alts.isEmpty()) {
                this.wrapList(this.cs.wrapDisjunctiveCatchTypes(), this.cs.alignMultilineDisjunctiveCatchTypes(), false, JavaTokenId.BAR, this.cs.wrapAfterDisjunctiveCatchBar(), alts);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int findNewlineAfterStatement(Tree statement) {
            int pos = (int)this.sp.getEndPosition(this.root, statement);
            if (pos < 0) {
                return pos;
            }
            int index = this.tokens.index();
            try {
                this.tokens.move(pos);
                while (this.tokens.moveNext()) {
                    Token tukac = this.tokens.token();
                    switch ((JavaTokenId)tukac.id()) {
                        case WHITESPACE: {
                            int nl = tukac.text().toString().indexOf(10);
                            if (nl == -1) break;
                            int n = this.tokens.offset() + nl + 1;
                            return n;
                        }
                        case LINE_COMMENT: {
                            int n = this.tokens.offset() + tukac.length();
                            return n;
                        }
                        case BLOCK_COMMENT: {
                            break;
                        }
                        default: {
                            int n = pos;
                            return n;
                        }
                    }
                }
            }
            finally {
                this.tokens.moveIndex(index);
                this.tokens.moveNext();
            }
            return pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitIf(IfTree node, Void p) {
            this.accept(JavaTokenId.IF, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeIfParen() ? 1 : 0);
                this.scan((Tree)node.getCondition(), p);
            }
            finally {
                this.continuationIndent = old;
            }
            StatementTree elseStat = node.getElseStatement();
            CodeStyle.BracesGenerationStyle redundantIfBraces = this.cs.redundantIfBraces();
            int eoln = this.findNewlineAfterStatement(node);
            if (elseStat != null && redundantIfBraces == CodeStyle.BracesGenerationStyle.ELIMINATE && this.danglingElseChecker.hasDanglingElse(node.getThenStatement()) || redundantIfBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || this.endOffset < eoln || node.getCondition().getKind() == Tree.Kind.ERRONEOUS)) {
                redundantIfBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            this.lastIndent = this.indent;
            boolean prevblock = this.wrapStatement(this.cs.wrapIfStatement(), redundantIfBraces, this.cs.spaceBeforeIfLeftBrace() ? 1 : 0, node.getThenStatement());
            if (elseStat != null) {
                CodeStyle.WrapStyle wrapElse;
                if (this.cs.placeElseOnNewLine() || !prevblock) {
                    this.newline();
                } else {
                    this.spaces(this.cs.spaceBeforeElse() ? 1 : 0, this.tokens.offset() < this.startOffset);
                }
                this.accept(JavaTokenId.ELSE, new JavaTokenId[0]);
                if (elseStat.getKind() == Tree.Kind.IF && this.cs.specialElseIf()) {
                    Diff d;
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    if (!this.spaces(1, false)) {
                        this.scan((Tree)elseStat, p);
                        return true;
                    }
                    this.rollback(index, c, d);
                }
                boolean preserveNewLine = true;
                if (this.cs.specialElseIf() && elseStat.getKind() == Tree.Kind.IF) {
                    redundantIfBraces = CodeStyle.BracesGenerationStyle.ELIMINATE;
                    wrapElse = CodeStyle.WrapStyle.WRAP_NEVER;
                    preserveNewLine = false;
                    this.lastIndent -= this.indentSize;
                } else {
                    redundantIfBraces = this.cs.redundantIfBraces();
                    if (redundantIfBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || this.endOffset < eoln)) {
                        redundantIfBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
                    }
                    wrapElse = this.cs.wrapIfStatement();
                }
                this.wrapStatement(wrapElse, redundantIfBraces, this.cs.spaceBeforeElseLeftBrace() ? 1 : 0, preserveNewLine, elseStat);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitDoWhileLoop(DoWhileLoopTree node, Void p) {
            this.accept(JavaTokenId.DO, new JavaTokenId[0]);
            this.lastIndent = this.indent;
            boolean old = this.continuationIndent;
            try {
                Iterator<? extends StatementTree> stats;
                boolean isBlock;
                int eoln = this.findNewlineAfterStatement(node);
                CodeStyle.BracesGenerationStyle redundantDoWhileBraces = this.cs.redundantDoWhileBraces();
                if (redundantDoWhileBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || this.endOffset < eoln || node.getCondition().getKind() == Tree.Kind.ERRONEOUS)) {
                    redundantDoWhileBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
                }
                boolean bl = isBlock = node.getStatement().getKind() == Tree.Kind.BLOCK || redundantDoWhileBraces == CodeStyle.BracesGenerationStyle.GENERATE;
                if (isBlock && redundantDoWhileBraces == CodeStyle.BracesGenerationStyle.ELIMINATE && (stats = ((BlockTree)node.getStatement()).getStatements().iterator()).hasNext()) {
                    StatementTree stat = stats.next();
                    if (!stats.hasNext() && stat.getKind() != Tree.Kind.VARIABLE) {
                        isBlock = false;
                    }
                }
                isBlock = this.wrapStatement(this.cs.wrapDoWhileStatement(), redundantDoWhileBraces, !isBlock || this.cs.spaceBeforeDoLeftBrace() ? 1 : 0, node.getStatement());
                if (this.cs.placeWhileOnNewLine() || !isBlock) {
                    this.newline();
                } else {
                    this.spaces(this.cs.spaceBeforeWhile() ? 1 : 0);
                }
                this.accept(JavaTokenId.WHILE, new JavaTokenId[0]);
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeWhileParen() ? 1 : 0);
                this.scan((Tree)node.getCondition(), p);
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitWhileLoop(WhileLoopTree node, Void p) {
            this.accept(JavaTokenId.WHILE, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeWhileParen() ? 1 : 0);
                this.scan((Tree)node.getCondition(), p);
            }
            finally {
                this.continuationIndent = old;
            }
            this.lastIndent = this.indent;
            int eoln = this.findNewlineAfterStatement(node);
            CodeStyle.BracesGenerationStyle redundantWhileBraces = this.cs.redundantWhileBraces();
            if (redundantWhileBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || this.endOffset < eoln || node.getCondition().getKind() == Tree.Kind.ERRONEOUS)) {
                redundantWhileBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            this.wrapStatement(this.cs.wrapWhileStatement(), redundantWhileBraces, this.cs.spaceBeforeWhileLeftBrace() ? 1 : 0, node.getStatement());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitForLoop(ForLoopTree node, Void p) {
            this.accept(JavaTokenId.FOR, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeForParen() ? 1 : 0);
                this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                this.spaces(this.cs.spaceWithinForParens() ? 1 : 0);
                java.util.List<? extends StatementTree> inits = node.getInitializer();
                int alignIndent = -1;
                if (inits != null && !inits.isEmpty()) {
                    if (this.cs.alignMultilineFor()) {
                        alignIndent = this.col;
                    }
                    Iterator<? extends StatementTree> it = inits.iterator();
                    while (it.hasNext()) {
                        this.scan((Tree)it.next(), p);
                        if (!it.hasNext() || this.fieldGroup) continue;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                    this.spaces(this.cs.spaceBeforeSemi() ? 1 : 0);
                }
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
                ExpressionTree cond = node.getCondition();
                if (cond != null) {
                    this.wrapTree(this.cs.wrapFor(), alignIndent, this.cs.spaceAfterSemi() ? 1 : 0, cond);
                    this.spaces(this.cs.spaceBeforeSemi() ? 1 : 0);
                }
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
                java.util.List<? extends ExpressionStatementTree> updates = node.getUpdate();
                if (updates != null && !updates.isEmpty()) {
                    boolean first = true;
                    Iterator<? extends ExpressionStatementTree> it = updates.iterator();
                    while (it.hasNext()) {
                        ExpressionStatementTree update = it.next();
                        if (first) {
                            this.wrapTree(this.cs.wrapFor(), alignIndent, this.cs.spaceAfterSemi() ? 1 : 0, update);
                        } else {
                            this.scan((Tree)update, p);
                        }
                        first = false;
                        if (!it.hasNext()) continue;
                        this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                        this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                        this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                    }
                }
                this.spaces(this.cs.spaceWithinForParens() ? 1 : 0);
                this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            this.lastIndent = this.indent;
            CodeStyle.BracesGenerationStyle redundantForBraces = this.cs.redundantForBraces();
            int eoln = this.findNewlineAfterStatement(node);
            if (redundantForBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || this.endOffset < eoln || node.getCondition() != null && node.getCondition().getKind() == Tree.Kind.ERRONEOUS)) {
                redundantForBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            this.wrapStatement(this.cs.wrapForStatement(), redundantForBraces, this.cs.spaceBeforeForLeftBrace() ? 1 : 0, node.getStatement());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
            this.accept(JavaTokenId.FOR, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeForParen() ? 1 : 0);
                this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
                this.spaces(this.cs.spaceWithinForParens() ? 1 : 0);
                int alignIndent = this.cs.alignMultilineFor() ? this.col : -1;
                this.scan((Tree)node.getVariable(), p);
                this.wrapOperatorAndTree(this.cs.wrapFor(), alignIndent, this.cs.spaceBeforeColon() ? 1 : 0, this.cs.spaceAfterColon() ? 1 : 0, -1, node.getExpression());
                this.spaces(this.cs.spaceWithinForParens() ? 1 : 0);
                this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            this.lastIndent = this.indent;
            CodeStyle.BracesGenerationStyle redundantForBraces = this.cs.redundantForBraces();
            int eoln = this.findNewlineAfterStatement(node);
            if (redundantForBraces == CodeStyle.BracesGenerationStyle.GENERATE && ((long)this.startOffset > this.sp.getStartPosition(this.root, node) || this.endOffset < eoln)) {
                redundantForBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
            }
            this.wrapStatement(this.cs.wrapForStatement(), redundantForBraces, this.cs.spaceBeforeForLeftBrace() ? 1 : 0, node.getStatement());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitSynchronized(SynchronizedTree node, Void p) {
            this.accept(JavaTokenId.SYNCHRONIZED, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeSynchronizedParen() ? 1 : 0);
                this.scan((Tree)node.getExpression(), p);
            }
            finally {
                this.continuationIndent = old;
            }
            this.lastIndent = this.indent;
            this.scan((Tree)node.getBlock(), p);
            return true;
        }

        @Override
        public Boolean visitSwitch(SwitchTree node, Void p) {
            return this.handleSwitch(node, p);
        }

        @Override
        public Boolean visitSwitchExpression(SwitchExpressionTree node, Void p) {
            return this.handleSwitch(node, p);
        }

        @Override
        public Boolean visitYield(YieldTree node, Void p) {
            ExpressionTree exprTree = node.getValue();
            if (exprTree != null) {
                this.accept(JavaTokenId.IDENTIFIER, new JavaTokenId[0]);
                this.space();
                this.scan((Tree)exprTree, p);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitBindingPattern(BindingPatternTree node, Void p) {
            this.scan((Tree)node.getVariable(), p);
            return true;
        }

        public Boolean visitGuardedPattern(GuardedPatternTree node, Void p) {
            this.scan((Tree)node.getPattern(), p);
            this.space();
            this.accept(JavaTokenId.AMPAMP, new JavaTokenId[0]);
            this.space();
            this.scan((Tree)node.getExpression(), p);
            return true;
        }

        public Boolean visitParenthesizedPattern(ParenthesizedPatternTree node, Void p) {
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            this.scan((Tree)node.getPattern(), p);
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleSwitch(Tree node, Void p) {
            java.util.List<? extends CaseTree> cases;
            ExpressionTree selExpr;
            if (node.getKind() == Tree.Kind.SWITCH) {
                selExpr = ((SwitchTree)node).getExpression();
                cases = ((SwitchTree)node).getCases();
            } else {
                selExpr = ((SwitchExpressionTree)node).getExpression();
                cases = ((SwitchExpressionTree)node).getCases();
            }
            this.accept(JavaTokenId.SWITCH, new JavaTokenId[0]);
            boolean oldContinuationIndent = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.spaces(this.cs.spaceBeforeSwitchParen() ? 1 : 0);
                this.scan((Tree)selExpr, p);
            }
            finally {
                this.continuationIndent = oldContinuationIndent;
            }
            CodeStyle.BracePlacement bracePlacement = this.cs.getOtherBracePlacement();
            boolean spaceBeforeLeftBrace = this.cs.spaceBeforeSwitchLeftBrace();
            boolean indentCases = this.cs.indentCasesFromSwitch();
            int old = this.lastIndent;
            int halfIndent = this.lastIndent;
            if (node.getKind() == Tree.Kind.SWITCH_EXPRESSION) {
                this.continuationIndent = false;
            }
            switch (bracePlacement) {
                case SAME_LINE: {
                    this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    if (!indentCases) break;
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE: {
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    if (!indentCases) break;
                    this.indent = this.lastIndent + this.indentSize;
                    break;
                }
                case NEW_LINE_HALF_INDENTED: {
                    int oldLast = this.lastIndent;
                    halfIndent = this.indent = this.lastIndent + (this.indentSize >> 1);
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    if (indentCases) {
                        this.indent = oldLast + this.indentSize;
                        break;
                    }
                    this.indent = old;
                    break;
                }
                case NEW_LINE_INDENTED: {
                    halfIndent = this.indent = this.lastIndent + this.indentSize;
                    this.newline();
                    this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                    if (indentCases) break;
                    this.indent = old;
                }
            }
            if (node.getKind() == Tree.Kind.SWITCH_EXPRESSION) {
                this.indent = this.lastIndent + this.indentSize;
            }
            try {
                Diff diff;
                for (CaseTree caseTree : cases) {
                    this.newline();
                    this.scan((Tree)caseTree, p);
                }
                this.newline();
                this.indent = halfIndent;
                Diff diff2 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (diff != null && diff.end == this.tokens.offset()) {
                    String string;
                    if (diff.text != null) {
                        int n = diff.text.lastIndexOf(10);
                        if (n < 0) {
                            diff.text = this.getIndent();
                        } else {
                            diff.text = diff.text.substring(0, n + 1) + this.getIndent();
                        }
                    }
                    String string2 = string = diff.text != null ? diff.text : this.getIndent();
                    if (string.equals(this.fText.substring(diff.start, diff.end))) {
                        this.diffs.removeFirst();
                    }
                } else if (this.tokens.movePrevious()) {
                    String string;
                    int idx;
                    if (this.tokens.token().id() == JavaTokenId.WHITESPACE && (idx = (string = this.tokens.token().text().toString()).lastIndexOf(10)) >= 0) {
                        String string3 = string.substring(idx + 1);
                        String ind = this.getIndent();
                        if (!ind.equals(string3)) {
                            this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                        }
                    }
                    this.tokens.moveNext();
                }
            }
            finally {
                this.continuationIndent = oldContinuationIndent;
            }
            this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
            this.indent = this.lastIndent = old;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean visitCase(CaseTree node, Void p) {
            void var5_8;
            java.util.List<? extends CaseLabelTree> labels = node.getLabels();
            if (labels != null && labels.size() > 0) {
                if (this.tokens.token().id() == JavaTokenId.DEFAULT && ((Tree)labels.get(0)).getKind() == Tree.Kind.DEFAULT_CASE_LABEL) {
                    this.accept(JavaTokenId.DEFAULT, new JavaTokenId[0]);
                } else {
                    this.accept(JavaTokenId.CASE, new JavaTokenId[0]);
                    this.space();
                    block5: for (Tree tree : labels) {
                        switch (tree.getKind()) {
                            case DEFAULT_CASE_LABEL: {
                                this.removeWhiteSpace(JavaTokenId.DEFAULT);
                                this.accept(JavaTokenId.DEFAULT, new JavaTokenId[0]);
                                continue block5;
                            }
                            case BINDING_PATTERN: 
                            case PARENTHESIZED_PATTERN: 
                            case GUARDED_PATTERN: {
                                this.removeWhiteSpace(JavaTokenId.IDENTIFIER);
                                this.scan(tree, p);
                                continue block5;
                            }
                            case NULL_LITERAL: {
                                this.removeWhiteSpace(JavaTokenId.NULL);
                                this.scan(tree, p);
                                continue block5;
                            }
                        }
                        this.scan(tree, p);
                    }
                }
            } else if (node.getExpressions().size() > 0) {
                java.util.List<? extends ExpressionTree> exprs = node.getExpressions();
                this.accept(JavaTokenId.CASE, new JavaTokenId[0]);
                this.space();
                exprs.forEach(exp -> this.scan((Tree)exp, p));
            } else {
                this.accept(JavaTokenId.DEFAULT, new JavaTokenId[0]);
            }
            java.util.List<? extends StatementTree> statements = node.getStatements();
            Object var5_6 = null;
            if (statements != null) {
                this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
            } else {
                this.space();
                this.accept(JavaTokenId.ARROW, new JavaTokenId[0]);
                Tree tree = node.getBody();
                if (tree instanceof StatementTree) {
                    statements = Collections.singletonList((StatementTree)tree);
                }
            }
            int old = this.indent;
            this.indent = this.lastIndent + this.indentSize;
            boolean first = true;
            if (statements != null) {
                for (StatementTree statementTree : statements) {
                    if (first) {
                        if (statementTree.getKind() == Tree.Kind.BLOCK) {
                            this.indent = this.lastIndent;
                        }
                        this.wrapStatement(this.cs.wrapCaseStatements(), CodeStyle.BracesGenerationStyle.LEAVE_ALONE, 1, statementTree);
                    } else {
                        this.newline();
                        this.scan((Tree)statementTree, p);
                    }
                    first = false;
                }
            } else if (var5_8 != null) {
                this.newline();
                this.scan((Tree)var5_8, p);
                this.spaces(this.cs.spaceBeforeSemi() ? 1 : 0);
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            this.indent = old;
            return true;
        }

        private void removeWhiteSpace(JavaTokenId forToken) {
            while (this.tokens.offset() < this.endPos && this.tokens.token().id() != forToken) {
                if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                    String text = this.tokens.token().text().toString();
                    String ind = this.getIndent();
                    if (!ind.equals(text)) {
                        this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset() + this.tokens.token().length(), SPACE));
                    }
                }
                if (this.tokens.moveNext()) continue;
            }
        }

        @Override
        public Boolean visitBreak(BreakTree node, Void p) {
            JavaTokenId token = this.accept(JavaTokenId.BREAK, new JavaTokenId[0]);
            Name label = node.getLabel();
            if (label != null) {
                this.space();
                this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitContinue(ContinueTree node, Void p) {
            this.accept(JavaTokenId.CONTINUE, new JavaTokenId[0]);
            Name label = node.getLabel();
            if (label != null) {
                this.space();
                this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
            }
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitAssignment(AssignmentTree node, Void p) {
            int alignIndent = this.cs.alignMultilineAssignment() ? this.col : -1;
            boolean b = this.scan((Tree)node.getVariable(), p);
            if (b || this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
                boolean spaceAroundAssignOps;
                boolean bl = spaceAroundAssignOps = this.insideAnnotation ? this.cs.spaceAroundAnnotationValueAssignOps() : this.cs.spaceAroundAssignOps();
                if (this.cs.wrapAfterAssignOps()) {
                    ExpressionTree expr;
                    boolean containedNewLine = this.spaces(spaceAroundAssignOps ? 1 : 0, false);
                    if (this.accept(JavaTokenId.EQ, new JavaTokenId[0]) == JavaTokenId.EQ && containedNewLine) {
                        this.newline();
                    }
                    if ((expr = node.getExpression()).getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)expr).getType() == null) {
                        if (this.cs.getOtherBracePlacement() == CodeStyle.BracePlacement.SAME_LINE) {
                            this.spaces(spaceAroundAssignOps ? 1 : 0);
                        }
                        this.scan((Tree)expr, p);
                    } else if (this.wrapAnnotation && expr.getKind() == Tree.Kind.ANNOTATION) {
                        this.wrapTree(CodeStyle.WrapStyle.WRAP_ALWAYS, alignIndent, spaceAroundAssignOps ? 1 : 0, expr);
                    } else {
                        this.wrapTree(this.cs.wrapAssignOps(), alignIndent, spaceAroundAssignOps ? 1 : 0, expr);
                    }
                } else {
                    this.wrapOperatorAndTree(this.cs.wrapAssignOps(), alignIndent, spaceAroundAssignOps ? 1 : 0, node.getExpression());
                }
            } else {
                this.scan((Tree)node.getExpression(), p);
            }
            return true;
        }

        @Override
        public Boolean visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
            int alignIndent = this.cs.alignMultilineAssignment() ? this.col : -1;
            this.scan((Tree)node.getVariable(), p);
            if (this.cs.wrapAfterAssignOps()) {
                boolean containedNewLine = this.spaces(this.cs.spaceAroundAssignOps() ? 1 : 0, false);
                if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                    this.col += this.tokens.token().length();
                    this.lastBlankLines = -1;
                    this.lastBlankLinesTokenIndex = -1;
                    this.lastBlankLinesDiff = null;
                    this.tokens.moveNext();
                    if (containedNewLine) {
                        this.newline();
                    }
                }
                this.wrapTree(this.cs.wrapAssignOps(), alignIndent, this.cs.spaceAroundAssignOps() ? 1 : 0, node.getExpression());
            } else {
                this.wrapOperatorAndTree(this.cs.wrapAssignOps(), alignIndent, this.cs.spaceAroundAssignOps() ? 1 : 0, node.getExpression());
            }
            return true;
        }

        @Override
        public Boolean visitPrimitiveType(PrimitiveTypeTree node, Void p) {
            switch (node.getPrimitiveTypeKind()) {
                case BOOLEAN: {
                    this.accept(JavaTokenId.BOOLEAN, new JavaTokenId[0]);
                    break;
                }
                case BYTE: {
                    this.accept(JavaTokenId.BYTE, new JavaTokenId[0]);
                    break;
                }
                case CHAR: {
                    this.accept(JavaTokenId.CHAR, new JavaTokenId[0]);
                    break;
                }
                case DOUBLE: {
                    this.accept(JavaTokenId.DOUBLE, new JavaTokenId[0]);
                    break;
                }
                case FLOAT: {
                    this.accept(JavaTokenId.FLOAT, new JavaTokenId[0]);
                    break;
                }
                case INT: {
                    this.accept(JavaTokenId.INT, new JavaTokenId[0]);
                    break;
                }
                case LONG: {
                    this.accept(JavaTokenId.LONG, new JavaTokenId[0]);
                    break;
                }
                case SHORT: {
                    this.accept(JavaTokenId.SHORT, new JavaTokenId[0]);
                    break;
                }
                case VOID: {
                    this.accept(JavaTokenId.VOID, new JavaTokenId[0]);
                }
            }
            return true;
        }

        @Override
        public Boolean visitArrayType(ArrayTypeTree node, Void p) {
            boolean ret = this.scan(node.getType(), p);
            int index = this.tokens.index();
            int c = this.col;
            Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            JavaTokenId id = this.accept(JavaTokenId.LBRACKET, JavaTokenId.ELLIPSIS, JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
            if (id == JavaTokenId.ELLIPSIS) {
                return ret;
            }
            if (id != JavaTokenId.IDENTIFIER && id != JavaTokenId.UNDERSCORE) {
                this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
                return ret;
            }
            this.rollback(index, c, d);
            this.spaces(1, this.fieldGroup);
            this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
            this.accept(JavaTokenId.LBRACKET, new JavaTokenId[0]);
            this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
            return false;
        }

        @Override
        public Boolean visitArrayAccess(ArrayAccessTree node, Void p) {
            this.scan((Tree)node.getExpression(), p);
            this.accept(JavaTokenId.LBRACKET, new JavaTokenId[0]);
            this.spaces(this.cs.spaceWithinArrayIndexBrackets() ? 1 : 0);
            this.scan((Tree)node.getIndex(), p);
            this.spaces(this.cs.spaceWithinArrayIndexBrackets() ? 1 : 0);
            this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitNewArray(NewArrayTree node, Void p) {
            Tree type = node.getType();
            java.util.List<? extends ExpressionTree> inits = node.getInitializers();
            if (type != null) {
                int n;
                this.accept(JavaTokenId.NEW, new JavaTokenId[0]);
                this.space();
                int n2 = n = inits != null ? 1 : 0;
                while (type.getKind() == Tree.Kind.ARRAY_TYPE) {
                    ++n;
                    type = ((ArrayTypeTree)type).getType();
                }
                this.scan(type, p);
                for (ExpressionTree expressionTree : node.getDimensions()) {
                    this.accept(JavaTokenId.LBRACKET, new JavaTokenId[0]);
                    this.spaces(this.cs.spaceWithinArrayInitBrackets() ? 1 : 0);
                    this.scan((Tree)expressionTree, p);
                    this.spaces(this.cs.spaceWithinArrayInitBrackets() ? 1 : 0);
                    this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
                }
                while (--n >= 0) {
                    this.accept(JavaTokenId.LBRACKET, new JavaTokenId[0]);
                    this.accept(JavaTokenId.RBRACKET, new JavaTokenId[0]);
                }
            }
            if (inits != null) {
                CodeStyle.BracePlacement bracePlacement = this.cs.getOtherBracePlacement();
                boolean spaceBeforeLeftBrace = this.cs.spaceBeforeArrayInitLeftBrace();
                boolean bl = this.continuationIndent;
                try {
                    boolean afterNewline;
                    this.continuationIndent = this.isLastIndentContinuation;
                    int old = this.lastIndent;
                    int halfIndent = this.lastIndent;
                    switch (bracePlacement) {
                        case SAME_LINE: {
                            if (type != null) {
                                this.spaces(spaceBeforeLeftBrace ? 1 : 0, this.tokens.offset() < this.startOffset);
                            }
                            this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                            this.indent = this.lastIndent + this.indentSize;
                            break;
                        }
                        case NEW_LINE: {
                            this.newline();
                            this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                            this.indent = this.lastIndent + this.indentSize;
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            int oldLast = this.lastIndent;
                            halfIndent = this.indent = this.lastIndent + (this.indentSize >> 1);
                            this.newline();
                            this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                            this.indent = oldLast + this.indentSize;
                            break;
                        }
                        case NEW_LINE_INDENTED: {
                            halfIndent = this.indent = this.lastIndent + this.indentSize;
                            this.newline();
                            this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                        }
                    }
                    boolean bl2 = afterNewline = bracePlacement != CodeStyle.BracePlacement.SAME_LINE;
                    if (!inits.isEmpty()) {
                        Diff d;
                        if (afterNewline) {
                            this.newline();
                        } else {
                            this.spaces(this.cs.spaceWithinBraces() ? 1 : 0, true);
                        }
                        CodeStyle.WrapStyle ws = this.insideAnnotation && inits.get(0).getKind() == Tree.Kind.ANNOTATION ? this.cs.wrapAnnotations() : this.cs.wrapArrayInit();
                        this.wrapList(ws, this.cs.alignMultilineArrayInit(), false, JavaTokenId.COMMA, inits);
                        if (this.tokens.token().text().toString().indexOf(10) >= 0) {
                            afterNewline = true;
                        }
                        int index = this.tokens.index();
                        int c = this.col;
                        Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                        if (this.accept(JavaTokenId.COMMA, new JavaTokenId[0]) == null) {
                            this.rollback(index, c, d);
                        }
                        this.indent = this.lastIndent - this.indentSize;
                        if (afterNewline) {
                            this.newline();
                        } else {
                            this.spaces(this.cs.spaceWithinBraces() ? 1 : 0);
                        }
                    } else if (afterNewline) {
                        this.newline();
                    }
                    this.indent = halfIndent;
                    if (afterNewline) {
                        Diff diff;
                        Diff diff2 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                        if (diff != null && diff.end == this.tokens.offset()) {
                            String spaces;
                            if (diff.text != null) {
                                int idx = diff.text.lastIndexOf(10);
                                if (idx < 0) {
                                    diff.text = this.getIndent();
                                } else {
                                    diff.text = diff.text.substring(0, idx + 1) + this.getIndent();
                                }
                            }
                            String string = spaces = diff.text != null ? diff.text : this.getIndent();
                            if (spaces.equals(this.fText.substring(diff.start, diff.end))) {
                                this.diffs.removeFirst();
                            }
                        } else if (this.tokens.movePrevious()) {
                            String text;
                            int idx;
                            if (this.tokens.token().id() == JavaTokenId.WHITESPACE && (idx = (text = this.tokens.token().text().toString()).lastIndexOf(10)) >= 0) {
                                text = text.substring(idx + 1);
                                String ind = this.getIndent();
                                if (!ind.equals(text)) {
                                    this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                                }
                            }
                            this.tokens.moveNext();
                        }
                    }
                    this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
                    this.indent = this.lastIndent = old;
                }
                finally {
                    this.continuationIndent = bl;
                }
            }
            return true;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, Void p) {
            this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE, JavaTokenId.THIS, JavaTokenId.SUPER);
            return true;
        }

        @Override
        public Boolean visitUnary(UnaryTree node, Void p) {
            JavaTokenId id = (JavaTokenId)this.tokens.token().id();
            if (OPERATOR.equals(id.primaryCategory())) {
                this.spaces(this.cs.spaceAroundUnaryOps() ? 1 : 0);
                this.col += this.tokens.token().length();
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
                this.tokens.moveNext();
                int index = this.tokens.index();
                int c = this.col;
                Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                this.spaces(this.cs.spaceAroundUnaryOps() ? 1 : 0);
                if (this.tokens.token().id() == id) {
                    this.rollback(index, c, d);
                    this.space();
                }
                this.scan((Tree)node.getExpression(), p);
            } else {
                this.scan((Tree)node.getExpression(), p);
                this.spaces(this.cs.spaceAroundUnaryOps() ? 1 : 0);
                this.col += this.tokens.token().length();
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
                this.tokens.moveNext();
                this.spaces(this.cs.spaceAroundUnaryOps() ? 1 : 0);
            }
            return true;
        }

        @Override
        public Boolean visitBinary(BinaryTree node, Void p) {
            int alignIndent = this.cs.alignMultilineBinaryOp() ? this.col : -1;
            this.scan((Tree)node.getLeftOperand(), p);
            if (this.cs.wrapAfterBinaryOps()) {
                boolean containedNewLine = this.spaces(this.cs.spaceAroundBinaryOps() ? 1 : 0, false);
                if (OPERATOR.equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                    this.col += this.tokens.token().length();
                    this.lastBlankLines = -1;
                    this.lastBlankLinesTokenIndex = -1;
                    this.tokens.moveNext();
                    if (containedNewLine) {
                        this.newline();
                    }
                }
                this.wrapTree(this.cs.wrapBinaryOps(), alignIndent, this.cs.spaceAroundBinaryOps() ? 1 : 0, node.getRightOperand());
            } else {
                this.wrapOperatorAndTree(this.cs.wrapBinaryOps(), alignIndent, this.cs.spaceAroundBinaryOps() ? 1 : 0, node.getRightOperand());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            int alignIndent = this.cs.alignMultilineTernaryOp() ? this.col : -1;
            this.scan((Tree)node.getCondition(), p);
            boolean old = this.continuationIndent;
            int oldIndent = this.indent;
            try {
                if (this.isLastIndentContinuation) {
                    this.indent = this.indent();
                }
                if (this.cs.wrapAfterTernaryOps()) {
                    boolean containedNewLine = this.spaces(this.cs.spaceAroundTernaryOps() ? 1 : 0, false);
                    this.accept(JavaTokenId.QUESTION, new JavaTokenId[0]);
                    if (containedNewLine) {
                        this.newline();
                    }
                    this.wrapTree(this.cs.wrapTernaryOps(), alignIndent, this.cs.spaceAroundTernaryOps() ? 1 : 0, node.getTrueExpression());
                    containedNewLine = this.spaces(this.cs.spaceAroundTernaryOps() ? 1 : 0, false);
                    this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
                    if (containedNewLine) {
                        this.newline();
                    }
                    this.wrapTree(this.cs.wrapTernaryOps(), alignIndent, this.cs.spaceAroundTernaryOps() ? 1 : 0, node.getFalseExpression());
                } else {
                    this.wrapOperatorAndTree(this.cs.wrapTernaryOps(), alignIndent, this.cs.spaceAroundTernaryOps() ? 1 : 0, node.getTrueExpression());
                    this.wrapOperatorAndTree(this.cs.wrapTernaryOps(), alignIndent, this.cs.spaceAroundTernaryOps() ? 1 : 0, node.getFalseExpression());
                }
            }
            finally {
                this.indent = oldIndent;
                this.continuationIndent = old;
            }
            return true;
        }

        @Override
        public Boolean visitEmptyStatement(EmptyStatementTree node, Void p) {
            this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitExpressionStatement(ExpressionStatementTree node, Void p) {
            boolean old = this.continuationIndent;
            try {
                this.continuationIndent = true;
                this.scan((Tree)node.getExpression(), p);
                this.accept(JavaTokenId.SEMICOLON, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
            return true;
        }

        @Override
        public Boolean visitInstanceOf(InstanceOfTree node, Void p) {
            this.scan((Tree)node.getExpression(), p);
            this.space();
            this.accept(JavaTokenId.INSTANCEOF, new JavaTokenId[0]);
            this.space();
            Tree pattern = node.getPattern();
            if (pattern == null) {
                pattern = node.getType();
            }
            this.scan(pattern, p);
            return true;
        }

        @Override
        public Boolean visitLabeledStatement(LabeledStatementTree node, Void p) {
            int cnt;
            if (!ERROR.contentEquals(node.getLabel())) {
                this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE);
            }
            this.accept(JavaTokenId.COLON, new JavaTokenId[0]);
            int old = this.indent;
            if (!this.cs.absoluteLabelIndent()) {
                this.indent += this.cs.getLabelIndent();
            }
            if ((cnt = this.indent() - this.col) < 0) {
                this.newline();
            } else {
                this.spaces(cnt);
            }
            this.scan((Tree)node.getStatement(), p);
            this.indent = old;
            return true;
        }

        @Override
        public Boolean visitTypeCast(TypeCastTree node, Void p) {
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            boolean spaceWithinParens = this.cs.spaceWithinTypeCastParens();
            this.spaces(spaceWithinParens ? 1 : 0);
            this.scan(node.getType(), p);
            this.spaces(spaceWithinParens ? 1 : 0);
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            this.spaces(this.cs.spaceAfterTypeCast() ? 1 : 0);
            this.scan((Tree)node.getExpression(), p);
            return true;
        }

        @Override
        public Boolean visitIntersectionType(IntersectionTypeTree node, Void p) {
            Iterator<? extends Tree> it = node.getBounds().iterator();
            while (it.hasNext()) {
                Tree bound = it.next();
                this.scan(bound, p);
                if (!it.hasNext()) continue;
                this.space();
                this.accept(JavaTokenId.AMP, new JavaTokenId[0]);
                this.space();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitParenthesized(ParenthesizedTree node, Void p) {
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            int old = this.indent;
            boolean oldContinuationIndent = this.continuationIndent;
            try {
                boolean spaceWithinParens;
                switch (this.getCurrentPath().getParentPath().getLeaf().getKind()) {
                    case IF: {
                        spaceWithinParens = this.cs.spaceWithinIfParens();
                        break;
                    }
                    case FOR_LOOP: {
                        spaceWithinParens = this.cs.spaceWithinForParens();
                        break;
                    }
                    case WHILE_LOOP: 
                    case DO_WHILE_LOOP: {
                        spaceWithinParens = this.cs.spaceWithinWhileParens();
                        break;
                    }
                    case SWITCH: 
                    case SWITCH_EXPRESSION: {
                        spaceWithinParens = this.cs.spaceWithinSwitchParens();
                        break;
                    }
                    case SYNCHRONIZED: {
                        spaceWithinParens = this.cs.spaceWithinSynchronizedParens();
                        break;
                    }
                    case VARIABLE: {
                        spaceWithinParens = this.cs.spaceWithinSwitchParens();
                        break;
                    }
                    default: {
                        spaceWithinParens = this.cs.spaceWithinParens();
                        if (!this.cs.alignMultilineParenthesized()) break;
                        this.indent = this.col;
                        this.continuationIndent = false;
                    }
                }
                this.spaces(spaceWithinParens ? 1 : 0);
                this.scan((Tree)node.getExpression(), p);
                this.spaces(spaceWithinParens ? 1 : 0);
            }
            finally {
                this.indent = old;
                this.continuationIndent = oldContinuationIndent;
            }
            this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            return true;
        }

        @Override
        public Boolean visitLiteral(LiteralTree node, Void p) {
            do {
                this.col += this.tokens.token().length();
            } while (this.tokens.moveNext() && this.tokens.offset() < this.endPos);
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            return true;
        }

        @Override
        public Boolean visitErroneous(ErroneousTree node, Void p) {
            for (Tree tree : node.getErrorTrees()) {
                int pos = (int)this.sp.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree);
                while (this.tokens.offset() < pos) {
                    this.col += this.tokens.token().length();
                    if (this.tokens.moveNext()) continue;
                }
                this.lastBlankLines = -1;
                this.lastBlankLinesTokenIndex = -1;
                this.lastBlankLinesDiff = null;
                this.scan(tree, p);
            }
            while (this.tokens.offset() < this.endPos) {
                int len = this.tokens.token().length();
                if (this.tokens.token().id() == JavaTokenId.WHITESPACE && this.tokens.offset() + len >= this.endPos) break;
                this.col += len;
                if (this.tokens.moveNext()) continue;
            }
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            return true;
        }

        @Override
        public Boolean visitOther(Tree node, Void p) {
            do {
                this.col += this.tokens.token().length();
            } while (this.tokens.moveNext() && this.tokens.offset() < this.endPos);
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            return true;
        }

        private JavaTokenId accept(JavaTokenId first, JavaTokenId ... rest) {
            if (this.checkWrap != null && this.col > this.rightMargin && this.checkWrap.pos >= this.lastNewLineOffset) {
                throw this.checkWrap;
            }
            if (this.tokens.offset() >= this.endPos || this.eof) {
                return null;
            }
            this.lastBlankLines = -1;
            this.lastBlankLinesTokenIndex = -1;
            this.lastBlankLinesDiff = null;
            EnumSet<JavaTokenId[]> tokenIds = EnumSet.of(first, rest);
            Token lastWSToken = null;
            int after = 0;
            do {
                String spaces;
                if (this.tokens.offset() >= this.endPos || this.eof) {
                    if (lastWSToken != null) {
                        this.lastBlankLines = 0;
                        this.lastBlankLinesTokenIndex = this.tokens.index() - 1;
                        this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    }
                    return null;
                }
                JavaTokenId id = (JavaTokenId)this.tokens.token().id();
                boolean contains = tokenIds.contains(id);
                if (!contains && id == JavaTokenId.IDENTIFIER) {
                    for (JavaTokenId javaTokenId : tokenIds) {
                        if (javaTokenId.fixedText() == null || !javaTokenId.fixedText().contentEquals(this.tokens.token().text())) continue;
                        contains = true;
                        break;
                    }
                    if (TokenUtilities.textEquals((CharSequence)this.tokens.token().text(), (CharSequence)"sealed") || TokenUtilities.textEquals((CharSequence)this.tokens.token().text(), (CharSequence)"permits")) {
                        contains = true;
                    }
                    if (TokenUtilities.textEquals((CharSequence)this.tokens.token().text(), (CharSequence)"non") && this.tokens.moveNext()) {
                        if (TokenUtilities.textEquals((CharSequence)this.tokens.token().text(), (CharSequence)"-") && this.tokens.moveNext()) {
                            if (TokenUtilities.textEquals((CharSequence)this.tokens.token().text(), (CharSequence)"sealed")) {
                                contains = true;
                            } else {
                                this.tokens.movePrevious();
                                this.tokens.movePrevious();
                            }
                        } else {
                            this.tokens.movePrevious();
                        }
                    }
                }
                if (contains) {
                    String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                    if (lastWSToken != null) {
                        if (spaces == null || !spaces.contentEquals(lastWSToken.text())) {
                            this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                        }
                    } else if (spaces != null && spaces.length() > 0) {
                        this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                    }
                    if (after > 0) {
                        this.col = this.indent();
                    }
                    this.col += this.tokens.token().length();
                    this.bof = false;
                    return this.tokens.moveNext() ? id : null;
                }
                switch (id) {
                    case WHITESPACE: {
                        lastWSToken = this.tokens.token();
                        break;
                    }
                    case LINE_COMMENT: {
                        if (lastWSToken != null) {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                        }
                        this.col = 0;
                        after = 1;
                        break;
                    }
                    case JAVADOC_COMMENT: {
                        if (lastWSToken != null) {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                            this.col = after > 0 ? this.indent() : ++this.col;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                            if (after > 0) {
                                this.col = this.indent();
                            }
                        }
                        String tokenText = this.tokens.token().text().toString();
                        int n = tokenText.lastIndexOf(10);
                        if (n >= 0) {
                            tokenText = tokenText.substring(n + 1);
                        }
                        this.col += this.getCol(tokenText);
                        this.reformatComment();
                        after = 2;
                        break;
                    }
                    case BLOCK_COMMENT: {
                        if (lastWSToken != null) {
                            String spaces2;
                            String string = after == 1 ? this.getIndent() : (spaces2 = after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            if (!spaces2.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces2));
                            }
                            lastWSToken = null;
                            this.col = after > 0 ? this.indent() : ++this.col;
                        } else {
                            String spaces2;
                            String string = after == 1 ? this.getIndent() : (spaces2 = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces2 != null && spaces2.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces2));
                            }
                            if (after > 0) {
                                this.col = this.indent();
                            }
                        }
                        String tokenText = this.tokens.token().text().toString();
                        int n = tokenText.lastIndexOf(10);
                        if (n >= 0) {
                            tokenText = tokenText.substring(n + 1);
                        }
                        this.col += this.getCol(tokenText);
                        this.reformatComment();
                        after = 0;
                        break;
                    }
                    default: {
                        if (lastWSToken != null) {
                            this.lastBlankLines = -1;
                            this.lastBlankLinesTokenIndex = this.tokens.index() - 1;
                            this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                        }
                        this.bof = false;
                        return null;
                    }
                }
            } while (this.tokens.moveNext());
            this.eof = true;
            return null;
        }

        private void space() {
            this.spaces(1);
        }

        private void spaces(int count) {
            this.spaces(count, false);
        }

        private boolean spaces(int count, boolean preserveNewline) {
            if (this.checkWrap != null && this.col > this.rightMargin && this.checkWrap.pos >= this.lastNewLineOffset) {
                throw this.checkWrap;
            }
            Token lastWSToken = null;
            boolean containedNewLine = false;
            int after = 0;
            do {
                if (this.tokens.offset() >= this.endPos) {
                    if (lastWSToken != null) {
                        this.tokens.movePrevious();
                    }
                    return containedNewLine;
                }
                switch ((JavaTokenId)this.tokens.token().id()) {
                    case WHITESPACE: {
                        lastWSToken = this.tokens.token();
                        break;
                    }
                    case LINE_COMMENT: {
                        String text;
                        String spaces;
                        containedNewLine = true;
                        if (lastWSToken != null) {
                            spaces = after == 1 ? this.getIndent() : (after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            text = lastWSToken.text().toString();
                            int idx = text.lastIndexOf(10);
                            if (idx >= 0 && preserveNewline) {
                                spaces = this.getNewlines(1) + this.getIndent();
                                this.lastBlankLines = 1;
                                this.lastBlankLinesTokenIndex = this.tokens.index();
                                this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                this.lastNewLineOffset = this.tokens.offset();
                            }
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                        }
                        this.col = 0;
                        after = 1;
                        break;
                    }
                    case JAVADOC_COMMENT: {
                        String text;
                        String spaces;
                        if (lastWSToken != null) {
                            spaces = after == 1 ? this.getIndent() : (after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            text = lastWSToken.text().toString();
                            int idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                containedNewLine = true;
                                if (preserveNewline) {
                                    spaces = this.getNewlines(1) + this.getIndent();
                                    after = 3;
                                    this.lastBlankLines = 1;
                                    this.lastBlankLinesTokenIndex = this.tokens.index();
                                    this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                    this.lastNewLineOffset = this.tokens.offset();
                                }
                            }
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                            this.col = after > 0 ? this.indent() : ++this.col;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                            if (after > 0) {
                                this.col = this.indent();
                            }
                        }
                        String tokenText = this.tokens.token().text().toString();
                        int idx = tokenText.lastIndexOf(10);
                        if (idx >= 0) {
                            tokenText = tokenText.substring(idx + 1);
                        }
                        this.col += this.getCol(tokenText);
                        this.reformatComment();
                        after = 2;
                        break;
                    }
                    case BLOCK_COMMENT: {
                        String text;
                        String spaces;
                        if (lastWSToken != null) {
                            spaces = after == 1 ? this.getIndent() : (after == 2 ? this.getNewlines(1) + this.getIndent() : SPACE);
                            text = lastWSToken.text().toString();
                            int idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                containedNewLine = true;
                                if (preserveNewline) {
                                    spaces = this.getNewlines(1) + this.getIndent();
                                    after = 3;
                                    this.lastBlankLines = 1;
                                    this.lastBlankLinesTokenIndex = this.tokens.index();
                                    this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                    this.lastNewLineOffset = this.tokens.offset();
                                }
                            }
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                            lastWSToken = null;
                            this.col = after > 0 ? this.indent() : ++this.col;
                        } else {
                            String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : null);
                            if (spaces != null && spaces.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                            }
                            if (after > 0) {
                                this.col = this.indent();
                            }
                        }
                        String tokenText = this.tokens.token().text().toString();
                        int idx = tokenText.lastIndexOf(10);
                        if (idx >= 0) {
                            tokenText = tokenText.substring(idx + 1);
                        }
                        this.col += this.getCol(tokenText);
                        this.reformatComment();
                        after = 0;
                        break;
                    }
                    default: {
                        String spaces;
                        String text;
                        String string = after == 1 ? this.getIndent() : (spaces = after == 2 ? this.getNewlines(1) + this.getIndent() : this.getSpaces(count));
                        if (lastWSToken != null) {
                            text = lastWSToken.text().toString();
                            int idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                containedNewLine = true;
                                if (preserveNewline) {
                                    spaces = this.getNewlines(1) + this.getIndent();
                                    after = 3;
                                    this.lastBlankLines = 1;
                                    this.lastBlankLinesTokenIndex = this.tokens.index();
                                    this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                                    this.lastNewLineOffset = this.tokens.offset();
                                }
                            }
                            if (!spaces.contentEquals(lastWSToken.text())) {
                                this.addDiff(new Diff(this.tokens.offset() - lastWSToken.length(), this.tokens.offset(), spaces));
                            }
                        } else if (spaces.length() > 0) {
                            this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), spaces));
                        }
                        this.col = after > 0 ? this.indent() : (this.col += count);
                        return containedNewLine;
                    }
                }
            } while (this.tokens.moveNext());
            return containedNewLine;
        }

        private void newline() {
            this.blankLines(0);
        }

        private void blankLines(int count) {
            int maxCount;
            if (this.checkWrap != null && this.col > this.rightMargin && this.checkWrap.pos >= this.lastNewLineOffset) {
                throw this.checkWrap;
            }
            int n = maxCount = this.bof ? 0 : this.maxPreservedBlankLines;
            if (maxCount < count) {
                maxCount = count;
            }
            if (!this.bof && this.templateEdit && maxCount < 1) {
                maxCount = 1;
            }
            if (this.lastBlankLinesTokenIndex < 0) {
                this.lastBlankLines = count;
                this.lastBlankLinesTokenIndex = this.tokens.index();
                this.lastBlankLinesDiff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            } else if (this.lastBlankLines < count) {
                this.lastBlankLines = count;
                this.rollback(this.lastBlankLinesTokenIndex, this.lastBlankLinesTokenIndex, this.lastBlankLinesDiff);
            } else {
                Diff diff;
                Diff diff2 = diff = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                if (diff != null && diff.end == this.tokens.offset()) {
                    String spaces;
                    if (diff.text != null) {
                        int idx = diff.text.lastIndexOf(10);
                        if (idx < 0) {
                            diff.text = this.getIndent();
                        } else {
                            diff.text = diff.text.substring(0, idx + 1) + this.getIndent();
                        }
                    }
                    String string = spaces = diff.text != null ? diff.text : this.getIndent();
                    if (spaces.equals(this.fText.substring(diff.start, diff.end))) {
                        this.diffs.removeFirst();
                    }
                } else if (this.tokens.movePrevious()) {
                    if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                        String text = this.tokens.token().text().toString();
                        int idx = text.lastIndexOf(10);
                        if (idx >= 0) {
                            text = text.substring(idx + 1);
                            String ind = this.getIndent();
                            if (!ind.equals(text)) {
                                this.addDiff(new Diff(this.tokens.offset() + idx + 1, this.tokens.offset() + this.tokens.token().length(), ind));
                            }
                        } else if (this.tokens.movePrevious()) {
                            if (this.tokens.token().id() == JavaTokenId.LINE_COMMENT) {
                                this.tokens.moveNext();
                                String ind = this.getIndent();
                                if (!ind.equals(text)) {
                                    this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset() + this.tokens.token().length(), ind));
                                }
                            } else {
                                this.tokens.moveNext();
                            }
                        }
                    }
                    this.tokens.moveNext();
                }
                this.col = this.indent();
                return;
            }
            this.lastNewLineOffset = this.tokens.offset();
            this.checkWrap = null;
            Token lastToken = null;
            int after = 0;
            Diff pendingDiff = null;
            String pendingText = null;
            int beforeCnt = 0;
            do {
                if (this.tokens.offset() >= this.endPos) {
                    return;
                }
                switch ((JavaTokenId)this.tokens.token().id()) {
                    case WHITESPACE: {
                        lastToken = this.tokens.token();
                        break;
                    }
                    case BLOCK_COMMENT: {
                        String ind;
                        int lastIdx;
                        int idx;
                        String text;
                        int offset;
                        if (this.tokens.index() > 1 && after != 1) {
                            if (maxCount < Integer.MAX_VALUE) {
                                ++maxCount;
                            }
                            ++count;
                        }
                        if (lastToken != null) {
                            offset = this.tokens.offset() - lastToken.length();
                            text = lastToken.text().toString();
                            idx = 0;
                            lastIdx = 0;
                            while (maxCount > 0 && (idx = text.indexOf(10, lastIdx)) >= 0) {
                                if (idx > lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx, null));
                                }
                                lastIdx = idx + 1;
                                --maxCount;
                                --count;
                                --beforeCnt;
                            }
                            idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                if (idx > lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx + 1, null));
                                }
                                lastIdx = idx + 1;
                            }
                            if (lastIdx == 0 && count < 0 && after != 1) {
                                count = 0;
                            }
                            if (pendingDiff != null) {
                                pendingDiff.text = beforeCnt < 0 ? this.getIndent() : this.getNewlines(count) + this.getIndent();
                                if (!pendingDiff.text.equals(pendingText)) {
                                    this.addDiff(pendingDiff);
                                    pendingDiff = null;
                                }
                                ind = after == 3 ? SPACE : (beforeCnt < 0 ? this.getNewlines(count) + this.getIndent() : this.getIndent());
                            } else {
                                String string = ind = after == 3 ? SPACE : this.getNewlines(count) + this.getIndent();
                            }
                            if (!ind.equals(text.substring(lastIdx))) {
                                this.addDiff(new Diff(offset + lastIdx, this.tokens.offset(), ind));
                            }
                            lastToken = null;
                            this.col = after == 3 ? this.col + 1 : this.indent();
                        }
                        this.reformatComment();
                        count = 0;
                        after = 3;
                        break;
                    }
                    case JAVADOC_COMMENT: {
                        String ind;
                        int lastIdx;
                        int idx;
                        String text;
                        int offset;
                        if (this.tokens.index() > 1 && after != 1) {
                            if (maxCount < Integer.MAX_VALUE) {
                                ++maxCount;
                            }
                            ++count;
                        }
                        if (lastToken != null) {
                            offset = this.tokens.offset() - lastToken.length();
                            text = lastToken.text().toString();
                            idx = 0;
                            lastIdx = 0;
                            while (maxCount > 0 && (idx = text.indexOf(10, lastIdx)) >= 0) {
                                if (idx > lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx, null));
                                }
                                lastIdx = idx + 1;
                                --maxCount;
                                --count;
                                --beforeCnt;
                            }
                            idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                after = 0;
                                if (idx >= lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx + 1, null));
                                }
                                lastIdx = idx + 1;
                            }
                            if (lastIdx == 0 && count < 0 && after != 1) {
                                count = 0;
                            }
                            if (pendingDiff != null) {
                                pendingDiff.text = beforeCnt < 0 ? this.getIndent() : this.getNewlines(count) + this.getIndent();
                                if (!pendingDiff.text.equals(pendingText)) {
                                    this.addDiff(pendingDiff);
                                    pendingDiff = null;
                                }
                                ind = after == 3 ? SPACE : (beforeCnt < 0 ? this.getNewlines(count) + this.getIndent() : this.getIndent());
                            } else {
                                String string = ind = after == 3 ? SPACE : this.getNewlines(count) + this.getIndent();
                            }
                            if (!ind.equals(text.substring(lastIdx))) {
                                this.addDiff(new Diff(offset + lastIdx, this.tokens.offset(), ind));
                            }
                            lastToken = null;
                            this.col = after == 3 ? this.col + 1 : this.indent();
                        } else {
                            String text2 = this.getNewlines(count) + this.getIndent();
                            if (text2.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), text2));
                            }
                            this.col = this.indent();
                        }
                        this.reformatComment();
                        count = 0;
                        after = 2;
                        break;
                    }
                    case LINE_COMMENT: {
                        String indent;
                        int lastIdx;
                        int idx;
                        String text;
                        int offset;
                        if (lastToken != null) {
                            offset = this.tokens.offset() - lastToken.length();
                            text = lastToken.text().toString();
                            if (this.tokens.index() > 1 && after != 1 && text.indexOf(10) >= 0) {
                                if (maxCount < Integer.MAX_VALUE) {
                                    ++maxCount;
                                }
                                ++count;
                            }
                            idx = 0;
                            lastIdx = 0;
                            while (maxCount > 0 && (idx = text.indexOf(10, lastIdx)) >= 0) {
                                if (idx > lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx, null));
                                }
                                lastIdx = idx + 1;
                                --maxCount;
                                --count;
                                if (pendingText != null) continue;
                                ++beforeCnt;
                            }
                            idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                if (idx >= lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx + 1, null));
                                }
                                lastIdx = idx + 1;
                            }
                            if (lastIdx == 0 && after == 1) {
                                indent = this.getIndent();
                                if (!indent.equals(text)) {
                                    this.addDiff(new Diff(offset, this.tokens.offset(), indent));
                                }
                            } else if (lastIdx > 0 && lastIdx < lastToken.length()) {
                                pendingText = text.substring(lastIdx);
                                indent = this.getIndent();
                                if (!indent.equals(pendingText)) {
                                    this.addDiff(new Diff(offset + lastIdx, this.tokens.offset(), indent));
                                    pendingText = null;
                                } else {
                                    pendingDiff = new Diff(offset + lastIdx, this.tokens.offset(), null);
                                }
                            }
                            lastToken = null;
                        }
                        after = 1;
                        break;
                    }
                    default: {
                        String indent;
                        int lastIdx;
                        int idx;
                        String text;
                        int offset;
                        if (this.tokens.index() > 1 && after != 1) {
                            if (maxCount < Integer.MAX_VALUE) {
                                ++maxCount;
                            }
                            ++count;
                        }
                        if (lastToken != null) {
                            offset = this.tokens.offset() - lastToken.length();
                            text = lastToken.text().toString();
                            idx = 0;
                            lastIdx = 0;
                            while (maxCount > 0 && (idx = text.indexOf(10, lastIdx)) >= 0) {
                                if (idx > 0) {
                                    if (this.templateEdit && idx >= lastIdx) {
                                        this.addDiff(new Diff(offset + lastIdx, offset + idx, this.getIndent()));
                                    } else if (idx > lastIdx) {
                                        this.addDiff(new Diff(offset + lastIdx, offset + idx, null));
                                    }
                                }
                                lastIdx = idx + 1;
                                --maxCount;
                                --count;
                                --beforeCnt;
                            }
                            idx = text.lastIndexOf(10);
                            if (idx >= 0) {
                                after = 0;
                                if (idx >= lastIdx) {
                                    this.addDiff(new Diff(offset + lastIdx, offset + idx + 1, null));
                                }
                                lastIdx = idx + 1;
                            }
                            if (lastIdx == 0 && count < 0 && after != 1) {
                                count = 0;
                            }
                            if (pendingDiff != null) {
                                pendingDiff.text = beforeCnt < 0 ? this.getIndent() : this.getNewlines(count) + this.getIndent();
                                if (!pendingDiff.text.equals(pendingText)) {
                                    this.addDiff(pendingDiff);
                                    pendingDiff = null;
                                }
                                indent = after == 3 ? SPACE : (beforeCnt < 0 ? this.getNewlines(count) + this.getIndent() : this.getIndent());
                            } else {
                                String string = indent = after == 3 ? SPACE : this.getNewlines(count) + this.getIndent();
                            }
                            if (!indent.equals(text.substring(lastIdx))) {
                                this.addDiff(new Diff(offset + lastIdx, this.tokens.offset(), indent));
                            }
                        } else {
                            String text3 = this.getNewlines(count) + this.getIndent();
                            if (text3.length() > 0) {
                                this.addDiff(new Diff(this.tokens.offset(), this.tokens.offset(), text3));
                            }
                        }
                        this.col = this.indent();
                        return;
                    }
                }
            } while (this.tokens.moveNext());
            this.eof = true;
        }

        private void rollback(int index, int col, Diff diff) {
            this.tokens.moveIndex(index);
            this.tokens.moveNext();
            if (diff == null) {
                this.diffs.clear();
            } else {
                while (!this.diffs.isEmpty() && this.diffs.getFirst() != diff) {
                    this.diffs.removeFirst();
                }
            }
            this.col = col;
            if (index < this.lastBlankLinesTokenIndex) {
                this.lastBlankLinesTokenIndex = -1;
            }
        }

        private void appendToDiff(String s) {
            Diff d;
            int offset = this.tokens.offset();
            Diff diff = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            if (d != null && d.getEndOffset() == offset) {
                d.text = d.text + s;
            } else {
                this.addDiff(new Diff(offset, offset, s));
            }
        }

        private void addDiff(Diff diff) {
            Diff d;
            Diff diff2 = d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
            if (d == null || d.getStartOffset() <= diff.getStartOffset()) {
                this.diffs.addFirst(diff);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int wrapToken(CodeStyle.WrapStyle wrapStyle, int spacesCnt, JavaTokenId first, JavaTokenId ... rest) {
            int ret = -1;
            switch (wrapStyle) {
                case WRAP_ALWAYS: {
                    this.newline();
                    ret = this.col;
                    this.accept(first, rest);
                    break;
                }
                case WRAP_IF_LONG: {
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    int o = this.tokens.offset();
                    WrapAbort oldCheckWrap = this.checkWrap;
                    this.checkWrap = new WrapAbort(o);
                    try {
                        this.spaces(spacesCnt, true);
                        ret = this.col;
                        this.accept(first, rest);
                    }
                    catch (WrapAbort wrapAbort) {
                    }
                    finally {
                        this.checkWrap = oldCheckWrap;
                    }
                    if (this.col <= this.rightMargin || o < this.lastNewLineOffset) break;
                    this.rollback(index, c, d);
                    this.newline();
                    ret = this.col;
                    this.accept(first, rest);
                    break;
                }
                case WRAP_NEVER: {
                    this.spaces(spacesCnt, true);
                    ret = this.col;
                    this.accept(first, rest);
                }
            }
            return ret;
        }

        private int wrapTree(CodeStyle.WrapStyle wrapStyle, int alignIndent, int spacesCnt, Tree tree) {
            return this.wrapTree(wrapStyle, alignIndent, spacesCnt, true, tree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int wrapTree(CodeStyle.WrapStyle wrapStyle, int alignIndent, int spacesCnt, boolean preserveNewLine, Tree tree) {
            int ret = -1;
            int oldLast = this.lastIndent;
            try {
                switch (wrapStyle) {
                    case WRAP_ALWAYS: {
                        int old = this.indent;
                        try {
                            if (alignIndent >= 0) {
                                this.indent = this.continuationIndent ? alignIndent - this.continuationIndentSize : alignIndent;
                            }
                            this.newline();
                            ret = this.col;
                            this.scan(tree, null);
                            return ret;
                        }
                        finally {
                            this.indent = old;
                        }
                    }
                    case WRAP_IF_LONG: {
                        int index = this.tokens.index();
                        int c = this.col;
                        Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                        int old = this.indent;
                        WrapAbort oldCheckWrap = this.checkWrap;
                        int o = this.tokens.offset();
                        this.checkWrap = new WrapAbort(this.tokens.offset());
                        try {
                            try {
                                if (alignIndent >= 0) {
                                    this.indent = this.continuationIndent ? alignIndent - this.continuationIndentSize : alignIndent;
                                }
                                this.spaces(spacesCnt, preserveNewLine);
                                ret = this.col;
                                this.scan(tree, null);
                            }
                            finally {
                                this.indent = old;
                            }
                        }
                        catch (WrapAbort wrapAbort) {
                        }
                        finally {
                            this.checkWrap = oldCheckWrap;
                        }
                        if (this.col <= this.rightMargin) return ret;
                        if (o < this.lastNewLineOffset) return ret;
                        this.rollback(index, c, d);
                        try {
                            this.indent = alignIndent >= 0 ? (this.continuationIndent ? alignIndent - this.continuationIndentSize : alignIndent) : old;
                            this.newline();
                            ret = this.col;
                            this.scan(tree, null);
                            return ret;
                        }
                        finally {
                            this.indent = old;
                        }
                    }
                    case WRAP_NEVER: {
                        int old = this.indent;
                        try {
                            if (alignIndent >= 0) {
                                this.indent = this.continuationIndent ? alignIndent - this.continuationIndentSize : alignIndent;
                            }
                            this.spaces(spacesCnt, preserveNewLine);
                            ret = this.col;
                            this.scan(tree, null);
                            return ret;
                        }
                        finally {
                            this.indent = old;
                        }
                    }
                }
                return ret;
            }
            finally {
                this.lastIndent = oldLast;
            }
        }

        private int wrapOperatorAndTree(CodeStyle.WrapStyle wrapStyle, int alignIndent, int spacesCnt, Tree tree) {
            return this.wrapOperatorAndTree(wrapStyle, alignIndent, spacesCnt, spacesCnt, -1, tree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private int wrapOperatorAndTree(CodeStyle.WrapStyle wrapStyle, int alignIndent, int spacesCntBeforeOp, int spacesCntAfterOp, int treeIndent, Tree tree) {
            ret = -1;
            switch (3.$SwitchMap$org$netbeans$api$java$source$CodeStyle$WrapStyle[wrapStyle.ordinal()]) {
                case 1: {
                    old = this.indent;
                    oldLast = this.lastIndent;
                    oldContinuationIndent = this.continuationIndent;
                    try {
                        if (alignIndent >= 0) {
                            this.indent = this.continuationIndent != false ? alignIndent - this.continuationIndentSize : alignIndent;
                        }
                        this.newline();
                    }
                    finally {
                        this.indent = old;
                    }
                    ret = this.col;
                    if ("operator".equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                        this.col += this.tokens.token().length();
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.tokens.moveNext();
                    }
                    try {
                        if (tree.getKind() == Tree.Kind.BLOCK) {
                            this.spaces(spacesCntAfterOp);
                            this.continuationIndent = false;
                        } else if (tree.getKind() != Tree.Kind.NEW_ARRAY || ((NewArrayTree)tree).getType() != null || this.cs.getOtherBracePlacement() == CodeStyle.BracePlacement.SAME_LINE) {
                            this.spaces(spacesCntAfterOp);
                        } else {
                            this.continuationIndent = false;
                        }
                        if (treeIndent >= 0) {
                            this.indent = treeIndent;
                        }
                        this.scan(tree, null);
                        break;
                    }
                    finally {
                        this.lastIndent = oldLast;
                        this.continuationIndent = oldContinuationIndent;
                    }
                }
                case 2: {
                    index = this.tokens.index();
                    c = this.col;
                    d = this.diffs.isEmpty() != false ? null : this.diffs.getFirst();
                    old = this.indent;
                    oldLast = this.lastIndent;
                    oldContinuationIndent = this.continuationIndent;
                    o = this.tokens.offset();
                    oldCheckWrap = this.checkWrap;
                    this.checkWrap = new WrapAbort(o);
                    try {
                        try {
                            if (alignIndent >= 0) {
                                this.indent = this.continuationIndent != false ? alignIndent - this.continuationIndentSize : alignIndent;
                                this.indent = alignIndent;
                            }
                            this.spaces(spacesCntBeforeOp, true);
                        }
                        finally {
                            this.indent = old;
                            this.lastIndent = oldLast;
                        }
                        ret = this.col;
                        if ("operator".equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                            this.col += this.tokens.token().length();
                            this.lastBlankLines = -1;
                            this.lastBlankLinesTokenIndex = -1;
                            this.tokens.moveNext();
                        }
                        try {
                            if (tree.getKind() == Tree.Kind.BLOCK) {
                                this.spaces(spacesCntAfterOp);
                                this.continuationIndent = false;
                            } else if (tree.getKind() != Tree.Kind.NEW_ARRAY || ((NewArrayTree)tree).getType() != null || this.cs.getOtherBracePlacement() == CodeStyle.BracePlacement.SAME_LINE) {
                                this.spaces(spacesCntAfterOp);
                            } else {
                                this.continuationIndent = false;
                            }
                            if (treeIndent >= 0) {
                                this.indent = treeIndent;
                            }
                            this.scan(tree, null);
                        }
                        finally {
                            this.continuationIndent = oldContinuationIndent;
                        }
                    }
                    catch (WrapAbort var16_28) {
                    }
                    finally {
                        this.checkWrap = oldCheckWrap;
                    }
                    if (this.col <= this.rightMargin || o < this.lastNewLineOffset) break;
                    this.rollback(index, c, d);
                    try {
                        if (alignIndent >= 0) {
                            this.indent = this.continuationIndent != false ? alignIndent - this.continuationIndentSize : alignIndent;
                        } else {
                            this.indent = old;
                            this.lastIndent = oldLast;
                            this.continuationIndent = oldContinuationIndent;
                        }
                        this.newline();
                    }
                    finally {
                        this.indent = old;
                        this.lastIndent = oldLast;
                        this.continuationIndent = oldContinuationIndent;
                    }
                    ret = this.col;
                    if ("operator".equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                        this.col += this.tokens.token().length();
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.tokens.moveNext();
                    }
                    try {
                        if (tree.getKind() == Tree.Kind.BLOCK) {
                            this.spaces(spacesCntAfterOp);
                            this.continuationIndent = false;
                        } else if (tree.getKind() != Tree.Kind.NEW_ARRAY || ((NewArrayTree)tree).getType() != null || this.cs.getOtherBracePlacement() == CodeStyle.BracePlacement.SAME_LINE) {
                            this.spaces(spacesCntAfterOp);
                        } else {
                            this.continuationIndent = false;
                        }
                        if (treeIndent >= 0) {
                            this.indent = treeIndent;
                        }
                        this.scan(tree, null);
                        break;
                    }
                    finally {
                        this.continuationIndent = oldContinuationIndent;
                    }
                }
                case 3: {
                    index = this.tokens.index();
                    c = this.col;
                    d = this.diffs.isEmpty() != false ? null : this.diffs.getFirst();
                    old = this.indent;
                    oldLast = this.lastIndent;
                    oldContinuationIndent = this.continuationIndent;
                    try {
                        if (alignIndent >= 0) {
                            this.indent = this.continuationIndent != false ? alignIndent - this.continuationIndentSize : alignIndent;
                        }
                        this.spaces(spacesCntBeforeOp, true);
                    }
                    finally {
                        this.indent = old;
                        this.lastIndent = oldLast;
                    }
                    ret = this.col;
                    if ("operator".equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                        this.col += this.tokens.token().length();
                        this.lastBlankLines = -1;
                        this.lastBlankLinesTokenIndex = -1;
                        this.tokens.moveNext();
                    }
                    try {
                        if (tree.getKind() != Tree.Kind.BLOCK) ** GOTO lbl181
                        if (this.cs.getOtherBracePlacement() != CodeStyle.BracePlacement.SAME_LINE) ** GOTO lbl205
                        if (!this.spaces(spacesCntAfterOp, false)) ** GOTO lbl179
                        this.rollback(index, c, d);
                        old = this.indent;
                        oldLast = this.lastIndent;
                        try {
                            if (alignIndent >= 0) {
                                this.indent = this.continuationIndent != false ? alignIndent - this.continuationIndentSize : alignIndent;
                            }
                            this.newline();
                        }
                        finally {
                            this.indent = old;
                            this.lastIndent = oldLast;
                        }
                        ret = this.col;
                        if ("operator".equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                            this.col += this.tokens.token().length();
                            this.lastBlankLines = -1;
                            this.lastBlankLinesTokenIndex = -1;
                            this.tokens.moveNext();
                        }
                        this.spaces(spacesCntAfterOp);
lbl179:
                        // 2 sources

                        this.continuationIndent = this.isLastIndentContinuation;
                        ** GOTO lbl205
lbl181:
                        // 1 sources

                        if (tree.getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)tree).getType() == null && this.cs.getOtherBracePlacement() != CodeStyle.BracePlacement.SAME_LINE) ** GOTO lbl204
                        if (!this.spaces(spacesCntAfterOp, false)) ** GOTO lbl205
                        this.rollback(index, c, d);
                        old = this.indent;
                        oldLast = this.lastIndent;
                        try {
                            if (alignIndent >= 0) {
                                this.indent = this.continuationIndent != false ? alignIndent - this.continuationIndentSize : alignIndent;
                            }
                            this.newline();
                        }
                        finally {
                            this.indent = old;
                            this.lastIndent = oldLast;
                        }
                        ret = this.col;
                        if ("operator".equals(((JavaTokenId)this.tokens.token().id()).primaryCategory())) {
                            this.col += this.tokens.token().length();
                            this.lastBlankLines = -1;
                            this.lastBlankLinesTokenIndex = -1;
                            this.tokens.moveNext();
                        }
                        this.spaces(spacesCntAfterOp);
                        ** GOTO lbl205
lbl204:
                        // 1 sources

                        this.continuationIndent = this.isLastIndentContinuation;
lbl205:
                        // 5 sources

                        if (treeIndent >= 0) {
                            this.indent = treeIndent;
                        }
                        this.scan(tree, null);
                        break;
                    }
                    finally {
                        this.continuationIndent = oldContinuationIndent;
                    }
                }
            }
            return ret;
        }

        private boolean wrapStatement(CodeStyle.WrapStyle wrapStyle, CodeStyle.BracesGenerationStyle bracesGenerationStyle, int spacesCnt, StatementTree tree) {
            return this.wrapStatement(wrapStyle, bracesGenerationStyle, spacesCnt, true, tree);
        }

        private boolean wrapStatement(CodeStyle.WrapStyle wrapStyle, CodeStyle.BracesGenerationStyle bracesGenerationStyle, int spacesCnt, boolean preserveNewLine, StatementTree tree) {
            Tree.Kind kind = tree.getKind();
            if (kind == Tree.Kind.EMPTY_STATEMENT) {
                this.scan((Tree)tree, null);
                return true;
            }
            if (kind == Tree.Kind.BLOCK || kind == Tree.Kind.TRY || kind == Tree.Kind.SYNCHRONIZED) {
                Iterator<? extends StatementTree> stats;
                if (kind == Tree.Kind.BLOCK && bracesGenerationStyle == CodeStyle.BracesGenerationStyle.ELIMINATE && (stats = ((BlockTree)tree).getStatements().iterator()).hasNext()) {
                    StatementTree stat = stats.next();
                    if (!stats.hasNext() && stat.getKind() != Tree.Kind.VARIABLE) {
                        Diff d;
                        this.accept(JavaTokenId.LBRACE, new JavaTokenId[0]);
                        int start = this.tokens.offset() - 1;
                        while (!this.diffs.isEmpty() && (d = this.diffs.getFirst()) != null && d.getStartOffset() >= start) {
                            this.diffs.removeFirst();
                        }
                        this.addDiff(new Diff(start, this.tokens.offset(), null));
                        int old = this.indent;
                        this.indent = this.lastIndent + this.indentSize;
                        this.wrapTree(wrapStyle, -1, spacesCnt, preserveNewLine, stat);
                        this.indent = old;
                        this.accept(JavaTokenId.RBRACE, new JavaTokenId[0]);
                        this.tokens.moveIndex(this.tokens.index() - 2);
                        this.tokens.moveNext();
                        if (this.tokens.token().id() == JavaTokenId.WHITESPACE) {
                            start = this.tokens.offset();
                            if (this.tokens.movePrevious()) {
                                if (this.tokens.token().id() == JavaTokenId.LINE_COMMENT) {
                                    --start;
                                }
                                this.tokens.moveNext();
                            }
                            this.tokens.moveNext();
                        } else {
                            this.tokens.moveNext();
                            start = this.tokens.offset();
                        }
                        this.tokens.moveNext();
                        while (!(this.diffs.isEmpty() || (d = this.diffs.getFirst()) == null || d.getStartOffset() < start || d.text != null && d.text.indexOf(125) >= 0)) {
                            this.diffs.removeFirst();
                        }
                        this.addDiff(new Diff(start, this.tokens.offset(), null));
                        return false;
                    }
                }
                this.scan((Tree)tree, null);
                return true;
            }
            if (bracesGenerationStyle == CodeStyle.BracesGenerationStyle.GENERATE) {
                this.scan((Tree)new FakeBlock(tree), null);
                return true;
            }
            int old = this.indent;
            this.indent = this.lastIndent + this.indentSize;
            this.wrapTree(wrapStyle, -1, spacesCnt, preserveNewLine, tree);
            this.indent = old;
            return false;
        }

        private void wrapList(CodeStyle.WrapStyle wrapStyle, boolean align, boolean prependSpace, JavaTokenId separator, java.util.List<? extends Tree> trees) {
            this.wrapList(wrapStyle, align, prependSpace, separator, true, trees);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wrapList(CodeStyle.WrapStyle wrapStyle, boolean align, boolean prependSpace, JavaTokenId separator, boolean wrapAfterSeparator, java.util.List<? extends Tree> trees) {
            boolean spaceAfterSeparator;
            boolean spaceBeforeSeparator;
            boolean first = true;
            int alignIndent = -1;
            switch (separator) {
                case COMMA: {
                    spaceBeforeSeparator = this.cs.spaceBeforeComma();
                    spaceAfterSeparator = this.cs.spaceAfterComma();
                    break;
                }
                case SEMICOLON: {
                    spaceBeforeSeparator = this.cs.spaceBeforeSemi();
                    spaceAfterSeparator = this.cs.spaceAfterSemi();
                    break;
                }
                default: {
                    spaceBeforeSeparator = spaceAfterSeparator = this.cs.spaceAroundBinaryOps();
                }
            }
            for (Tree tree : trees) {
                boolean containedNewLine;
                if (this.wrapAnnotation && tree.getKind() == Tree.Kind.ANNOTATION) {
                    if (!first) {
                        containedNewLine = this.spaces(spaceBeforeSeparator ? 1 : 0, false);
                        if (separator.equals((Object)this.accept(separator, new JavaTokenId[0])) && containedNewLine) {
                            this.newline();
                        }
                    }
                    this.wrapTree(CodeStyle.WrapStyle.WRAP_ALWAYS, alignIndent, spaceAfterSeparator ? 1 : 0, tree);
                } else if (tree.getKind() == Tree.Kind.ERRONEOUS) {
                    this.scan(tree, null);
                } else if (first) {
                    int index = this.tokens.index();
                    int c = this.col;
                    Diff d = this.diffs.isEmpty() ? null : this.diffs.getFirst();
                    this.spaces(prependSpace ? 1 : 0, true);
                    if (align) {
                        alignIndent = this.col;
                    }
                    if (wrapStyle == CodeStyle.WrapStyle.WRAP_NEVER || c <= this.indent()) {
                        this.scan(tree, null);
                    } else {
                        int o = this.tokens.offset();
                        WrapAbort oldCheckWrap = this.checkWrap;
                        this.checkWrap = new WrapAbort(o);
                        try {
                            this.scan(tree, null);
                        }
                        catch (WrapAbort wrapAbort) {
                        }
                        finally {
                            this.checkWrap = oldCheckWrap;
                        }
                        if (this.col > this.rightMargin && o >= this.lastNewLineOffset) {
                            this.rollback(index, c, d);
                            this.newline();
                            if (align) {
                                alignIndent = this.col;
                            }
                            this.scan(tree, null);
                        }
                    }
                } else if (wrapAfterSeparator) {
                    containedNewLine = this.spaces(spaceBeforeSeparator ? 1 : 0, false);
                    if (separator.equals((Object)this.accept(separator, new JavaTokenId[0])) && containedNewLine) {
                        this.newline();
                    }
                    this.wrapTree(wrapStyle, alignIndent, spaceAfterSeparator ? 1 : 0, tree);
                } else {
                    this.wrapOperatorAndTree(wrapStyle, alignIndent, spaceAfterSeparator ? 1 : 0, tree);
                }
                first = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanMethodCall(MethodInvocationTree node) {
            java.util.List<? extends Tree> targs = node.getTypeArguments();
            if (targs != null && !targs.isEmpty()) {
                JavaTokenId accepted;
                if (JavaTokenId.LT == this.accept(JavaTokenId.LT, new JavaTokenId[0])) {
                    ++this.tpLevel;
                }
                Iterator<? extends Tree> it = targs.iterator();
                while (it.hasNext()) {
                    Tree targ = it.next();
                    this.scan(targ, null);
                    if (!it.hasNext()) continue;
                    this.spaces(this.cs.spaceBeforeComma() ? 1 : 0);
                    this.accept(JavaTokenId.COMMA, new JavaTokenId[0]);
                    this.spaces(this.cs.spaceAfterComma() ? 1 : 0);
                }
                if (this.tpLevel > 0 && (accepted = this.accept(JavaTokenId.GT, JavaTokenId.GTGT, JavaTokenId.GTGTGT)) != null) {
                    switch (accepted) {
                        case GTGTGT: {
                            this.tpLevel -= 3;
                            break;
                        }
                        case GTGT: {
                            this.tpLevel -= 2;
                            break;
                        }
                        case GT: {
                            --this.tpLevel;
                        }
                    }
                }
            }
            this.accept(JavaTokenId.IDENTIFIER, JavaTokenId.UNDERSCORE, JavaTokenId.THIS, JavaTokenId.SUPER);
            this.spaces(this.cs.spaceBeforeMethodCallParen() ? 1 : 0);
            this.accept(JavaTokenId.LPAREN, new JavaTokenId[0]);
            boolean old = this.continuationIndent;
            try {
                java.util.List<? extends ExpressionTree> args = node.getArguments();
                if (args != null && !args.isEmpty()) {
                    int oldIndent = this.indent;
                    int oldLastIndent = this.lastIndent;
                    boolean continuation = this.isLastIndentContinuation;
                    if (continuation) {
                        this.indent = this.indent();
                        this.isLastIndentContinuation = false;
                    }
                    try {
                        this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                        this.wrapList(this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs(), false, JavaTokenId.COMMA, args);
                    }
                    finally {
                        this.indent = oldIndent;
                        this.lastIndent = oldLastIndent;
                        this.continuationIndent = continuation;
                    }
                    this.spaces(this.cs.spaceWithinMethodCallParens() ? 1 : 0, true);
                }
                this.accept(JavaTokenId.RPAREN, new JavaTokenId[0]);
            }
            finally {
                this.continuationIndent = old;
            }
        }

        private void reformatComment() {
            String sub;
            char c;
            int actionType;
            int checkOffset;
            Iterator it;
            int i;
            if (this.tokens.token().id() != JavaTokenId.BLOCK_COMMENT && this.tokens.token().id() != JavaTokenId.JAVADOC_COMMENT) {
                return;
            }
            TokenSequence javadocTokens = null;
            TokenSequence embedded = this.tokens.embedded();
            if (embedded != null) {
                if (JavadocTokenId.language().equals((Object)embedded.language())) {
                    javadocTokens = embedded;
                } else {
                    return;
                }
            }
            String text = this.tokens.token().text().toString();
            int offset = this.tokens.offset();
            LinkedList<Pair<Integer, Integer>> marks = new LinkedList<Pair<Integer, Integer>>();
            int maxParamNameLength = 0;
            int maxExcNameLength = 0;
            int initTextEndOffset = Integer.MAX_VALUE;
            if (javadocTokens != null) {
                int state = 0;
                int currWSOffset = -1;
                int lastWSOffset = -1;
                int identStart = -1;
                int lastNLOffset = -1;
                int lastAddedNLOffset = -1;
                boolean afterText = false;
                boolean insideTag = false;
                int nestedParenCnt = 0;
                StringBuilder cseq = null;
                Pair toAdd = null;
                Pair nlAdd = null;
                block15: while (javadocTokens.moveNext()) {
                    switch ((JavadocTokenId)javadocTokens.token().id()) {
                        case TAG: {
                            int newState;
                            toAdd = null;
                            nlAdd = null;
                            String tokenText = javadocTokens.token().text().toString();
                            if (JDOC_PARAM_TAG.equalsIgnoreCase(tokenText)) {
                                newState = 1;
                            } else if (JDOC_RETURN_TAG.equalsIgnoreCase(tokenText)) {
                                newState = 3;
                            } else if (JDOC_THROWS_TAG.equalsIgnoreCase(tokenText) || JDOC_EXCEPTION_TAG.equalsIgnoreCase(tokenText)) {
                                newState = 4;
                            } else {
                                if (JDOC_LINK_TAG.equalsIgnoreCase(tokenText) || JDOC_LINKPLAIN_TAG.equalsIgnoreCase(tokenText) || JDOC_CODE_TAG.equalsIgnoreCase(tokenText) || JDOC_SNIPPET_TAG.equalsIgnoreCase(tokenText) || JDOC_DOCROOT_TAG.equalsIgnoreCase(tokenText) || JDOC_INHERITDOC_TAG.equalsIgnoreCase(tokenText) || JDOC_VALUE_TAG.equalsIgnoreCase(tokenText) || JDOC_LITERAL_TAG.equalsIgnoreCase(tokenText)) {
                                    insideTag = true;
                                    this.addMark((Pair<Integer, Integer>)Pair.of((Object)(currWSOffset >= 0 ? currWSOffset : javadocTokens.offset() - offset), (Object)5), marks, state);
                                    currWSOffset = -1;
                                    lastWSOffset = -1;
                                    continue block15;
                                }
                                if (insideTag) continue block15;
                                newState = 7;
                            }
                            if (lastWSOffset < initTextEndOffset && newState > 0) {
                                initTextEndOffset = lastWSOffset;
                            }
                            if (currWSOffset >= 0 && afterText) {
                                this.addMark((Pair<Integer, Integer>)Pair.of((Object)currWSOffset, (Object)(state == 0 && this.cs.blankLineAfterJavadocDescription() || state == 2 && newState != 1 && this.cs.blankLineAfterJavadocParameterDescriptions() || state == 3 && this.cs.blankLineAfterJavadocReturnTag() ? 0 : 1)), marks, state);
                            }
                            if ((state = newState) == 3 && this.cs.alignJavadocReturnDescription()) {
                                toAdd = Pair.of((Object)(javadocTokens.offset() + javadocTokens.token().length() - offset), (Object)3);
                            }
                            currWSOffset = -1;
                            lastWSOffset = -1;
                            continue block15;
                        }
                        case IDENT: {
                            if (toAdd != null) {
                                this.addMark(toAdd, marks, state);
                                toAdd = null;
                            }
                            nlAdd = null;
                            if (identStart < 0 && (state == 1 || state == 4)) {
                                identStart = javadocTokens.offset() - offset;
                            }
                            currWSOffset = -1;
                            lastWSOffset = -1;
                            afterText = true;
                            continue block15;
                        }
                        case HTML_TAG: {
                            if (toAdd != null) {
                                this.addMark(toAdd, marks, state);
                            }
                            nlAdd = null;
                            String tokenText = javadocTokens.token().text().toString();
                            if (tokenText.endsWith(">")) {
                                if (P_TAG.equalsIgnoreCase(tokenText) || END_P_TAG.equalsIgnoreCase(tokenText)) {
                                    if (currWSOffset >= 0 && currWSOffset > lastAddedNLOffset && (toAdd == null || (Integer)toAdd.first() < currWSOffset)) {
                                        this.addMark((Pair<Integer, Integer>)Pair.of((Object)currWSOffset, (Object)1), marks, state);
                                    }
                                    lastAddedNLOffset = javadocTokens.offset() + javadocTokens.token().length() - offset;
                                    this.addMark((Pair<Integer, Integer>)Pair.of((Object)lastAddedNLOffset, (Object)1), marks, state);
                                    afterText = false;
                                } else if (PRE_TAG.equalsIgnoreCase(tokenText)) {
                                    if (currWSOffset >= 0 && state == 0 && (toAdd == null || (Integer)toAdd.first() < currWSOffset)) {
                                        this.addMark((Pair<Integer, Integer>)Pair.of((Object)currWSOffset, (Object)1), marks, state);
                                    }
                                    this.addMark((Pair<Integer, Integer>)Pair.of((Object)(javadocTokens.offset() - offset), (Object)5), marks, state);
                                    state = 6;
                                } else if (CODE_TAG.equalsIgnoreCase(tokenText)) {
                                    this.addMark((Pair<Integer, Integer>)Pair.of((Object)(javadocTokens.offset() - offset), (Object)5), marks, state);
                                } else if (PRE_END_TAG.equalsIgnoreCase(tokenText)) {
                                    state = 0;
                                    this.addMark((Pair<Integer, Integer>)Pair.of((Object)(currWSOffset >= 0 ? currWSOffset : javadocTokens.offset() - offset), (Object)6), marks, state);
                                } else if (CODE_END_TAG.equalsIgnoreCase(tokenText)) {
                                    this.addMark((Pair<Integer, Integer>)Pair.of((Object)(currWSOffset >= 0 ? currWSOffset : javadocTokens.offset() - offset), (Object)6), marks, state);
                                } else {
                                    if (currWSOffset >= 0 && lastNLOffset >= currWSOffset && lastAddedNLOffset < currWSOffset && (toAdd == null || (Integer)toAdd.first() < currWSOffset)) {
                                        this.addMark((Pair<Integer, Integer>)Pair.of((Object)currWSOffset, (Object)1), marks, state);
                                    }
                                    this.addMark((Pair<Integer, Integer>)Pair.of((Object)(javadocTokens.offset() - offset), (Object)5), marks, state);
                                    this.addMark((Pair<Integer, Integer>)Pair.of((Object)(javadocTokens.offset() + javadocTokens.token().length() - offset - 1), (Object)6), marks, state);
                                    nlAdd = Pair.of((Object)(javadocTokens.offset() + javadocTokens.token().length() - offset), (Object)1);
                                }
                            } else {
                                cseq = new StringBuilder(tokenText);
                            }
                            toAdd = null;
                            currWSOffset = -1;
                            lastWSOffset = -1;
                            continue block15;
                        }
                        case OTHER_TEXT: {
                            currWSOffset = -1;
                            lastWSOffset = -1;
                            if (cseq == null) {
                                cseq = new StringBuilder();
                            }
                            cseq.append(javadocTokens.token().text());
                            int nlNum = 1;
                            int insideTagEndOffset = -1;
                            boolean addNow = false;
                            boolean nlFollows = false;
                            for (int i2 = cseq.length(); i2 >= 0; --i2) {
                                if (i2 == 0) {
                                    if (lastWSOffset < 0) {
                                        lastWSOffset = javadocTokens.offset() - offset;
                                    }
                                    if (currWSOffset >= 0 || nlNum < 0) continue;
                                    currWSOffset = javadocTokens.offset() - offset;
                                    continue;
                                }
                                char c2 = cseq.charAt(i2 - 1);
                                if (Character.isWhitespace(c2)) {
                                    if (c2 == '\n') {
                                        --nlNum;
                                        nlFollows = true;
                                        int off = javadocTokens.offset() + i2 - offset;
                                        if (off > lastNLOffset) {
                                            lastNLOffset = off;
                                        }
                                    }
                                    if (lastWSOffset >= 0 || currWSOffset < 0) continue;
                                    lastWSOffset = -2;
                                    continue;
                                }
                                nlFollows = false;
                                if (c2 == '*') continue;
                                if (toAdd != null) {
                                    this.addMark((Pair<Integer, Integer>)toAdd, marks, state);
                                    toAdd = null;
                                } else {
                                    addNow = true;
                                }
                                if (insideTag) {
                                    if (c2 == '{') {
                                        ++nestedParenCnt;
                                    } else if (c2 == '}') {
                                        if (nestedParenCnt > 0) {
                                            --nestedParenCnt;
                                        } else {
                                            insideTagEndOffset = javadocTokens.offset() + i2 - offset - 1;
                                            insideTag = false;
                                        }
                                    }
                                }
                                if (lastWSOffset == -2) {
                                    lastWSOffset = javadocTokens.offset() + i2 - offset;
                                }
                                if (currWSOffset < 0 && nlNum >= 0) {
                                    currWSOffset = javadocTokens.offset() + i2 - offset;
                                }
                                afterText = true;
                            }
                            if (nlFollows && nlAdd != null) {
                                toAdd = nlAdd;
                            }
                            nlAdd = null;
                            if (identStart >= 0) {
                                int len = javadocTokens.offset() - offset - identStart;
                                for (i = 0; i <= cseq.length(); ++i) {
                                    if (i != cseq.length() && !Character.isWhitespace(cseq.charAt(i))) continue;
                                    len += i;
                                    break;
                                }
                                if (state == 1) {
                                    if (len > maxParamNameLength) {
                                        maxParamNameLength = len;
                                    }
                                    if (this.cs.alignJavadocParameterDescriptions()) {
                                        toAdd = Pair.of((Object)(identStart + len), (Object)2);
                                    }
                                    state = 2;
                                } else if (state == 4) {
                                    if (len > maxExcNameLength) {
                                        maxExcNameLength = len;
                                    }
                                    if (this.cs.alignJavadocExceptionDescriptions()) {
                                        toAdd = Pair.of((Object)(identStart + len), (Object)4);
                                    }
                                    state = 5;
                                }
                                if (addNow && toAdd != null) {
                                    this.addMark((Pair<Integer, Integer>)toAdd, marks, state);
                                    toAdd = null;
                                }
                                identStart = -1;
                            }
                            if (insideTagEndOffset >= 0) {
                                this.addMark((Pair<Integer, Integer>)Pair.of((Object)insideTagEndOffset, (Object)6), marks, state);
                            }
                            cseq = null;
                            continue block15;
                        }
                    }
                    if (toAdd != null) {
                        this.addMark(toAdd, marks, state);
                        toAdd = null;
                    }
                    nlAdd = null;
                }
            }
            if ((it = marks.iterator()).hasNext()) {
                Pair next = (Pair)it.next();
                checkOffset = (Integer)next.first();
                actionType = (Integer)next.second();
            } else {
                checkOffset = Integer.MAX_VALUE;
                actionType = -1;
            }
            String indentString = this.getIndent();
            String lineStartString = this.cs.addLeadingStarInComment() ? indentString + SPACE + LEADING_STAR + SPACE : indentString + SPACE;
            int currNWSPos = -1;
            int lastNWSPos = -1;
            int currWSPos = -1;
            int lastWSPos = -1;
            int lastNewLinePos = -1;
            Diff pendingDiff = null;
            int start = javadocTokens != null ? 3 : 2;
            int end = text.length() - 2;
            this.col += start;
            boolean preserveNewLines = true;
            boolean firstLine = true;
            boolean enableCommentFormatting = javadocTokens != null ? this.cs.enableJavadocFormatting() : this.cs.enableBlockCommentFormatting();
            boolean noFormat = this.bof;
            int align = -1;
            for (i = start; i < text.length(); ++i) {
                String sub2;
                String s;
                String blankLineString = i >= initTextEndOffset ? (this.cs.addLeadingStarInComment() ? indentString + SPACE + LEADING_STAR : EMPTY) : (javadocTokens != null && !noFormat && this.cs.generateParagraphTagOnBlankLines() ? (this.cs.addLeadingStarInComment() ? indentString + SPACE + LEADING_STAR + SPACE + P_TAG : indentString + SPACE + P_TAG) : (this.cs.addLeadingStarInComment() ? indentString + SPACE + LEADING_STAR : EMPTY));
                c = text.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (enableCommentFormatting) {
                        if (currNWSPos >= 0) {
                            lastNWSPos = currNWSPos;
                            currNWSPos = -1;
                        }
                        if (currWSPos < 0) {
                            currWSPos = i;
                            if (noFormat) {
                                ++this.col;
                            } else {
                                if (this.col > this.rightMargin && this.cs.wrapCommentText() && lastWSPos >= 0) {
                                    int num;
                                    int endOff = pendingDiff != null ? pendingDiff.getEndOffset() - offset : lastWSPos + 1;
                                    s = pendingDiff != null && pendingDiff.text != null && pendingDiff.text.charAt(0) == '\n' ? pendingDiff.text : NEWLINE + lineStartString;
                                    this.col = this.getCol(lineStartString) + i - endOff;
                                    if (align > 0 && (num = align - this.getCol(lineStartString)) > 0) {
                                        s = s + this.getSpaces(num);
                                        this.col += num;
                                    }
                                    ++this.col;
                                    if (endOff > lastWSPos && !s.equals(text.substring(lastWSPos, endOff))) {
                                        this.addDiff(new Diff(offset + lastWSPos, offset + endOff, s));
                                    }
                                } else if (pendingDiff != null) {
                                    String sub3 = text.substring(pendingDiff.start - offset, pendingDiff.end - offset);
                                    if (!sub3.equals(pendingDiff.text)) {
                                        this.addDiff(pendingDiff);
                                    }
                                    ++this.col;
                                } else {
                                    ++this.col;
                                }
                                pendingDiff = null;
                            }
                        }
                    }
                    if (c == '\n') {
                        if (lastNewLinePos >= 0) {
                            String subs;
                            if (enableCommentFormatting && !blankLineString.equals(subs = text.substring(lastNewLinePos + 1, i))) {
                                this.addDiff(new Diff(offset + lastNewLinePos + 1, offset + i, blankLineString));
                            }
                            preserveNewLines = true;
                            lastNewLinePos = i;
                            align = -1;
                        } else {
                            lastNewLinePos = currWSPos >= 0 ? currWSPos : i;
                        }
                        firstLine = false;
                    }
                    if (i < checkOffset || actionType != 5) continue;
                    noFormat = true;
                    align = -1;
                    if (it.hasNext()) {
                        Pair next = (Pair)it.next();
                        checkOffset = (Integer)next.first();
                        actionType = (Integer)next.second();
                        continue;
                    }
                    checkOffset = Integer.MAX_VALUE;
                    actionType = -1;
                    continue;
                }
                if (pendingDiff != null && (sub2 = text.substring(pendingDiff.start - offset, pendingDiff.end - offset)).equals(pendingDiff.text)) {
                    pendingDiff = null;
                }
                if (enableCommentFormatting) {
                    if (currNWSPos < 0) {
                        currNWSPos = i;
                    }
                    if (i >= checkOffset) {
                        noFormat = false;
                        switch (actionType) {
                            case 0: {
                                pendingDiff = new Diff(currWSPos >= 0 ? offset + currWSPos : offset + i, offset + i, NEWLINE + blankLineString + NEWLINE);
                                lastNewLinePos = i - 1;
                                preserveNewLines = true;
                                align = -1;
                                break;
                            }
                            case 1: {
                                pendingDiff = new Diff(currWSPos >= 0 ? offset + currWSPos : offset + i, offset + i, NEWLINE);
                                lastNewLinePos = i - 1;
                                preserveNewLines = true;
                                align = -1;
                                break;
                            }
                            case 2: {
                                this.col += maxParamNameLength + lastNWSPos - currWSPos;
                                align = this.col;
                                currWSPos = -1;
                                if (lastNewLinePos >= 0) break;
                                int num = maxParamNameLength + lastNWSPos + 1 - i;
                                if (num > 0) {
                                    this.addDiff(new Diff(offset + i, offset + i, this.getSpaces(num)));
                                    break;
                                }
                                if (num >= 0) break;
                                this.addDiff(new Diff(offset + i + num, offset + i, null));
                                break;
                            }
                            case 3: {
                                align = this.col;
                                break;
                            }
                            case 4: {
                                this.col += maxExcNameLength + lastNWSPos - currWSPos;
                                align = this.col;
                                currWSPos = -1;
                                if (lastNewLinePos >= 0) break;
                                int num = maxExcNameLength + lastNWSPos + 1 - i;
                                if (num > 0) {
                                    this.addDiff(new Diff(offset + i, offset + i, this.getSpaces(num)));
                                    break;
                                }
                                if (num >= 0) break;
                                this.addDiff(new Diff(offset + i + num, offset + i, null));
                                break;
                            }
                            case 5: {
                                noFormat = true;
                                if (currWSPos <= 0) break;
                                lastWSPos = currWSPos;
                                break;
                            }
                            case 6: {
                                preserveNewLines = true;
                            }
                        }
                        if (it.hasNext()) {
                            Pair next = (Pair)it.next();
                            checkOffset = (Integer)next.first();
                            actionType = (Integer)next.second();
                        } else {
                            checkOffset = Integer.MAX_VALUE;
                            actionType = -1;
                        }
                    }
                }
                if (lastNewLinePos >= 0) {
                    if (!preserveNewLines && !noFormat && i < text.length() - 2 && enableCommentFormatting && !this.cs.preserveNewLinesInComments() && this.cs.wrapCommentText()) {
                        lastWSPos = lastNewLinePos;
                        if (pendingDiff != null) {
                            pendingDiff.text = pendingDiff.text + SPACE;
                        } else {
                            pendingDiff = new Diff(offset + lastNewLinePos, offset + i, SPACE);
                        }
                        lastNewLinePos = -1;
                        if (c == '*') {
                            int diff = 0;
                            while (++i < text.length()) {
                                ++this.col;
                                c = text.charAt(i);
                                if (c == '\n') {
                                    pendingDiff.text = NEWLINE + blankLineString + NEWLINE;
                                    ++diff;
                                    preserveNewLines = true;
                                    lastNewLinePos = i;
                                    align = -1;
                                    break;
                                }
                                if (Character.isWhitespace(c)) continue;
                            }
                            if (pendingDiff != null) {
                                pendingDiff.end += (diff += offset + i - pendingDiff.end);
                                this.col -= diff;
                            }
                        }
                    } else {
                        String subs;
                        String s2;
                        if (pendingDiff != null) {
                            pendingDiff.text = pendingDiff.text + (indentString + SPACE);
                            String subs2 = text.substring(pendingDiff.start - offset, i);
                            if (pendingDiff.text.equals(subs2)) {
                                lastNewLinePos = pendingDiff.start - offset;
                                pendingDiff = null;
                            }
                        } else if ((enableCommentFormatting || i == end || javadocTokens != null && c == '*') && !(s2 = NEWLINE + indentString + SPACE).equals(subs = text.substring(lastNewLinePos, i))) {
                            pendingDiff = new Diff(offset + lastNewLinePos, offset + i, s2);
                        }
                        currWSPos = -1;
                        lastWSPos = -1;
                        this.col = this.getCol(indentString + SPACE);
                        if (enableCommentFormatting) {
                            if (c == '*') {
                                ++this.col;
                                while (++i < text.length()) {
                                    c = text.charAt(i);
                                    if (c == '\n') {
                                        if (!this.cs.addLeadingStarInComment()) {
                                            String subs3 = text.substring(lastNewLinePos + 1, i);
                                            if (blankLineString.equals(subs3)) {
                                                pendingDiff = null;
                                            } else if (pendingDiff != null) {
                                                pendingDiff.end = offset + i;
                                                pendingDiff.text = NEWLINE + blankLineString;
                                            } else {
                                                pendingDiff = new Diff(offset + lastNewLinePos + 1, offset + i, blankLineString);
                                            }
                                        } else if (currWSPos >= 0) {
                                            if (pendingDiff != null && !(sub = text.substring(pendingDiff.start - offset, pendingDiff.end - offset)).equals(pendingDiff.text)) {
                                                this.addDiff(pendingDiff);
                                            }
                                            pendingDiff = new Diff(offset + currWSPos, offset + i, javadocTokens != null && lastNWSPos >= 0 && i < initTextEndOffset && !noFormat && this.cs.generateParagraphTagOnBlankLines() ? " <p>" : EMPTY);
                                        } else if (javadocTokens != null && lastNWSPos >= 0 && i < initTextEndOffset && !noFormat && this.cs.generateParagraphTagOnBlankLines()) {
                                            if (pendingDiff != null && !(sub = text.substring(pendingDiff.start - offset, pendingDiff.end - offset)).equals(pendingDiff.text)) {
                                                this.addDiff(pendingDiff);
                                            }
                                            pendingDiff = new Diff(offset + i, offset + i, " <p>");
                                        }
                                        currWSPos = -1;
                                        lastNewLinePos = i;
                                        align = -1;
                                    } else {
                                        if (Character.isWhitespace(c)) {
                                            if (currWSPos >= 0) continue;
                                            currWSPos = i;
                                            ++this.col;
                                            continue;
                                        }
                                        if (c == '*' || c == '/') {
                                            ++this.col;
                                            lastNewLinePos = -1;
                                        } else {
                                            if (i >= checkOffset && actionType == 6) {
                                                noFormat = false;
                                                preserveNewLines = true;
                                                if (it.hasNext()) {
                                                    Pair next = (Pair)it.next();
                                                    checkOffset = (Integer)next.first();
                                                    actionType = (Integer)next.second();
                                                } else {
                                                    checkOffset = Integer.MAX_VALUE;
                                                    actionType = -1;
                                                }
                                            }
                                            if (!this.cs.addLeadingStarInComment()) {
                                                if (noFormat) {
                                                    if (pendingDiff != null) {
                                                        pendingDiff.end = currWSPos >= 0 ? offset + currWSPos + 1 : pendingDiff.end + 1;
                                                    } else {
                                                        pendingDiff = new Diff(offset + lastNewLinePos + 1, currWSPos >= 0 ? offset + currWSPos + 1 : offset + i, indentString + SPACE);
                                                    }
                                                } else {
                                                    if (pendingDiff != null) {
                                                        pendingDiff.end = offset + i;
                                                    } else {
                                                        pendingDiff = new Diff(offset + lastNewLinePos + 1, offset + i, indentString + SPACE);
                                                    }
                                                    this.col = this.getCol(indentString + SPACE);
                                                }
                                            } else {
                                                if (currWSPos < 0) {
                                                    currWSPos = i;
                                                    ++this.col;
                                                }
                                                String subs4 = text.substring(currWSPos, i);
                                                s = this.getSpaces(align < 0 ? 1 : align - this.getCol(lineStartString) + 1);
                                                if (!noFormat && !s.equals(subs4)) {
                                                    String sub4;
                                                    if (pendingDiff != null && !(sub4 = text.substring(pendingDiff.start - offset, pendingDiff.end - offset)).equals(pendingDiff.text)) {
                                                        this.addDiff(pendingDiff);
                                                    }
                                                    pendingDiff = new Diff(offset + currWSPos, offset + i, s);
                                                }
                                            }
                                            lastNewLinePos = -1;
                                            currWSPos = -1;
                                        }
                                    }
                                    break;
                                }
                            } else {
                                if (this.cs.addLeadingStarInComment()) {
                                    int num = Math.max(align - this.col - 1, 1);
                                    s = this.getSpaces(num);
                                    if (pendingDiff != null) {
                                        pendingDiff.text = pendingDiff.text + (LEADING_STAR + s);
                                    } else {
                                        pendingDiff = new Diff(offset + i, offset + i, LEADING_STAR + s);
                                    }
                                    this.col += num + 1;
                                } else if (align > this.col) {
                                    int num = align - this.col;
                                    s = this.getSpaces(num);
                                    if (pendingDiff != null) {
                                        pendingDiff.text = pendingDiff.text + s;
                                    } else {
                                        pendingDiff = new Diff(offset + i, offset + i, s);
                                    }
                                    this.col += num;
                                }
                                lastNewLinePos = -1;
                            }
                        } else {
                            lastNewLinePos = -1;
                        }
                        if (pendingDiff != null) {
                            sub = text.substring(pendingDiff.start - offset, pendingDiff.end - offset);
                            if (!sub.equals(pendingDiff.text)) {
                                this.addDiff(pendingDiff);
                            }
                            pendingDiff = null;
                        }
                    }
                } else if (enableCommentFormatting) {
                    if (firstLine) {
                        String s3 = !noFormat && this.cs.wrapOneLineComments() ? NEWLINE + lineStartString : SPACE;
                        String string = sub = currWSPos >= 0 ? text.substring(currWSPos, i) : null;
                        if (!s3.equals(sub)) {
                            this.addDiff(new Diff(currWSPos >= 0 ? offset + currWSPos : offset + i, offset + i, s3));
                        }
                        if (!noFormat && this.cs.wrapOneLineComments()) {
                            this.col = this.getCol(lineStartString);
                        }
                        firstLine = false;
                    } else if (currWSPos >= 0) {
                        if (!noFormat) {
                            lastWSPos = currWSPos;
                            if (currWSPos < i - 1) {
                                pendingDiff = new Diff(offset + currWSPos + 1, offset + i, null);
                            }
                        }
                    } else if (c != '*') {
                        preserveNewLines = false;
                    }
                } else if (c != '*') {
                    preserveNewLines = false;
                }
                currWSPos = -1;
                ++this.col;
            }
            if (enableCommentFormatting) {
                for (i = text.length() - 3; i >= 0 && (c = text.charAt(i)) != '\n'; --i) {
                    if (Character.isWhitespace(c)) continue;
                    String s = !noFormat && this.cs.wrapOneLineComments() ? NEWLINE + indentString + SPACE : SPACE;
                    if (s.equals(sub = text.substring(i + 1, text.length() - 2))) break;
                    this.addDiff(new Diff(offset + i + 1, offset + text.length() - 2, s));
                    break;
                }
            }
        }

        private void addMark(Pair<Integer, Integer> mark, java.util.List<Pair<Integer, Integer>> marks, int state) {
            if (state != 6) {
                marks.add(mark);
            }
        }

        private int indent() {
            return this.continuationIndent ? this.indent + this.continuationIndentSize : this.indent;
        }

        private String getSpaces(int count) {
            if (count <= 0) {
                return EMPTY;
            }
            if (count == 1) {
                return SPACE;
            }
            StringBuilder sb = new StringBuilder();
            while (count-- > 0) {
                sb.append(' ');
            }
            return sb.toString();
        }

        private String getNewlines(int count) {
            if (count <= 0) {
                return EMPTY;
            }
            if (count == 1) {
                return NEWLINE;
            }
            StringBuilder sb = new StringBuilder();
            while (count-- > 0) {
                sb.append('\n');
            }
            return sb.toString();
        }

        private String getIndent() {
            StringBuilder sb = new StringBuilder();
            int col = 0;
            if (!this.expandTabToSpaces) {
                while (col + this.tabSize <= this.indent()) {
                    sb.append('\t');
                    col += this.tabSize;
                }
            }
            while (col < this.indent()) {
                sb.append(SPACE);
                ++col;
            }
            this.lastIndent = this.indent;
            this.isLastIndentContinuation = this.continuationIndent;
            return sb.toString();
        }

        /*
         * WARNING - void declaration
         */
        private int getIndentLevel(TokenSequence<JavaTokenId> tokens, TreePath path) {
            if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                return 0;
            }
            Tree lastTree = null;
            int indent = -1;
            while (path != null) {
                int offset = (int)this.sp.getStartPosition(path.getCompilationUnit(), path.getLeaf());
                if (offset < 0) {
                    return indent;
                }
                tokens.move(offset);
                Object var6_9 = null;
                while (tokens.movePrevious()) {
                    Token token = tokens.token();
                    if (token.id() == JavaTokenId.WHITESPACE) {
                        String string = token.text().toString();
                        int idx = string.lastIndexOf(10);
                        if (idx < 0) continue;
                        String string2 = string.substring(idx + 1);
                        indent = this.getCol(string2);
                        break;
                    }
                    if (token.id() == JavaTokenId.LINE_COMMENT) {
                        void var6_10;
                        indent = var6_10 != null ? this.getCol((String)var6_10) : 0;
                        break;
                    }
                    if (token.id() != JavaTokenId.BLOCK_COMMENT && token.id() != JavaTokenId.JAVADOC_COMMENT) break;
                    Object var6_13 = null;
                }
                if (indent >= 0) break;
                lastTree = path.getLeaf();
                path = path.getParentPath();
            }
            if (lastTree != null && path != null) {
                block0 : switch (path.getLeaf().getKind()) {
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: {
                        for (Tree tree : ((ClassTree)path.getLeaf()).getMembers()) {
                            if (tree != lastTree) continue;
                            indent += this.tabSize;
                            break block0;
                        }
                        break;
                    }
                    case BLOCK: {
                        for (Tree tree : ((BlockTree)path.getLeaf()).getStatements()) {
                            if (tree != lastTree) continue;
                            indent += this.tabSize;
                            break block0;
                        }
                        break;
                    }
                }
            }
            return indent;
        }

        private int getCol(String text) {
            int col = 0;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\n') {
                    col = 0;
                    continue;
                }
                if (c == '\t') {
                    col += this.tabSize;
                    col -= col % this.tabSize;
                    continue;
                }
                ++col;
            }
            return col;
        }

        private boolean insideBlock(TreePath path) {
            while (path != null) {
                if (Tree.Kind.BLOCK == path.getLeaf().getKind()) {
                    return true;
                }
                if (Tree.Kind.CLASS == path.getLeaf().getKind()) {
                    return false;
                }
                path = path.getParentPath();
            }
            return false;
        }

        private boolean isEnumerator(VariableTree tree) {
            return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x4000L) != 0L;
        }

        private boolean isSynthetic(CompilationUnitTree cut, Tree leaf) {
            IdentifierTree it;
            MethodInvocationTree mit;
            ExpressionStatementTree est;
            JCTree tree = (JCTree)leaf;
            if (tree.pos == -1) {
                return true;
            }
            if (leaf.getKind() == Tree.Kind.METHOD) {
                return (((JCTree.JCMethodDecl)leaf).mods.flags & 0x1000000000L) != 0L;
            }
            if (leaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = (ExpressionStatementTree)leaf).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (mit = (MethodInvocationTree)est.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((it = (IdentifierTree)mit.getMethodSelect()).getName().toString())) {
                return this.sp.getEndPosition(cut, leaf) == -1L;
            }
            return false;
        }

        private static class DanglingElseChecker
        extends SimpleTreeVisitor<Void, Void> {
            private boolean foundDanglingElse;

            private DanglingElseChecker() {
            }

            public boolean hasDanglingElse(Tree t) {
                if (t == null) {
                    return false;
                }
                this.foundDanglingElse = false;
                this.visit(t, null);
                return this.foundDanglingElse;
            }

            @Override
            public Void visitBlock(BlockTree node, Void p) {
                StatementTree stat;
                Iterator<? extends StatementTree> it = node.getStatements().iterator();
                StatementTree statementTree = stat = it.hasNext() ? it.next() : null;
                if (stat != null && !it.hasNext()) {
                    this.visit(stat, p);
                }
                return null;
            }

            @Override
            public Void visitDoWhileLoop(DoWhileLoopTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }

            @Override
            public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }

            @Override
            public Void visitForLoop(ForLoopTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }

            @Override
            public Void visitIf(IfTree node, Void p) {
                if (node.getElseStatement() == null) {
                    this.foundDanglingElse = true;
                } else {
                    this.visit(node.getElseStatement(), p);
                }
                return null;
            }

            @Override
            public Void visitLabeledStatement(LabeledStatementTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }

            @Override
            public Void visitSynchronized(SynchronizedTree node, Void p) {
                return (Void)this.visit(node.getBlock(), p);
            }

            @Override
            public Void visitWhileLoop(WhileLoopTree node, Void p) {
                return (Void)this.visit(node.getStatement(), p);
            }
        }

        private static class FakeBlock
        extends JCTree.JCBlock {
            private StatementTree stat;

            private FakeBlock(StatementTree stat) {
                super(0L, List.of((JCTree.JCStatement)stat));
                this.stat = stat;
            }
        }

        private static class WrapAbort
        extends Error {
            private int pos;

            public WrapAbort(int pos) {
                this.pos = pos;
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return null;
            }
        }
    }

    public static class Factory
    implements ReformatTask.Factory {
        public ReformatTask createTask(org.netbeans.modules.editor.indent.spi.Context context) {
            if (!NoJavacHelper.hasWorkingJavac()) {
                return null;
            }
            Source source = Source.create((Document)context.document());
            return source != null ? new Reformatter(source, context) : null;
        }
    }
}

