/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.progress;

import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.ui.api.TestResultDisplayHandler;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.progress.ModuleInfo;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TestProgressParams;
import org.netbeans.modules.java.lsp.server.protocol.TestSuiteInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class TestProgressHandler
implements TestResultDisplayHandler.Spi<ModuleInfo> {
    private static final Logger LOG = Logger.getLogger(TestProgressHandler.class.getName());
    private final NbCodeLanguageClient lspClient;
    private final IDebugProtocolClient debugClient;
    private final String uri;

    public TestProgressHandler(NbCodeLanguageClient lspClient, IDebugProtocolClient debugClient, String uri) {
        this.lspClient = lspClient;
        this.debugClient = debugClient;
        this.uri = uri;
    }

    public ModuleInfo create(TestSession session) {
        return TestProgressHandler.getModuleInfo(session);
    }

    public void displayOutput(ModuleInfo token, String text, boolean error) {
        if (text != null) {
            OutputEventArguments output = new OutputEventArguments();
            output.setOutput(text.trim() + "\n");
            this.debugClient.output(output);
        }
    }

    private String firstModulePath(ModuleInfo token) {
        List<String> paths = token.getTestRoots();
        if (paths == null || paths.isEmpty()) {
            return null;
        }
        if (paths.size() > 1) {
            LOG.log(Level.WARNING, "Mutliple test roots are not yet supported for module {0}", token.getModuleName());
        }
        return paths.iterator().next();
    }

    public void displaySuiteRunning(ModuleInfo token, String suiteName) {
        this.lspClient.notifyTestProgress(new TestProgressParams(this.uri, new TestSuiteInfo(suiteName, "started").setModuleName(token.getModuleName()).setModulePath(this.firstModulePath(token))));
    }

    public void displaySuiteRunning(ModuleInfo token, TestSuite suite) {
        this.lspClient.notifyTestProgress(new TestProgressParams(this.uri, new TestSuiteInfo(suite.getName(), "started").setModuleName(token.getModuleName()).setModulePath(this.firstModulePath(token))));
    }

    public void displayReport(ModuleInfo token, Report report) {
        HashMap<String, FileObject> fileLocations = new HashMap<String, FileObject>();
        LinkedHashMap<CallSite, TestSuiteInfo.TestCaseInfo> testCases = new LinkedHashMap<CallSite, TestSuiteInfo.TestCaseInfo>();
        String className = report.getSuiteClassName();
        for (Testcase test : report.getTests()) {
            String name = test.getDisplayName();
            String id = className + ":" + name;
            String state = this.statusToState(test.getStatus());
            List<String> stackTrace = test.getTrouble() != null ? Arrays.asList(test.getTrouble().getStackTrace()) : null;
            String location = test.getLocation();
            FileObject fo = location != null ? fileLocations.computeIfAbsent(location, loc -> {
                LineConvertors.FileLocator fileLocator = (LineConvertors.FileLocator)test.getSession().getProject().getLookup().lookup(LineConvertors.FileLocator.class);
                int i = loc.indexOf(58);
                if (i > 0) {
                    loc = loc.substring(0, i);
                }
                return fileLocator != null ? fileLocator.find(loc) : null;
            }) : null;
            int cnt = 1;
            String base = id;
            while (testCases.containsKey(id)) {
                id = base + "-" + cnt++;
            }
            TestSuiteInfo.TestCaseInfo info = new TestSuiteInfo.TestCaseInfo(id, name, fo != null ? Utils.toUri(fo) : null, null, state, stackTrace);
            testCases.put((CallSite)((Object)id), info);
        }
        String state = this.statusToState(report.getStatus());
        FileObject fo = fileLocations.size() == 1 ? (FileObject)fileLocations.values().iterator().next() : null;
        this.lspClient.notifyTestProgress(new TestProgressParams(this.uri, new TestSuiteInfo(report.getSuiteClassName(), token.getModuleName(), this.firstModulePath(token), fo != null ? Utils.toUri(fo) : null, null, state, new ArrayList<TestSuiteInfo.TestCaseInfo>(testCases.values()))));
    }

    public void displayMessage(ModuleInfo token, String message) {
    }

    public void displayMessageSessionFinished(ModuleInfo token, String message) {
    }

    public int getTotalTests(ModuleInfo token) {
        return 0;
    }

    private String statusToState(Status status) {
        switch (status) {
            case PASSED: 
            case PASSEDWITHERRORS: {
                return "passed";
            }
            case ERROR: {
                return "errored";
            }
            case FAILED: {
                return "failed";
            }
            case SKIPPED: 
            case ABORTED: 
            case IGNORED: {
                return "skipped";
            }
            case PENDING: {
                return "started";
            }
        }
        throw new IllegalStateException("Unexpected testsuite status: " + status);
    }

    private static ModuleInfo getModuleInfo(TestSession session) {
        Project project = session.getProject();
        String moduleName = project != null ? ProjectUtils.getInformation((Project)project).getDisplayName() : null;
        List<String> testPaths = TestProgressHandler.getModuleTestPaths(project);
        return new ModuleInfo(moduleName, testPaths);
    }

    private static List<String> getModuleTestPaths(Project project) {
        if (project == null) {
            return null;
        }
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (SourceGroup sourceGroup : sourceGroups) {
            URL[] urls;
            for (URL u : urls = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder())) {
                FileObject f = URLMapper.findFileObject((URL)u);
                if (f == null) continue;
                paths.add(f.getPath());
            }
        }
        return paths.isEmpty() ? null : new ArrayList(paths);
    }
}

