/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.ni;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.lsp.server.files.OpenedDocuments;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.netbeans.modules.java.lsp.server.protocol.DecorationRenderOptions;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.SetTextEditorDecorationParams;
import org.netbeans.modules.java.lsp.server.protocol.ThemeColor;
import org.netbeans.modules.nativeimage.api.Location;
import org.netbeans.modules.nativeimage.api.debug.NIDebugger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public final class NILocationVisualizer
implements Consumer<String> {
    private final File niFileSources;
    private final NIDebugger niDebugger;
    private final NbCodeLanguageClient client;
    private final OpenedDocuments openedDocuments;
    private Set<String> decorationKeys = new HashSet<String>();

    private NILocationVisualizer(File nativeImageFile, NIDebugger niDebugger, CompletableFuture<Void> finished, OpenedDocuments openedDocuments) {
        this.niFileSources = NILocationVisualizer.getNativeSources(nativeImageFile);
        this.niDebugger = niDebugger;
        OperationContext ctx = OperationContext.find(Lookup.getDefault());
        this.client = ctx.getClient();
        this.openedDocuments = openedDocuments;
        finished.thenRun(() -> {
            Set<String> keys;
            openedDocuments.removeOpenedConsumer(this);
            NILocationVisualizer nILocationVisualizer = this;
            synchronized (nILocationVisualizer) {
                keys = this.decorationKeys;
                this.decorationKeys = null;
            }
            for (String key : keys) {
                this.client.disposeTextEditorDecoration(key);
            }
        });
    }

    private static File getNativeSources(File niFile) {
        File sources = new File(niFile.getParentFile(), "sources");
        if (sources.isDirectory()) {
            return sources;
        }
        return null;
    }

    public static void handle(File nativeImageFile, NIDebugger niDebugger, CompletableFuture<Void> finished, OpenedDocuments openedDocuments) {
        openedDocuments.addOpenedConsumer(new NILocationVisualizer(nativeImageFile, niDebugger, finished, openedDocuments));
    }

    @Override
    public void accept(String uri) {
        List<Location> locations = this.getLocations(uri);
        if (locations != null) {
            DecorationRenderOptions decorationOptions = new DecorationRenderOptions();
            decorationOptions.setColor((Either<String, ThemeColor>)Either.forLeft((Object)"gray"));
            CompletableFuture<String> decorationFuture = this.client.createTextEditorDecoration(decorationOptions);
            decorationFuture.thenAccept(key -> {
                boolean disposed;
                Intervals intervals = NILocationVisualizer.getCodeIntervals(uri);
                Range[] ranges = this.locationsToRanges(locations, intervals);
                this.client.setTextEditorDecoration(new SetTextEditorDecorationParams((String)key, uri, ranges));
                NILocationVisualizer nILocationVisualizer = this;
                synchronized (nILocationVisualizer) {
                    boolean bl = disposed = this.decorationKeys == null;
                    if (!disposed) {
                        this.decorationKeys.add((String)key);
                    }
                }
                if (disposed) {
                    this.client.disposeTextEditorDecoration((String)key);
                }
            });
        }
    }

    private final List<Location> getLocations(String uri) {
        String relPath;
        List locations = this.niDebugger.listLocations(uri);
        if (locations == null && this.niFileSources != null && (relPath = NILocationVisualizer.getRelativePath(uri)) != null) {
            File sourcesFile = new File(this.niFileSources, relPath);
            String filePath = sourcesFile.getAbsolutePath();
            locations = this.niDebugger.listLocations(filePath);
        }
        return locations;
    }

    private Range[] locationsToRanges(List<Location> locations, Intervals intervals) {
        locations.sort((l1, l2) -> l1.getLine() - l2.getLine());
        ArrayList<Range> ranges = new ArrayList<Range>();
        int lastLine = intervals.getFirst();
        int maxLine = intervals.getLast();
        for (Location l : locations) {
            int line = l.getLine();
            if (line == 0) continue;
            if (lastLine < line) {
                int start = lastLine;
                int end = line - 1;
                while (true) {
                    int endCol;
                    int startCol;
                    int rangeEnd;
                    if (!intervals.contains(start) && start < maxLine) {
                        ++start;
                        continue;
                    }
                    if (start > end) break;
                    for (rangeEnd = start; rangeEnd < end && intervals.contains(rangeEnd); ++rangeEnd) {
                    }
                    int[] extendedRange = intervals.extendRange(start, rangeEnd);
                    if (extendedRange != null) {
                        start = extendedRange[0];
                        startCol = extendedRange[1];
                        rangeEnd = extendedRange[2];
                        endCol = extendedRange[3];
                    } else {
                        startCol = intervals.getFirstColumn(start);
                        endCol = intervals.getLastColumn(rangeEnd);
                    }
                    int endLine = rangeEnd;
                    if (endCol == -1) {
                        ++endLine;
                        endCol = 1;
                    }
                    ranges.add(new Range(new Position(start - 1, startCol - 1), new Position(endLine - 1, endCol - 1)));
                    start = rangeEnd + 1;
                    if (start > end) break;
                }
            }
            lastLine = line + 1;
        }
        if (lastLine < maxLine) {
            ranges.add(new Range(new Position(lastLine, 0), new Position(maxLine, 0)));
        }
        for (String variable : intervals.variables.keySet()) {
            Map listVariables = this.niDebugger.listVariables(variable, true, -1);
            if (listVariables == null || !listVariables.isEmpty()) continue;
            Interval interval = intervals.variables.get(variable);
            ranges.add(new Range(new Position(interval.l1 - 1, interval.c1 - 1), new Position(interval.l2 - 1, interval.c2 - 1)));
        }
        return ranges.toArray(new Range[0]);
    }

    private static String r2s(List<Range> ranges) {
        StringBuilder sb = new StringBuilder("[");
        for (Range r : ranges) {
            sb.append(r.getStart().getLine() + " - " + r.getEnd().getLine());
            sb.append(", ");
        }
        if (sb.length() > 3) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }

    private static String getRelativePath(String url) {
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (fo == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
        }
        if (cp == null) {
            return null;
        }
        return cp.getResourceName(fo, '/', true);
    }

    private static Intervals getCodeIntervals(String url) {
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        JavaSource source = JavaSource.forFileObject((FileObject)fo);
        final Intervals intervals = new Intervals();
        try {
            source.runWhenScanFinished((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    List topLevelElements = cc.getTopLevelElements();
                    TreeUtilities treeUtilities = cc.getTreeUtilities();
                    SourcePositions sourcePositions = cc.getTrees().getSourcePositions();
                    LineMap lineMap = cc.getCompilationUnit().getLineMap();
                    for (Element element : topLevelElements) {
                        Tree tree = cc.getTrees().getTree(element);
                        if (tree.getKind() != Tree.Kind.CLASS) continue;
                        List<? extends Tree> members = ((ClassTree)tree).getMembers();
                        for (Tree tree2 : members) {
                            VariableTree variable;
                            boolean isStatic;
                            Tree t = null;
                            Tree enclosingTree = null;
                            if (tree2.getKind() == Tree.Kind.METHOD) {
                                t = ((MethodTree)tree2).getBody();
                                enclosingTree = tree2;
                            } else if (tree2.getKind() == Tree.Kind.BLOCK) {
                                t = tree2;
                            }
                            if (t != null) {
                                Interval interval = NILocationVisualizer.createInterval(cc.getCompilationUnit(), sourcePositions, lineMap, t, enclosingTree);
                                if (interval == null) continue;
                                intervals.add(interval);
                                continue;
                            }
                            if (tree2.getKind() != Tree.Kind.VARIABLE || !(isStatic = (variable = (VariableTree)tree2).getModifiers().getFlags().contains((Object)Modifier.STATIC))) continue;
                            Object name = variable.getName().toString();
                            name = cc.getElementUtilities().getElementName(element, true) + "::" + (String)name;
                            Interval interval = NILocationVisualizer.createInterval(cc.getCompilationUnit(), sourcePositions, lineMap, tree2, enclosingTree);
                            if (interval == null) continue;
                            intervals.addVariable((String)name, interval);
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return intervals;
    }

    private static Interval createInterval(CompilationUnitTree cut, SourcePositions sourcePositions, LineMap lineMap, Tree tree, Tree enclosingTree) {
        long start = sourcePositions.getStartPosition(cut, tree);
        long end = sourcePositions.getEndPosition(cut, tree);
        if (start != -1L && end != -1L) {
            int line1 = (int)lineMap.getLineNumber(start);
            int col1 = (int)lineMap.getColumnNumber(start);
            int line2 = (int)lineMap.getLineNumber(end);
            int col2 = (int)lineMap.getColumnNumber(end);
            Interval enclosingInterval = null;
            if (enclosingTree != null) {
                enclosingInterval = NILocationVisualizer.createInterval(cut, sourcePositions, lineMap, enclosingTree, null);
            }
            return new Interval(line1, col1, line2, col2, enclosingInterval);
        }
        return null;
    }

    private static final class Intervals {
        private final List<Interval> intervals = new ArrayList<Interval>();
        private final Map<String, Interval> variables = new HashMap<String, Interval>();

        private Intervals() {
        }

        void add(Interval i) {
            int index = this.intervals.size();
            for (int idx = 0; idx < this.intervals.size(); ++idx) {
                Interval ii = this.intervals.get(idx);
                if (i.l1 >= ii.l1) continue;
                index = idx;
                break;
            }
            this.intervals.add(index, i);
        }

        void addVariable(String name, Interval i) {
            this.variables.put(name, i);
        }

        boolean contains(int n) {
            for (Interval i : this.intervals) {
                if (!i.contains(n)) continue;
                return true;
            }
            return false;
        }

        int getFirst() {
            if (this.intervals.size() > 0) {
                return this.intervals.get((int)0).l1;
            }
            return 0;
        }

        int getLast() {
            int s = this.intervals.size();
            if (s > 0) {
                return this.intervals.get((int)(s - 1)).l2;
            }
            return -1;
        }

        private int getFirstColumn(int line) {
            for (Interval i : this.intervals) {
                if (!i.contains(line)) continue;
                return i.firstColumnOn(line);
            }
            return 1;
        }

        private int getLastColumn(int line) {
            for (Interval i : this.intervals) {
                if (!i.contains(line)) continue;
                return i.lastColumnOn(line);
            }
            return -1;
        }

        private int[] extendRange(int start, int end) {
            int xStartL = -1;
            int xStartC = -1;
            int xEndL = -1;
            int xEndC = -1;
            for (Interval i : this.intervals) {
                Interval ie;
                if (start > i.l1 || i.l2 > end || (ie = i.enclosing) == null) continue;
                if (xStartL < 0) {
                    xStartL = ie.l1;
                    xStartC = ie.c1;
                }
                xEndL = ie.l2;
                xEndC = ie.c2;
            }
            if (xStartL != -1) {
                return new int[]{xStartL, xStartC, xEndL, xEndC};
            }
            return null;
        }
    }

    private static final class Interval {
        private final int l1;
        private final int c1;
        private final int l2;
        private final int c2;
        private final Interval enclosing;

        Interval(int l1, int c1, int l2, int c2, Interval enclosing) {
            assert (l1 <= l2);
            this.l1 = l1;
            this.c1 = c1;
            this.l2 = l2;
            this.c2 = c2;
            if (enclosing != null) {
                assert (enclosing.l1 <= l1);
                assert (enclosing.l2 >= l2);
            }
            this.enclosing = enclosing;
        }

        private boolean contains(int l) {
            return this.l1 <= l && l <= this.l2;
        }

        private int firstColumnOn(int l) {
            if (l == this.l1) {
                return this.c1;
            }
            return 1;
        }

        private int lastColumnOn(int l) {
            if (l == this.l2) {
                return this.c2;
            }
            return -1;
        }

        public String toString() {
            return "Interval<" + this.l1 + ", " + this.l2 + ">";
        }
    }
}

