/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import org.netbeans.modules.java.lsp.server.URITranslator;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistry;
import org.netbeans.modules.java.lsp.server.explorer.TreeViewProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.ExplorerManagerFactory;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeChangeType;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeChangedParams;
import org.netbeans.modules.java.lsp.server.explorer.api.ResourceData;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeItemData;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TreeNodeRegistryImpl
implements TreeNodeRegistry {
    private static final Logger LOG = Logger.getLogger(TreeNodeRegistryImpl.class.getName());
    private static final String ENCODING_BASE64 = "base64";
    private static final String PROTO_LSPCACHE = "lspcache";
    private static final String CACHE_ICONS_NAME = "icons";
    private static final String EXT_PNG = ".png";
    private static final String MIME_PNG = "image/png";
    private static final String ICONS_PREFIX = "//icons/";
    private static final String URLPREFIX_LSPCACHE = "lspcache://icons/";
    private final Lookup sessionLookup;
    private final Map<String, TreeViewProvider> providers = new HashMap<String, TreeViewProvider>();
    private final Map<Integer, TreeViewProvider> node2Provider = new HashMap<Integer, TreeViewProvider>();
    private final Map<Image, TreeNodeRegistry.ImageDataOrIndex> images = new WeakHashMap<Image, TreeNodeRegistry.ImageDataOrIndex>();
    private final Map<URI, TreeNodeRegistry.ImageDataOrIndex> imageData = new WeakHashMap<URI, TreeNodeRegistry.ImageDataOrIndex>();
    private RequestProcessor RP = new RequestProcessor(this.getClass());
    private int nodeCounter = 1;
    private NbCodeLanguageClient langClient;
    private static final int FIRE_DELAY = 50;
    private static final int MIN_DELAY = 20;
    private Map<Integer, E> queuedChanges = new LinkedHashMap<Integer, E>();
    private boolean scheduled;
    private RequestProcessor.Task fireRef;
    private RequestProcessor.Task FIRE = this.RP.create(() -> {
        ArrayList<NodeChangedParams> toFire = new ArrayList<NodeChangedParams>();
        long limit = System.currentTimeMillis() - 20L;
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            Iterator<E> it = this.queuedChanges.values().iterator();
            while (it.hasNext()) {
                E e = it.next();
                if (e.timestamp > limit) break;
                it.remove();
                toFire.add(e.data);
            }
            if (this.queuedChanges.isEmpty()) {
                this.scheduled = false;
            } else {
                this.fireRef.schedule(50);
            }
        }
        for (NodeChangedParams p : toFire) {
            this.notifyItemChanged(p);
        }
    }, true);
    private long listenerId;
    private Map<Long, L> nodeListeners = new HashMap<Long, L>();

    public TreeNodeRegistryImpl(Lookup sessionLookup) {
        this.sessionLookup = sessionLookup;
        this.fireRef = this.FIRE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterNode(int nodeId, Node n) {
        LOG.log(Level.FINEST, "Discarding node #{0}", nodeId);
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            this.node2Provider.remove(nodeId);
        }
    }

    @Override
    public synchronized int registerNode(Node n, TreeViewProvider tvp) {
        int id = ++this.nodeCounter;
        LOG.log(Level.FINEST, "Registered node #{0}, {1}", new Object[]{id, n});
        this.node2Provider.put(id, tvp);
        return id;
    }

    @Override
    public Node findNode(int id) {
        return this.providerOf(id).findNode(id);
    }

    @Override
    public synchronized TreeViewProvider providerOf(int id) {
        TreeViewProvider p = this.node2Provider.get(id);
        return p != null ? p : TreeViewProvider.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<TreeViewProvider> createProvider(String id) {
        LOG.log(Level.FINER, "Asked for {0}", id);
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            TreeViewProvider p = this.providers.get(id);
            if (p != null) {
                return CompletableFuture.completedFuture(p);
            }
        }
        ProxyLookup ctxLookup = new ProxyLookup(new Lookup[]{Lookups.forPath((String)("Explorers/" + id)), Lookups.forPath((String)"Explorers/_all")});
        FileObject conf = FileUtil.getConfigFile((String)("Explorers/" + id));
        boolean confirmDelete = conf != null && conf.getAttribute("explorerConfirmsDelete") == Boolean.TRUE;
        for (ExplorerManagerFactory f : ctxLookup.lookupAll(ExplorerManagerFactory.class)) {
            CompletionStage<ExplorerManager> em = f.createManager(id, (Lookup)ctxLookup);
            if (em == null) continue;
            LOG.log(Level.FINER, "Creating provider from factory {0}", f);
            return em.thenApply(arg_0 -> this.lambda$createProvider$0(id, (Lookup)ctxLookup, confirmDelete, arg_0));
        }
        CompletableFuture<TreeViewProvider> f = new CompletableFuture<TreeViewProvider>();
        f.completeExceptionally(new IllegalArgumentException("View " + id + " is not supported."));
        return f;
    }

    protected void notifyItemChanged(NodeChangedParams itemId) {
    }

    private synchronized TreeViewProvider registerManager(final ExplorerManager em, String id, Lookup ctxLookup, boolean confirmDelete) {
        TreeViewProvider p = this.providers.get(id);
        if (p != null) {
            return p;
        }
        em.addVetoableChangeListener(e -> {
            if ("rootContext".equals(e.getPropertyName())) {
                throw new PropertyVetoException("Root change not allowed", e);
            }
        });
        ActionMap map = new ActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)em));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)em));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)em));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)em, (boolean)confirmDelete));
        Lookup expLookup = ExplorerUtils.createLookup((ExplorerManager)em, (ActionMap)map);
        TreeViewProvider tvp = new TreeViewProvider(id, em, this, (Lookup)new ProxyLookup(new Lookup[]{expLookup, ctxLookup})){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onDidChangeTreeData(Node n, NodeChangeType type, String property) {
                int rootId = this.findId(em.getRootContext());
                if (n == null) {
                    TreeNodeRegistryImpl.this.notifyItemChanged(new NodeChangedParams(rootId));
                    return;
                }
                int nodeId = this.findId(n);
                if (nodeId == -1) {
                    return;
                }
                TreeNodeRegistryImpl treeNodeRegistryImpl = TreeNodeRegistryImpl.this;
                synchronized (treeNodeRegistryImpl) {
                    E e = (E)TreeNodeRegistryImpl.this.queuedChanges.remove(nodeId);
                    if (e == null) {
                        e = new E(rootId, nodeId);
                    }
                    TreeNodeRegistryImpl.this.queuedChanges.put(nodeId, e);
                    if (type != null) {
                        e.data.addType(type);
                    }
                    if (type == NodeChangeType.PROPERTY) {
                        if (property != null) {
                            e.data.addChangedProperty(property);
                        } else {
                            e.data.setChangedProperties(null);
                        }
                    }
                    if (!TreeNodeRegistryImpl.this.scheduled) {
                        TreeNodeRegistryImpl.this.scheduled = true;
                        TreeNodeRegistryImpl.this.FIRE.schedule(50);
                    }
                }
            }
        };
        this.providers.put(id, tvp);
        return tvp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceData imageContents(URI uri) {
        URL toOpen;
        TreeNodeRegistry.ImageDataOrIndex d;
        block20: {
            String scheme = uri.getScheme();
            TreeNodeRegistryImpl treeNodeRegistryImpl = this;
            synchronized (treeNodeRegistryImpl) {
                d = this.imageData.get(uri);
                if (d != null && d.imageData != null) {
                    ResourceData rd = new ResourceData();
                    rd.setContentSize(d.imageData.length);
                    String base64Content = Base64.getEncoder().encodeToString(d.imageData).replace("\\n", "");
                    rd.setContent(base64Content);
                    rd.setContentType(d.contentType);
                    rd.setEncoding(ENCODING_BASE64);
                    return rd;
                }
            }
            try {
                if ("nbres".equals(scheme)) {
                    toOpen = uri.toURL();
                    break block20;
                }
                if (PROTO_LSPCACHE.equals(scheme) && uri.getSchemeSpecificPart().startsWith(ICONS_PREFIX)) {
                    String fn = uri.getSchemeSpecificPart().substring(ICONS_PREFIX.length());
                    File iconFile = new File(new File(URITranslator.getCacheDir(), CACHE_ICONS_NAME), fn);
                    toOpen = iconFile.toURI().toURL();
                    break block20;
                }
                throw new IllegalArgumentException("Resource not found: " + uri);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        URLConnection c = null;
        try {
            c = toOpen.openConnection();
            ResourceData rd = new ResourceData();
            try (InputStream istm = c.getInputStream();){
                byte[] content = new byte[c.getContentLength()];
                istm.read(content);
                rd.setContentSize(content.length);
                String base64Content = Base64.getEncoder().encodeToString(content).replace("\\n", "");
                rd.setContent(base64Content);
                rd.setContentType(c.getContentType());
                rd.setEncoding(ENCODING_BASE64);
                TreeNodeRegistryImpl treeNodeRegistryImpl = this;
                synchronized (treeNodeRegistryImpl) {
                    if (d != null) {
                        d.contentType = c.getContentType();
                        d.imageData = content;
                    }
                }
            }
            return rd;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeNodeRegistry.ImageDataOrIndex imageOrIndex(Image i) {
        TreeNodeRegistry.ImageDataOrIndex res;
        block19: {
            TreeNodeRegistryImpl treeNodeRegistryImpl = this;
            synchronized (treeNodeRegistryImpl) {
                res = this.images.get(i);
                if (res != null) {
                    return res;
                }
            }
            URL u = ImageUtilities.findImageBaseURL((Image)i);
            try {
                File nf;
                if (u != null) {
                    URI u2 = TreeViewProvider.builtinURI2URI(TreeViewProvider.findImageURI(i));
                    res = new TreeNodeRegistry.ImageDataOrIndex(u2);
                    break block19;
                }
                byte[] data = this.printImagePngData(i);
                MessageDigest md = MessageDigest.getInstance("SHA1");
                byte[] dg = md.digest(data);
                String base64Content = Base64.getUrlEncoder().encodeToString(dg).replace("\\n", "");
                String fname = base64Content + EXT_PNG;
                File iconsDir = new File(URITranslator.getCacheDir(), CACHE_ICONS_NAME);
                if ((iconsDir.mkdirs() || iconsDir.isDirectory()) && !(nf = new File(iconsDir, fname)).exists()) {
                    try (OutputStream ostm = Files.newOutputStream(nf.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        ostm.write(data);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Error creating disk image cache {0}", nf);
                        LOG.log(Level.FINE, "Exception creating file/content:", ex);
                    }
                }
                res = new TreeNodeRegistry.ImageDataOrIndex(new URI(URLPREFIX_LSPCACHE + fname)).imageData(ENCODING_BASE64, data);
            }
            catch (IOException | URISyntaxException | NoSuchAlgorithmException ex) {
                LOG.log(Level.WARNING, "Could not load or print image: {0}", i);
                LOG.log(Level.WARNING, "Image content generation failed with exception:", ex);
                res = new TreeNodeRegistry.ImageDataOrIndex(TreeItemData.NO_URI);
            }
        }
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            this.images.put(i, res);
            this.imageData.put(res.baseURI, res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] printImagePngData(Image i) throws IOException {
        BufferedImage bi;
        if (i instanceof BufferedImage) {
            bi = (BufferedImage)i;
        } else {
            class IO
            implements ImageObserver {
                int bits;
                CountDownLatch cdl = new CountDownLatch(1);
                int height = -1;
                int width = -1;

                IO() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    this.bits |= 3 & infoflags;
                    IO iO = this;
                    synchronized (iO) {
                        if ((infoflags & 1) > 0) {
                            this.height = height;
                        }
                        if ((infoflags & 2) > 0) {
                            this.width = width;
                        }
                    }
                    if ((infoflags & 0xC0) > 0) {
                        this.cdl.countDown();
                        return false;
                    }
                    if ((infoflags & 0x20) > 0) {
                        this.cdl.countDown();
                        return false;
                    }
                    return true;
                }
            }
            IO observer = new IO();
            int h = i.getHeight(observer);
            int w = i.getWidth(observer);
            if (h == -1 || w == -1) {
                try {
                    observer.cdl.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IO iO = observer;
                synchronized (iO) {
                    h = observer.height;
                    w = observer.width;
                    if (h == -1 || w == -1) {
                        LOG.log(Level.WARNING, "Could not realize image to get its size: {0}", i);
                        return null;
                    }
                }
            }
            bi = new BufferedImage(w, h, 2);
            Graphics2D bGr = bi.createGraphics();
            bGr.drawImage(i, 0, 0, null);
            bGr.dispose();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", baos);
        baos.flush();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addNodeChangesListener(int id, Set<NodeChangeType> types) {
        long ret;
        Node n = this.findNode(id);
        if (n == null) {
            return -1L;
        }
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            ret = ++this.listenerId;
            L l = new L(id, n);
            this.nodeListeners.put(ret, l);
            l.add(types);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeChangesListener(long listenerId, Set<NodeChangeType> types) {
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            L l = this.nodeListeners.get(listenerId);
            if (l == null) {
                return;
            }
            l.remove(types == null || types.isEmpty() ? EnumSet.allOf(NodeChangeType.class) : types);
        }
    }

    private /* synthetic */ TreeViewProvider lambda$createProvider$0(String id, Lookup ctxLookup, boolean confirmDelete, ExplorerManager em2) {
        return this.registerManager(em2, id, ctxLookup, confirmDelete);
    }

    private class L
    implements NodeListener,
    PropertyChangeListener {
        private final int id;
        private final Node node;
        private Set<NodeChangeType> types = EnumSet.noneOf(NodeChangeType.class);
        private volatile boolean destroyed;
        private List<Runnable> propDisposes;

        public L(int id, Node node) {
            this.id = id;
            this.node = node;
        }

        public void add(Set<NodeChangeType> toAdd) {
            boolean prevN = this.types.contains((Object)NodeChangeType.CHILDREN) || this.types.contains((Object)NodeChangeType.DESTROY) || this.types.contains((Object)NodeChangeType.SELF);
            boolean prevP = this.types.contains((Object)NodeChangeType.PROPERTY);
            this.types.addAll(toAdd);
            boolean newN = this.types.contains((Object)NodeChangeType.CHILDREN) || this.types.contains((Object)NodeChangeType.DESTROY) || this.types.contains((Object)NodeChangeType.SELF);
            boolean newP = this.types.contains((Object)NodeChangeType.PROPERTY);
            if (prevN != newN && newN) {
                this.node.addPropertyChangeListener((PropertyChangeListener)this);
                this.node.addNodeListener((NodeListener)this);
            }
            if (prevP != newP && newP) {
                if (!newN) {
                    this.node.addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.refreshPropertySets();
            }
        }

        public synchronized void remove(Set<NodeChangeType> toRemove) {
            boolean prevN = this.types.contains((Object)NodeChangeType.CHILDREN) || this.types.contains((Object)NodeChangeType.DESTROY) || this.types.contains((Object)NodeChangeType.SELF);
            boolean prevP = this.types.contains((Object)NodeChangeType.PROPERTY);
            this.types.removeAll(toRemove);
            boolean newN = this.types.contains((Object)NodeChangeType.CHILDREN) || this.types.contains((Object)NodeChangeType.DESTROY) || this.types.contains((Object)NodeChangeType.SELF);
            boolean newP = this.types.contains((Object)NodeChangeType.PROPERTY);
            if (prevN != newN && prevN) {
                this.node.removeNodeListener((NodeListener)this);
            }
            if (!newP && !newN) {
                this.node.removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (prevP != newP && prevP) {
                this.unregisterSheetListeners();
            }
        }

        private synchronized void unregisterSheetListeners() {
            this.propDisposes.forEach(Runnable::run);
            this.propDisposes.clear();
        }

        private synchronized void refreshPropertySets() {
            this.unregisterSheetListeners();
            for (Node.PropertySet ps : this.node.getPropertySets()) {
                if (!(ps instanceof Sheet.Set)) continue;
                Sheet.Set ss = (Sheet.Set)ps;
                ss.addPropertyChangeListener((PropertyChangeListener)this);
                this.propDisposes.add(() -> ss.removePropertyChangeListener((PropertyChangeListener)this));
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
            this.children();
        }

        public void childrenRemoved(NodeMemberEvent ev) {
            this.children();
        }

        public void childrenReordered(NodeReorderEvent ev) {
            this.children();
        }

        void children() {
            if (this.destroyed) {
                return;
            }
            if (!this.types.contains((Object)NodeChangeType.CHILDREN)) {
                return;
            }
            TreeNodeRegistryImpl.this.providerOf(this.id).onDidChangeTreeData(this.node, NodeChangeType.CHILDREN, null);
        }

        public void nodeDestroyed(NodeEvent ev) {
            if (this.destroyed) {
                return;
            }
            if (!this.types.contains((Object)NodeChangeType.DESTROY)) {
                return;
            }
            this.destroyed = true;
            TreeNodeRegistryImpl.this.providerOf(this.id).onDidChangeTreeData(this.node, NodeChangeType.DESTROY, null);
            TreeNodeRegistryImpl.this.removeNodeChangesListener(this.id, this.types);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.destroyed) {
                return;
            }
            boolean prop = this.types.contains((Object)NodeChangeType.PROPERTY);
            TreeViewProvider p = TreeNodeRegistryImpl.this.providerOf(this.id);
            if (p == null) {
                return;
            }
            if (evt.getSource() == this.node) {
                if (prop && "propertySets".equals(evt.getPropertyName())) {
                    p.onDidChangeTreeData(this.node, NodeChangeType.PROPERTY, null);
                } else if (this.types.contains((Object)NodeChangeType.SELF)) {
                    p.onDidChangeTreeData(this.node, NodeChangeType.SELF, null);
                }
                return;
            }
            if (!prop) {
                return;
            }
            if (evt.getSource() instanceof Node.PropertySet) {
                p.onDidChangeTreeData(this.node, NodeChangeType.PROPERTY, null);
                return;
            }
            p.onDidChangeTreeData(this.node, NodeChangeType.PROPERTY, evt.getPropertyName());
        }
    }

    private static class E {
        long timestamp = System.currentTimeMillis();
        NodeChangedParams data;

        public E(int rootId, int nodeId) {
            this.data = new NodeChangedParams(rootId, nodeId);
        }
    }
}

