/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.lsp.LazyCodeAction;
import org.netbeans.api.lsp.Range;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.spi.lsp.CodeActionProvider;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class CodeActionsProvider2LspApiBridge
extends CodeActionsProvider {
    private static final String URL = "url";
    private static final String INDEX = "index";
    private List<LazyCodeAction> lastCodeActions = null;

    @Override
    public Set<String> getCommands() {
        HashSet<String> allCommands = new HashSet<String>();
        for (CommandProvider cmdProvider : Lookup.getDefault().lookupAll(CommandProvider.class)) {
            allCommands.addAll(cmdProvider.getCommands());
        }
        return allCommands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        for (CommandProvider cmdProvider : Lookup.getDefault().lookupAll(CommandProvider.class)) {
            if (!cmdProvider.getCommands().contains(command)) continue;
            return cmdProvider.runCommand(command, arguments).thenApply(ret -> {
                if (ret instanceof WorkspaceEdit) {
                    return Utils.workspaceEditFromApi((WorkspaceEdit)ret, null, client);
                }
                return ret;
            });
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        this.lastCodeActions = new ArrayList<LazyCodeAction>();
        ArrayList<CodeAction> allActions = new ArrayList<CodeAction>();
        Document doc = resultIterator.getSnapshot().getSource().getDocument(false);
        if (doc instanceof StyledDocument) {
            String uri = params.getTextDocument().getUri();
            int startOffset = Utils.getOffset((StyledDocument)doc, params.getRange().getStart());
            int endOffset = Utils.getOffset((StyledDocument)doc, params.getRange().getEnd());
            Range r = new Range(startOffset, endOffset);
            List only = params.getContext().getOnly();
            Lookup l = only != null ? Lookups.fixed((Object[])new Object[]{client, resultIterator, only}) : Lookups.fixed((Object[])new Object[]{client, resultIterator});
            for (CodeActionProvider caProvider : Lookup.getDefault().lookupAll(CodeActionProvider.class)) {
                try {
                    for (org.netbeans.api.lsp.CodeAction ca : caProvider.getCodeActions(doc, r, l)) {
                        HashMap<String, Object> data = null;
                        String command = ca.getCommand() != null ? ca.getCommand().getCommand() : null;
                        WorkspaceEdit edit = null;
                        if (ca instanceof LazyCodeAction && ((LazyCodeAction)ca).getLazyEdit() != null) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put(URL, uri);
                            map.put(INDEX, this.lastCodeActions.size());
                            this.lastCodeActions.add((LazyCodeAction)ca);
                            data = map;
                        } else if (ca.getEdit() != null) {
                            edit = ca.getEdit();
                        }
                        CodeAction codeAction = this.createCodeAction(client, ca.getTitle(), ca.getKind(), data, command, command != null ? ca.getCommand().getArguments() : null);
                        if (edit != null) {
                            codeAction.setEdit(Utils.workspaceEditFromApi(edit, uri, client));
                        }
                        allActions.add(codeAction);
                    }
                }
                catch (Exception ex) {
                    client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                }
            }
        }
        return allActions;
    }

    @Override
    public CompletableFuture<CodeAction> resolve(NbCodeLanguageClient client, CodeAction codeAction, Object data) {
        LazyCodeAction inputAction;
        JsonObject obj;
        if (data instanceof JsonObject && (obj = (JsonObject)data).has(URL) && obj.has(INDEX) && (inputAction = this.lastCodeActions.get(obj.getAsJsonPrimitive(INDEX).getAsInt())) != null) {
            codeAction.setEdit(Utils.workspaceEditFromApi((WorkspaceEdit)inputAction.getLazyEdit().get(), obj.getAsJsonPrimitive(URL).getAsString(), client));
        }
        return CompletableFuture.completedFuture(codeAction);
    }
}

