/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.attach;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.modules.java.lsp.server.debugging.attach.Bundle;
import org.netbeans.modules.java.lsp.server.debugging.attach.ConfigurationAttribute;
import org.netbeans.modules.java.lsp.server.debugging.attach.ConfigurationAttributes;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.DebugConnector;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.openide.util.RequestProcessor;

public final class AttachConfigurations {
    static final String CONFIG_TYPE = "java8+";
    static final String CONFIG_REQUEST = "attach";
    static final RequestProcessor RP = new RequestProcessor(AttachConfigurations.class);
    private final List<ConfigurationAttributes> configurations;

    private AttachConfigurations(List<AttachingConnector> attachingConnectors) {
        ArrayList<ConfigurationAttributes> configs = new ArrayList<ConfigurationAttributes>(5);
        for (AttachingConnector ac : attachingConnectors) {
            configs.add(new ConfigurationAttributes(ac));
        }
        this.configurations = Collections.unmodifiableList(configs);
    }

    public static AttachConfigurations get() {
        return new AttachConfigurations(Bootstrap.virtualMachineManager().attachingConnectors());
    }

    public static CompletableFuture<Object> findConnectors() {
        return CompletableFuture.supplyAsync(() -> AttachConfigurations.get().listAttachingConnectors(), (Executor)RP);
    }

    List<ConfigurationAttributes> getConfigurations() {
        return this.configurations;
    }

    private List<DebugConnector> listAttachingConnectors() {
        ArrayList<DebugConnector> connectors = new ArrayList<DebugConnector>(this.configurations.size());
        for (ConfigurationAttributes configAttributes : this.configurations) {
            Map<String, ConfigurationAttribute> attributesMap = configAttributes.getAttributes();
            ArrayList<String> names = new ArrayList<String>(2);
            ArrayList<String> values = new ArrayList<String>(2);
            ArrayList<String> descriptions = new ArrayList<String>(2);
            for (Map.Entry<String, ConfigurationAttribute> entry : attributesMap.entrySet()) {
                ConfigurationAttribute ca = entry.getValue();
                if (!ca.isMustSpecify()) continue;
                names.add(entry.getKey());
                values.add(ca.getDefaultValue());
                descriptions.add(ca.getDescription());
            }
            DebugConnector connector = new DebugConnector(configAttributes.getId(), configAttributes.getName(), CONFIG_TYPE, names, values, descriptions);
            connectors.add(connector);
        }
        connectors.sort((c1, c2) -> c1.getName().compareToIgnoreCase(c2.getName()));
        return connectors;
    }

    ConfigurationAttributes findConfiguration(Map<String, Object> attributes) {
        if (!CONFIG_TYPE.equals(attributes.get("type")) || !CONFIG_REQUEST.equals(attributes.get("request"))) {
            return null;
        }
        Set<String> names = attributes.keySet();
        for (ConfigurationAttributes config : this.configurations) {
            if (!config.areMandatoryAttributesIn(names)) continue;
            return config;
        }
        return null;
    }

    public static CompletableFuture<Object> findProcessAttachTo(NbCodeLanguageClient client) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> AttachConfigurations.listProcessesToAttachTo(client), (Executor)RP).thenCompose(params -> client.showQuickPick((ShowQuickPickParams)params))).thenApply(itemsList -> {
            if (itemsList == null || itemsList.isEmpty()) {
                return null;
            }
            return ((QuickPickItem)itemsList.get(0)).getUserData();
        });
    }

    private static void notifyNoProcessesError(NbCodeLanguageClient client) {
        MessageParams params = new MessageParams();
        params.setMessage(Bundle.MSG_NoDebuggableProcess());
        params.setType(MessageType.Error);
        client.showMessage(params);
    }

    private static ShowQuickPickParams listProcessesToAttachTo(NbCodeLanguageClient client) {
        ArrayList<QuickPickItem> attachables = new ArrayList<QuickPickItem>();
        List<VirtualMachineDescriptor> descriptors = VirtualMachine.list();
        for (VirtualMachineDescriptor descriptor : descriptors) {
            try {
                VirtualMachine vm = VirtualMachine.attach(descriptor);
                Properties agentProperties = vm.getAgentProperties();
                boolean hasJDWP = false;
                for (Object key : agentProperties.keySet()) {
                    if (!(key instanceof String) || !((String)key).contains("jdwp")) continue;
                    hasJDWP = true;
                    break;
                }
                if (!hasJDWP) continue;
                attachables.add(AttachConfigurations.createQuickPickItem(descriptor, vm));
            }
            catch (AttachNotSupportedException | IOException ex) {}
        }
        if (attachables.isEmpty()) {
            AttachConfigurations.notifyNoProcessesError(client);
            throw ErrorUtilities.createResponseErrorException("No debuggable JVM process found.", ResponseErrorCode.RequestCancelled);
        }
        return new ShowQuickPickParams(Bundle.LBL_PickProcessAttach(), attachables);
    }

    private static QuickPickItem createQuickPickItem(VirtualMachineDescriptor descriptor, VirtualMachine vm) {
        int index;
        String description;
        String label = descriptor.id();
        String detail = descriptor.displayName();
        if ("Unknown".equals(detail)) {
            String command = null;
            try {
                command = vm.getSystemProperties().getProperty("sun.java.command");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (command == null) {
                try {
                    command = vm.getAgentProperties().getProperty("sun.java.command");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (command != null) {
                detail = command;
            }
        }
        String string = description = (index = detail.indexOf(32)) > 0 ? detail.substring(0, index) : detail;
        if (index <= 0) {
            detail = null;
        }
        String userData = descriptor.id();
        return new QuickPickItem(label, description, detail, false, userData);
    }
}

