/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.variables;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.SetVariableResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.NbScope;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.debugging.variables.ViewModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class NbVariablesRequestHandler {
    private static final String LOCALS_VIEW_NAME = "LocalsView";
    private static final String LOCALS_VALUE_COLUMN_ID = "LocalsValue";
    private static final String LOCALS_TO_STRING_COLUMN_ID = "LocalsToString";
    private static final String LOCALS_TYPE_COLUMN_ID = "LocalsType";
    private final ViewModel.Provider localsModelProvider = new ViewModel.Provider("LocalsView");

    public CompletableFuture<VariablesResponse> variables(VariablesArguments arguments, DebugAdapterContext context) {
        CompletableFuture<VariablesResponse> future = new CompletableFuture<VariablesResponse>();
        VariablesResponse response = new VariablesResponse();
        Object container = context.getThreadsProvider().getThreadObjects().getObject(arguments.getVariablesReference());
        if (container == null) {
            response.setVariables(new Variable[0]);
        } else {
            int threadId;
            Session session = context.getDebugSession().getSession();
            Models.CompoundModel localsModel = this.localsModelProvider.getModel(session);
            if (container instanceof NbScope) {
                threadId = ((NbScope)container).getFrame().getThreadId();
                container = localsModel.getRoot();
            } else {
                threadId = context.getThreadsProvider().getThreadObjects().findObjectThread(arguments.getVariablesReference());
            }
            ArrayList<Variable> list = new ArrayList<Variable>();
            try {
                Object[] children;
                int count;
                int n = count = arguments.getCount() != null ? arguments.getCount() : 0;
                if (count > 0) {
                    int start = arguments.getStart() != null ? arguments.getStart() : 0;
                    children = localsModel.getChildren(container, start, start + count);
                } else {
                    children = localsModel.getChildren(container, 0, Integer.MAX_VALUE);
                }
                for (Object child : children) {
                    String value;
                    String name = localsModel.getDisplayName(child);
                    try {
                        value = String.valueOf(localsModel.getValueAt(child, LOCALS_TO_STRING_COLUMN_ID));
                    }
                    catch (UnknownTypeException ex) {
                        value = String.valueOf(localsModel.getValueAt(child, LOCALS_VALUE_COLUMN_ID));
                    }
                    String type = String.valueOf(localsModel.getValueAt(child, LOCALS_TYPE_COLUMN_ID));
                    Variable variable = new Variable();
                    variable.setName(name);
                    variable.setValue(value);
                    variable.setType(type);
                    if (!localsModel.isLeaf(child)) {
                        int id = context.getThreadsProvider().getThreadObjects().addObject(threadId, child);
                        variable.setVariablesReference(id);
                    }
                    list.add(variable);
                }
            }
            catch (UnknownTypeException e) {
                ErrorUtilities.completeExceptionally(future, e.getMessage(), ResponseErrorCode.InternalError);
                return future;
            }
            response.setVariables(list.toArray(new Variable[list.size()]));
        }
        future.complete(response);
        return future;
    }

    public CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args, DebugAdapterContext context) {
        int threadId;
        CompletableFuture<SetVariableResponse> future = new CompletableFuture<SetVariableResponse>();
        if (StringUtils.isBlank((CharSequence)args.getValue())) {
            ErrorUtilities.completeExceptionally(future, "SetVariablesRequest: property 'value' is missing, null, or empty", ResponseErrorCode.InvalidParams);
            return future;
        }
        if (args.getVariablesReference() == -1) {
            ErrorUtilities.completeExceptionally(future, "SetVariablesRequest: property 'variablesReference' is missing, null, or empty", ResponseErrorCode.InvalidParams);
            return future;
        }
        if (StringUtils.isBlank((CharSequence)args.getName())) {
            ErrorUtilities.completeExceptionally(future, "SetVariablesRequest: property 'name' is missing, null, or empty", ResponseErrorCode.InvalidParams);
            return future;
        }
        Object container = context.getThreadsProvider().getThreadObjects().getObject(args.getVariablesReference());
        if (container == null) {
            ErrorUtilities.completeExceptionally(future, "Failed to set variable. Reason: Cannot set value because the thread is resumed.", ResponseErrorCode.InternalError);
            return future;
        }
        Session session = context.getDebugSession().getSession();
        Models.CompoundModel localsModel = this.localsModelProvider.getModel(session);
        if (container instanceof NbScope) {
            threadId = ((NbScope)container).getFrame().getThreadId();
            container = localsModel.getRoot();
        } else {
            threadId = context.getThreadsProvider().getThreadObjects().findObjectThread(args.getVariablesReference());
        }
        String varName = args.getName();
        try {
            Object[] children = localsModel.getChildren(container, 0, Integer.MAX_VALUE);
            Object varChild = null;
            for (Object child : children) {
                String name = localsModel.getDisplayName(child);
                if (!varName.equals(name)) continue;
                varChild = child;
                break;
            }
            if (varChild != null) {
                localsModel.setValueAt(varChild, LOCALS_VALUE_COLUMN_ID, (Object)args.getValue());
                String value = String.valueOf(localsModel.getValueAt(varChild, LOCALS_TO_STRING_COLUMN_ID));
                String type = String.valueOf(localsModel.getValueAt(varChild, LOCALS_TYPE_COLUMN_ID));
                int id = context.getThreadsProvider().getThreadObjects().addObject(threadId, varChild);
                SetVariableResponse response = new SetVariableResponse();
                response.setType(type);
                response.setValue(value);
                response.setVariablesReference(Integer.valueOf(id));
                response.setIndexedVariables(Integer.valueOf(0));
                future.complete(response);
            } else {
                ErrorUtilities.completeExceptionally(future, String.format("SetVariableRequest: Variable %s cannot be found.", varName), ResponseErrorCode.InternalError);
            }
        }
        catch (UnknownTypeException e) {
            ErrorUtilities.completeExceptionally(future, e.getMessage(), ResponseErrorCode.InternalError);
        }
        return future;
    }
}

