/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.lookup.Lookups;

public final class WorkspaceServiceImpl
implements WorkspaceService,
LanguageClientAware {
    private NbCodeLanguageClient client;

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        switch (params.getCommand()) {
            case "graalvm.pause.script": {
                ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
                am.doAction((Object)"pauseInGraalScript");
                return CompletableFuture.completedFuture(true);
            }
            case "java.build.workspace": {
                for (Project prj : OpenProjects.getDefault().getOpenProjects()) {
                    ActionProvider ap = (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
                    if (ap == null || !ap.isActionEnabled("build", Lookups.fixed((Object[])new Object[0]))) continue;
                    ap.invokeAction("rebuild", Lookups.fixed((Object[])new Object[0]));
                }
                return CompletableFuture.completedFuture(true);
            }
        }
        throw new UnsupportedOperationException("Command not supported: " + params.getCommand());
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void didChangeConfiguration(DidChangeConfigurationParams arg0) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams arg0) {
    }

    public void connect(LanguageClient client) {
        this.client = (NbCodeLanguageClient)client;
    }
}

