/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.ThreadObjects;
import org.netbeans.spi.debugger.ui.DebuggingView;

public final class NbThreads {
    private int lastId = 1;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<Integer, DebuggingView.DVThread> threads = new HashMap<Integer, DebuggingView.DVThread>();
    private final Map<DebuggingView.DVThread, Integer> threadIds = new HashMap<DebuggingView.DVThread, Integer>();
    private final Map<JPDAThread, Integer> jpdaThreadIds = new HashMap<JPDAThread, Integer>();
    private final ThreadObjects threadObjects = new ThreadObjects();

    public void initialize(final DebugAdapterContext context, Map<String, Object> options) {
        DebuggerManager.getDebuggerManager().addDebuggerListener("sessions", (DebuggerManagerListener)new DebuggerManagerAdapter(){

            public void sessionAdded(Session session) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("sessions", (DebuggerManagerListener)this);
                JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
                NbThreads.this.initThreads(context, debugger);
            }
        });
    }

    private void initThreads(final DebugAdapterContext context, final JPDADebugger debugger) {
        debugger.addPropertyChangeListener("state", evt -> {
            int newState = (Integer)evt.getNewValue();
            switch (newState) {
                case 4: {
                    context.getClient().terminated(new TerminatedEventArguments());
                }
            }
        });
        DebuggerEngine engine = debugger.getSession().getCurrentEngine();
        if (engine == null) {
            debugger.getSession().addPropertyChangeListener("currentLanguage", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DebuggerEngine currentEngine = debugger.getSession().getCurrentEngine();
                    if (currentEngine != null) {
                        debugger.getSession().removePropertyChangeListener("currentLanguage", (PropertyChangeListener)this);
                        if (!NbThreads.this.initialized.getAndSet(true)) {
                            NbThreads.this.initThreads(context, currentEngine);
                        }
                    }
                }
            });
            engine = debugger.getSession().getCurrentEngine();
        }
        if (engine != null && !this.initialized.getAndSet(true)) {
            this.initThreads(context, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initThreads(DebugAdapterContext context, DebuggerEngine engine) {
        DebuggingView.DVSupport dvSupport = (DebuggingView.DVSupport)engine.lookupFirst(null, DebuggingView.DVSupport.class);
        dvSupport.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "threadStarted": {
                    int id;
                    DebuggingView.DVThread dvThread = (DebuggingView.DVThread)evt.getNewValue();
                    Map<Integer, DebuggingView.DVThread> map = this.threads;
                    synchronized (map) {
                        Integer idInteger = this.threadIds.get(dvThread);
                        if (idInteger == null) {
                            id = this.lastId++;
                            this.threads.put(id, dvThread);
                            this.threadIds.put(dvThread, id);
                            this.jpdaThreadIds.put(this.getJPDAThread(dvThread), id);
                        } else {
                            id = idInteger;
                        }
                    }
                    ThreadEventArguments threadStartEvent = new ThreadEventArguments();
                    threadStartEvent.setReason("started");
                    threadStartEvent.setThreadId(id);
                    context.getClient().thread(threadStartEvent);
                    break;
                }
                case "threadDied": {
                    DebuggingView.DVThread dvThread = (DebuggingView.DVThread)evt.getOldValue();
                    int id = 0;
                    Map<Integer, DebuggingView.DVThread> idInteger = this.threads;
                    synchronized (idInteger) {
                        Integer idObject = this.threadIds.remove(dvThread);
                        this.jpdaThreadIds.remove(this.getJPDAThread(dvThread));
                        if (idObject != null) {
                            id = idObject;
                            this.threads.remove(id);
                        }
                    }
                    if (id <= 0) break;
                    ThreadEventArguments threadDeathEvent = new ThreadEventArguments();
                    threadDeathEvent.setReason("exited");
                    threadDeathEvent.setThreadId(id);
                    context.getClient().thread(threadDeathEvent);
                    break;
                }
                case "threadSuspended": {
                    String eventName;
                    DebuggingView.DVThread dvThread = (DebuggingView.DVThread)evt.getNewValue();
                    int id = this.getId(dvThread);
                    assert (id > 0) : "Unknown ID for thread " + dvThread;
                    if (id <= 0) break;
                    if (dvThread.isInStep()) {
                        eventName = "step";
                    } else if (dvThread.getCurrentBreakpoint() != null) {
                        context.getBreakpointManager().notifyBreakpointHit(id, dvThread.getCurrentBreakpoint());
                        eventName = "breakpoint";
                    } else {
                        eventName = "pause";
                    }
                    StoppedEventArguments stoppedEvent = new StoppedEventArguments();
                    stoppedEvent.setReason(eventName);
                    stoppedEvent.setThreadId(Integer.valueOf(id));
                    context.getClient().stopped(stoppedEvent);
                    break;
                }
                case "threadResumed": {
                    DebuggingView.DVThread dvThread = (DebuggingView.DVThread)evt.getNewValue();
                    int id = this.getId(dvThread);
                    assert (id > 0) : "Unknown ID for thread " + dvThread;
                    context.getBreakpointManager().notifyBreakpointHit(id, null);
                }
            }
        });
        Map<Integer, DebuggingView.DVThread> map = this.threads;
        synchronized (map) {
            for (DebuggingView.DVThread dvThread : dvSupport.getAllThreads()) {
                int id;
                if (this.threadIds.containsKey(dvThread)) continue;
                ++this.lastId;
                this.threads.put(id, dvThread);
                this.threadIds.put(dvThread, id);
                this.jpdaThreadIds.put(this.getJPDAThread(dvThread), id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(DebuggingView.DVThread thread) {
        Integer idObject;
        int id = 0;
        Map<Integer, DebuggingView.DVThread> map = this.threads;
        synchronized (map) {
            idObject = this.threadIds.get(thread);
        }
        if (idObject != null) {
            id = idObject;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggingView.DVThread getThread(int id) {
        Map<Integer, DebuggingView.DVThread> map = this.threads;
        synchronized (map) {
            return this.threads.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(JPDAThread thread) {
        Integer idObject;
        int id = 0;
        Map<Integer, DebuggingView.DVThread> map = this.threads;
        synchronized (map) {
            idObject = this.jpdaThreadIds.get(thread);
        }
        if (idObject != null) {
            id = idObject;
        }
        return id;
    }

    private JPDAThread getJPDAThread(DebuggingView.DVThread dvThread) {
        return (JPDAThread)((Supplier)dvThread).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitThreads(BiConsumer<Integer, DebuggingView.DVThread> threadsConsumer) {
        Map<Integer, DebuggingView.DVThread> map = this.threads;
        synchronized (map) {
            for (Map.Entry<Integer, DebuggingView.DVThread> entry : this.threads.entrySet()) {
                threadsConsumer.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public ThreadObjects getThreadObjects() {
        return this.threadObjects;
    }
}

