/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class ProgressUI
implements ProgressListener {
    private static final Logger LOGGER = Logger.getLogger(ProgressUI.class.getName());
    private String title;
    private boolean modal;
    private Deployment.Logger logger;
    private ProgressHandle handle;
    private ProgressObject progObj;
    private JDialog dialog;
    private JLabel messageLabel;
    private String lastMessage;
    private JComponent progressComponent;
    private boolean finished;
    private boolean completionEventProcessed;

    public ProgressUI(String title, boolean modal) {
        this(title, modal, null);
    }

    public ProgressUI(String title, boolean modal, Deployment.Logger logger) {
        this.modal = modal;
        this.title = title;
        this.logger = logger;
        this.handle = ProgressHandle.createHandle((String)title);
    }

    public void start() {
        this.start(null);
    }

    public void start(Integer delay) {
        if (this.modal) {
            this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
        }
        if (delay != null) {
            this.handle.setInitialDelay(delay.intValue());
        }
        this.handle.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showProgressDialog() {
        String lastMessageTmp;
        if (this.finished) {
            return;
        }
        this.dialog = new JDialog(WindowManager.getDefault().getMainWindow(), this.title, true);
        this.dialog.setDefaultCloseOperation(0);
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            lastMessageTmp = this.lastMessage;
        }
        this.dialog.getContentPane().add(this.createProgressDialog(this.handle, lastMessageTmp != null ? lastMessageTmp : this.title));
        this.dialog.pack();
        this.dialog.setBounds(Utilities.findCenterBounds((Dimension)this.dialog.getSize()));
        this.dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        this.dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(final String message) {
        String lastMessageTmp;
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            lastMessageTmp = this.lastMessage;
        }
        if (message != null && message.length() > 0 && !message.equals(lastMessageTmp)) {
            this.handle.progress(message);
            progressUI = this;
            synchronized (progressUI) {
                this.lastMessage = message;
            }
            this.log(message);
        }
        if (this.modal) {
            Mutex.EVENT.readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (ProgressUI.this.messageLabel != null) {
                        ProgressUI.this.messageLabel.setText(message);
                    } else {
                        ProgressUI progressUI = ProgressUI.this;
                        synchronized (progressUI) {
                            ProgressUI.this.lastMessage = message;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.handle.finish();
        ProgressObject po = null;
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            po = this.progObj;
            this.progObj = null;
        }
        if (po != null) {
            po.removeProgressListener((ProgressListener)this);
        }
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ProgressUI.this.finished = true;
                if (ProgressUI.this.dialog != null) {
                    ProgressUI.this.dialog.setVisible(false);
                    ProgressUI.this.dialog.dispose();
                    ProgressUI.this.dialog = null;
                }
            }
        });
    }

    public void failed(String message) {
        this.finish();
        if (this.logger != null) {
            this.log(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressObject(ProgressObject obj) {
        ProgressObject po = null;
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            po = this.progObj;
        }
        if (po != null) {
            po.removeProgressListener((ProgressListener)this);
        }
        progressUI = this;
        synchronized (progressUI) {
            this.progObj = obj;
            if (obj == null) {
                return;
            }
            this.completionEventProcessed = false;
        }
        obj.addProgressListener((ProgressListener)this);
        DeploymentStatus status = obj.getDeploymentStatus();
        if (status.isCompleted() || status.isFailed()) {
            this.handleDeploymentStatus(status);
        } else {
            this.progress(status.getMessage());
        }
    }

    private void log(String msg) {
        try {
            if (this.logger != null && msg != null) {
                LOGGER.log(Level.FINEST, msg);
                this.logger.log(msg);
            }
        }
        catch (ThreadDeath e) {
            LOGGER.log(Level.FINE, null, e);
        }
    }

    private JComponent createProgressDialog(ProgressHandle handle, String message) {
        JPanel panel = new JPanel();
        this.messageLabel = new JLabel();
        panel.setLayout(new GridBagLayout());
        this.messageLabel.setText(message);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        panel.add((Component)this.messageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        panel.add((Component)this.progressComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 12, 12);
        JButton cancel = new JButton(NbBundle.getMessage(ProgressUI.class, (String)"LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProgressUI.class, (String)"AD_Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressUI.this.finish();
            }
        });
        panel.add((Component)cancel, gridBagConstraints);
        return panel;
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        this.handleDeploymentStatus(progressEvent.getDeploymentStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeploymentStatus(DeploymentStatus status) {
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            if (this.completionEventProcessed) {
                return;
            }
            if (status.isCompleted() || status.isFailed()) {
                this.completionEventProcessed = true;
            }
        }
        if (status.isFailed()) {
            this.failed(status.getMessage());
        } else {
            this.progress(status.getMessage());
        }
    }
}

