/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.sharability;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.j2ee.deployment.impl.sharability.JavadocForBinaryQueryImpl;
import org.netbeans.modules.j2ee.deployment.impl.sharability.ServerVolumeContentModel;
import org.netbeans.spi.project.libraries.LibraryCustomizerContext;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ServerVolumeCustomizer
extends JPanel
implements Customizer {
    private String volumeType;
    private LibraryImplementation impl;
    private LibraryStorageArea area;
    private ServerVolumeContentModel model;
    private Boolean allowRelativePaths = null;
    private static File lastFolder = null;
    private JButton addButton;
    private JList content;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JLabel message;
    private JButton removeButton;
    private JButton upButton;
    private JButton addURLButton;

    ServerVolumeCustomizer(String volumeType) {
        this.volumeType = volumeType;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)("ServerVolumeCustomizer.TXT_" + volumeType)));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addButton.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        if (this.addURLButton != null) {
            this.addURLButton.setEnabled(enabled);
        }
        int[] indices = this.content.getSelectedIndices();
        this.removeButton.setEnabled(enabled && indices.length > 0);
        this.downButton.setEnabled(enabled && indices.length > 0 && indices[indices.length - 1] < this.model.getSize() - 1);
        this.upButton.setEnabled(enabled && indices.length > 0 && indices[0] > 0);
    }

    private void postInitComponents() {
        this.content.setCellRenderer(new ContentRenderer());
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        if (!this.volumeType.equals("javadoc") && !this.volumeType.equals("src")) {
            this.addButton.setText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_AddClassPath"));
            this.addButton.setMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_AddClassPath").charAt(0));
            this.message.setText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_ContentClassPath"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_ContentClassPath").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.AD_AddClassPath"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.AD_ContentClassPath"));
        } else if (this.volumeType.equals("javadoc")) {
            this.addButton.setText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_AddJavadoc"));
            this.addButton.setMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_AddJavadoc").charAt(0));
            this.message.setText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_ContentJavadoc"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_ContentJavadoc").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.AD_AddJavadoc"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.AD_ContentJavadoc"));
        } else if (this.volumeType.equals("src")) {
            this.addButton.setText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_AddSources"));
            this.addButton.setMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_AddSources").charAt(0));
            this.message.setText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_ContentSources"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_ContentSources").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.AD_AddSources"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.AD_ContentSources"));
        }
        this.content.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] indices = ServerVolumeCustomizer.this.content.getSelectedIndices();
                ServerVolumeCustomizer.this.removeButton.setEnabled(indices.length > 0);
                ServerVolumeCustomizer.this.downButton.setEnabled(indices.length > 0 && indices[indices.length - 1] < ServerVolumeCustomizer.this.model.getSize() - 1);
                ServerVolumeCustomizer.this.upButton.setEnabled(indices.length > 0 && indices[0] > 0);
            }
        });
    }

    private void initComponents() {
        this.message = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.content = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.message.setLabelFor(this.content);
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.CTL_ContentMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 2, 6);
        this.add((Component)this.message, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.content);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.CTL_AddContent"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerVolumeCustomizer.this.addResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription("null");
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.CTL_RemoveContent"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerVolumeCustomizer.this.removeResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.AD_RemoveContent"));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.CTL_UpContent"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerVolumeCustomizer.this.upResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.add((Component)this.upButton, gridBagConstraints);
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.AD_UpContent"));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.CTL_DownContent"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerVolumeCustomizer.this.downResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.downButton, gridBagConstraints);
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.AD_DownContent"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ServerVolumeCustomizer.class).getString("ServerVolumeCustomizer.AD_J2SEVolumeCustomizer"));
    }

    private void downResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0 || indices[0] < 0 || indices[indices.length - 1] >= this.model.getSize() - 1) {
            return;
        }
        this.model.moveDown(indices);
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = indices[i] + 1;
        }
        this.content.setSelectedIndices(indices);
    }

    private void upResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0 || indices[0] <= 0) {
            return;
        }
        this.model.moveUp(indices);
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = indices[i] - 1;
        }
        this.content.setSelectedIndices(indices);
    }

    private void removeResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0) {
            return;
        }
        this.model.removeResources(indices);
        if (indices[indices.length - 1] - indices.length + 1 < this.model.getSize()) {
            this.content.setSelectedIndex(indices[indices.length - 1] - indices.length + 1);
        } else if (indices[0] >= 1) {
            this.content.setSelectedIndex(indices[0] - 1);
        }
    }

    private void addResource(ActionEvent evt) {
        File baseFolder = null;
        if (this.allowRelativePaths.booleanValue()) {
            baseFolder = new File(URI.create(this.area.getLocation().toExternalForm())).getParentFile();
        }
        FileChooser chooser = new FileChooser(baseFolder, baseFolder);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setAcceptAllFileFilterUsed(false);
        if (!this.volumeType.equals("javadoc") && !this.volumeType.equals("src")) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.TXT_OpenClasses"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter((FileFilter)new SimpleFileFilter(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.TXT_Classpath"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_SelectCP"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_SelectCP").charAt(0));
        } else if (this.volumeType.equals("javadoc")) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.TXT_OpenJavadoc"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter((FileFilter)new SimpleFileFilter(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.TXT_Javadoc"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_SelectJD"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_SelectJD").charAt(0));
        } else if (this.volumeType.equals("src")) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.TXT_OpenSources"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter((FileFilter)new SimpleFileFilter(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.TXT_Sources"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.CTL_SelectSRC"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.MNE_SelectSRC").charAt(0));
        }
        if (lastFolder != null) {
            chooser.setCurrentDirectory(lastFolder);
        } else if (baseFolder != null) {
            chooser.setCurrentDirectory(baseFolder);
        }
        if (chooser.showOpenDialog((Component)this) == 0) {
            try {
                lastFolder = chooser.getCurrentDirectory();
                this.addFiles(chooser.getSelectedPaths(), this.area != null ? this.area.getLocation() : null);
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private void addFiles(String[] fileNames, URL libraryLocation) throws MalformedURLException {
        int firstIndex = this.model.getSize();
        for (int i = 0; i < fileNames.length; ++i) {
            File f = new File(fileNames[i]);
            URI uri = LibrariesSupport.convertFilePathToURI((String)fileNames[i]);
            if (this.allowRelativePaths != null && this.allowRelativePaths.booleanValue()) {
                File realFile = f;
                if (!f.isAbsolute()) {
                    assert (this.area != null);
                    if (this.area != null) {
                        realFile = FileUtil.normalizeFile((File)new File(new File(URI.create(this.area.getLocation().toExternalForm())).getParentFile(), f.getPath()));
                    }
                }
                if (FileUtil.isArchiveFile((URL)realFile.toURI().toURL())) {
                    uri = LibrariesSupport.getArchiveRoot((URI)uri);
                } else if (!uri.toString().endsWith("/")) {
                    try {
                        uri = new URI(uri.toString() + "/");
                    }
                    catch (URISyntaxException ex) {
                        throw new AssertionError((Object)ex);
                    }
                }
                this.model.addResource(uri);
            } else {
                assert (f.isAbsolute()) : f.getPath();
                URL url = FileUtil.normalizeFile((File)f).toURI().toURL();
                if (FileUtil.isArchiveFile((URL)url)) {
                    url = FileUtil.getArchiveRoot((URL)url);
                } else if (!url.toExternalForm().endsWith("/")) {
                    url = new URL(url.toExternalForm() + "/");
                }
                this.model.addResource(url);
            }
            if (!this.volumeType.equals("javadoc") || JavadocForBinaryQueryImpl.isValidLibraryJavadocRoot(LibrariesSupport.resolveLibraryEntryURI((URL)libraryLocation, (URI)uri).toURL())) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.TXT_InvalidJavadocRoot", (Object)f.getPath()), 0));
        }
        int lastIndex = this.model.getSize() - 1;
        if (firstIndex <= lastIndex) {
            int[] toSelect = new int[lastIndex - firstIndex + 1];
            for (int i = 0; i < toSelect.length; ++i) {
                toSelect[i] = firstIndex + i;
            }
            this.content.setSelectedIndices(toSelect);
        }
    }

    @Override
    public void setObject(Object bean) {
        assert (bean instanceof LibraryCustomizerContext) : bean.getClass();
        LibraryCustomizerContext context = (LibraryCustomizerContext)bean;
        this.area = context.getLibraryStorageArea();
        this.impl = context.getLibraryImplementation();
        this.allowRelativePaths = context.getLibraryImplementation2() != null;
        this.model = new ServerVolumeContentModel(this.impl, this.area, this.volumeType);
        this.content.setModel(this.model);
        if (this.model.getSize() > 0) {
            this.content.setSelectedIndex(0);
        }
    }

    private static class ContentRenderer
    extends DefaultListCellRenderer {
        private ContentRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c;
            String displayName = null;
            Color color = null;
            String toolTip = null;
            URI uri = null;
            if (value instanceof URI) {
                uri = (URI)value;
            } else if (value instanceof URL) {
                try {
                    uri = ((URL)value).toURI();
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (uri != null) {
                if (uri.toString().contains("!/")) {
                    uri = LibrariesSupport.getArchiveFile((URI)uri);
                }
                boolean broken = false;
                ServerVolumeContentModel model = (ServerVolumeContentModel)list.getModel();
                LibraryStorageArea area = model.getArea();
                FileObject fo = LibrariesSupport.resolveLibraryEntryFileObject((URL)(area != null ? area.getLocation() : null), (URI)uri);
                if (fo == null) {
                    broken = true;
                    displayName = "file".equals(uri.getScheme()) ? LibrariesSupport.convertURIToFilePath((URI)uri) : uri.toString();
                } else if (uri.isAbsolute()) {
                    displayName = FileUtil.getFileDisplayName((FileObject)fo);
                } else {
                    displayName = LibrariesSupport.convertURIToFilePath((URI)uri);
                    toolTip = FileUtil.getFileDisplayName((FileObject)fo);
                }
                if (broken) {
                    color = new Color(164, 0, 0);
                    toolTip = NbBundle.getMessage(ServerVolumeCustomizer.class, (String)"ServerVolumeCustomizer.TXT_BrokenFile");
                }
            }
            if ((c = super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus)) instanceof JComponent) {
                if (color != null) {
                    ((JComponent)c).setForeground(color);
                }
                if (toolTip != null) {
                    ((JComponent)c).setToolTipText(toolTip);
                } else {
                    ((JComponent)c).setToolTipText(null);
                }
            }
            return c;
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

