/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.openide.loaders.DataObject;

final class SourceData {
    private DataObject resource;
    private I18nSupport support;
    private Map<HardCodedString, I18nString> stringMap = new TreeMap<HardCodedString, I18nString>(new HardStringComparator());
    private Set<HardCodedString> removedStrings;

    public SourceData(DataObject resource) {
        this.resource = resource;
    }

    public SourceData(DataObject resource, I18nSupport support) {
        this.resource = resource;
        this.support = support;
        support.getResourceHolder().setResource(resource);
    }

    public DataObject getResource() {
        return this.resource;
    }

    public I18nSupport getSupport() {
        return this.support;
    }

    public Map<HardCodedString, I18nString> getStringMap() {
        return this.stringMap;
    }

    public void setStringMap(Map<HardCodedString, I18nString> stringMap) {
        this.stringMap.clear();
        this.stringMap.putAll(stringMap);
    }

    public Set<HardCodedString> getRemovedStrings() {
        return this.removedStrings;
    }

    public void setRemovedStrings(Set<HardCodedString> removedStrings) {
        this.removedStrings = removedStrings;
    }

    private static class HardStringComparator
    implements Comparator<HardCodedString> {
        private HardStringComparator() {
        }

        @Override
        public int compare(HardCodedString hcs1, HardCodedString hcs2) {
            return hcs1.getStartPosition().getOffset() - hcs2.getStartPosition().getOffset();
        }
    }
}

