/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;

public abstract class AbstractDiskCache<K extends Serializable, T extends Serializable>
implements Serializable {
    private static final Logger LOG = Logger.getLogger(AbstractDiskCache.class.getName());
    protected K key;
    private boolean valid = false;
    private transient CacheEntry<T> entry;

    protected AbstractDiskCache() {
    }

    protected AbstractDiskCache(K key) {
        this.key = key;
    }

    public final synchronized CacheEntry<T> loadEntry() {
        CacheEntry ret = this.entry;
        if (ret == null && !GradleExperimentalSettings.getDefault().isCacheDisabled()) {
            File cacheFile = this.cacheFile();
            if (cacheFile.canRead()) {
                try (ObjectInputStream is = new ObjectInputStream(new FileInputStream(cacheFile));){
                    ret = (CacheEntry)is.readObject();
                    this.valid = true;
                }
                catch (IOException | ClassNotFoundException ex) {
                    LOG.log(Level.INFO, "Could no load project info from {0} due to: {1}", new Object[]{cacheFile, ex.getMessage()});
                    cacheFile.delete();
                }
            }
            this.entry = ret;
        }
        return ret;
    }

    public final synchronized T loadData() {
        CacheEntry<T> e = this.loadEntry();
        return e != null && e.isValid() ? (T)e.getData() : null;
    }

    public final synchronized void storeData(T data) {
        File cacheFile = this.cacheFile();
        if (!cacheFile.exists()) {
            cacheFile.getParentFile().mkdirs();
        }
        try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(cacheFile));){
            CacheEntryImpl e = new CacheEntryImpl(this, data);
            os.writeObject(e);
            this.entry = e;
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Failed to persist info to {0} due to {1}", new Object[]{cacheFile, ex.getMessage()});
            cacheFile.delete();
        }
    }

    public final synchronized void invalidate() {
        File cacheFile = this.cacheFile();
        this.valid = false;
        if (cacheFile.canRead()) {
            cacheFile.delete();
        }
    }

    protected abstract int cacheVersion();

    protected abstract File cacheFile();

    protected abstract Set<File> cacheInvalidators();

    private final class CacheEntryImpl<T extends Serializable>
    implements CacheEntry<T> {
        int version;
        long timestamp;
        Set<File> sourceFiles;
        T data;

        protected CacheEntryImpl() {
        }

        protected CacheEntryImpl(T data) {
            this.timestamp = System.currentTimeMillis();
            this.version = AbstractDiskCache.this.cacheVersion();
            this.sourceFiles = AbstractDiskCache.this.cacheInvalidators();
            this.data = data;
        }

        @Override
        public boolean isCompatible() {
            return this.version == AbstractDiskCache.this.cacheVersion();
        }

        @Override
        public boolean isValid() {
            boolean ret;
            boolean bl = ret = this.data != null && this.isCompatible();
            if (AbstractDiskCache.this.valid && ret && this.sourceFiles != null) {
                for (File f : this.sourceFiles) {
                    if (f.exists() && f.lastModified() <= this.timestamp) continue;
                    ret = false;
                    break;
                }
            }
            return ret;
        }

        @Override
        public T getData() {
            return this.data;
        }

        public String toString() {
            Class<?> dataClass = this.data != null ? this.data.getClass() : null;
            return "CacheEntryImpl{data:version=" + dataClass + ":" + this.version + ", timestamp=" + new Date(this.timestamp) + ", sourceFiles=" + this.sourceFiles + '}';
        }
    }

    public static interface CacheEntry<D extends Serializable>
    extends Serializable {
        public boolean isCompatible();

        public boolean isValid();

        public D getData();
    }
}

