/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.Serializable;
import java.util.regex.Pattern;

public final class GradleTask
implements Serializable {
    private static final Pattern CAMLE_CASE_SPLITTER = Pattern.compile("(?<!^)(?=[A-Z0-9])");
    final String path;
    final String group;
    final String name;
    final String description;

    GradleTask(String path, String group, String name, String description) {
        this.path = path;
        this.group = group;
        this.name = name;
        this.description = description;
    }

    public String getPath() {
        return this.path;
    }

    public String getGroup() {
        return this.group != null ? this.group : "<private>";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public boolean isPrivate() {
        return this.group == null;
    }

    public boolean matches(String abbrev) {
        return GradleTask.abbrevMatch(abbrev, this.name);
    }

    static boolean abbrevMatch(String abbrev, String name) {
        String[] nameParts;
        if (abbrev.isEmpty()) {
            return true;
        }
        if (abbrev.length() > name.length()) {
            return false;
        }
        String[] abbrevParts = CAMLE_CASE_SPLITTER.split(abbrev);
        if (abbrevParts.length > (nameParts = CAMLE_CASE_SPLITTER.split(name)).length) {
            return false;
        }
        for (int i = 0; i < abbrevParts.length; ++i) {
            String part = abbrevParts[i];
            if (nameParts[i].startsWith(part)) continue;
            return false;
        }
        return true;
    }
}

