/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.netbeans.modules.gradle.spi.GradleSettings;

public final class GradleModuleFileCache21 {
    private static final String CLASSIFIER_SOURCES = "sources";
    private static final String CLASSIFIER_JAVADOC = "javadoc";
    private static final String EXT_JAR = "jar";
    private static final String EXT_POM = "pom";
    private static final Path FILE_CACHE_BASE = Paths.get("caches", "modules-2", "files-2.1");
    final Path cacheBaseDir;

    GradleModuleFileCache21(Path gradleHome) {
        this.cacheBaseDir = gradleHome.resolve(FILE_CACHE_BASE);
    }

    public boolean contains(Path path) {
        return path.startsWith(this.cacheBaseDir);
    }

    public CachedArtifactVersion resolveCachedArtifactVersion(Path artifact) throws IllegalArgumentException {
        return new CachedArtifactVersion(artifact.getParent().getParent());
    }

    public CachedArtifactVersion.Entry resolveEntry(Path artifact) throws IllegalArgumentException {
        CachedArtifactVersion av = this.resolveCachedArtifactVersion(artifact);
        return av.entries.get(artifact.getFileName().toString());
    }

    public CachedArtifactVersion resolveModule(String moduleId) throws IllegalArgumentException {
        String[] gav = GradleModuleFileCache21.gavSplit(moduleId);
        return new CachedArtifactVersion(gav[0], gav[1], gav[2]);
    }

    public static GradleModuleFileCache21 getGradleFileCache(Path gradleHome) {
        return new GradleModuleFileCache21(gradleHome);
    }

    public static GradleModuleFileCache21 getGradleFileCache() {
        return GradleModuleFileCache21.getGradleFileCache(GradleSettings.getDefault().getGradleUserHome().toPath());
    }

    public static String[] gavSplit(String gav) {
        int firstColon = gav.indexOf(58);
        int lastColon = gav.lastIndexOf(58);
        if (firstColon == -1 || firstColon == lastColon) {
            throw new IllegalArgumentException("Invalig GAV format: " + gav);
        }
        return new String[]{gav.substring(0, firstColon), gav.substring(firstColon + 1, lastColon), gav.substring(lastColon + 1)};
    }

    public final class CachedArtifactVersion {
        final Path path;
        final Map<String, Entry> entries = new HashMap<String, Entry>();

        public CachedArtifactVersion(String organization, String module, String version) {
            this.path = GradleModuleFileCache21.this.cacheBaseDir.resolve(Paths.get(organization, module, version));
            try {
                this.readEntries();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public CachedArtifactVersion(Path path) throws IllegalArgumentException {
            if (!path.startsWith(GradleModuleFileCache21.this.cacheBaseDir) || path.getNameCount() - 3 != GradleModuleFileCache21.this.cacheBaseDir.getNameCount()) {
                throw new IllegalArgumentException("Not a Cached Gradle Atrifact Version dir: " + path.toString());
            }
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public String getVersion() {
            return this.path.getFileName().toString();
        }

        public String getModule() {
            return this.path.getParent().getFileName().toString();
        }

        public String getOrganization() {
            return this.path.getParent().getParent().getFileName().toString();
        }

        public Map<String, Entry> getEntries() {
            return Collections.unmodifiableMap(this.entries);
        }

        public Entry getSources() {
            return this.getClassifiedEntry(GradleModuleFileCache21.CLASSIFIER_SOURCES, GradleModuleFileCache21.EXT_JAR);
        }

        public Entry getJavaDoc() {
            return this.getClassifiedEntry(GradleModuleFileCache21.CLASSIFIER_JAVADOC, GradleModuleFileCache21.EXT_JAR);
        }

        public Entry getBinary() {
            return this.getClassifiedEntry(null, GradleModuleFileCache21.EXT_JAR);
        }

        public Entry getPom() {
            return this.getClassifiedEntry(null, GradleModuleFileCache21.EXT_POM);
        }

        public Entry getClassifiedEntry(String classifier, String extension) {
            String name = this.getModule() + "-" + this.getVersion() + (classifier != null ? "-" + classifier : "") + "." + extension;
            if (this.entries.isEmpty() && Files.exists(this.path, new LinkOption[0])) {
                try {
                    this.readEntries();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.entries.get(name);
        }

        private void readEntries() throws IOException {
            if ((long)this.entries.size() != Files.list(this.getPath()).count()) {
                this.entries.clear();
                Files.walkFileTree(this.getPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            Entry entry = new Entry(file);
                            CachedArtifactVersion.this.entries.put(entry.getName(), entry);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }

        public final class Entry {
            final Path path;

            public Entry(String name, String hash) {
                this.path = CachedArtifactVersion.this.getPath().resolve(Paths.get(hash, name));
            }

            public Entry(Path path) throws IllegalArgumentException {
                if (!path.startsWith(CachedArtifactVersion.this.path) || path.getNameCount() - 2 != CachedArtifactVersion.this.path.getNameCount()) {
                    throw new IllegalArgumentException("Not a Cached Gradle Atrifact: " + path.toString());
                }
                this.path = path;
            }

            public Path getPath() {
                return this.path;
            }

            public String getName() {
                return this.path.getFileName().toString();
            }

            public String getHash() {
                return this.path.getParent().toString();
            }

            public String getVersion() {
                return CachedArtifactVersion.this.getVersion();
            }

            public String getModule() {
                return CachedArtifactVersion.this.getModule();
            }

            public String getOrganization() {
                return CachedArtifactVersion.this.getOrganization();
            }

            public String getClassifier() {
                int extDot;
                String ret = null;
                String prefix = this.getModule() + "-" + this.getVersion() + "-";
                String name = this.getName();
                if (name.startsWith(prefix) && (extDot = name.lastIndexOf(46)) > prefix.length()) {
                    ret = name.substring(prefix.length(), extDot);
                }
                return ret;
            }

            public int hashCode() {
                return Objects.hashCode(this.getHash());
            }

            public CachedArtifactVersion getCachedArtifats() {
                return CachedArtifactVersion.this;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Entry other = (Entry)obj;
                if (!Objects.equals(this.getHash(), other.getHash())) {
                    return false;
                }
                return Objects.equals(this.getPath(), other.getPath());
            }
        }
    }
}

