/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.nodes.AnnotatedAbstractNode;
import org.netbeans.modules.gradle.nodes.Bundle;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;

public final class BuildScriptsNode
extends AnnotatedAbstractNode {
    private static final String BS_BADGE = "org/netbeans/modules/gradle/resources/buildscripts-badge.png";

    public BuildScriptsNode(NbGradleProjectImpl prj) {
        super(Children.create((ChildFactory)new ProjectFilesChildren(prj), (boolean)true), Lookups.fixed((Object[])new Object[]{prj.getProjectDirectory()}));
        this.setName("buildscripts");
        this.setDisplayName(Bundle.LBL_Build_Scripts());
    }

    @Override
    protected Image getIconImpl(int param) {
        return this.getIcon(false);
    }

    @Override
    protected Image getOpenedIconImpl(int param) {
        return this.getIcon(true);
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)BS_BADGE, (boolean)true);
        Image img = ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
        return img;
    }

    private static class ProjectFilesChildren
    extends ChildFactory.Detachable<Pair<FileObject, GradleFiles.Kind>>
    implements PropertyChangeListener {
        private final NbGradleProjectImpl project;
        private final FileChangeAdapter fileChangeListener;

        ProjectFilesChildren(NbGradleProjectImpl proj) {
            this.project = proj;
            this.fileChangeListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    this.refresh(false);
                }

                public void fileDeleted(FileEvent fe) {
                    this.refresh(false);
                }
            };
        }

        protected Node createNodeForKey(Pair<FileObject, GradleFiles.Kind> key) {
            boolean isRoot = this.project.getGradleProject().getBaseProject().isRoot();
            if (isRoot && (key.second() == GradleFiles.Kind.ROOT_SCRIPT || key.second() == GradleFiles.Kind.ROOT_PROPERTIES)) {
                return null;
            }
            try {
                Node node = DataObject.find((FileObject)((FileObject)key.first())).getNodeDelegate().cloneNode();
                String nameSuffix = null;
                if (key.second() != null) {
                    if (key.second() == GradleFiles.Kind.USER_PROPERTIES) {
                        nameSuffix = Bundle.LBL_UserSuffix();
                    }
                    if (!isRoot) {
                        switch ((GradleFiles.Kind)((Object)key.second())) {
                            case BUILD_SCRIPT: 
                            case PROJECT_PROPERTIES: {
                                nameSuffix = Bundle.LBL_ProjectSuffixt();
                                break;
                            }
                            case ROOT_SCRIPT: 
                            case ROOT_PROPERTIES: {
                                nameSuffix = Bundle.LBL_RootSuffix();
                            }
                        }
                    }
                }
                if (nameSuffix != null) {
                    node.setDisplayName(((FileObject)key.first()).getNameExt() + " [" + nameSuffix + "]");
                }
                return node;
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.refresh(false);
            }
        }

        protected void addNotify() {
            NbGradleProject.addPropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.fileChangeListener);
        }

        protected void removeNotify() {
            NbGradleProject.removePropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().removeFileChangeListener((FileChangeListener)this.fileChangeListener);
        }

        protected boolean createKeys(List<Pair<FileObject, GradleFiles.Kind>> keys) {
            GradleFiles gf = this.project.getGradleFiles();
            for (GradleFiles.Kind kind : GradleFiles.Kind.values()) {
                File f = gf.getFile(kind);
                if (f == null || !f.isFile()) continue;
                keys.add((Pair<FileObject, GradleFiles.Kind>)Pair.of((Object)FileUtil.toFileObject((File)f), (Object)((Object)kind)));
            }
            return true;
        }
    }
}

