/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class GradleSourceForBinary
implements SourceForBinaryQueryImplementation2 {
    private final Project project;
    private final Map<URL, Res> cache = new HashMap<URL, Res>();

    public GradleSourceForBinary(Project project) {
        this.project = project;
    }

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        Res ret = this.cache.get(binaryRoot);
        if (ret == null) {
            try {
                NbGradleProject watcher = NbGradleProject.get((Project)this.project);
                if (watcher.getQuality().atLeast(NbGradleProject.Quality.FALLBACK)) {
                    GradleJavaProject prj = GradleJavaProject.get(this.project);
                    block5 : switch (binaryRoot.getProtocol()) {
                        case "file": {
                            File root = FileUtil.normalizeFile((File)Utilities.toFile((URI)binaryRoot.toURI()));
                            for (GradleJavaSourceSet ss : prj.getSourceSets().values()) {
                                File outputDir = ss.getCompilerArgs(GradleJavaSourceSet.SourceType.JAVA).contains("--module-source-path") ? root.getParentFile() : root;
                                for (File dir : ss.getOutputClassDirs()) {
                                    if (!outputDir.equals(dir)) continue;
                                    ret = new Res(this.project, ss.getName(), EnumSet.of(GradleJavaSourceSet.SourceType.JAVA, GradleJavaSourceSet.SourceType.GROOVY, GradleJavaSourceSet.SourceType.SCALA, GradleJavaSourceSet.SourceType.GENERATED));
                                    break;
                                }
                                if (root.equals(ss.getOutputResources())) {
                                    ret = new Res(this.project, ss.getName(), EnumSet.of(GradleJavaSourceSet.SourceType.RESOURCES));
                                }
                                if (ret == null) continue;
                                break block5;
                            }
                            break;
                        }
                        case "jar": {
                            File jar = FileUtil.normalizeFile((File)Utilities.toFile((URI)FileUtil.getArchiveFile((URL)binaryRoot).toURI()));
                            if (jar.equals(prj.getMainJar()) && prj.getSourceSets().containsKey("main")) {
                                ret = new Res(this.project, "main", EnumSet.allOf(GradleJavaSourceSet.SourceType.class));
                                break;
                            }
                            if (!jar.equals(prj.getArchive("tests")) || !prj.getSourceSets().containsKey("test")) break;
                            ret = new Res(this.project, "test", EnumSet.allOf(GradleJavaSourceSet.SourceType.class));
                            break;
                        }
                    }
                }
                if (ret != null) {
                    this.cache.put(binaryRoot, ret);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return ret;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    public static class Res
    implements SourceForBinaryQueryImplementation2.Result {
        private final Project project;
        private final String sourceSet;
        private final Set<GradleJavaSourceSet.SourceType> sourceTypes;
        private final PropertyChangeListener listener;
        private final ChangeSupport support = new ChangeSupport((Object)this);

        public Res(Project project, String sourceSet, Set<GradleJavaSourceSet.SourceType> sourceTypes) {
            this.project = project;
            this.sourceSet = sourceSet;
            this.sourceTypes = sourceTypes;
            this.listener = evt -> {
                if ("ProjectInfo".equals(evt.getPropertyName())) {
                    this.support.fireChange();
                }
            };
            NbGradleProject.get((Project)project).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)project));
        }

        public boolean preferSources() {
            return true;
        }

        public FileObject[] getRoots() {
            GradleJavaSourceSet ss;
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            GradleJavaSourceSet gradleJavaSourceSet = ss = GradleJavaProject.get(this.project) != null ? GradleJavaProject.get(this.project).getSourceSets().get(this.sourceSet) : null;
            if (ss != null) {
                for (GradleJavaSourceSet.SourceType type : this.sourceTypes) {
                    Set<File> dirs = ss.getSourceDirs(type);
                    for (File dir : dirs) {
                        FileObject fo = FileUtil.toFileObject((File)dir);
                        if (fo == null) continue;
                        roots.add(fo);
                    }
                }
            }
            return roots.toArray(new FileObject[roots.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            ChangeSupport changeSupport = this.support;
            synchronized (changeSupport) {
                this.support.addChangeListener(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            ChangeSupport changeSupport = this.support;
            synchronized (changeSupport) {
                this.support.removeChangeListener(l);
            }
        }
    }
}

