/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.execute;

import java.util.prefs.Preferences;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.openide.util.Pair;

public class JavaRunUtils {
    private JavaRunUtils() {
    }

    public static boolean isCompileOnSaveEnabled(Project project) {
        return JavaRunUtils.isOptionEnabled(project, "compile.on.save", false);
    }

    public static Pair<String, JavaPlatform> getActivePlatform(String activePlatformId) {
        JavaPlatform[] installedPlatforms;
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            JavaPlatform p = pm.getDefaultPlatform();
            return Pair.of(p.getProperties().get("platform.ant.name"), (Object)p);
        }
        for (JavaPlatform installedPlatform : installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null))) {
            String antName = (String)installedPlatform.getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return Pair.of((Object)activePlatformId, (Object)installedPlatform);
        }
        return Pair.of((Object)activePlatformId, null);
    }

    public static Pair<String, JavaPlatform> getActivePlatform(Project project) {
        Preferences prefs = NbGradleProject.getPreferences((Project)project, (boolean)false);
        String platformId = prefs.get("jdkPlatform", null);
        if (platformId == null) {
            GradleBaseProject gbp = GradleBaseProject.get((Project)project);
            platformId = gbp != null ? gbp.getNetBeansProperty("jdkPlatform") : null;
        }
        return JavaRunUtils.getActivePlatform(platformId);
    }

    private static boolean isOptionEnabled(Project project, String option, boolean defaultValue) {
        GradleBaseProject gbp = GradleBaseProject.get((Project)project);
        if (gbp != null) {
            String value = gbp.getNetBeansProperty(option);
            if (value != null) {
                return Boolean.valueOf(value);
            }
            return NbGradleProject.getPreferences((Project)project, (boolean)false).getBoolean(option, defaultValue);
        }
        return false;
    }
}

