/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.source.Source;
import org.netbeans.spi.debugger.ui.DebuggingView;

public final class TruffleDVFrame
implements DebuggingView.DVFrame {
    private final DebuggingView.DVThread thread;
    private final TruffleStackFrame truffleFrame;

    TruffleDVFrame(DebuggingView.DVThread thread, TruffleStackFrame truffleFrame) {
        this.thread = thread;
        this.truffleFrame = truffleFrame;
    }

    TruffleStackFrame getTruffleFrame() {
        return this.truffleFrame;
    }

    public String getName() {
        return this.truffleFrame.getMethodName();
    }

    public DebuggingView.DVThread getThread() {
        return this.thread;
    }

    public void makeCurrent() {
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(this.truffleFrame.getThread());
        if (currentPCInfo != null) {
            currentPCInfo.setSelectedStackFrame(this.truffleFrame);
        }
    }

    public URI getSourceURI() {
        Source source = this.truffleFrame.getSourcePosition().getSource();
        URI uri = source.getURI();
        if (uri != null && "file".equalsIgnoreCase(uri.getScheme())) {
            return uri;
        }
        try {
            return source.getUrl().toURI();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public String getSourceMimeType() {
        Source source = this.truffleFrame.getSourcePosition().getSource();
        return source.getMimeType();
    }

    public int getLine() {
        return this.truffleFrame.getSourcePosition().getStartLine();
    }

    public int getColumn() {
        return this.truffleFrame.getSourcePosition().getStartColumn();
    }
}

