/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.DatabaseConnectionAccessor;
import org.netbeans.modules.db.explorer.DatabaseConnectionConvertor;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DatabaseUILogger;
import org.netbeans.modules.db.explorer.DbDriverManager;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.OpenConnection;
import org.netbeans.modules.db.explorer.OpenConnectionInterface;
import org.netbeans.modules.db.explorer.action.ConnectAction;
import org.netbeans.modules.db.explorer.node.ConnectionNode;
import org.netbeans.modules.db.explorer.node.DDLHelper;
import org.netbeans.modules.db.explorer.node.RootNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.runtime.DatabaseRuntimeManager;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class DatabaseConnection
implements DBConnection {
    private static final Logger LOGGER = Logger.getLogger(DatabaseConnection.class.getName());
    static final long serialVersionUID = 4554639187416958735L;
    private final Set<ExceptionListener> exceptionListeners = Collections.synchronizedSet(new HashSet());
    private Connection jdbcConnection;
    private String drv;
    private String drvname;
    private String db;
    private String usr;
    private String defaultCatalog = null;
    private String defaultSchema = null;
    private Set<String> importantSchemas = null;
    private Set<String> importantCatalogs = null;
    private String schema;
    private String pwd = "";
    private Boolean rpwd = Boolean.FALSE;
    private String connectionFileName;
    private PropertyChangeSupport propertySupport;
    private String name;
    private String displayName;
    private int errorCode = -1;
    private final DatabaseConnector connector = new DatabaseConnector(this);
    private MetadataModel metadataModel = null;
    private Properties connectionProperties = new Properties();
    private volatile boolean separateSystemTables = false;
    private Boolean useScrollableCursors = null;
    private State state;
    private transient org.netbeans.api.db.explorer.DatabaseConnection dbconn = DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this);
    private static final String SUPPORT = "_schema_support";
    public static final String PROP_DRIVER = "driver";
    public static final String PROP_DATABASE = "database";
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_REMEMBER_PASSWORD = "rememberpwd";
    public static final String PROP_SCHEMA = "schema";
    public static final String PROP_DEFSCHEMA = "defaultSchema";
    public static final String PROP_DEFCATALOG = "defaultCatalog";
    public static final String PROP_DRIVERNAME = "drivername";
    public static final String PROP_NAME = "name";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    public static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    public static final int DERBY_UNICODE_ERROR_CODE = 20000;
    private OpenConnectionInterface openConnection = null;
    private volatile JDBCDriver jdbcdrv = null;
    private JDBCDriver[] drivers = null;
    private static final Lookup.Result<OpenConnectionInterface> openConnectionLookupResult;
    private static Collection<? extends OpenConnectionInterface> openConnectionServices;
    private static final RequestProcessor RP;

    public DatabaseConnection() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public DatabaseConnection(String driver, String database, String user, String password) {
        this(driver, null, database, null, user, password, null, null);
    }

    public DatabaseConnection(String driver, String driverName, String database, String theschema, String user, String password) {
        this(driver, driverName, database, theschema, user, password, null, null);
    }

    public DatabaseConnection(String driver, String driverName, String database, String theschema, String user) {
        this(driver, driverName, database, theschema, user, null, null, null);
    }

    public DatabaseConnection(String driver, String driverName, String database, String theschema, String user, Properties connectionProperties) {
        this(driver, driverName, database, theschema, user, null, null, connectionProperties);
    }

    public DatabaseConnection(String driver, String driverName, String database, String theschema, String user, String password, Boolean rememberPassword) {
        this(driver, driverName, database, theschema, user, password, rememberPassword, null);
    }

    public DatabaseConnection(String driver, String driverName, String database, String theschema, String user, String password, Boolean rememberPassword, Properties connectionProperties) {
        this();
        this.drv = driver;
        this.drvname = driverName;
        this.db = database;
        this.usr = user;
        this.pwd = password;
        this.rpwd = rememberPassword;
        this.schema = theschema;
        this.name = this.getName();
        this.setConnectionProperties(connectionProperties);
    }

    public JDBCDriver findJDBCDriver() {
        Object[] drvs = JDBCDriverManager.getDefault().getDrivers(this.drv);
        if (this.drivers == null || !Arrays.equals(drvs, this.drivers)) {
            this.drivers = drvs;
            Object useDriver = null;
            if (drvs.length > 0) {
                useDriver = drvs[0];
                for (int i = 0; i < drvs.length; ++i) {
                    if (!((JDBCDriver)drvs[i]).getName().equals(this.getDriverName())) continue;
                    useDriver = drvs[i];
                    break;
                }
            }
            this.jdbcdrv = useDriver;
        }
        return this.jdbcdrv;
    }

    public Connection getJDBCConnection(boolean test) {
        Connection conn = this.getJDBCConnection();
        if (test && !this.test()) {
            try {
                this.disconnect();
            }
            catch (DatabaseException e) {
                LOGGER.log(Level.FINE, null, e);
            }
            return null;
        }
        return conn;
    }

    public void setMetadataModel(MetadataModel model) {
        this.metadataModel = model;
    }

    public MetadataModel getMetadataModel() {
        return this.metadataModel;
    }

    public boolean isVitalConnection() {
        if (this.getJDBCConnection() == null) {
            return false;
        }
        try {
            return !DatabaseConnection.checkClosedWithTimeout(this.getJDBCConnection());
        }
        catch (Exception ex) {
            if (this.dbconn != null) {
                try {
                    this.disconnect();
                }
                catch (DatabaseException ex1) {
                    LOGGER.log(Level.FINE, "While trying vitality of connection: " + ex1.getLocalizedMessage(), ex1);
                }
            }
            LOGGER.log(Level.FINE, "While trying vitality of connection: " + ex.getLocalizedMessage(), ex);
            return false;
        }
    }

    private static boolean checkClosedWithTimeout(final Connection connection) {
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    SQLWarning warnings = connection.getWarnings();
                    if (LOGGER.isLoggable(Level.FINE) && warnings != null) {
                        LOGGER.log(Level.FINE, "Warnings while trying vitality of connection: {0}", warnings);
                    }
                    return connection.isClosed();
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.FINE, "While trying vitality of connection: " + ex.getLocalizedMessage(), ex);
                    return false;
                }
            }
        };
        Future future = RP.submit((Callable)task);
        try {
            return (Boolean)future.get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean test() {
        try {
            if (!this.isVitalConnection()) {
                return false;
            }
            try {
                return this.getJDBCConnection().isValid(10000);
            }
            catch (Throwable err) {
                this.getJDBCConnection().getMetaData().getTables(null, null, " ", new String[]{"TABLE"}).close();
            }
        }
        catch (NullPointerException | SQLException e) {
            if ("net.sourceforge.jtds.jdbc.Driver".equals(this.getDriver()) && e instanceof SQLException && "07009".equals(((SQLException)e).getSQLState())) {
                return true;
            }
            LOGGER.log(Level.INFO, NbBundle.getMessage(DatabaseConnection.class, (String)"MSG_TestFailed", (Object)this.getName(), (Object)e.getMessage()));
            LOGGER.log(Level.FINE, null, e);
            return false;
        }
        return true;
    }

    private Collection<? extends OpenConnectionInterface> getOpenConnections() {
        if (openConnectionServices == null) {
            openConnectionServices = openConnectionLookupResult.allInstances();
        }
        return openConnectionServices;
    }

    private OpenConnectionInterface getOpenConnection() {
        if (this.openConnection != null) {
            return this.openConnection;
        }
        this.openConnection = new OpenConnection();
        String driver = this.getDriver();
        if (driver == null) {
            return this.openConnection;
        }
        try {
            for (OpenConnectionInterface openConnectionInterface : this.getOpenConnections()) {
                if (!openConnectionInterface.isFor(driver)) continue;
                this.openConnection = openConnectionInterface;
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return this.openConnection;
    }

    public String getDriver() {
        return this.drv;
    }

    public void setDriver(String driver) {
        if (driver == null || driver.equals(this.drv)) {
            return;
        }
        String olddrv = this.drv;
        this.drv = driver;
        this.propertySupport.firePropertyChange(PROP_DRIVER, olddrv, this.drv);
        this.openConnection = null;
    }

    public String getDriverName() {
        return this.drvname;
    }

    public void setDriverName(String name) {
        if (name == null || name.equals(this.drvname)) {
            return;
        }
        String olddrv = this.drvname;
        this.drvname = name;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DRIVERNAME, olddrv, this.drvname);
        }
    }

    public String getDatabase() {
        if (this.db == null) {
            this.db = "";
        }
        return this.db;
    }

    public void setDatabase(String database) {
        if (database == null || database.equals(this.db)) {
            return;
        }
        String oldDisplayName = this.getDisplayName();
        String oldName = this.getName();
        String olddb = this.db;
        this.db = database;
        this.name = null;
        this.name = this.getName();
        String newDisplayName = this.getDisplayName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DATABASE, olddb, this.db);
            this.propertySupport.firePropertyChange(PROP_NAME, oldName, this.name);
            if (!oldDisplayName.equals(newDisplayName)) {
                this.propertySupport.firePropertyChange(PROP_DISPLAY_NAME, oldDisplayName, newDisplayName);
            }
        }
    }

    public String getUser() {
        if (this.usr == null) {
            this.usr = "";
        }
        return this.usr;
    }

    public void setUser(String user) {
        if (user == null || user.equals(this.usr)) {
            return;
        }
        String oldDisplayName = this.getDisplayName();
        String oldName = this.getName();
        String oldusr = this.usr;
        this.usr = user;
        this.name = null;
        this.name = this.getName();
        String newDisplayName = this.getDisplayName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_USER, oldusr, this.usr);
            this.propertySupport.firePropertyChange(PROP_NAME, oldName, this.name);
            if (!oldDisplayName.equals(this.displayName)) {
                this.propertySupport.firePropertyChange(PROP_DISPLAY_NAME, oldDisplayName, newDisplayName);
            }
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getSchema() == null || this.getSchema().length() == 0 ? NbBundle.getMessage(DatabaseConnection.class, (String)"ConnectionNodeUniqueName", (Object)this.getDatabase(), (Object)this.getUser(), (Object)NbBundle.getMessage(DatabaseConnection.class, (String)"SchemaIsNotSet")) : NbBundle.getMessage(DatabaseConnection.class, (String)"ConnectionNodeUniqueName", (Object)this.getDatabase(), (Object)this.getUser(), (Object)this.getSchema());
        }
        return this.name;
    }

    public void setName(String value) {
        if (this.name == null || this.getName().equals(value)) {
            return;
        }
        String old = this.name;
        this.name = value;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_NAME, old, this.name);
        }
    }

    public String getDisplayName() {
        return this.displayName != null && this.displayName.length() > 0 ? this.displayName : this.getName();
    }

    public void setDisplayName(String value) {
        if (this.displayName == null && value == null || this.getDisplayName().equals(value)) {
            return;
        }
        String old = this.displayName;
        this.displayName = value;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DISPLAY_NAME, old, this.displayName);
        }
    }

    public Properties getConnectionProperties() {
        return (Properties)this.connectionProperties.clone();
    }

    public void setConnectionProperties(Properties connectionProperties) {
        Properties old = this.connectionProperties;
        this.connectionProperties = connectionProperties == null ? new Properties() : (Properties)connectionProperties.clone();
        this.propertySupport.firePropertyChange(PROP_CONNECTIONPROPERTIES, old, connectionProperties);
    }

    public String getSchema() {
        if (this.schema == null) {
            this.schema = "";
        }
        if (this.schema.length() == 0) {
            return this.defaultSchema == null ? "" : this.defaultSchema;
        }
        return this.schema;
    }

    public void setSchema(String schema_name) {
        if (schema_name == null || schema_name.equals(this.schema)) {
            return;
        }
        String oldDisplayName = this.getDisplayName();
        String oldName = this.getName();
        String oldschema = this.schema;
        this.name = null;
        this.schema = schema_name;
        this.name = this.getName();
        String newDisplayName = this.getDisplayName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_SCHEMA, oldschema, this.schema);
            this.propertySupport.firePropertyChange(PROP_NAME, oldName, this.name);
            if (!oldDisplayName.equals(this.displayName)) {
                this.propertySupport.firePropertyChange(PROP_DISPLAY_NAME, oldDisplayName, newDisplayName);
            }
        }
    }

    public void setDefaultCatalog(String val) throws CommandNotSupportedException, DDLException {
        DDLHelper.setDefaultDatabase(this.getConnector().getDatabaseSpecification(), val);
        String oldVal = this.defaultCatalog;
        this.defaultCatalog = val;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DEFCATALOG, oldVal, this.defaultCatalog);
        }
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultSchema(String newDefaultSchema) throws Exception {
        DDLHelper.setDefaultSchema(this.getConnector().getDatabaseSpecification(), newDefaultSchema);
        String oldName = this.name;
        this.name = null;
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DEFSCHEMA, oldDefaultSchema, this.defaultSchema);
            this.propertySupport.firePropertyChange(PROP_SCHEMA, this.schema, this.getSchema());
            this.propertySupport.firePropertyChange(PROP_NAME, oldName, this.name);
        }
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setConnectionFileName(String connectionFileName) {
        this.connectionFileName = connectionFileName;
    }

    private void restorePassword() {
        if (this.connectionFileName == null) {
            LOGGER.log(Level.FINE, "No connectionFileName for {0}", this);
            this.pwd = "";
            this.rpwd = false;
            return;
        }
        String key = this.connectionFileName;
        char[] chars = Keyring.read((String)key);
        if (chars != null) {
            LOGGER.log(Level.FINE, "A password read for {0}", key);
            this.pwd = String.valueOf(chars);
            this.rpwd = true;
        } else {
            LOGGER.log(Level.FINE, "No password read for {0}", key);
            this.pwd = "";
            this.rpwd = false;
        }
    }

    public static void storePassword(String key, char[] pwd) {
        Parameters.notNull((CharSequence)"key", (Object)key);
        Parameters.notNull((CharSequence)"pwd", (Object)pwd);
        LOGGER.log(Level.FINE, "Storing password for {0}", key);
        Keyring.save((String)key, (char[])pwd, (String)NbBundle.getMessage(DatabaseConnectionConvertor.class, (String)"DatabaseConnectionConvertor.password_description", (Object)key));
    }

    public static void deletePassword(String key) {
        Parameters.notNull((CharSequence)"key", (Object)key);
        LOGGER.log(Level.FINE, "Deleting password for {0}", key);
        Keyring.delete((String)key);
    }

    public boolean rememberPassword() {
        if (this.rpwd == null) {
            this.restorePassword();
        }
        assert (this.rpwd != null) : "rpwd must be set to true or false";
        return this.rpwd == null ? false : this.rpwd;
    }

    public void setRememberPassword(boolean flag) {
        Boolean oldrpwd = this.rpwd;
        this.rpwd = flag;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_REMEMBER_PASSWORD, oldrpwd, this.rpwd);
        }
    }

    public String getPassword() {
        if (this.pwd == null) {
            this.restorePassword();
        }
        return this.pwd;
    }

    public void setPassword(String password) {
        if (password == null || password.equals(this.pwd)) {
            return;
        }
        String oldpwd = this.pwd;
        this.pwd = password.length() == 0 ? null : password;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_PASSWORD, oldpwd, this.pwd);
        }
    }

    public Connection createJDBCConnection() throws DDLException {
        LOGGER.log(Level.FINE, "createJDBCConnection()");
        if (this.drv == null || this.db == null || this.usr == null) {
            throw new DDLException(NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_InsufficientConnInfo"));
        }
        Properties dbprops = this.connectionProperties != null ? this.getConnectionProperties() : new Properties();
        if (this.usr != null && this.usr.length() > 0) {
            dbprops.put(PROP_USER, this.usr);
        }
        if (this.pwd != null && this.pwd.length() > 0) {
            dbprops.put(PROP_PASSWORD, this.pwd);
        }
        try {
            this.setState(State.connecting);
            this.getOpenConnection().enable();
            this.startRuntimes();
            DerbyConectionEventListener.getDefault().beforeConnect(this);
            JDBCDriver useDriver = this.findJDBCDriver();
            if (useDriver == null) {
                Class.forName(this.drv);
            }
            Connection connection = DbDriverManager.getDefault().getConnection(this.db, dbprops, useDriver);
            this.setJDBCConnection(connection);
            DatabaseUILogger.logConnection(this.drv);
            this.setState(State.connected);
            this.getOpenConnection().disable();
            return connection;
        }
        catch (SQLException e) {
            String message = NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_CannotEstablishConnection", (Object)this.db, (Object)this.drv, (Object)e.getMessage());
            this.setState(State.failed);
            this.getOpenConnection().disable();
            this.initSQLException(e);
            throw new DDLException(message, (Throwable)e);
        }
        catch (ClassNotFoundException | RuntimeException exc) {
            String message = NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_CannotEstablishConnection", (Object)this.db, (Object)this.drv, (Object)exc.getMessage());
            this.setState(State.failed);
            this.getOpenConnection().disable();
            throw new DDLException(message, (Throwable)exc);
        }
    }

    public void connectSync() throws DatabaseException {
        try {
            this.doConnect();
        }
        catch (Exception exc) {
            try {
                if (this.getJDBCConnection() != null) {
                    this.getJDBCConnection().close();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.FINE, null, e);
            }
            throw new DatabaseException(exc);
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() throws DDLException {
        if (this.drv == null || this.db == null || this.usr == null) {
            this.sendException((Exception)((Object)new DDLException(NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_InsufficientConnInfo"))));
        }
        Properties dbprops = this.connectionProperties != null ? this.getConnectionProperties() : new Properties();
        if (this.usr != null && this.usr.length() > 0) {
            dbprops.put(PROP_USER, this.usr);
        }
        if (this.pwd != null && this.pwd.length() > 0) {
            dbprops.put(PROP_PASSWORD, this.pwd);
        }
        Connection conn = null;
        try {
            this.setState(State.connecting);
            this.getOpenConnection().enable();
            this.startRuntimes();
            DerbyConectionEventListener.getDefault().beforeConnect(this);
            JDBCDriver useDriver = this.findJDBCDriver();
            if (useDriver == null) {
                Class.forName(this.drv);
            }
            conn = DbDriverManager.getDefault().getConnection(this.db, dbprops, useDriver);
            this.setJDBCConnection(conn);
            DatabaseUILogger.logConnection(this.drv);
            this.connector.finishConnect(null);
            this.setState(State.connected);
            if (this.getConnector().getDatabaseSpecification() != null && this.getConnector().supportsCommand("SetDefaultSchemaCommand")) {
                try {
                    this.setDefaultSchema(this.getSchema());
                }
                catch (CommandNotSupportedException | DDLException x) {
                    LOGGER.log(Level.INFO, x.getLocalizedMessage(), x);
                }
            }
        }
        catch (Exception e) {
            String message = NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_CannotEstablishConnection", (Object)this.db, (Object)this.drv, (Object)e.getMessage());
            if (this.drv.equals(DRIVER_CLASS_NET) && e instanceof SQLException) {
                this.errorCode = ((SQLException)e).getErrorCode();
                if (this.errorCode == 20000) {
                    message = MessageFormat.format(NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_DerbyCreateDatabaseUnicode"), message, this.db);
                }
            }
            this.setState(State.failed);
            if (e instanceof SQLException) {
                this.initSQLException((SQLException)e);
            }
            DDLException ddle = new DDLException(message);
            ddle.initCause((Throwable)e);
            if (conn != null) {
                this.setJDBCConnection(null);
                try {
                    conn.close();
                }
                catch (SQLException sqle) {
                    LOGGER.log(Level.WARNING, null, sqle);
                }
            }
            throw ddle;
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "JDBC connection error", t);
            String message = NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_CannotEstablishConnection", (Object)this.db, (Object)this.drv, (Object)t.getMessage());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception(t, (Object)message));
            this.setState(State.failed);
        }
        finally {
            this.getOpenConnection().disable();
        }
    }

    public RequestProcessor.Task connectAsync() {
        LOGGER.log(Level.FINE, "connect()");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DatabaseConnection.this.doConnect();
                }
                catch (Exception e) {
                    DatabaseConnection.this.sendException(e);
                }
            }
        };
        RequestProcessor.Task task = RP.post(runnable, 0);
        return task;
    }

    public boolean isConnected() {
        return this.jdbcConnection != null;
    }

    private void initSQLException(SQLException e) {
        SQLException current = e;
        SQLException next = current.getNextException();
        while (next != null) {
            try {
                current.initCause(next);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            current = next;
            next = current.getNextException();
        }
    }

    private void startRuntimes() {
        DatabaseRuntime[] runtimes = DatabaseRuntimeManager.getDefault().getRuntimes(this.drv);
        for (int i = 0; i < runtimes.length; ++i) {
            DatabaseRuntime runtime = runtimes[i];
            if (runtime.isRunning() || !runtime.canStart() || !runtime.acceptsDatabaseURL(this.db)) continue;
            runtime.start();
        }
    }

    public void addExceptionListener(ExceptionListener l) {
        if (l != null) {
            this.exceptionListeners.add(l);
        }
    }

    public void removeExceptionListener(ExceptionListener l) {
        this.exceptionListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(Exception exc) {
        ArrayList<ExceptionListener> listeners = new ArrayList<ExceptionListener>();
        Set<ExceptionListener> set = this.exceptionListeners;
        synchronized (set) {
            for (ExceptionListener l : this.exceptionListeners) {
                listeners.add(l);
            }
        }
        for (ExceptionListener listener : listeners) {
            listener.exceptionOccurred(exc);
        }
    }

    private void setJDBCConnection(Connection c) {
        this.jdbcConnection = c;
    }

    public Connection getJDBCConnection() {
        return this.jdbcConnection;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public int hashCode() {
        return Objects.hashCode(this.drv) + Objects.hashCode(this.db) + Objects.hashCode(this.usr);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseConnection) {
            DatabaseConnection conn = (DatabaseConnection)obj;
            return Objects.equals(this.drv, conn.drv) && Objects.equals(this.drvname, conn.drvname) && Objects.equals(this.db, conn.db) && Objects.equals(this.usr, conn.usr) && Objects.equals(this.getSchema(), conn.getSchema()) && Objects.equals(this.getConnectionProperties(), conn.getConnectionProperties());
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.drv = (String)in.readObject();
        this.db = (String)in.readObject();
        this.usr = (String)in.readObject();
        this.schema = (String)in.readObject();
        this.rpwd = Boolean.FALSE;
        this.name = (String)in.readObject();
        try {
            this.drvname = (String)in.readObject();
            this.displayName = (String)in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connectionProperties = (Properties)in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.name == null || !this.name.equals(SUPPORT)) {
            this.schema = null;
        }
        this.name = null;
        this.name = this.getName();
        this.dbconn = DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.drv);
        out.writeObject(this.db);
        out.writeObject(this.usr);
        out.writeObject(this.schema);
        out.writeObject(SUPPORT);
        out.writeObject(this.drvname);
        out.writeObject(this.displayName);
        out.writeObject(this.connectionProperties);
    }

    public String toString() {
        return "Driver:" + this.getDriver() + "Database:" + this.getDatabase().toLowerCase() + "User:" + this.getUser().toLowerCase() + "Schema:" + this.getSchema().toLowerCase();
    }

    public org.netbeans.api.db.explorer.DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public void selectInExplorer() {
        this.selectInExplorer(true);
    }

    public void selectInExplorer(boolean activateTopComponent) {
        Node[] children;
        TopComponent servicesTab = null;
        ExplorerManager explorer = null;
        for (TopComponent component : TopComponent.getRegistry().getOpened()) {
            if (!component.getClass().getName().equals("org.netbeans.core.ide.ServicesTab")) continue;
            servicesTab = component;
            assert (servicesTab instanceof ExplorerManager.Provider);
            explorer = ((ExplorerManager.Provider)servicesTab).getExplorerManager();
            break;
        }
        if (explorer == null) {
            return;
        }
        Node root = explorer.getRootContext();
        Node databasesNode = null;
        Node connectionNode = null;
        for (Node node : children = root.getChildren().getNodes()) {
            if (!node.getName().equals("Databases")) continue;
            databasesNode = node;
            break;
        }
        if (databasesNode == null) {
            return;
        }
        for (Node node : children = databasesNode.getChildren().getNodes()) {
            if (!node.getDisplayName().equals(this.getDisplayName())) continue;
            connectionNode = node;
            break;
        }
        try {
            if (connectionNode != null) {
                explorer.setSelectedNodes(new Node[]{connectionNode});
                if (activateTopComponent && servicesTab != null) {
                    servicesTab.requestActive();
                }
            }
        }
        catch (PropertyVetoException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public void refreshInExplorer() throws DatabaseException {
        final ConnectionNode connectionNode = DatabaseConnection.findConnectionNode(this.getDisplayName());
        if (connectionNode != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    MetadataModel model = DatabaseConnection.this.getMetadataModel();
                    if (model != null) {
                        try {
                            model.runReadAction((Action)new Action<Metadata>(){

                                public void run(Metadata metaData) {
                                    metaData.refresh();
                                }
                            });
                        }
                        catch (MetadataModelException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                    connectionNode.refresh();
                }
            });
        }
    }

    public void showConnectionDialog() {
        try {
            ConnectionNode cni = DatabaseConnection.findConnectionNode(this.getDisplayName());
            assert (cni != null) : "DatabaseConnection node not found for " + this;
            if (cni != null && !this.isConnected()) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        new ConnectAction.ConnectionDialogDisplayer().showDialog(DatabaseConnection.this, false);
                    }
                });
            }
        }
        catch (DatabaseException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public DatabaseConnector getConnector() {
        return this.connector;
    }

    public void notifyChange() {
        this.propertySupport.firePropertyChange("changed", null, null);
    }

    public void disconnect() throws DatabaseException {
        if (this.jdbcConnection != null) {
            try {
                this.jdbcConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DerbyConectionEventListener.getDefault().afterDisconnect(this, this.jdbcConnection);
            this.connector.performDisconnect();
            this.jdbcConnection = null;
            this.setState(State.disconnected);
        }
    }

    public static ConnectionNode findConnectionNode(String connection) throws DatabaseException {
        assert (connection != null);
        RootNode root = RootNode.instance();
        Collection<? extends Node> children = root.getChildNodes();
        for (Node node : children) {
            ConnectionNode cnode;
            if (!(node instanceof ConnectionNode) || !(cnode = (ConnectionNode)node).getName().equals(connection)) continue;
            return cnode;
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        return this;
    }

    public Set<String> getImportantSchemas() {
        if (this.importantSchemas == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.importantSchemas);
    }

    public void addImportantSchema(String schema) {
        if (this.importantSchemas == null) {
            this.importantSchemas = new HashSet<String>();
        }
        ArrayList<String> oldList = new ArrayList<String>(this.importantSchemas);
        this.importantSchemas.add(schema);
        this.propertySupport.firePropertyChange("importantSchemas", oldList, this.importantSchemas);
    }

    public void removeImportantSchema(String schema) {
        if (this.importantSchemas != null) {
            ArrayList<String> oldList = new ArrayList<String>(this.importantSchemas);
            this.importantSchemas.remove(schema);
            this.propertySupport.firePropertyChange("importantSchemas", oldList, this.importantSchemas);
        }
    }

    public boolean isImportantSchema(String schema) {
        return this.importantSchemas != null && this.importantSchemas.contains(schema);
    }

    public Set<String> getImportantCatalogs() {
        if (this.importantCatalogs == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.importantCatalogs);
    }

    public void addImportantCatalog(String database) {
        if (this.importantCatalogs == null) {
            this.importantCatalogs = new HashSet<String>();
        }
        ArrayList<String> oldList = new ArrayList<String>(this.importantCatalogs);
        this.importantCatalogs.add(database);
        this.propertySupport.firePropertyChange("importantCatalogs", oldList, this.importantCatalogs);
    }

    public void removeImportantCatalog(String database) {
        if (this.importantCatalogs != null) {
            ArrayList<String> oldList = new ArrayList<String>(this.importantCatalogs);
            this.importantCatalogs.remove(database);
            this.propertySupport.firePropertyChange("importantCatalogs", oldList, this.importantCatalogs);
        }
    }

    public boolean isImportantCatalog(String database) {
        return this.importantCatalogs != null && this.importantCatalogs.contains(database);
    }

    public boolean isSeparateSystemTables() {
        return this.separateSystemTables;
    }

    public void setSeparateSystemTables(boolean separateSystemTables) {
        boolean oldVal = this.separateSystemTables;
        this.separateSystemTables = separateSystemTables;
        this.propertySupport.firePropertyChange("separateSystemTables", oldVal, separateSystemTables);
    }

    private boolean isUseScrollableCursorsByDefault() {
        return false;
    }

    public boolean isUseScrollableCursors() {
        return this.useScrollableCursors == null ? this.isUseScrollableCursorsByDefault() : this.useScrollableCursors.booleanValue();
    }

    public void setUseScrollableCursors(boolean useScrollableCursors) {
        boolean oldVal = this.isUseScrollableCursors();
        this.useScrollableCursors = useScrollableCursors;
        this.propertySupport.firePropertyChange("useScrollableCursors", oldVal, useScrollableCursors);
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        State oldState = this.state;
        this.state = state;
        this.propertySupport.firePropertyChange("state", (Object)oldState, (Object)state);
    }

    static {
        openConnectionServices = null;
        openConnectionLookupResult = Lookup.getDefault().lookup(new Lookup.Template(OpenConnectionInterface.class));
        openConnectionLookupResult.addLookupListener(new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                Class<DatabaseConnection> clazz = DatabaseConnection.class;
                synchronized (DatabaseConnection.class) {
                    openConnectionServices = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        RP = new RequestProcessor(DatabaseConnection.class.getName(), 10);
    }

    public static enum State {
        disconnected,
        connecting,
        connected,
        failed;

    }
}

