/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openide.util.NbBundle;

public class PropertyEditorPanel
extends JPanel {
    public static final String PROP_VALUE = "value";
    private Properties value;
    private boolean editable;
    private boolean updateing;
    private JButton addRowButton;
    private JPanel buttonPanel;
    private JScrollPane propertyScrollPane;
    private JTable propertyTable;
    private JButton removeRowButton;

    public PropertyEditorPanel(Properties initalValue, boolean editable) {
        this.initComponents();
        this.value = initalValue;
        this.editable = editable;
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.updateTableFromEditor();
        final TableModel tm = this.propertyTable.getModel();
        tm.addTableModelListener(new TableModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableChanged(TableModelEvent tme) {
                PropertyEditorPanel propertyEditorPanel = PropertyEditorPanel.this;
                synchronized (propertyEditorPanel) {
                    if (PropertyEditorPanel.this.updateing) {
                        return;
                    }
                    PropertyEditorPanel.this.updateing = true;
                    Properties p = new Properties();
                    for (int i = 0; i < tm.getRowCount(); ++i) {
                        p.setProperty((String)tm.getValueAt(i, 0), (String)tm.getValueAt(i, 1));
                    }
                    Properties oldValue = PropertyEditorPanel.this.value;
                    PropertyEditorPanel.this.value = p;
                    PropertyEditorPanel.this.firePropertyChange(PropertyEditorPanel.PROP_VALUE, oldValue, PropertyEditorPanel.this.value);
                    PropertyEditorPanel.this.updateing = false;
                }
            }
        });
        this.propertyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                PropertyEditorPanel.this.updateRemoveButtonSensible();
            }
        });
        this.updateAddButtonSensible();
        this.updateRemoveButtonSensible();
    }

    private void updateAddButtonSensible() {
        if (this.editable) {
            this.addRowButton.setEnabled(true);
        } else {
            this.addRowButton.setEnabled(false);
        }
    }

    private void updateRemoveButtonSensible() {
        if (this.editable && this.propertyTable.getSelectedRowCount() > 0) {
            this.removeRowButton.setEnabled(true);
        } else {
            this.removeRowButton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTableFromEditor() {
        PropertyEditorPanel propertyEditorPanel = this;
        synchronized (propertyEditorPanel) {
            if (this.updateing) {
                return;
            }
            this.updateing = true;
            DefaultTableModel dtm = (DefaultTableModel)this.propertyTable.getModel();
            Vector<String> columns = new Vector<String>(2);
            Vector values = new Vector();
            columns.add(dtm.getColumnName(0));
            columns.add(dtm.getColumnName(1));
            if (this.value != null) {
                for (String key : this.value.stringPropertyNames()) {
                    Vector<String> row = new Vector<String>(2);
                    row.add(key);
                    row.add(this.value.getProperty(key, ""));
                    values.add(row);
                }
            }
            dtm.setDataVector(values, columns);
            this.updateing = false;
        }
    }

    public Properties getValue() {
        return this.value;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.addRowButton = new JButton();
        this.removeRowButton = new JButton();
        this.propertyScrollPane = new JScrollPane();
        this.propertyTable = new JTable();
        this.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.addRowButton.setText(NbBundle.getMessage(PropertyEditorPanel.class, (String)"PropertyEditorPanel.addRowButton.text"));
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyEditorPanel.this.addRowButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.addRowButton);
        this.removeRowButton.setText(NbBundle.getMessage(PropertyEditorPanel.class, (String)"PropertyEditorPanel.removeRowButton.text"));
        this.removeRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyEditorPanel.this.removeRowButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.removeRowButton);
        this.add((Component)this.buttonPanel, "Last");
        this.propertyTable.setAutoCreateRowSorter(true);
        this.propertyTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Property", "Value"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return PropertyEditorPanel.this.editable;
            }
        });
        this.propertyTable.setColumnSelectionAllowed(true);
        this.propertyScrollPane.setViewportView(this.propertyTable);
        this.propertyTable.getColumnModel().getSelectionModel().setSelectionMode(2);
        this.propertyTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(PropertyEditorPanel.class, (String)"PropertyEditorPanel.propertyTable.columnModel.title0"));
        this.propertyTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(PropertyEditorPanel.class, (String)"PropertyEditorPanel.propertyTable.columnModel.title1"));
        this.add((Component)this.propertyScrollPane, "Center");
    }

    private void addRowButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.propertyTable.getModel();
        dtm.addRow(new Object[]{"", ""});
    }

    private void removeRowButtonActionPerformed(ActionEvent evt) {
        int[] viewRows = this.propertyTable.getSelectedRows();
        int[] modelRows = new int[viewRows.length];
        for (int i = 0; i < viewRows.length; ++i) {
            modelRows[i] = this.propertyTable.convertRowIndexToModel(viewRows[i]);
        }
        Arrays.sort(modelRows);
        DefaultTableModel dtm = (DefaultTableModel)this.propertyTable.getModel();
        for (int i = modelRows.length - 1; i >= 0; --i) {
            dtm.removeRow(modelRows[i]);
        }
    }
}

