/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ViewNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.View;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ViewNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Schema> schemaHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private static final Comparator<Node> viewComparator = new Comparator<Node>(){

        @Override
        public int compare(Node model1, Node model2) {
            return model1.getDisplayName().compareTo(model2.getDisplayName());
        }
    };

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ViewNodeProvider(Lookup lookup) {
        super(lookup, viewComparator);
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Schema schema = (Schema)ViewNodeProvider.this.schemaHandle.resolve(metaData);
                        if (schema != null) {
                            Collection views = schema.getViews();
                            for (View view : views) {
                                MetadataElementHandle handle = MetadataElementHandle.create((MetadataElement)view);
                                Collection matches = ViewNodeProvider.this.getNodes(handle);
                                if (matches.size() > 0) {
                                    newList.addAll(matches);
                                    continue;
                                }
                                NodeDataLookup lookup = new NodeDataLookup();
                                lookup.add(ViewNodeProvider.this.connection);
                                lookup.add(handle);
                                newList.add(ViewNode.create(lookup, ViewNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ViewNodeProvider createInstance(Lookup lookup) {
                ViewNodeProvider provider = new ViewNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

