/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.commons.TextUtils;
import org.netbeans.modules.bugtracking.tasks.cache.CategoryEntry;
import org.netbeans.modules.bugtracking.tasks.cache.StorageUtils;
import org.netbeans.modules.bugtracking.tasks.cache.TaskEntry;
import org.openide.modules.Places;

public class DashboardStorage {
    private static DashboardStorage instance;
    private static final String STORAGE_FILE = "storage";
    private static final String CLOSED_CAT_FILE = "closedCategories";
    private static final String CLOSED_REPO_FILE = "closedRepositories";
    private static final String STORAGE_VERSION_1_0 = "1.0";
    private static final String STORAGE_VERSION = "1.0";
    private static final String CATEGORY_SUFIX = ".c";
    private static final Logger LOG;
    private File storageFolder;

    private DashboardStorage() {
    }

    public static DashboardStorage getInstance() {
        if (instance == null) {
            instance = new DashboardStorage();
            instance.initStorage();
        }
        return instance;
    }

    private void initStorage() {
        this.storageFolder = this.getStorageRootFile();
        this.getStorageFolder(this.storageFolder);
        this.writeStorage();
    }

    public void storeClosedCategories(List<String> closedCategoryNames) {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the category storage in awt";
        File closedCategoryFile = new File(this.getStorageFolder(this.storageFolder), CLOSED_CAT_FILE);
        this.storeClosedEntries(closedCategoryFile, closedCategoryNames);
    }

    public void storeClosedRepositories(List<String> closedCategoryIds) {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the category storage in awt";
        File closedRepositoryFile = new File(this.getStorageFolder(this.storageFolder), CLOSED_REPO_FILE);
        this.storeClosedEntries(closedRepositoryFile, closedCategoryIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeClosedEntries(File file, List<String> closedEntries) {
        LOG.log(Level.FINE, "start storing closed entries");
        StorageUtils.FileLocks.FileLock lock = null;
        FilterOutputStream dos = null;
        try {
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(file);
            synchronized (fileLock) {
                if (closedEntries.isEmpty()) {
                    file.delete();
                }
                dos = this.getClosedOutputStream(file);
                for (String entry : closedEntries) {
                    this.writeString((DataOutputStream)dos, entry);
                }
                ((DataOutputStream)dos).flush();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        finally {
            LOG.log(Level.FINE, "finished storing closed entries");
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
            if (lock != null) {
                lock.release();
            }
        }
    }

    public List<String> readClosedCategories() {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the category storage in awt";
        File closedCategoryFile = new File(this.getStorageFolder(this.storageFolder), CLOSED_CAT_FILE);
        return this.readClosedEntries(closedCategoryFile);
    }

    public List<String> readClosedRepositories() {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the repository storage in awt";
        File closedRepositoryFile = new File(this.getStorageFolder(this.storageFolder), CLOSED_REPO_FILE);
        return this.readClosedEntries(closedRepositoryFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readClosedEntries(File file) {
        LOG.log(Level.FINE, "start reading closed entries");
        FilterInputStream dis = null;
        StorageUtils.FileLocks.FileLock lock = null;
        try {
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(file);
            synchronized (fileLock) {
                try {
                    dis = this.getClosedInputStream(file);
                    List<String> list = this.readEntries((DataInputStream)dis);
                    return list;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, null, ex);
                        List<String> list = Collections.emptyList();
                        return list;
                    }
                }
            }
        }
        finally {
            LOG.log(Level.FINE, "finished reading closed entries");
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
            if (lock != null) {
                lock.release();
            }
        }
    }

    private List<String> readEntries(DataInputStream dis) throws IOException {
        if (dis == null) {
            return Collections.emptyList();
        }
        ArrayList<String> entries = new ArrayList<String>();
        while (true) {
            String entry;
            try {
                entry = DashboardStorage.readString(dis);
            }
            catch (EOFException e) {
                break;
            }
            entries.add(entry);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCategory(String categoryName, List<TaskEntry> tasks) {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the category storage in awt";
        LOG.log(Level.FINE, "start storing category {0}", categoryName);
        StorageUtils.FileLocks.FileLock lock = null;
        FilterOutputStream dos = null;
        try {
            File categoryFile = this.getCategoryFile(this.getStorageFolder(this.storageFolder), categoryName);
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(categoryFile);
            synchronized (fileLock) {
                dos = this.getCategoryOutputStream(categoryFile);
                for (TaskEntry taskEntry : tasks) {
                    this.writeString((DataOutputStream)dos, taskEntry.getIssueId());
                    this.writeString((DataOutputStream)dos, taskEntry.getRepositoryId());
                }
                ((DataOutputStream)dos).flush();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        finally {
            LOG.log(Level.FINE, "finished storing category {0}", categoryName);
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
            if (lock != null) {
                lock.release();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean renameCategory(String oldName, String newName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteCategories(String ... categoryNames) {
        for (String name : categoryNames) {
            this.deleteCategory(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCategory(String categoryName) {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the category storage in awt";
        LOG.log(Level.FINE, "start deleting category {0}", categoryName);
        StorageUtils.FileLocks.FileLock lock = null;
        try {
            File categoryFile = this.getCategoryFile(this.getStorageFolder(this.storageFolder), categoryName);
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(categoryFile);
            synchronized (fileLock) {
                try {
                    boolean bl = categoryFile.delete();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SecurityException ex) {
                        LOG.log(Level.WARNING, "Not able to delete category file", ex);
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            LOG.log(Level.FINE, "finished deleting category {0}", categoryName);
            if (lock != null) {
                lock.release();
            }
        }
    }

    public List<CategoryEntry> readCategories() {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the category storage in awt";
        ArrayList<CategoryEntry> categories = new ArrayList<CategoryEntry>();
        File[] files = this.getStorageFolder(this.storageFolder).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.equals(DashboardStorage.this.getStorageFolder(DashboardStorage.this.storageFolder)) && name.endsWith(DashboardStorage.CATEGORY_SUFIX);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String categoryName = TextUtils.decodeURL((String)file.getName().replace(CATEGORY_SUFIX, ""));
            List<TaskEntry> taskEntries = this.readCategory(categoryName);
            if (taskEntries == null) continue;
            CategoryEntry categoryEntry = new CategoryEntry(categoryName, taskEntries);
            categories.add(categoryEntry);
        }
        return categories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskEntry> readCategory(String categoryName) {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the category storage in awt";
        LOG.log(Level.FINE, "start reading category {0}", categoryName);
        FilterInputStream dis = null;
        StorageUtils.FileLocks.FileLock lock = null;
        try {
            File categoryFile = this.getCategoryFile(this.getStorageFolder(this.storageFolder), categoryName);
            if (!categoryFile.exists()) {
                List<TaskEntry> list = null;
                return list;
            }
            StorageUtils.FileLocks.FileLock fileLock = lock = StorageUtils.FileLocks.getLock(categoryFile);
            synchronized (fileLock) {
                try {
                    dis = this.getCategoryInputStream(categoryFile);
                    List<TaskEntry> list = this.readCategory((DataInputStream)dis);
                    return list;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, null, ex);
                        fileLock = null;
                        return fileLock;
                    }
                }
            }
        }
        finally {
            LOG.log(Level.FINE, "finished reading category {0}", categoryName);
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
            if (lock != null) {
                lock.release();
            }
        }
    }

    private List<TaskEntry> readCategory(DataInputStream dis) throws IOException {
        if (dis == null) {
            return Collections.emptyList();
        }
        ArrayList<TaskEntry> ids = new ArrayList<TaskEntry>();
        while (true) {
            String idRepository;
            String idIssue;
            try {
                idIssue = DashboardStorage.readString(dis);
                idRepository = DashboardStorage.readString(dis);
            }
            catch (EOFException e) {
                break;
            }
            ids.add(new TaskEntry(idIssue, idRepository));
        }
        return ids;
    }

    private DataOutputStream getCategoryOutputStream(File categoryFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(categoryFile, false)));
        ZipEntry entry = new ZipEntry(categoryFile.getName());
        zos.putNextEntry(entry);
        return new DataOutputStream(zos);
    }

    private DataInputStream getCategoryInputStream(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        zis.getNextEntry();
        return new DataInputStream(zis);
    }

    private DataOutputStream getClosedOutputStream(File closedFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(closedFile, false)));
        ZipEntry entry = new ZipEntry(closedFile.getName());
        zos.putNextEntry(entry);
        return new DataOutputStream(zos);
    }

    private DataInputStream getClosedInputStream(File closedFile) throws IOException {
        if (!closedFile.exists()) {
            return null;
        }
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(closedFile)));
        zis.getNextEntry();
        return new DataInputStream(zis);
    }

    private File getCategoryFile(File folder, String name) {
        return new File(folder, TextUtils.encodeURL((String)name) + CATEGORY_SUFIX);
    }

    private File getStorageRootFile() {
        File userDir = Places.getUserDirectory();
        return new File(new File(new File(userDir, "var"), "bugtracking"), "dashboard");
    }

    private void writeStorage() {
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(new File(this.getStorageFolder(this.storageFolder), STORAGE_FILE), false));
            this.writeString((DataOutputStream)dos, "1.0");
            ((DataOutputStream)dos).flush();
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeString(DataOutputStream dos, String str) throws IOException {
        if (str != null) {
            dos.writeInt(str.length());
            dos.writeChars(str);
        } else {
            dos.writeInt(0);
        }
    }

    private static String readString(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (len-- > 0) {
            char c = dis.readChar();
            sb.append(c);
        }
        return sb.toString();
    }

    private File getStorageFolder(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.tasks.ui.cache.CategoryStorage");
    }
}

