/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.services.DependencyChecker;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.ArtificialFeaturesProvider;
import org.netbeans.modules.autoupdate.updateprovider.FeatureItem;
import org.netbeans.modules.autoupdate.updateprovider.InstallInfo;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public class FeatureUpdateElementImpl
extends UpdateElementImpl {
    private String codeName;
    private String displayName;
    private SpecificationVersion specVersion;
    private String description;
    private String homepage;
    private String category;
    private InstallInfo installInfo;
    private static final Logger LOG = Logger.getLogger(FeatureUpdateElementImpl.class.getName());
    private Set<ModuleUpdateElementImpl> moduleElementsImpl;
    private UpdateManager.TYPE type;

    public FeatureUpdateElementImpl(FeatureItem item, String providerName, Set<ModuleUpdateElementImpl> moduleElementsImpl, UpdateManager.TYPE type) {
        super(item, providerName);
        this.type = type;
        this.moduleElementsImpl = moduleElementsImpl;
        this.codeName = item.getCodeName();
        String itemSpec = item.getSpecificationVersion();
        if (itemSpec == null) {
            LOG.log(Level.INFO, this.codeName + " has no specificationVersion.");
        } else {
            this.specVersion = new SpecificationVersion(itemSpec);
        }
        this.installInfo = new InstallInfo(item);
        this.displayName = item.getDisplayName();
        this.description = item.getDescription();
        this.category = item.getCategory();
        if (this.category == null) {
            this.category = NbBundle.getMessage(UpdateElementImpl.class, (String)"UpdateElementImpl_Feature_CategoryName");
        }
    }

    @Override
    public String getCodeName() {
        return this.codeName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SpecificationVersion getSpecificationVersion() {
        if (this.specVersion == null) {
            this.specVersion = new SpecificationVersion(ArtificialFeaturesProvider.createVersion(this.getModuleInfos()));
        }
        return this.specVersion;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNotification() {
        return null;
    }

    @Override
    public String getAuthor() {
        String res = "";
        HashSet<String> authors = new HashSet<String>();
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            if (impl.getAuthor() == null || !authors.add(impl.getAuthor())) continue;
            res = res + (res.length() == 0 ? impl.getAuthor() : ", " + impl.getAuthor());
        }
        return res;
    }

    @Override
    public String getHomepage() {
        return this.homepage;
    }

    @Override
    public int getDownloadSize() {
        int res = 0;
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            if (impl.getUpdateUnit().getAvailableUpdates().isEmpty()) continue;
            res += impl.getUpdateUnit().getAvailableUpdates().get(0).getDownloadSize();
        }
        return res;
    }

    @Override
    public String getSource() {
        String res = "";
        HashSet<String> sources = new HashSet<String>();
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            if (!sources.add(impl.getSource())) continue;
            res = res + (res.length() == 0 ? impl.getSource() : ", " + impl.getSource());
        }
        return res;
    }

    @Override
    public String getCategory() {
        if (this.isAutoload() || this.isFixed()) {
            this.category = UpdateUnitFactory.LIBRARIES_CATEGORY;
        } else if (this.isEager()) {
            this.category = UpdateUnitFactory.BRIDGES_CATEGORY;
        } else if (this.category == null || this.category.length() == 0) {
            this.category = UpdateUnitFactory.UNSORTED_CATEGORY;
        }
        return this.category;
    }

    @Override
    public String getDate() {
        String res = null;
        Date date = null;
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            String sd = impl.getDate();
            if (sd == null) continue;
            try {
                Date d = Utilities.parseDate(sd);
                date = date == null ? d : new Date(Math.max(date.getTime(), d.getTime()));
            }
            catch (ParseException pe) {
                assert (false) : pe + " cannot happened.";
            }
        }
        if (date != null) {
            res = Utilities.formatDate(date);
        }
        return res;
    }

    @Override
    public String getLicenseId() {
        String res = "";
        HashSet<String> ids = new HashSet<String>();
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            String id;
            if (impl.getUpdateUnit().getAvailableUpdates().isEmpty() || !ids.add(id = impl.getUpdateUnit().getAvailableUpdates().get(0).getLicenseId())) continue;
            res = res + (res.length() == 0 ? id : "," + id);
        }
        return res;
    }

    @Override
    public String getLicence() {
        String res = "";
        HashSet<String> licenses = new HashSet<String>();
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            String lic;
            if (impl.getUpdateUnit().getAvailableUpdates().isEmpty() || !licenses.add(lic = impl.getUpdateUnit().getAvailableUpdates().get(0).getLicence())) continue;
            res = res + (res.length() == 0 ? lic : "<br>" + lic);
        }
        return res;
    }

    @Override
    public InstallInfo getInstallInfo() {
        return this.installInfo;
    }

    @Override
    public List<ModuleInfo> getModuleInfos() {
        ArrayList<ModuleInfo> infos = new ArrayList<ModuleInfo>();
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            if (infos.contains(impl.getModuleInfo())) continue;
            infos.add(impl.getModuleInfo());
        }
        return infos;
    }

    public Set<ModuleUpdateElementImpl> getContainedModuleElements() {
        assert (this.moduleElementsImpl != null) : "FeatureUpdateElementImpl contains modules " + this.moduleElementsImpl;
        return this.moduleElementsImpl;
    }

    @Override
    public UpdateManager.TYPE getType() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        boolean res = true;
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            res &= impl.isEnabled();
        }
        return res;
    }

    @Override
    public boolean isAutoload() {
        boolean res = true;
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            res &= impl.isAutoload();
        }
        return res;
    }

    @Override
    public boolean isEager() {
        boolean res = true;
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            res &= impl.isEager();
        }
        return res;
    }

    @Override
    public boolean isFixed() {
        boolean res = true;
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            res &= impl.isFixed();
        }
        return res;
    }

    @Override
    public boolean isPreferredUpdate() {
        boolean res = true;
        for (ModuleUpdateElementImpl impl : this.getContainedModuleElements()) {
            res &= impl.isPreferredUpdate();
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureUpdateElementImpl other = (FeatureUpdateElementImpl)obj;
        if (!(this.specVersion == other.specVersion || this.specVersion != null && this.specVersion.equals((Object)other.specVersion))) {
            return false;
        }
        return this.codeName == other.codeName || this.codeName != null && this.codeName.equals(other.codeName);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.codeName != null ? this.codeName.hashCode() : 0);
        hash = 61 * hash + (this.specVersion != null ? this.specVersion.hashCode() : 0);
        return hash;
    }

    public static class Agent
    extends FeatureUpdateElementImpl {
        private Set<ModuleUpdateElementImpl> moduleElementsImpl;
        private FeatureItem featureItem;

        public Agent(FeatureItem item, String providerName, UpdateManager.TYPE type) {
            super(item, providerName, null, type);
            this.featureItem = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ModuleUpdateElementImpl> getContainedModuleElements() {
            Agent agent = this;
            synchronized (agent) {
                if (this.moduleElementsImpl == null) {
                    this.moduleElementsImpl = this.processContainedModules(this.featureItem.getModuleCodeNames(), null);
                }
            }
            assert (this.moduleElementsImpl != null) : "FeatureUpdateElementImpl contains modules " + this.moduleElementsImpl;
            return this.moduleElementsImpl;
        }

        private Set<ModuleUpdateElementImpl> processContainedModules(Set<String> dependenciesToModules, UpdateUnitProvider provider) {
            HashSet<ModuleUpdateElementImpl> res = new HashSet<ModuleUpdateElementImpl>();
            assert (dependenciesToModules != null) : "Invalid Feature " + this + " with null modules.";
            if (dependenciesToModules == null) {
                dependenciesToModules = Collections.emptySet();
            }
            HashSet deps = new HashSet();
            for (String depSpec : dependenciesToModules) {
                deps.addAll(Dependency.create((int)1, (String)depSpec));
            }
            List<UpdateUnit> moduleUnits = provider == null ? UpdateManager.getDefault().getUpdateUnits(UpdateManager.TYPE.MODULE) : provider.getUpdateUnits(UpdateManager.TYPE.MODULE);
            for (UpdateUnit unit : moduleUnits) {
                for (Dependency dep : deps) {
                    assert (1 == dep.getType()) : "Only Dependency.TYPE_MODULE supported, but " + dep;
                    String name = dep.getName();
                    if (name.indexOf(47) != -1) {
                        int to = name.indexOf(47);
                        name = name.substring(0, to);
                    }
                    if (!unit.getCodeName().equals(name)) continue;
                    UpdateElement el = Agent.getMatchedUpdateElement(unit, dep);
                    if (el != null) {
                        assert (Trampoline.API.impl(el) instanceof ModuleUpdateElementImpl) : "Impl of " + el + " is instanceof ModuleUpdateElementImpl.";
                        ModuleUpdateElementImpl impl = (ModuleUpdateElementImpl)Trampoline.API.impl(el);
                        res.add(impl);
                        continue;
                    }
                    LOG.log(Level.INFO, this.getUpdateUnit() + " requires a module " + name + " what is not present.");
                }
            }
            return res;
        }

        private static UpdateElement getMatchedUpdateElement(UpdateUnit unit, Dependency dep) {
            if (Agent.match(unit.getInstalled(), dep)) {
                return unit.getInstalled();
            }
            if (!unit.getAvailableUpdates().isEmpty() && Agent.match(unit.getAvailableUpdates().get(0), dep)) {
                return unit.getAvailableUpdates().get(0);
            }
            return null;
        }

        private static boolean match(UpdateElement el, Dependency dep) {
            if (el == null) {
                return false;
            }
            return DependencyChecker.checkDependencyModuleAllowEqual(dep, Utilities.takeModuleInfo(el));
        }
    }
}

