/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleProvider;
import org.netbeans.updater.UpdateTracking;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ModuleEnableDisableDeleteHelper {
    private static final ModuleEnableDisableDeleteHelper INSTANCE = new ModuleEnableDisableDeleteHelper();
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_FILE_NAME = "name";
    private static final Logger err = Logger.getLogger(ModuleEnableDisableDeleteHelper.class.getName());
    private Set<File> storageFilesForDelete = null;

    public static ModuleEnableDisableDeleteHelper getInstance() {
        return INSTANCE;
    }

    public boolean canDelete(ModuleInfo moduleInfo) {
        if (moduleInfo == null) {
            return false;
        }
        if (Utilities.isEssentialModule(moduleInfo)) {
            err.log(Level.FINE, "Cannot delete module because module " + moduleInfo.getCodeName() + " isEssentialModule.");
            return false;
        }
        return this.foundUpdateTracking(moduleInfo);
    }

    public Collection<File> findControlFiles(Collection<ModuleInfo> modules, ProgressHandle handle) {
        if (modules == null) {
            throw new IllegalArgumentException("ModuleInfo argument cannot be null.");
        }
        if (handle != null) {
            handle.switchToDeterminate(modules.size() + 1);
        }
        return this.doFindControlFiles(modules, handle);
    }

    private Collection<File> doFindControlFiles(Collection<ModuleInfo> modules, ProgressHandle handle) {
        HashSet<File> configs = new HashSet<File>();
        int i = 0;
        for (ModuleInfo moduleInfo : modules) {
            File config = this.locateConfigFile(moduleInfo);
            assert (config != null) : "Located config file for " + moduleInfo.getCodeName();
            assert (config.exists()) : config + " config file must exists for " + moduleInfo.getCodeName();
            err.log(Level.FINE, "Locate config file of " + moduleInfo.getCodeNameBase() + ": " + config);
            if (config != null) {
                configs.add(config);
            }
            if (handle == null) continue;
            handle.progress(++i);
        }
        return configs;
    }

    public Collection<File> markForDelete(Collection<ModuleInfo> modules, ProgressHandle handle) throws IOException {
        this.storageFilesForDelete = null;
        if (modules == null) {
            throw new IllegalArgumentException("ModuleInfo argument cannot be null.");
        }
        if (handle != null) {
            handle.switchToDeterminate(modules.size() * 2 + 1);
        }
        Collection<File> configFiles = this.doFindControlFiles(modules, handle);
        int i = configFiles.size();
        this.getStorageFilesForDelete().addAll(configFiles);
        for (ModuleInfo moduleInfo : modules) {
            this.removeModuleFiles(moduleInfo, true);
            if (handle == null) continue;
            handle.progress(++i);
        }
        return this.getStorageFilesForDelete();
    }

    public void delete(ModuleInfo[] modules, ProgressHandle handle) throws IOException {
        this.storageFilesForDelete = null;
        if (modules == null) {
            throw new IllegalArgumentException("ModuleInfo argument cannot be null.");
        }
        if (handle != null) {
            handle.switchToDeterminate(modules.length + 1);
        }
        int i = 0;
        for (ModuleInfo moduleInfo : modules) {
            err.log(Level.FINE, "Locate and remove config file of " + moduleInfo.getCodeNameBase());
            this.removeControlModuleFile(moduleInfo, false);
        }
        if (handle != null) {
            handle.progress(++i);
        }
        this.refreshModuleList();
        int rerunWaitCount = 0;
        for (ModuleInfo moduleInfo : modules) {
            err.log(Level.FINE, "Locate and remove config file of " + moduleInfo.getCodeNameBase());
            if (handle != null) {
                handle.progress(moduleInfo.getDisplayName(), ++i);
            }
            while (rerunWaitCount < 100 && !this.isModuleUninstalled(moduleInfo)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    err.log(Level.INFO, "Overflow checks of uninstalled module " + moduleInfo.getCodeName());
                    Thread.currentThread().interrupt();
                }
                ++rerunWaitCount;
            }
            this.removeModuleFiles(moduleInfo, false);
        }
    }

    private boolean isModuleUninstalled(ModuleInfo moduleInfo) {
        return InstalledModuleProvider.getInstalledModules().get(moduleInfo.getCodeNameBase()) == null;
    }

    private File locateConfigFile(ModuleInfo m) {
        String configFile = "config/Modules/" + m.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(configFile, m.getCodeNameBase(), false);
    }

    private Collection<File> locateAllConfigFiles(ModuleInfo m) {
        HashSet<File> configFiles = new HashSet<File>();
        String configFileName = m.getCodeNameBase().replace('.', '-') + ".xml";
        for (File cluster : UpdateTracking.clusters((boolean)true)) {
            File configFile = new File(new File(new File(cluster, "config"), "Modules"), configFileName);
            if (!configFile.exists()) continue;
            configFiles.add(configFile);
        }
        return configFiles;
    }

    private void removeControlModuleFile(ModuleInfo m, boolean markForDelete) throws IOException {
        File configFile;
        while ((configFile = this.locateConfigFile(m)) != null && !this.getStorageFilesForDelete().contains(configFile)) {
            if (configFile != null && configFile.exists()) {
                if (markForDelete) {
                    err.log(Level.FINE, "Control file " + configFile + " is marked for delete.");
                    this.getStorageFilesForDelete().add(configFile);
                    continue;
                }
                err.log(Level.FINE, "Try delete the config File " + configFile);
                configFile.delete();
                err.log(Level.FINE, "Control file " + configFile + " is deleted.");
                continue;
            }
            err.log(Level.FINE, "Warning: Config File " + configFile + " doesn't exist!");
        }
    }

    private boolean foundUpdateTracking(ModuleInfo moduleInfo) {
        File updateTracking = Utilities.locateUpdateTracking(moduleInfo);
        if (updateTracking != null && updateTracking.exists()) {
            if (!Utilities.canWrite(updateTracking)) {
                err.log(Level.FINE, "Cannot delete module " + moduleInfo.getCodeName() + " because is forbidden to write in directory " + updateTracking.getParentFile().getParent());
                return false;
            }
            return true;
        }
        err.log(Level.FINE, "Cannot delete module " + moduleInfo.getCodeName() + " because no update_tracking file found.");
        return false;
    }

    private void removeModuleFiles(ModuleInfo m, boolean markForDelete) throws IOException {
        File updateTracking;
        err.log(Level.FINE, "Entry removing files of module " + m);
        while ((updateTracking = Utilities.locateUpdateTracking(m)) != null && !this.getStorageFilesForDelete().contains(updateTracking)) {
            this.removeModuleFilesInCluster(m, updateTracking, markForDelete);
        }
        err.log(Level.FINE, "Exit removing files of module " + m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModuleFilesInCluster(ModuleInfo moduleInfo, File updateTracking, boolean markForDelete) throws IOException {
        Object file;
        err.log(Level.FINE, "Read update_tracking " + updateTracking + " file.");
        Set<String> moduleFiles = this.readModuleFiles(this.getModuleConfiguration(updateTracking));
        String configFile = "config/Modules/" + moduleInfo.getCodeNameBase().replace('.', '-') + ".xml";
        if (moduleFiles.contains(configFile) && (file = InstalledFileLocator.getDefault().locate(configFile, moduleInfo.getCodeNameBase(), false)) != null && ((File)file).exists() && !this.getStorageFilesForDelete().contains(file)) {
            err.log(Level.WARNING, "Config file " + configFile + " must be already removed or marked for remove but still exist as file " + (File)file + " and not found in StorageFilesForDelete : " + this.getStorageFilesForDelete());
        }
        for (String fileName : moduleFiles) {
            if (fileName.equals(configFile)) continue;
            Set files = InstalledFileLocator.getDefault().locateAll(fileName, moduleInfo.getCodeNameBase(), false);
            File file2 = null;
            if (files.size() > 0) {
                file2 = (File)files.iterator().next();
                if (files.size() > 1) {
                    boolean found = false;
                    for (File f : files) {
                        if (!f.getPath().startsWith(updateTracking.getParentFile().getParentFile().getPath())) continue;
                        file2 = f;
                        found = true;
                        break;
                    }
                    if (!found) {
                        err.log(Level.WARNING, "InstalledFileLocator doesn't choose the right file with file name " + fileName + " for module " + moduleInfo.getCodeNameBase() + " since a few files were returned : " + Arrays.toString(files.toArray()) + ", and since none are in the same cluster as update tracking file " + updateTracking + " will use " + file2);
                    }
                }
            }
            if (file2 == null) {
                err.log(Level.WARNING, "InstalledFileLocator doesn't locate file " + fileName + " for module " + moduleInfo.getCodeNameBase());
                continue;
            }
            if (file2.equals(updateTracking)) continue;
            assert (file2.exists()) : "File " + file2 + " exists.";
            if (!file2.exists()) continue;
            if (markForDelete) {
                err.log(Level.FINE, "File " + file2 + " is marked for delete.");
                this.getStorageFilesForDelete().add(file2);
                continue;
            }
            try {
                FileObject fo = FileUtil.toFileObject((File)file2);
                if (fo != null) {
                    fo.lock().releaseLock();
                }
                File f = file2;
                while (f.delete()) {
                    f = f.getParentFile();
                }
            }
            catch (IOException ioe) {
                assert (false) : "Waring: IOException " + ioe.getMessage() + " was caught. Propably file lock on the file.";
                err.log(Level.FINE, "Waring: IOException " + ioe.getMessage() + " was caught. Propably file lock on the file.");
                err.log(Level.FINE, "Try call File.deleteOnExit() on " + file2);
                file2.deleteOnExit();
            }
            err.log(Level.FINE, "File " + file2 + " is deleted.");
        }
        FileObject trackingFo = FileUtil.toFileObject((File)updateTracking);
        FileLock lock = null;
        try {
            FileLock fileLock = lock = trackingFo != null ? trackingFo.lock() : null;
            if (markForDelete) {
                err.log(Level.FINE, "Tracking file " + updateTracking + " is marked for delete.");
                this.getStorageFilesForDelete().add(updateTracking);
            } else {
                updateTracking.delete();
                err.log(Level.FINE, "Tracking file " + updateTracking + " is deleted.");
            }
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        err.log(Level.FINE, "File " + updateTracking + " is deleted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getModuleConfiguration(File moduleUpdateTracking) {
        Document document = null;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(moduleUpdateTracking));
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException saxe) {
            err.log(Level.WARNING, "SAXException when reading " + moduleUpdateTracking, saxe);
            FileReader reader = null;
            try {
                reader = new FileReader(moduleUpdateTracking);
                char[] text = new char[1024];
                Object fileContent = "";
                while (reader.read(text) > 0) {
                    fileContent = (String)fileContent + String.copyValueOf(text);
                }
                err.log(Level.WARNING, "SAXException in file:\n------FILE START------\n " + (String)fileContent + "\n------FILE END-----\n");
            }
            catch (Exception exception) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
        catch (IOException ioe) {
            err.log(Level.WARNING, "IOException when reading " + moduleUpdateTracking, ioe);
        }
        assert (document.getDocumentElement() != null) : "File " + moduleUpdateTracking + " must contain <module> element.";
        return this.getModuleElement(document.getDocumentElement());
    }

    private Node getModuleElement(Element element) {
        Node lastElement = null;
        assert (ELEMENT_MODULE.equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList listModuleVersions = element.getElementsByTagName(ELEMENT_VERSION);
        for (int i = 0; i < listModuleVersions.getLength() && (lastElement = this.getModuleLastVersion(listModuleVersions.item(i))) == null; ++i) {
        }
        return lastElement;
    }

    private Node getModuleLastVersion(Node version) {
        Node attrLast = version.getAttributes().getNamedItem(ATTR_LAST);
        assert (attrLast != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(attrLast.getNodeValue()).booleanValue()) {
            return version;
        }
        return null;
    }

    private Set<String> readModuleFiles(Node version) {
        if (version == null) {
            return Collections.emptySet();
        }
        NodeList fileNodes = version.getChildNodes();
        if (fileNodes == null) {
            return Collections.emptySet();
        }
        HashSet<String> files = new HashSet<String>();
        for (int i = 0; i < fileNodes.getLength(); ++i) {
            if (!fileNodes.item(i).hasAttributes()) continue;
            NamedNodeMap map = fileNodes.item(i).getAttributes();
            files.add(map.getNamedItem(ATTR_FILE_NAME).getNodeValue());
            err.log(Level.FINE, "Mark to delete: " + map.getNamedItem(ATTR_FILE_NAME).getNodeValue());
        }
        return files;
    }

    private void refreshModuleList() {
        FileObject modulesRoot = FileUtil.getConfigFile((String)"Modules");
        err.log(Level.FINE, "Call refresh on " + modulesRoot + " file object.");
        if (modulesRoot != null) {
            modulesRoot.refresh();
        }
    }

    private Set<File> getStorageFilesForDelete() {
        if (this.storageFilesForDelete == null) {
            this.storageFilesForDelete = new HashSet<File>();
        }
        return this.storageFilesForDelete;
    }
}

