/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class StashDropCommand
extends GitCommand {
    private final int stashIndex;
    private final boolean all;

    public StashDropCommand(Repository repository, GitClassFactory accessor, int stashIndex, boolean all, ProgressMonitor monitor) {
        super(repository, accessor, monitor);
        this.stashIndex = stashIndex;
        this.all = all;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            new Git(repository).stashDrop().setAll(this.all).setStashRef(this.stashIndex).call();
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        if (this.all) {
            return "git stash clear";
        }
        return "git stash drop stash@{" + this.stashIndex + "}";
    }
}

