/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import java.io.Reader;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.netbeans.api.xml.parsers.DocumentInputSource;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.Util;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class DataObjectAdapters {
    private static final String SAX_FEATURES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static SAXParserFactory saxParserFactory;

    private DataObjectAdapters() {
    }

    public static InputSource inputSource(DataObject dataObject) {
        if (dataObject == null) {
            throw new NullPointerException();
        }
        return new DataObjectInputSource(dataObject);
    }

    public static Source source(DataObject dataObject) {
        if (dataObject == null) {
            throw new NullPointerException();
        }
        return new DataObjectSAXSource(dataObject);
    }

    private static String getSystemId(DataObject dataObject) {
        return dataObject.getPrimaryFile().toURI().toASCIIString();
    }

    private static synchronized SAXParserFactory getSAXParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature(SAX_FEATURES_NAMESPACES, true);
        }
        return saxParserFactory;
    }

    private static XMLReader newXMLReader() throws ParserConfigurationException, SAXException {
        SAXParser parser = DataObjectAdapters.getSAXParserFactory().newSAXParser();
        return parser.getXMLReader();
    }

    private static EntityResolver getEntityResolver() {
        UserCatalog catalog = UserCatalog.getDefault();
        EntityResolver res = catalog == null ? null : catalog.getEntityResolver();
        return res;
    }

    private static class DataObjectInputSource
    extends InputSource {
        private final DataObject dataObject;

        public DataObjectInputSource(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        @Override
        public String getSystemId() {
            return DataObjectAdapters.getSystemId(this.dataObject);
        }

        @Override
        public Reader getCharacterStream() {
            StyledDocument doc;
            EditorCookie editor = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
            if (editor != null && (doc = editor.getDocument()) != null) {
                return new DocumentInputSource((Document)doc).getCharacterStream();
            }
            return null;
        }
    }

    private static class DataObjectSAXSource
    extends SAXSource {
        private final DataObject dataObject;

        public DataObjectSAXSource(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        @Override
        public String getSystemId() {
            return DataObjectAdapters.getSystemId(this.dataObject);
        }

        @Override
        public XMLReader getXMLReader() {
            try {
                XMLReader reader = DataObjectAdapters.newXMLReader();
                reader.setEntityResolver(DataObjectAdapters.getEntityResolver());
                return reader;
            }
            catch (ParserConfigurationException ex) {
                Util.THIS.debug(ex);
            }
            catch (SAXNotRecognizedException ex) {
                Util.THIS.debug(ex);
            }
            catch (SAXNotSupportedException ex) {
                Util.THIS.debug(ex);
            }
            catch (SAXException ex) {
                Util.THIS.debug(ex);
            }
            return null;
        }

        @Override
        public InputSource getInputSource() {
            return DataObjectAdapters.inputSource(this.dataObject);
        }
    }
}

