/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webmodule;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.FrameworkConfigurationPanel;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;

public class WebModuleExtenderBridge
extends WebModuleExtender {
    private final WebFrameworkProvider framework;
    private final WebModule webModule;
    private final ExtenderController controller;
    private final FrameworkConfigurationPanel configPanel;
    private final WizardDescriptor wizard;
    private Map<String, Object> oldProps;

    public static WebModuleExtenderBridge create(WebFrameworkProvider framework, WebModule webModule, ExtenderController controller) {
        WebModuleExtenderBridge result = new WebModuleExtenderBridge(framework, webModule, controller);
        result.initialize();
        return result;
    }

    private WebModuleExtenderBridge(WebFrameworkProvider framework, WebModule webModule, ExtenderController controller) {
        WizardDescriptor tmpWizard;
        this.framework = framework;
        this.webModule = webModule;
        this.controller = controller;
        FrameworkConfigurationPanel tmpPanel = framework.getConfigurationPanel(webModule);
        this.configPanel = tmpPanel != null ? tmpPanel : new EmptyConfigPanel();
        this.wizard = tmpWizard = new WizardDescriptor(new WizardDescriptor.Panel[]{new EmptyPanel()});
    }

    private void initialize() {
        this.wizard.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String message = (String)WebModuleExtenderBridge.this.wizard.getProperty("WizardPanel_errorMessage");
                if (message != null && message.trim().length() == 0) {
                    message = null;
                }
                WebModuleExtenderBridge.this.controller.setErrorMessage(message);
            }
        });
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.configPanel.addChangeListener(listener);
    }

    @Override
    public Set<FileObject> extend(WebModule webModule) {
        this.configPanel.storeSettings(this.wizard);
        return this.framework.extend(webModule);
    }

    @Override
    public JComponent getComponent() {
        return (JComponent)this.configPanel.getComponent();
    }

    @Override
    public HelpCtx getHelp() {
        return this.configPanel.getHelp();
    }

    @Override
    public boolean isValid() {
        return this.configPanel.isValid();
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.configPanel.removeChangeListener(listener);
    }

    @Override
    public void update() {
        if (this.oldProps != null) {
            for (Map.Entry<String, Object> entry : this.oldProps.entrySet()) {
                this.wizard.putProperty(entry.getKey(), null);
            }
        }
        Map<String, Object> newProps = this.controller.getProperties().getProperties();
        for (Map.Entry<String, Object> entry : newProps.entrySet()) {
            this.wizard.putProperty(entry.getKey(), entry.getValue());
        }
        this.oldProps = newProps;
        this.configPanel.readSettings(this.wizard);
    }

    private static final class EmptyConfigPanel
    extends EmptyPanel
    implements FrameworkConfigurationPanel {
        private EmptyConfigPanel() {
        }

        @Override
        public Component getComponent() {
            return null;
        }

        @Override
        public void enableComponents(boolean enable) {
        }
    }

    private static class EmptyPanel
    implements WizardDescriptor.Panel {
        private JPanel component;

        private EmptyPanel() {
        }

        public void addChangeListener(ChangeListener l) {
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new JPanel();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public void readSettings(Object settings) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public void storeSettings(Object settings) {
        }
    }
}

