/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class DualGraph<N, E> {
    private EmbeddedPlanarGraph<N, E> originalGraph;
    private Map<Face, FaceVertex> vertexMap;
    private Collection<FaceVertex> vertices;
    private Map<MGraph.Edge<?>, FaceEdge> edgeMap;
    private Collection<FaceEdge> edges;
    private Collection<MGraph.Edge<?>> edgesToIgnore;
    private Collection<Face> facesToIgnore;

    public static <N, E> DualGraph<N, E> createGraph(EmbeddedPlanarGraph<N, E> graph, Collection<Face> facesToIgnore, Collection<MGraph.Edge<?>> edgesToIgnore) {
        DualGraph<N, E> dualGraph = new DualGraph<N, E>(graph, facesToIgnore, edgesToIgnore);
        dualGraph.createGraph();
        return dualGraph;
    }

    private DualGraph(EmbeddedPlanarGraph<N, E> graph, Collection<Face> facesToIgnore, Collection<MGraph.Edge<?>> edgesToIgnore) {
        this.originalGraph = graph;
        this.facesToIgnore = facesToIgnore;
        this.edgesToIgnore = edgesToIgnore;
        this.vertexMap = new HashMap<Face, FaceVertex>();
        this.vertices = new ArrayList<FaceVertex>();
        this.edgeMap = new HashMap();
        this.edges = new ArrayList<FaceEdge>();
    }

    private void createGraph() {
        this.createFaces();
        this.createEdges();
    }

    private void createFaces() {
        for (Face f : this.originalGraph.getFaces()) {
            if (this.facesToIgnore.contains(f) && !f.isOuterFace()) continue;
            this.getVertex(f);
        }
    }

    private void createEdges() {
        for (FaceVertex fv : this.getVertices()) {
            for (FaceVertex gv : this.getVertices()) {
                if (fv == gv) continue;
                for (MGraph.Edge<?> e : fv.getFace().getEdges()) {
                    if (this.edgesToIgnore.contains(e) || !gv.getFace().containsEdge(e)) continue;
                    FaceEdge faceEdge = this.getEdge(fv, gv, e);
                    fv.addEdge(faceEdge);
                }
            }
        }
    }

    public void updateFaces() {
        int vertexCount;
        int faceCount = this.originalGraph.getFaces().size();
        if (faceCount > (vertexCount = this.vertices.size())) {
            this.createFaces();
        } else if (faceCount < vertexCount) {
            this.vertices.clear();
            this.vertexMap.clear();
            this.createFaces();
        }
    }

    public void updateEdges() {
        this.edges.clear();
        this.edgeMap.clear();
        for (FaceVertex fv : this.getVertices()) {
            fv.getEdges().clear();
        }
        this.createEdges();
    }

    public EmbeddedPlanarGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    public Collection<FaceVertex> getVertices() {
        return this.vertices;
    }

    public Collection<FaceEdge> getEdges() {
        return this.edges;
    }

    private FaceVertex getVertex(Face face) {
        FaceVertex vertex = this.vertexMap.get(face);
        if (vertex == null) {
            vertex = new FaceVertex(face);
            this.vertexMap.put(face, vertex);
            this.vertices.add(vertex);
        }
        return vertex;
    }

    private FaceEdge getEdge(FaceVertex f, FaceVertex g, MGraph.Edge<?> e) {
        FaceEdge edge = this.edgeMap.get(e);
        if (edge == null) {
            edge = new FaceEdge(f, g, e);
            this.edgeMap.put(e, edge);
            this.edges.add(edge);
        }
        return edge;
    }

    public Collection<FaceVertex> getVerticesBorderingEdge(MGraph.Edge<?> e) {
        ArrayList<FaceVertex> result = new ArrayList<FaceVertex>();
        for (FaceVertex v : this.getVertices()) {
            if (!v.getFace().containsEdge(e)) continue;
            result.add(v);
        }
        return result;
    }

    public String toString() {
        Object s = "DualGraph:\n";
        s = (String)s + "vertices:\n";
        for (FaceVertex fv : this.vertices) {
            s = (String)s + "\t" + fv + "\n";
        }
        s = (String)s + "edges\n";
        for (FaceEdge fe : this.edges) {
            s = (String)s + "\t" + fe + "\n";
        }
        return s;
    }

    public static class FaceVertex {
        private Face face;
        private Collection<FaceEdge> edges;

        public FaceVertex(Face face) {
            this.face = face;
            this.edges = new LinkedHashSet<FaceEdge>();
        }

        public Face getFace() {
            return this.face;
        }

        public Collection<FaceEdge> getEdges() {
            return this.edges;
        }

        public void addEdge(FaceEdge edge) {
            if (!this.edges.contains(edge)) {
                this.edges.add(edge);
            }
        }

        public String toString() {
            return "FaceVertex: " + this.face.toString();
        }
    }

    public static class FaceEdge {
        private FaceVertex f;
        private FaceVertex g;
        private MGraph.Edge<?> edge;

        public FaceEdge(FaceVertex f, FaceVertex g, MGraph.Edge<?> e) {
            this.f = f;
            this.g = g;
            this.edge = e;
        }

        public FaceVertex getF() {
            return this.f;
        }

        public FaceVertex getG() {
            return this.g;
        }

        public MGraph.Edge<?> getEdge() {
            return this.edge;
        }

        public boolean contains(FaceVertex v) {
            return this.f == v || this.g == v;
        }

        public FaceVertex getOppositeVertex(FaceVertex v) {
            if (v == this.f) {
                return this.g;
            }
            if (v == this.g) {
                return this.f;
            }
            return null;
        }

        public FaceVertex getVertex(MGraph.Vertex<?> v) {
            if (this.f.face.containsVertex(v)) {
                return this.f;
            }
            if (this.g.face.containsVertex(v)) {
                return this.g;
            }
            return null;
        }

        public String toString() {
            Object s = "FaceEdge:\n";
            s = (String)s + "\t" + this.f + "\n";
            s = (String)s + "\t" + this.g + "\n";
            s = (String)s + "\t" + this.edge + "\n";
            return s;
        }
    }
}

