/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.search.SearchPattern;

public final class TextRegexpUtil {
    private static final String wordCharsExpr = "[\\p{javaLetterOrDigit}_]";
    private static final String checkNotAfterWordChar = "(?<![\\p{javaLetterOrDigit}_])";
    private static final String checkNotBeforeWordChar = "(?![\\p{javaLetterOrDigit}_])";
    private static String MULTILINE_REGEXP_PATTERN = ".*(\\\\n|\\\\r|\\\\f|\\\\u|\\\\0|\\\\x|\\\\s|\\(\\?[idmux]*s).*";
    private static final Logger LOG = Logger.getLogger(TextRegexpUtil.class.getName());

    private TextRegexpUtil() {
    }

    private static String makeLiteralRegexp(String literalPattern, boolean wholeWords) {
        StringBuilder sb = new StringBuilder();
        if (wholeWords) {
            sb.append(checkNotAfterWordChar);
        }
        sb.append(Pattern.quote(literalPattern));
        if (wholeWords) {
            sb.append(checkNotBeforeWordChar);
        }
        return sb.toString();
    }

    private static String makeRegexp(String simplePattern, boolean wholeWords) {
        if (simplePattern.length() == 0) {
            return simplePattern;
        }
        if (!wholeWords && Pattern.matches("[a-zA-Z0-9 ]*", simplePattern)) {
            return simplePattern;
        }
        StringBuilder buf = new StringBuilder(simplePattern.length() + 16);
        boolean quoted = false;
        boolean starPresent = false;
        int minCount = 0;
        boolean bufIsEmpty = true;
        char lastInputChar = '*';
        for (char c : simplePattern.toCharArray()) {
            if (quoted && (c == '?' || c == '*')) {
                assert (!starPresent && minCount == 0);
                if (wholeWords && bufIsEmpty) {
                    buf.append(checkNotAfterWordChar);
                }
                buf.append('\\');
                buf.append(c);
                lastInputChar = c;
                bufIsEmpty = false;
                quoted = false;
                continue;
            }
            if (c == '?') {
                assert (!quoted);
                ++minCount;
                continue;
            }
            if (c == '*') {
                assert (!quoted);
                starPresent = true;
                continue;
            }
            if (starPresent || minCount != 0) {
                if (wholeWords && bufIsEmpty && !starPresent) {
                    buf.append(checkNotAfterWordChar);
                }
                bufIsEmpty &= !TextRegexpUtil.addMetachars(buf, starPresent, minCount, wholeWords, !bufIsEmpty);
                starPresent = false;
                minCount = 0;
            }
            if (quoted) {
                buf.append("\\\\");
                quoted = false;
            }
            if (c == '\\') {
                quoted = true;
                continue;
            }
            if (wholeWords && bufIsEmpty && TextRegexpUtil.isWordChar(c)) {
                buf.append(checkNotAfterWordChar);
            }
            if (TextRegexpUtil.isSpecialCharacter(c)) {
                buf.append('\\');
            }
            buf.append(c);
            lastInputChar = c;
            bufIsEmpty = false;
        }
        if (quoted) {
            assert (!starPresent && minCount == 0);
            buf.append('\\').append('\\');
            lastInputChar = '\\';
        } else if (starPresent || minCount != 0) {
            if (wholeWords && !starPresent && bufIsEmpty) {
                buf.append(checkNotAfterWordChar);
            }
            bufIsEmpty &= !TextRegexpUtil.addMetachars(buf, starPresent, minCount, wholeWords, false);
            if (wholeWords && !starPresent) {
                buf.append(checkNotBeforeWordChar);
            }
            lastInputChar = '*';
        }
        if (wholeWords && TextRegexpUtil.isWordChar(lastInputChar)) {
            buf.append(checkNotBeforeWordChar);
        }
        return buf.toString();
    }

    private static Pattern compileSimpleTextPattern(SearchPattern sp) throws PatternSyntaxException {
        assert (sp != null);
        assert (sp.getSearchExpression() != null);
        assert (!sp.isRegExp());
        int flags = 0;
        if (!sp.isMatchCase()) {
            flags |= 2;
            flags |= 0x40;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, " - textPatternExpr = \"{0}{1}", new Object[]{sp.getSearchExpression(), Character.valueOf('\"')});
        }
        String searchRegexp = switch (sp.getMatchType()) {
            case SearchPattern.MatchType.BASIC -> TextRegexpUtil.makeRegexp(sp.getSearchExpression(), sp.isWholeWords());
            case SearchPattern.MatchType.LITERAL -> TextRegexpUtil.makeLiteralRegexp(sp.getSearchExpression(), sp.isWholeWords());
            default -> throw new IllegalStateException();
        };
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, " - regexp = \"{0}{1}", new Object[]{searchRegexp, Character.valueOf('\"')});
        }
        return Pattern.compile(searchRegexp, flags);
    }

    private static Pattern compileRegexpPattern(SearchPattern sp) throws PatternSyntaxException {
        assert (sp != null);
        assert (sp.getSearchExpression() != null);
        assert (sp.isRegExp());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, " - textPatternExpr = \"{0}{1}", new Object[]{sp.getSearchExpression(), Character.valueOf('\"')});
        }
        int flags = 0;
        if (!sp.isMatchCase()) {
            flags |= 2;
            flags |= 0x40;
        }
        return Pattern.compile(sp.getSearchExpression(), flags |= 8);
    }

    public static Pattern makeTextPattern(SearchPattern pattern) throws PatternSyntaxException, NullPointerException {
        if (pattern == null) {
            throw new NullPointerException("search pattern is null");
        }
        if (pattern.getSearchExpression() == null) {
            throw new NullPointerException("expression is null");
        }
        if (pattern.isRegExp()) {
            return TextRegexpUtil.compileRegexpPattern(pattern);
        }
        return TextRegexpUtil.compileSimpleTextPattern(pattern);
    }

    private static boolean isWordChar(char c) {
        if (c == '*' || c == '\\') {
            return false;
        }
        assert (wordCharsExpr.equals(wordCharsExpr)) : "update implementation of method isWordChar(char)";
        return c == '_' || Character.isLetterOrDigit(c);
    }

    private static boolean addMetachars(StringBuilder buf, boolean starPresent, int minCount, boolean wholeWords, boolean middle) {
        assert (starPresent || minCount != 0);
        if (starPresent && !wholeWords && !middle) {
            starPresent = false;
        }
        if (minCount == 0 && !starPresent) {
            return false;
        }
        if (wholeWords) {
            buf.append(wordCharsExpr);
        } else {
            buf.append('.');
        }
        switch (minCount) {
            case 0: {
                assert (starPresent);
                buf.append('*');
                break;
            }
            case 1: {
                if (!starPresent) break;
                buf.append('+');
                break;
            }
            default: {
                if (wholeWords) {
                    buf.append('{').append(minCount);
                    if (starPresent) {
                        buf.append(',');
                    }
                    buf.append('}');
                    break;
                }
                for (int i = 1; i < minCount; ++i) {
                    buf.append('.');
                }
                if (!starPresent) break;
                buf.append('+');
            }
        }
        if (starPresent && middle) {
            buf.append('?');
        }
        return true;
    }

    private static boolean isSpecialCharacter(char c) {
        return c > ' ' && c < '\u0080' && !TextRegexpUtil.isAlnum(c);
    }

    private static boolean isAlnum(char c) {
        return TextRegexpUtil.isAlpha(c) || TextRegexpUtil.isDigit(c);
    }

    private static boolean isAlpha(char c) {
        return (c = (char)(c | 0x20)) >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isMultilineOrMatchesMultiline(String expr) {
        if (expr == null) {
            return false;
        }
        return expr.contains("\n") || expr.contains("\r") || expr.matches(MULTILINE_REGEXP_PATTERN);
    }
}

