/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.progress.spi.ExtractedProgressUIWorker;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.modules.progress.spi.ProgressUIWorkerProvider;
import org.netbeans.modules.progress.spi.SwingController;
import org.netbeans.modules.progress.spi.UIInternalHandle;
import org.netbeans.progress.module.TrivialProgressUIWorkerProvider;
import org.netbeans.progress.module.UIInternalHandleAccessor;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public final class ProgressHandleFactory {
    private static ProgressUIWorkerProvider TRIVIAL_PROVIDER = new TrivialProgressUIWorkerProvider();

    private ProgressHandleFactory() {
    }

    @Deprecated
    public static ProgressHandle createHandle(String displayName) {
        return ProgressHandleFactory.createHandle(displayName, (Action)null);
    }

    @Deprecated
    public static ProgressHandle createHandle(String displayName, Cancellable allowToCancel) {
        return ProgressHandleFactory.createHandle(displayName, allowToCancel, null);
    }

    @Deprecated
    public static ProgressHandle createHandle(String displayName, Action linkOutput) {
        return ProgressHandleFactory.createHandle(displayName, null, linkOutput);
    }

    @Deprecated
    public static ProgressHandle createHandle(String displayName, Cancellable allowToCancel, Action linkOutput) {
        return ProgressHandle.createHandle((String)displayName, (Cancellable)allowToCancel, (Action)linkOutput);
    }

    public static ProgressHandle createUIHandle(String displayName, Cancellable allowToCancel, Action linkOutput) {
        return new UIInternalHandle(displayName, allowToCancel, true, linkOutput).createProgressHandle();
    }

    public static JComponent createProgressComponent(ProgressHandle handle) {
        return ProgressHandleFactory.ihextract(handle).getProgressComponent();
    }

    public static JLabel createMainLabelComponent(ProgressHandle handle) {
        return ProgressHandleFactory.ihextract(handle).getMainLabelComponent();
    }

    public static JLabel createDetailLabelComponent(ProgressHandle handle) {
        return ProgressHandleFactory.ihextract(handle).getDetailLabelComponent();
    }

    @Deprecated
    public static ProgressHandle createSystemHandle(String displayName) {
        return ProgressHandleFactory.createSystemHandle(displayName, null, null);
    }

    public static ProgressHandle createSystemHandle(String displayName, Cancellable allowToCancel) {
        return ProgressHandleFactory.createSystemHandle(displayName, allowToCancel, null);
    }

    public static ProgressHandle createSystemHandle(String displayName, Cancellable allowToCancel, Action linkOutput) {
        return ProgressHandle.createSystemHandle((String)displayName, (Cancellable)allowToCancel, (Action)linkOutput);
    }

    public static ProgressHandle createSystemUIHandle(String displayName, Cancellable allowToCancel, Action linkOutput) {
        return new UIInternalHandle(displayName, allowToCancel, false, linkOutput).createProgressHandle();
    }

    private static ExtractedProgressUIWorker ihextract(ProgressHandle h) {
        ExtractedProgressUIWorker worker;
        InternalHandle ih = h.getInternalHandle();
        if (ih instanceof UIInternalHandle) {
            return new UIHandleExtractor((UIInternalHandle)ih);
        }
        ProgressUIWorkerProvider prov = (ProgressUIWorkerProvider)Lookup.getDefault().lookup(ProgressUIWorkerProvider.class);
        if (prov == null) {
            prov = TRIVIAL_PROVIDER;
        }
        if ((worker = prov.extractProgressWorker(ih)) != null) {
            return new ForeignExtractor(ih, worker);
        }
        return null;
    }

    private static class UIHandleExtractor
    implements ExtractedProgressUIWorker {
        private final UIInternalHandle uiih;

        public UIHandleExtractor(UIInternalHandle uiih) {
            this.uiih = uiih;
        }

        @Override
        public JComponent getProgressComponent() {
            return this.uiih.extractComponent();
        }

        @Override
        public JLabel getMainLabelComponent() {
            return this.uiih.extractMainLabel();
        }

        @Override
        public JLabel getDetailLabelComponent() {
            return this.uiih.extractDetailLabel();
        }

        public void processProgressEvent(ProgressEvent event) {
            throw new UnsupportedOperationException("Never called.");
        }

        public void processSelectedProgressEvent(ProgressEvent event) {
            throw new UnsupportedOperationException("Never called.");
        }
    }

    private static class ForeignExtractor
    implements ExtractedProgressUIWorker {
        private final InternalHandle ih;
        private final ExtractedProgressUIWorker del;

        public ForeignExtractor(InternalHandle ih, ExtractedProgressUIWorker del) {
            this.del = del;
            this.ih = ih;
        }

        void customPlaced() {
            boolean wasCustomPlaced = this.ih.isCustomPlaced();
            UIInternalHandleAccessor acc = UIInternalHandleAccessor.instance();
            acc.markCustomPlaced(this.ih);
            if (!wasCustomPlaced) {
                acc.setController(this.ih, new SwingController(this.del));
            }
        }

        @Override
        public JComponent getProgressComponent() {
            this.customPlaced();
            return this.del.getProgressComponent();
        }

        @Override
        public JLabel getMainLabelComponent() {
            this.customPlaced();
            return this.del.getMainLabelComponent();
        }

        @Override
        public JLabel getDetailLabelComponent() {
            this.customPlaced();
            return this.del.getDetailLabelComponent();
        }

        public void processProgressEvent(ProgressEvent event) {
            this.del.processProgressEvent(event);
        }

        public void processSelectedProgressEvent(ProgressEvent event) {
            this.del.processSelectedProgressEvent(event);
        }
    }
}

