/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.classpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.GlobalPathRegistryImplementation;

public final class DefaultGlobalPathRegistryImplementation
extends GlobalPathRegistryImplementation {
    private final Map<String, List<ClassPath>> paths = new HashMap<String, List<ClassPath>>();

    @Override
    @NonNull
    protected Set<ClassPath> getPaths(@NonNull String id) {
        List<ClassPath> l = this.paths.get(id);
        if (l != null && !l.isEmpty()) {
            return Collections.unmodifiableSet(new HashSet<ClassPath>(l));
        }
        return Collections.emptySet();
    }

    @Override
    @NonNull
    protected Set<ClassPath> register(@NonNull String id, @NonNull ClassPath[] paths) {
        HashSet<ClassPath> added = new HashSet<ClassPath>();
        List<ClassPath> l = this.paths.get(id);
        if (l == null) {
            l = new ArrayList<ClassPath>();
            this.paths.put(id, l);
        }
        for (ClassPath path : paths) {
            if (path == null) {
                throw new NullPointerException("Null path encountered in " + Arrays.asList(paths) + " of type " + id);
            }
            if (!added.contains(path) && !l.contains(path)) {
                added.add(path);
            }
            l.add(path);
        }
        return added;
    }

    @Override
    @NonNull
    protected Set<ClassPath> unregister(@NonNull String id, @NonNull ClassPath[] paths) throws IllegalArgumentException {
        HashSet<ClassPath> removed = new HashSet<ClassPath>();
        List<ClassPath> l = this.paths.get(id);
        if (l == null) {
            l = new ArrayList<ClassPath>();
        }
        ArrayList<ClassPath> l2 = new ArrayList<ClassPath>(l);
        for (ClassPath path : paths) {
            if (path == null) {
                throw new NullPointerException();
            }
            if (!l2.remove(path)) {
                throw new IllegalArgumentException("Attempt to remove nonexistent path [" + path + "] from list of registered paths [" + l2 + "] for id " + id + ". All paths: " + this.paths);
            }
            if (removed.contains(path) || l2.contains(path)) continue;
            removed.add(path);
        }
        this.paths.put(id, l2);
        return removed;
    }

    @Override
    @NonNull
    protected Set<ClassPath> clear() {
        HashSet<ClassPath> removed = new HashSet<ClassPath>();
        Iterator<Map.Entry<String, List<ClassPath>>> it = this.paths.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<ClassPath>> e = it.next();
            removed.addAll((Collection<ClassPath>)e.getValue());
            it.remove();
        }
        assert (this.paths.isEmpty());
        return removed;
    }
}

