/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class SessionProvider {
    public abstract String getSessionName();

    public abstract String getLocationName();

    public abstract String getTypeID();

    public abstract Object[] getServices();

    static class ContextAware
    extends SessionProvider
    implements ContextAwareService<SessionProvider> {
        private String serviceName;
        private ContextProvider context;
        private SessionProvider delegate;

        private ContextAware(String serviceName) {
            this.serviceName = serviceName;
        }

        private ContextAware(String serviceName, ContextProvider context) {
            this.serviceName = serviceName;
            this.context = context;
        }

        private synchronized SessionProvider getDelegate() {
            if (this.delegate == null) {
                this.delegate = (SessionProvider)ContextAwareSupport.createInstance(this.serviceName, this.context);
            }
            return this.delegate;
        }

        @Override
        public SessionProvider forContext(ContextProvider context) {
            if (context == this.context) {
                return this;
            }
            return new ContextAware(this.serviceName, context);
        }

        @Override
        public String getSessionName() {
            return this.getDelegate().getSessionName();
        }

        @Override
        public String getLocationName() {
            return this.getDelegate().getLocationName();
        }

        @Override
        public String getTypeID() {
            return this.getDelegate().getTypeID();
        }

        @Override
        public Object[] getServices() {
            return this.getDelegate().getServices();
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            return new ContextAware(serviceName);
        }

        public synchronized String toString() {
            return "SessionProvider.ContextAware for service " + this.serviceName + ", context = " + this.context + ", delegate = " + this.delegate;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

