/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.apiregistry;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.BreakpointsClassFilter;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public static final String SERVICE_NAME = "serviceName";

    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(JPDADebugger.Registration.class.getCanonicalName(), SmartSteppingCallback.Registration.class.getCanonicalName(), SourcePathProvider.Registration.class.getCanonicalName(), EditorContext.Registration.class.getCanonicalName(), Evaluator.Registration.class.getCanonicalName(), BreakpointsClassFilter.Registration.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment env) throws LayerGenerationException {
        String path;
        Annotation reg;
        if (env.processingOver()) {
            return false;
        }
        int cnt = 0;
        for (Element element : env.getElementsAnnotatedWith(JPDADebugger.Registration.class)) {
            reg = element.getAnnotation(JPDADebugger.Registration.class);
            path = reg.path();
            this.handleProviderRegistration(element, JPDADebugger.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(SmartSteppingCallback.Registration.class)) {
            reg = element.getAnnotation(SmartSteppingCallback.Registration.class);
            path = reg.path();
            this.handleProviderRegistration(element, SmartSteppingCallback.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(SourcePathProvider.Registration.class)) {
            reg = element.getAnnotation(SourcePathProvider.Registration.class);
            path = reg.path();
            this.handleProviderRegistration(element, SourcePathProvider.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(EditorContext.Registration.class)) {
            reg = element.getAnnotation(EditorContext.Registration.class);
            path = reg.path();
            this.handleProviderRegistration(element, EditorContext.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(Evaluator.Registration.class)) {
            reg = element.getAnnotation(Evaluator.Registration.class);
            String language = reg.language();
            this.handleEvaluatorRegistration(element, language);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(BreakpointsClassFilter.Registration.class)) {
            reg = element.getAnnotation(BreakpointsClassFilter.Registration.class);
            path = reg.path();
            this.handleProviderRegistration(element, BreakpointsClassFilter.class, path);
            ++cnt;
        }
        return cnt == annotations.size();
    }

    private void handleProviderRegistration(Element e, Class providerClass, String path) throws IllegalArgumentException, LayerGenerationException {
        String className = this.instantiableClassOrMethod(e);
        if (!this.isClassOf(e, providerClass)) {
            throw new IllegalArgumentException("Annotated element " + e + " is not an instance of " + providerClass);
        }
        path = path != null && path.length() > 0 ? "Debugger/" + path : "Debugger";
        LayerBuilder lb = this.layer(new Element[]{e});
        String basename = className.replace('.', '-');
        LayerBuilder.File f = lb.file(path + "/" + basename + ".instance");
        f.stringvalue(SERVICE_NAME, className).stringvalue("serviceClass", providerClass.getName()).stringvalue("instanceOf", providerClass.getName()).methodvalue("instanceCreate", providerClass.getName() + "$ContextAware", "createService").write();
    }

    private void handleEvaluatorRegistration(Element e, String language) throws IllegalArgumentException, LayerGenerationException {
        String className = this.instantiableClassOrMethod(e);
        if (!this.implementsInterface(e, Evaluator.class.getName())) {
            throw new IllegalArgumentException("Annotated element " + e + " is not an instance of " + Evaluator.class);
        }
        String path = "Debugger/netbeans-JPDASession/" + language;
        LayerBuilder lb = this.layer(new Element[]{e});
        String basename = className.replace('.', '-');
        LayerBuilder.File f = lb.file(path + "/" + basename + ".instance");
        f.stringvalue(SERVICE_NAME, className).stringvalue("serviceClass", Evaluator.class.getName()).stringvalue("instanceOf", Evaluator.class.getName()).methodvalue("instanceCreate", "org.netbeans.spi.debugger.ContextAwareSupport", "createService").write();
    }

    private boolean isClassOf(Element e, Class providerClass) {
        switch (e.getKind()) {
            case CLASS: {
                TypeElement te = (TypeElement)e;
                TypeMirror superType = te.getSuperclass();
                if (superType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)superType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)retType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }

    private boolean implementsInterface(Element e, String interfaceName) {
        switch (e.getKind()) {
            case CLASS: {
                TypeElement te = (TypeElement)e;
                List<? extends TypeMirror> interfs = te.getInterfaces();
                for (TypeMirror typeMirror : interfs) {
                    e = ((DeclaredType)typeMirror).asElement();
                    String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                    if (!interfaceName.equals(string)) continue;
                    return true;
                }
                break;
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                TypeElement te = (TypeElement)((DeclaredType)retType).asElement();
                List<? extends TypeMirror> interfs = te.getInterfaces();
                for (TypeMirror typeMirror : interfs) {
                    e = ((DeclaredType)typeMirror).asElement();
                    String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                    if (!interfaceName.equals(clazz)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
            }
        }
        return false;
    }

    private String instantiableClassOrMethod(Element e) throws IllegalArgumentException, LayerGenerationException {
        switch (e.getKind()) {
            case CLASS: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(clazz + " must not be abstract", e);
                }
                boolean hasDefaultCtor = false;
                boolean hasContextCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(e.getEnclosedElements())) {
                    List<? extends VariableElement> params = constructor.getParameters();
                    if (params.isEmpty()) {
                        hasDefaultCtor = true;
                        break;
                    }
                    if (params.size() != 1) continue;
                    String type = params.get(0).asType().toString();
                    if (!ContextProvider.class.getName().equals(type)) continue;
                    hasContextCtor = true;
                    break;
                }
                if (!hasDefaultCtor && !hasContextCtor) {
                    throw new LayerGenerationException(clazz + " must have a no-argument constructor or constuctor taking " + ContextProvider.class.getName() + " as a parameter.", e);
                }
                return clazz;
            }
            case METHOD: {
                ExecutableElement ee = (ExecutableElement)e;
                String methodName = ee.getSimpleName().toString();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)ee.getEnclosingElement()).toString();
                if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(ee + " must be static", e);
                }
                if (ee.getParameters().size() > 0) {
                    throw new LayerGenerationException(ee + " must not have any parameters", e);
                }
                return clazz + "." + methodName + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }
}

