/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.text.EditorKit;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.run.RunTargetsAction;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Parameters;

final class AdvancedActionPanel
extends JPanel {
    private static final String ATTR_TARGETS = "org.apache.tools.ant.module.preferredTargets";
    private static final String ATTR_PROPERTIES = "org.apache.tools.ant.module.preferredProperties";
    private static final String ATTR_VERBOSITY = "org.apache.tools.ant.module.preferredVerbosity";
    private static final String PASSWORD_REPLACEMENT = "*****";
    private static final String[] VERBOSITIES = new String[]{NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_warn"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_info"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_verbose"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_debug")};
    private static final int[] VERBOSITY_LEVELS = new int[]{1, 2, 3, 4};
    private final AntProjectCookie project;
    private final Set<TargetLister.Target> allTargets;
    private String defaultTarget = null;
    private Set<? extends String> antConcealedProperties = Collections.emptySet();
    private Properties antProperties = new Properties();
    private JLabel propertiesLabel;
    private JEditorPane propertiesPane;
    private JScrollPane propertiesScrollPane;
    private JComboBox targetComboBox;
    private JTextField targetDescriptionField;
    private JLabel targetDescriptionLabel;
    private JLabel targetLabel;
    private JComboBox verbosityComboBox;
    private JLabel verbosityLabel;

    public AdvancedActionPanel(AntProjectCookie project, Set<TargetLister.Target> allTargets) {
        this.project = project;
        this.allTargets = allTargets;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.acsd.title"));
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.targetLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.targetDescriptionLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.targetDescriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.propertiesLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.propertiesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.verbosityLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.verbosityLabel.text"));
        EditorKit kit = this.propertiesPane.getEditorKit();
        String clazz = kit.getClass().getName();
        if (clazz.equals("javax.swing.text.DefaultEditorKit") || clazz.equals("javax.swing.JEditorPane$PlainEditorKit")) {
            this.propertiesPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        }
        this.targetComboBox.getInputMap().remove(KeyStroke.getKeyStroke("ENTER"));
        this.initializeFields();
    }

    private void initializeFields() {
        FileObject script = this.project.getFileObject();
        assert (script != null) : "No file found for " + this.project;
        String initialTargets = (String)script.getAttribute(ATTR_TARGETS);
        TreeSet<Object> relevantTargets = new TreeSet<Object>(Collator.getInstance());
        for (TargetLister.Target target : this.allTargets) {
            if (target.isOverridden() || target.isInternal()) continue;
            relevantTargets.add(target.getName());
            if (this.defaultTarget != null || !target.isDefault()) continue;
            this.defaultTarget = target.getName();
        }
        this.targetComboBox.setModel(new DefaultComboBoxModel<Object>(relevantTargets.toArray()));
        if (initialTargets != null) {
            this.targetComboBox.setSelectedItem(initialTargets);
        } else {
            this.targetComboBox.setSelectedItem(this.defaultTarget);
        }
        this.targetComboBoxActionPerformed(null);
        String initialProperties = (String)script.getAttribute(ATTR_PROPERTIES);
        if (initialProperties != null) {
            try {
                this.antProperties = AdvancedActionPanel.parseProperties(initialProperties);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        } else {
            this.antProperties = new Properties();
            this.antProperties.putAll(AntSettings.getProperties());
        }
        this.propertiesPane.setText(this.propertiesToString(this.antProperties, this.antConcealedProperties));
        Integer verbosity = (Integer)script.getAttribute(ATTR_VERBOSITY);
        if (verbosity == null) {
            verbosity = AntSettings.getVerbosity();
        }
        this.verbosityComboBox.setModel(new DefaultComboBoxModel<String>(VERBOSITIES));
        this.setVerbosity(verbosity);
    }

    private String propertiesToString(@NonNull Properties props, @NonNull Set<? extends String> concealedProperties) {
        Properties newProps = new Properties();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            if (concealedProperties.contains(key)) {
                value = PASSWORD_REPLACEMENT;
            }
            newProps.put(key, value);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            newProps.store(baos, null);
            String text = baos.toString("ISO-8859-1");
            return text.replaceFirst("^#.*\n", "");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setTargets(List<String> targetNames) {
        StringBuilder targets = new StringBuilder();
        if (targetNames != null) {
            for (String target : targetNames) {
                if (targets.length() > 0) {
                    targets.append(' ');
                }
                targets.append(target);
            }
        }
        this.targetComboBox.setSelectedItem(targets.toString());
    }

    public void setVerbosity(int verbosity) {
        for (int i = 0; i < VERBOSITY_LEVELS.length; ++i) {
            if (VERBOSITY_LEVELS[i] != verbosity) continue;
            this.verbosityComboBox.setSelectedItem(VERBOSITIES[i]);
            break;
        }
    }

    public void setConcealedProperties(@NonNull Set<? extends String> concealedProperties) {
        Parameters.notNull((CharSequence)"concealedProperties", concealedProperties);
        this.antConcealedProperties = new HashSet<String>(concealedProperties);
        this.propertiesPane.setText(this.propertiesToString(this.antProperties, this.antConcealedProperties));
    }

    public void setProperties(Map<String, String> properties) {
        this.antProperties = new Properties();
        this.antProperties.putAll(properties);
        this.propertiesPane.setText(this.propertiesToString(this.antProperties, this.antConcealedProperties));
    }

    private void initComponents() {
        this.targetLabel = new JLabel();
        this.targetComboBox = new JComboBox();
        this.targetDescriptionLabel = new JLabel();
        this.targetDescriptionField = new JTextField();
        this.propertiesLabel = new JLabel();
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesPane = new JEditorPane();
        this.verbosityLabel = new JLabel();
        this.verbosityComboBox = new JComboBox();
        this.targetLabel.setLabelFor(this.targetComboBox);
        this.targetLabel.setText("Select target(s) to run:");
        this.targetComboBox.setEditable(true);
        this.targetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"sampleTarget1", "sampleTarget2", "sampleTarget3"}));
        this.targetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedActionPanel.this.targetComboBoxActionPerformed(evt);
            }
        });
        this.targetDescriptionLabel.setLabelFor(this.targetDescriptionField);
        this.targetDescriptionLabel.setText("Target description:");
        this.targetDescriptionField.setEditable(false);
        this.targetDescriptionField.setText("Sample description here.");
        this.propertiesLabel.setLabelFor(this.propertiesPane);
        this.propertiesLabel.setText("Special Ant properties:");
        this.propertiesScrollPane.setMinimumSize(new Dimension(400, 150));
        this.propertiesScrollPane.setPreferredSize(new Dimension(400, 150));
        this.propertiesPane.setContentType("text/x-properties");
        this.propertiesScrollPane.setViewportView(this.propertiesPane);
        this.verbosityLabel.setLabelFor(this.verbosityComboBox);
        this.verbosityLabel.setText("Verbosity level:");
        this.verbosityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Errors only [SAMPLE]", "Normal [SAMPLE]", "Verbose [SAMPLE]"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.verbosityLabel, -1, -1, Short.MAX_VALUE).addComponent(this.propertiesLabel, -1, -1, Short.MAX_VALUE).addComponent(this.targetDescriptionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.targetLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetDescriptionField, -1, 624, Short.MAX_VALUE).addComponent(this.targetComboBox, 0, 624, Short.MAX_VALUE).addComponent(this.propertiesScrollPane, -1, 624, Short.MAX_VALUE).addComponent(this.verbosityComboBox, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetLabel).addComponent(this.targetComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetDescriptionLabel).addComponent(this.targetDescriptionField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.propertiesLabel).addComponent(this.propertiesScrollPane, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verbosityComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.verbosityLabel))).addContainerGap()));
        this.targetComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedActionPanel.class, (String)"ACS_SelectTarget"));
        this.targetComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedActionPanel.class, (String)"ACSD_SelectTarget"));
        this.targetDescriptionField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedActionPanel.class, (String)"ACSD_TargetDescription"));
    }

    private void targetComboBoxActionPerformed(ActionEvent evt) {
        String selection = (String)this.targetComboBox.getSelectedItem();
        if (selection == null) {
            selection = "";
        }
        StringTokenizer tok = new StringTokenizer(selection, " ,");
        ArrayList targetsL = Collections.list(NbCollections.checkedEnumerationByFilter((Enumeration)tok, String.class, (boolean)true));
        String description = "";
        if (targetsL.size() == 1) {
            String targetName = (String)targetsL.get(0);
            for (TargetLister.Target target : this.allTargets) {
                if (target.isOverridden() || !target.getName().equals(targetName)) continue;
                description = target.getElement().getAttribute("description");
                break;
            }
        }
        this.targetDescriptionField.setText(description);
    }

    private void run() throws IOException {
        StringTokenizer tok;
        Object targetsL;
        String selection = (String)this.targetComboBox.getSelectedItem();
        String[] targets = null;
        if (selection != null && !(targetsL = Collections.list(NbCollections.checkedEnumerationByFilter((Enumeration)(tok = new StringTokenizer(selection, " ,")), String.class, (boolean)true))).isEmpty()) {
            targets = targetsL.toArray(new String[targetsL.size()]);
        }
        Properties props = AdvancedActionPanel.parseProperties(this.propertiesPane.getText());
        for (Map.Entry entry : props.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!this.antConcealedProperties.contains(key) || !PASSWORD_REPLACEMENT.equals(value)) continue;
            entry.setValue(this.antProperties.get(key));
        }
        int verbosity = 2;
        String string = (String)this.verbosityComboBox.getSelectedItem();
        for (int i = 0; i < VERBOSITIES.length; ++i) {
            if (!VERBOSITIES[i].equals(string)) continue;
            verbosity = VERBOSITY_LEVELS[i];
            break;
        }
        FileObject script = this.project.getFileObject();
        assert (script != null);
        if (targets == null || targets.length == 1 && targets[0].equals(this.defaultTarget)) {
            script.setAttribute(ATTR_TARGETS, null);
        } else {
            StringBuffer targetsSpaceSep = new StringBuffer();
            for (int i = 0; i < targets.length; ++i) {
                if (i > 0) {
                    targetsSpaceSep.append(' ');
                }
                targetsSpaceSep.append(targets[i]);
            }
            script.setAttribute(ATTR_TARGETS, (Object)targetsSpaceSep.toString());
        }
        if (props.equals(AntSettings.getProperties())) {
            script.setAttribute(ATTR_PROPERTIES, null);
        } else {
            script.setAttribute(ATTR_PROPERTIES, (Object)this.propertiesPane.getText());
        }
        if (verbosity == AntSettings.getVerbosity()) {
            script.setAttribute(ATTR_VERBOSITY, null);
        } else {
            script.setAttribute(ATTR_VERBOSITY, (Object)verbosity);
        }
        TargetExecutor exec = new TargetExecutor(this.project, targets);
        exec.setProperties(NbCollections.checkedMapByCopy((Map)props, String.class, String.class, (boolean)true));
        exec.setConcealedProperties(this.antConcealedProperties);
        exec.setVerbosity(verbosity);
        exec.execute();
    }

    public boolean display() {
        String title = NbBundle.getMessage(RunTargetsAction.class, (String)"TITLE_run_advanced");
        DialogDescriptor dd = new DialogDescriptor((Object)this, title);
        dd.setOptionType(2);
        JButton run = new JButton(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_advanced_run"));
        run.setDefaultCapable(true);
        JButton cancel = new JButton(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_advanced_cancel"));
        dd.setOptions(new Object[]{run, cancel});
        dd.setModal(true);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(run)) {
            try {
                this.run();
                return true;
            }
            catch (IOException x) {
                AntModule.err.notify((Throwable)x);
            }
        }
        return false;
    }

    @NonNull
    private static Properties parseProperties(@NonNull String text) throws IOException {
        Properties props = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(text.getBytes("ISO-8859-1"));
        props.load(bais);
        return props;
    }
}

