/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.junit.extension;

import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.harness.Neo4j;
import org.neo4j.harness.Neo4jBuilder;
import org.neo4j.harness.Neo4jBuilders;
import org.neo4j.harness.internal.InProcessNeo4j;
import org.neo4j.harness.junit.extension.Neo4jExtensionBuilder;

@PublicApi
public class Neo4jExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final String NEO4J_NAMESPACE = "neo4j-extension";
    private static final String PER_METHOD_KEY = "perMethod";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"neo4j-extension"});
    private final Neo4jBuilder builder;

    public static Neo4jExtensionBuilder builder() {
        return new Neo4jExtensionBuilder();
    }

    public Neo4jExtension() {
        this(Neo4jBuilders.newInProcessBuilder());
    }

    protected Neo4jExtension(Neo4jBuilder builder) {
        this.builder = builder;
    }

    public void beforeAll(ExtensionContext context) {
        this.instantiateService(context);
    }

    public void afterAll(ExtensionContext context) {
        Neo4jExtension.destroyService(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = Neo4jExtension.getStore(context);
        if (store.get(Neo4j.class) == null) {
            store.put((Object)PER_METHOD_KEY, (Object)true);
            this.instantiateService(context);
        }
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(NAMESPACE);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        if (((Boolean)Neo4jExtension.getStore(extensionContext).getOrDefault((Object)PER_METHOD_KEY, Boolean.class, (Object)false)).booleanValue()) {
            Neo4jExtension.destroyService(extensionContext);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        return paramType.equals(GraphDatabaseService.class) || paramType.equals(Neo4j.class) || paramType.equals(DatabaseManagementService.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        return Neo4jExtension.getStore(extensionContext).get(paramType, paramType);
    }

    private void instantiateService(ExtensionContext context) {
        Neo4j neo = this.builder.build();
        DatabaseManagementService managementService = neo.databaseManagementService();
        GraphDatabaseService service = neo.defaultDatabaseService();
        ExtensionContext.Store store = Neo4jExtension.getStore(context);
        store.put(Neo4j.class, (Object)neo);
        store.put(DatabaseManagementService.class, (Object)managementService);
        store.put(GraphDatabaseService.class, (Object)service);
    }

    private static void destroyService(ExtensionContext context) {
        ExtensionContext.Store store = Neo4jExtension.getStore(context);
        store.remove(GraphDatabaseService.class);
        store.remove(DatabaseManagementService.class);
        InProcessNeo4j controls = (InProcessNeo4j)store.remove(Neo4j.class, InProcessNeo4j.class);
        controls.close();
    }
}

