/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.harness.Neo4jBuilder;
import org.neo4j.harness.internal.Extensions;
import org.neo4j.harness.internal.Fixtures;
import org.neo4j.harness.internal.HarnessRegisteredProcs;
import org.neo4j.harness.internal.InProcessNeo4j;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public abstract class AbstractInProcessNeo4jBuilder
implements Neo4jBuilder {
    private Path serverFolder;
    private final Extensions unmanagedExtentions = new Extensions();
    private final HarnessRegisteredProcs procedures = new HarnessRegisteredProcs();
    private final Fixtures fixtures = new Fixtures();
    private final List<ExtensionFactory<?>> extensionFactories = new ArrayList();
    private boolean disabledServer;
    private final Config.Builder config = Config.newBuilder();

    public AbstractInProcessNeo4jBuilder() {
    }

    public AbstractInProcessNeo4jBuilder(Path workingDir, String dataSubDir) {
        Path dataDir = workingDir.resolve(dataSubDir).toAbsolutePath();
        this.withWorkingDir(dataDir);
    }

    @Override
    public Neo4jBuilder withWorkingDir(Path workingDirectory) {
        Path dataDir = workingDirectory.resolve(AbstractInProcessNeo4jBuilder.randomFolderName()).toAbsolutePath();
        this.setWorkingDirectory(dataDir);
        return this;
    }

    @Override
    public Neo4jBuilder copyFrom(Path originalStoreDir) {
        try {
            FileUtils.copyDirectory((Path)originalStoreDir, (Path)this.serverFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public InProcessNeo4j build() {
        Config dbConfig;
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        Path userLogFile = this.serverFolder.resolve("neo4j.log");
        Path internalLogFile = this.serverFolder.resolve("debug.log");
        this.config.set(ServerSettings.third_party_packages, this.unmanagedExtentions.toList());
        Path certificates = this.serverFolder.resolve("certificates");
        if (this.disabledServer) {
            this.config.set(HttpConnector.enabled, (Object)false);
            this.config.set(HttpsConnector.enabled, (Object)false);
        }
        if (((Boolean)(dbConfig = this.config.build()).get(HttpsConnector.enabled)).booleanValue() || ((Boolean)dbConfig.get(BoltConnector.enabled)).booleanValue() && dbConfig.get(BoltConnector.encryption_level) != BoltConnector.EncryptionLevel.DISABLED) {
            SelfSignedCertificateFactory.create((FileSystemAbstraction)fs, (Path)certificates);
            List<SslPolicyConfig> policies = List.of(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS), SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT));
            for (SslPolicyConfig policy : policies) {
                this.config.set(policy.enabled, (Object)Boolean.TRUE);
                this.config.set(policy.base_directory, (Object)certificates);
                this.config.set(policy.trust_all, (Object)true);
                this.config.set(policy.client_auth, (Object)ClientAuth.NONE);
            }
            dbConfig = this.config.build();
        }
        Neo4jLoggerContext loggerContext = LogConfig.createTemporaryLoggerToSingleFile((FileSystemAbstraction)fs, (Path)userLogFile, (Level)Level.INFO, (boolean)true);
        Log4jLogProvider userLogProvider = new Log4jLogProvider(loggerContext);
        GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies().userLogProvider((InternalLogProvider)userLogProvider);
        dependencies = dependencies.extensions(this.buildExtensionList(dependencies));
        DatabaseManagementService managementService = this.createNeo(dbConfig, (ExternalDependencies)dependencies);
        InProcessNeo4j controls = new InProcessNeo4j(this.serverFolder, userLogFile, internalLogFile, managementService, dbConfig, (Closeable)userLogProvider);
        controls.start();
        try {
            this.fixtures.applyTo(controls);
        }
        catch (Exception e) {
            controls.close();
            throw e;
        }
        return controls;
    }

    protected abstract DatabaseManagementService createNeo(Config var1, ExternalDependencies var2);

    @Override
    public <T> Neo4jBuilder withConfig(Setting<T> setting, T value) {
        this.config.set(setting, value);
        return this;
    }

    @Override
    public Neo4jBuilder withUnmanagedExtension(String mountPath, Class<?> extension) {
        return this.withUnmanagedExtension(mountPath, extension.getPackage().getName());
    }

    @Override
    public Neo4jBuilder withUnmanagedExtension(String mountPath, String packageName) {
        this.unmanagedExtentions.add(mountPath, packageName);
        return this;
    }

    public Neo4jBuilder withExtensionFactories(Iterable<ExtensionFactory<?>> extensionFactories) {
        Iterables.addAll(this.extensionFactories, extensionFactories);
        return this;
    }

    @Override
    public Neo4jBuilder withDisabledServer() {
        this.disabledServer = true;
        return this;
    }

    @Override
    public Neo4jBuilder withFixture(Path cypherFileOrDirectory) {
        this.fixtures.add(cypherFileOrDirectory);
        return this;
    }

    @Override
    public Neo4jBuilder withFixture(String fixtureStatement) {
        this.fixtures.add(fixtureStatement);
        return this;
    }

    @Override
    public Neo4jBuilder withFixture(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.fixtures.add(fixtureFunction);
        return this;
    }

    @Override
    public Neo4jBuilder withProcedure(Class<?> procedureClass) {
        this.procedures.addProcedure(procedureClass);
        return this;
    }

    @Override
    public Neo4jBuilder withFunction(Class<?> functionClass) {
        this.procedures.addFunction(functionClass);
        return this;
    }

    @Override
    public Neo4jBuilder withAggregationFunction(Class<?> functionClass) {
        this.procedures.addAggregationFunction(functionClass);
        return this;
    }

    private Iterable<ExtensionFactory<?>> buildExtensionList(GraphDatabaseDependencies dependencies) {
        Iterable extensions = Iterables.append((Object)((Object)new Neo4jHarnessExtensions(this.procedures)), (Iterable)dependencies.extensions());
        return Iterables.addAll(this.extensionFactories, (Iterable)extensions);
    }

    private void setWorkingDirectory(Path workingDir) {
        this.setDirectory(workingDir);
        this.withConfig(GraphDatabaseSettings.auth_enabled, (Object)false);
        this.withConfig(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L));
        this.withConfig(HttpConnector.enabled, (Object)true);
        this.withConfig(HttpConnector.listen_address, new SocketAddress("localhost", 0));
        this.withConfig(HttpsConnector.enabled, (Object)false);
        this.withConfig(HttpsConnector.listen_address, new SocketAddress("localhost", 0));
        this.withConfig(BoltConnector.enabled, (Object)true);
        this.withConfig(BoltConnector.listen_address, new SocketAddress("localhost", 0));
    }

    private void setDirectory(Path dir) {
        this.serverFolder = dir;
        this.config.set(GraphDatabaseSettings.neo4j_home, (Object)this.serverFolder.toAbsolutePath());
    }

    private static String randomFolderName() {
        return DigestUtils.md5Hex((String)Long.toString(ThreadLocalRandom.current().nextLong()));
    }

    private static class Neo4jHarnessExtensions
    extends ExtensionFactory<Dependencies> {
        private final HarnessRegisteredProcs userProcs;

        Neo4jHarnessExtensions(HarnessRegisteredProcs userProcs) {
            super("harness");
            this.userProcs = userProcs;
        }

        public Lifecycle newInstance(ExtensionContext context, final Dependencies dependencies) {
            return new LifecycleAdapter(){

                public void start() throws Exception {
                    userProcs.applyTo(dependencies.procedures());
                }
            };
        }

        static interface Dependencies {
            public GlobalProcedures procedures();
        }
    }
}

