/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.internal.InProcessNeo4j;

public class Fixtures {
    private final List<String> fixtureStatements = new ArrayList<String>();
    private final List<Function<GraphDatabaseService, Void>> fixtureFunctions = new ArrayList<Function<GraphDatabaseService, Void>>();
    private static final String cypherSuffix = "cyp";
    private final DirectoryStream.Filter<Path> cypherFileOrDirectoryFilter = file -> {
        if (Files.isDirectory(file, new LinkOption[0])) {
            return true;
        }
        String[] split = file.getFileName().toString().split("\\.");
        String suffix = split[split.length - 1];
        return suffix.equals(cypherSuffix);
    };

    public void add(Path fixturePath) {
        try {
            if (Files.isDirectory(fixturePath, new LinkOption[0])) {
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(fixturePath, this.cypherFileOrDirectoryFilter);){
                    paths.forEach(this::add);
                }
                return;
            }
            this.add(Files.readString(fixturePath));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read fixture file '" + fixturePath.toAbsolutePath() + "': " + e.getMessage(), e);
        }
    }

    public void add(String statement) {
        if (!statement.isBlank()) {
            this.fixtureStatements.add(statement);
        }
    }

    public void add(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.fixtureFunctions.add(fixtureFunction);
    }

    void applyTo(InProcessNeo4j controls) {
        GraphDatabaseService db = controls.defaultDatabaseService();
        for (String string : this.fixtureStatements) {
            Transaction tx = db.beginTx();
            try {
                tx.execute(string);
                tx.commit();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        for (Function function : this.fixtureFunctions) {
            function.apply(db);
        }
    }
}

