/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.harness.Neo4j;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

@PublicApi
public class InProcessNeo4j
implements Neo4j {
    private final File serverFolder;
    private final File userLogFile;
    private final File internalLogFile;
    private final DatabaseManagementService managementService;
    private final Config config;
    private final Closeable additionalClosable;
    private ConnectorPortRegister connectorPortRegister;

    public InProcessNeo4j(File serverFolder, File userLogFile, File internalLogFile, DatabaseManagementService managementService, Config config, Closeable additionalClosable) {
        this.serverFolder = serverFolder;
        this.userLogFile = userLogFile;
        this.internalLogFile = internalLogFile;
        this.managementService = managementService;
        this.config = config;
        this.additionalClosable = additionalClosable;
    }

    @Override
    public URI boltURI() {
        if (((Boolean)this.config.get(BoltConnector.enabled)).booleanValue()) {
            return this.connectorUri("bolt", "bolt");
        }
        throw new IllegalStateException("Bolt connector is not configured");
    }

    @Override
    public URI httpURI() {
        if (((Boolean)this.config.get(HttpConnector.enabled)).booleanValue()) {
            return this.connectorUri("http", "http");
        }
        throw new IllegalStateException("HTTP connector is not configured");
    }

    @Override
    public URI httpsURI() {
        if (((Boolean)this.config.get(HttpsConnector.enabled)).booleanValue()) {
            return this.connectorUri("https", "https");
        }
        throw new IllegalStateException("HTTPS connector is not configured");
    }

    public void start() {
        this.connectorPortRegister = this.connectorPortRegister();
    }

    @Override
    public void close() {
        this.managementService.shutdown();
        this.connectorPortRegister = null;
        try {
            this.additionalClosable.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.looksLikeMd5Hash(this.serverFolder.getName())) {
                FileUtils.deleteRecursively((File)this.serverFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean up test server directory.", e);
        }
    }

    @Override
    public void printLogs(PrintStream out) {
        InProcessNeo4j.printLog("User Log File", this.userLogFile, out);
        InProcessNeo4j.printLog("Internal Log File", this.internalLogFile, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLog(String description, File file, PrintStream out) {
        if (file != null && file.exists()) {
            out.println(String.format("---------- BEGIN %s ----------", description));
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                reader.lines().forEach(out::println);
            }
            catch (IOException ex) {
                try {
                    out.println("Unable to collect log files: " + ex.getMessage());
                    ex.printStackTrace(out);
                }
                catch (Throwable throwable) {
                    out.println(String.format("---------- END %s ----------", description));
                    throw throwable;
                }
                out.println(String.format("---------- END %s ----------", description));
            }
            out.println(String.format("---------- END %s ----------", description));
        }
    }

    private boolean looksLikeMd5Hash(String name) {
        return name.length() == 32;
    }

    @Override
    public DatabaseManagementService databaseManagementService() {
        return this.managementService;
    }

    @Override
    public GraphDatabaseService defaultDatabaseService() {
        return this.managementService.database((String)this.config.get(GraphDatabaseSettings.default_database));
    }

    @Override
    public Configuration config() {
        return this.config;
    }

    private URI connectorUri(String scheme, String connectorName) {
        HostnamePort hostPort = this.connectorPortRegister.getLocalAddress(connectorName);
        return URI.create(scheme + "://" + hostPort + "/");
    }

    private ConnectorPortRegister connectorPortRegister() {
        return (ConnectorPortRegister)((GraphDatabaseAPI)this.defaultDatabaseService()).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }
}

